/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portalImpl.services.portletdefinitionregistry;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.UnavailableException;
import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.om.portlet.PortletApplicationDefinitionList;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.portalImpl.om.portlet.impl.PortletApplicationDefinitionImpl;
import org.apache.pluto.portalImpl.om.portlet.impl.PortletApplicationDefinitionListImpl;
import org.apache.pluto.portalImpl.om.servlet.impl.WebApplicationDefinitionImpl;
import org.apache.pluto.portalImpl.services.portletdefinitionregistry.PortletDefinitionRegistry;
import org.apache.pluto.portalImpl.services.portletdefinitionregistry.PortletDefinitionRegistryService;
import org.apache.pluto.portalImpl.util.Properties;
import org.apache.pluto.portalImpl.xml.Constants;
import org.apache.pluto.portalImpl.xml.XmlParser;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class PortletDefinitionRegistryServiceContextImpl
extends PortletDefinitionRegistryService {
    public static final String DEFAULT_CONTEXTS = "/WEB-INF/data/portletcontexts.txt";
    public static final String DEFAULT_MAPPING_PORTLETXML = "/WEB-INF/data/xml/portletdefinitionmapping.xml";
    public static final String DEFAULT_MAPPING_WEBXML = "/WEB-INF/data/xml/servletdefinitionmapping.xml";
    private static final String CONFIG_MAPPING_PORTLETXML = "mapping.portletxml.configfile";
    private static final String CONFIG_MAPPING_WEBXML = "mapping.webxml.configfile";
    private static Mapping webXmlMapping;
    private static Mapping portletXmlMapping;
    private static PortletApplicationDefinitionListImpl registry;
    private static Map definitions;

    public PortletApplicationDefinitionList getPortletApplicationDefinitionList() {
        return registry;
    }

    public PortletDefinition getPortletDefinition(ObjectID id) {
        return (PortletDefinition)definitions.get(id);
    }

    protected void init(ServletConfig config, Properties props) throws Exception {
        ServletContext context = config.getServletContext();
        portletXmlMapping = this.loadMapping(context, props.getString(CONFIG_MAPPING_PORTLETXML, DEFAULT_MAPPING_PORTLETXML));
        webXmlMapping = this.loadMapping(context, props.getString(CONFIG_MAPPING_WEBXML, DEFAULT_MAPPING_WEBXML));
        List contexts = this.loadDefinitionList(context, DEFAULT_CONTEXTS);
        registry = new PortletApplicationDefinitionListImpl();
        Iterator i = contexts.iterator();
        while (i.hasNext()) {
            String contextRoot = (String)i.next();
            PortletApplicationDefinition portletApp = this.loadApplicationDefinition(context, contextRoot);
            registry.add(portletApp);
        }
        definitions = new HashMap();
        i = registry.iterator();
        while (i.hasNext()) {
            PortletApplicationDefinition application = (PortletApplicationDefinition)i.next();
            Iterator j = application.getPortletDefinitionList().iterator();
            while (j.hasNext()) {
                PortletDefinition portlet = (PortletDefinition)j.next();
                definitions.put(portlet.getId(), portlet);
            }
        }
    }

    private Mapping loadMapping(ServletContext context, String path) throws UnavailableException {
        InputSource source = new InputSource(context.getResourceAsStream(path));
        Mapping mapping = new Mapping();
        try {
            mapping.loadMapping(source);
        }
        catch (IOException e) {
            throw (UnavailableException)new UnavailableException("Error reading mapping " + path).initCause((Throwable)e);
        }
        catch (MappingException e) {
            throw (UnavailableException)new UnavailableException("Invalid mapping " + path).initCause((Throwable)e);
        }
        return mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List loadDefinitionList(ServletContext context, String path) throws UnavailableException {
        ArrayList<String> arrayList;
        InputStream stream = context.getResourceAsStream(path);
        if (stream == null) {
            throw new UnavailableException("Unable to load registry " + path);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        try {
            String line;
            ArrayList<String> contexts = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                contexts.add(line.trim());
            }
            arrayList = contexts;
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw (UnavailableException)new UnavailableException("Error reading registry from " + path).initCause((Throwable)e);
            }
        }
        reader.close();
        return arrayList;
    }

    private PortletApplicationDefinition loadApplicationDefinition(ServletContext context, String path) throws UnavailableException {
        WebApplicationDefinitionImpl webApp;
        PortletApplicationDefinitionImpl portletApp;
        Unmarshaller unmarshaller;
        ServletContext appContext = context.getContext(path);
        if (appContext == null) {
            throw new UnavailableException("Unable to access context for " + path);
        }
        InputStream stream = appContext.getResourceAsStream("/WEB-INF/portlet.xml");
        String contextName = appContext.getServletContextName();
        if (stream == null) {
            throw new UnavailableException("The portlet.xml could not be found in context " + contextName + " (" + path + ")");
        }
        InputSource source = new InputSource(stream);
        try {
            unmarshaller = new Unmarshaller(portletXmlMapping);
            unmarshaller.setEntityResolver((EntityResolver)new XmlParser.EntityResolver(Constants.RES_PORTLET_DTDS, Constants.RES_PORTLET_DTD_NAMES));
        }
        catch (MappingException e) {
            throw (UnavailableException)new UnavailableException("Unable to construct unmarshaller for portlet.xml at context " + contextName).initCause((Throwable)e);
        }
        unmarshaller.setIgnoreExtraElements(true);
        try {
            portletApp = (PortletApplicationDefinitionImpl)unmarshaller.unmarshal(source);
        }
        catch (MarshalException e) {
            throw (UnavailableException)new UnavailableException("Unable to unmarshal portlet.xml from context " + contextName).initCause((Throwable)e);
        }
        catch (ValidationException e) {
            throw (UnavailableException)new UnavailableException("Unable to validate portlet.xml from context " + contextName).initCause((Throwable)e);
        }
        stream = appContext.getResourceAsStream("/WEB-INF/web.xml");
        if (stream == null) {
            throw new UnavailableException("No web.xml found in context " + contextName);
        }
        source = new InputSource(stream);
        try {
            unmarshaller = new Unmarshaller(webXmlMapping);
            unmarshaller.setEntityResolver((EntityResolver)new XmlParser.EntityResolver("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "/org/apache/pluto/portalImpl/xml/web-app_2_3.dtd", "web-app_2_3.dtd"));
        }
        catch (MappingException e) {
            throw (UnavailableException)new UnavailableException("Unable to construct unmarshaller for web.xml from context " + contextName + ". Error message: " + e.getMessage()).initCause((Throwable)e);
        }
        unmarshaller.setIgnoreExtraElements(true);
        try {
            webApp = (WebApplicationDefinitionImpl)unmarshaller.unmarshal(source);
        }
        catch (MarshalException e) {
            throw (UnavailableException)new UnavailableException("Unable to unmarshal web.xml from context " + contextName + ". Error message: " + e.getMessage()).initCause((Throwable)e);
        }
        catch (ValidationException e) {
            throw (UnavailableException)new UnavailableException("Unable to validate web.xml from context " + contextName + ". Error message: " + e.getMessage()).initCause((Throwable)e);
        }
        Vector<Object> structure = new Vector<Object>();
        structure.add(portletApp);
        structure.add(path);
        try {
            webApp.postLoad(structure);
            webApp.preBuild(structure);
            webApp.postBuild(structure);
        }
        catch (Exception e) {
            throw (UnavailableException)new UnavailableException("Problem: " + e.getMessage() + ". Context = " + contextName).initCause((Throwable)e);
        }
        return portletApp;
    }

    public void postInit() throws Exception {
        PortletDefinitionRegistry.setPortletDefinitionRegistryService();
    }
}

