/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portalImpl.services.pageregistry;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.pluto.portalImpl.aggregation.Fragment;
import org.apache.pluto.portalImpl.aggregation.RootFragment;
import org.apache.pluto.portalImpl.om.page.impl.PortalImpl;
import org.apache.pluto.portalImpl.services.log.Log;
import org.apache.pluto.portalImpl.services.pageregistry.PageRegistry;
import org.apache.pluto.portalImpl.services.pageregistry.PageRegistryService;
import org.apache.pluto.portalImpl.util.Properties;
import org.apache.pluto.services.log.Logger;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Unmarshaller;

public class PageRegistryServiceFileImpl
extends PageRegistryService {
    public static final String CONFIG_FILE = "WEB-INF/data/pageregistry.xml";
    public static final String DEFAULT_MAPPING = "WEB-INF/data/xml/pageregistrymapping.xml";
    private static final String CONFIG_MAPPING = "mapping.configfile";
    private Mapping mapping = null;
    private ServletContext servletContext = null;
    private PortalImpl registry = null;
    private RootFragment root = null;
    private Logger log = null;
    private static HashMap fragments = new HashMap();

    public void init(ServletConfig config, Properties properties) throws Exception {
        this.servletContext = config.getServletContext();
        this.log = Log.getService().getLogger(this.getClass());
        String _mapping = properties.getString(CONFIG_MAPPING, DEFAULT_MAPPING);
        File f = new File(_mapping);
        if (!f.isAbsolute()) {
            _mapping = this.servletContext.getRealPath(_mapping);
        }
        this.mapping = new Mapping();
        try {
            this.mapping.loadMapping(_mapping);
        }
        catch (Exception e) {
            this.log.error("Failed to load mapping file " + _mapping, (Throwable)e);
            throw e;
        }
        this.load();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Dumping complete object model description as it is read from the xml file...");
            this.log.debug(this.registry.toString());
        }
    }

    public void postInit(ServletConfig config) throws Exception {
        fragments = new HashMap();
        this.root = this.registry.build(config);
        PageRegistry.setRootFragment();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Dumping complete navigation tree created of the object model...");
            this.log.debug(this.root.getNavigation().toString());
        }
    }

    public RootFragment getRootFragment() {
        return this.root;
    }

    public Fragment getFragment(String id) {
        return (Fragment)fragments.get(id);
    }

    public void addFragment(Fragment fragment) throws Exception {
        String id = fragment.getId();
        if (fragments.containsKey(id)) {
            String msg = "Fragment with this name " + id + " already exists in the pageregistry.xml.";
            this.log.error(msg);
            throw new Exception(msg);
        }
        fragments.put(id, fragment);
    }

    private void load() throws Exception {
        String filename = CONFIG_FILE;
        File f = new File(filename);
        if (!f.isAbsolute()) {
            filename = this.servletContext.getRealPath(filename);
        }
        Unmarshaller unmarshaller = new Unmarshaller(this.mapping);
        this.registry = (PortalImpl)unmarshaller.unmarshal((Reader)new FileReader(filename));
    }
}

