/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portalImpl.services.factorymanager;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.pluto.factory.Factory;
import org.apache.pluto.portalImpl.services.factorymanager.FactoryManagerService;
import org.apache.pluto.portalImpl.util.Properties;
import org.apache.pluto.util.StringUtils;

public class FactoryManagerServiceImpl
extends FactoryManagerService {
    private static final String CONFIG_FACTORY_PRE = "factory.";
    private Map factoryMap = new HashMap();
    private List factoryList = new LinkedList();

    protected void init(ServletConfig config, Properties aProperties) throws Exception {
        String factoryInterfaceName;
        ServletContext context = null;
        if (config != null) {
            context = config.getServletContext();
        }
        if (context != null) {
            context.log("FactoryManager: Loading factories...");
        }
        HashMap<String, String> factoryImpls = new HashMap<String, String>();
        HashMap factoryProps = new HashMap();
        Iterator configNames = aProperties.keys();
        String lastFactoryInterfaceName = null;
        while (configNames.hasNext()) {
            String configName = (String)configNames.next();
            if (!configName.startsWith(CONFIG_FACTORY_PRE)) continue;
            String name = configName.substring(CONFIG_FACTORY_PRE.length());
            if (lastFactoryInterfaceName != null && name.startsWith(lastFactoryInterfaceName)) {
                String propertyName = name.substring(lastFactoryInterfaceName.length() + 1);
                String propertyValue = aProperties.getString(configName);
                Map properties = (Map)factoryProps.get(lastFactoryInterfaceName);
                properties.put(propertyName, propertyValue);
                continue;
            }
            factoryInterfaceName = name;
            String factoryImplName = aProperties.getString(configName);
            factoryImpls.put(factoryInterfaceName, factoryImplName);
            factoryProps.put(factoryInterfaceName, new HashMap());
            lastFactoryInterfaceName = factoryInterfaceName;
        }
        int numAll = 0;
        Iterator iter = factoryImpls.keySet().iterator();
        while (iter.hasNext()) {
            Class<?> factoryInterface;
            factoryInterfaceName = (String)iter.next();
            ++numAll;
            try {
                factoryInterface = Class.forName(factoryInterfaceName);
            }
            catch (ClassNotFoundException exc) {
                if (context == null) continue;
                context.log("FactoryManager: A factory with name " + factoryInterfaceName + " cannot be found.");
                continue;
            }
            String factoryImplName = (String)factoryImpls.get(factoryInterfaceName);
            Class<?> factoryImpl = null;
            Factory factory = null;
            try {
                factoryImpl = Class.forName(factoryImplName);
                factory = (Factory)factoryImpl.newInstance();
                Map props = (Map)factoryProps.get(factoryInterfaceName);
                if (context != null) {
                    context.log(StringUtils.nameOf(factoryInterface) + " initializing...");
                }
                factory.init(config, props);
                if (context != null) {
                    context.log(StringUtils.nameOf(factoryInterface) + " done.");
                }
            }
            catch (ClassNotFoundException exc) {
                if (context != null) {
                    context.log("FactoryManager: A factory implementation with name " + factoryImplName + " cannot be found.", (Throwable)exc);
                }
                throw exc;
            }
            catch (ClassCastException exc) {
                if (context != null) {
                    context.log("FactoryManager: Factory implementation " + factoryImplName + " is not a factory of the required type.", (Throwable)exc);
                }
                throw exc;
            }
            catch (InstantiationException exc) {
                if (context != null) {
                    context.log("FactoryManager: Factory implementation " + factoryImplName + " cannot be instantiated.", (Throwable)exc);
                }
                throw exc;
            }
            catch (Exception exc) {
                if (context != null) {
                    context.log("FactoryManager: An unidentified error occurred", (Throwable)exc);
                }
                throw exc;
            }
            if (factory == null) continue;
            this.factoryMap.put(factoryInterface, factory);
            this.factoryList.add(0, factory);
        }
        if (context != null) {
            context.log("FactoryManager: Factories initialized (" + numAll + " successful).");
        }
    }

    protected void destroy(ServletConfig config) {
        ServletContext context = null;
        if (config != null) {
            context = config.getServletContext();
        }
        Iterator iterator = this.factoryList.iterator();
        while (iterator.hasNext()) {
            Factory factory = (Factory)iterator.next();
            try {
                factory.destroy();
            }
            catch (Exception exc) {
                if (context == null) continue;
                context.log("FactoryManager: Factory couldn't be destroyed.", (Throwable)exc);
            }
        }
        this.factoryList.clear();
        this.factoryMap.clear();
    }

    public Factory getFactory(Class theClass) {
        return (Factory)this.factoryMap.get(theClass);
    }
}

