/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portalImpl.services;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.pluto.portalImpl.services.Service;
import org.apache.pluto.portalImpl.util.Properties;
import org.apache.pluto.util.StringUtils;

public class ServiceManager {
    private static final String SERVICES_CONFIG_FILE = "/WEB-INF/config/services.properties";
    private static final String SERVICES_CONFIG_DIR = "/WEB-INF/config/services/";
    private static volatile boolean cInitialized = false;
    private static Map cServicesMap = new HashMap();
    private static List cServicesList = new LinkedList();
    static /* synthetic */ Class class$0;

    public static void init(ServletConfig aConfig) throws Exception {
        ServiceManager.init(aConfig, SERVICES_CONFIG_FILE, SERVICES_CONFIG_DIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(ServletConfig aConfig, String aServiceConfigFile, String aServiceConfigDir) throws Exception {
        if (!cInitialized) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.apache.pluto.portalImpl.services.ServiceManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            synchronized (clazz) {
                if (cInitialized) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                cInitialized = true;
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        return;
        {
            ServletContext context = null;
            if (aConfig != null) {
                context = aConfig.getServletContext();
            }
            if (context != null) {
                context.log("ServiceManager: Loading services...");
            }
            Properties props = new Properties();
            try {
                props.load(context.getResourceAsStream(aServiceConfigFile));
            }
            catch (IOException exc) {
                if (context != null) {
                    context.log("ServiceManager: File \"" + aServiceConfigFile + "\" cannot be found or read.");
                }
                throw new Exception("ServiceManager: File \"" + aServiceConfigFile + "\" cannot be found or read.");
            }
            int numAll = 0;
            int numSuccessful = 0;
            Iterator iter = props.names();
            while (iter.hasNext()) {
                Class<?> serviceBase;
                String serviceBaseName = (String)iter.next();
                ++numAll;
                try {
                    serviceBase = Class.forName(serviceBaseName);
                }
                catch (ClassNotFoundException exc) {
                    if (context == null) continue;
                    context.log("ServiceManager: A service with name " + serviceBaseName + " cannot be found.");
                    continue;
                }
                String serviceImplName = props.getString(serviceBaseName);
                Class<?> serviceImpl = null;
                Service service = null;
                try {
                    serviceImpl = Class.forName(serviceImplName);
                    service = (Service)serviceImpl.newInstance();
                    Properties serviceProps = new Properties();
                    try {
                        InputStream is = null;
                        is = context.getResourceAsStream(String.valueOf(aServiceConfigDir) + StringUtils.nameOf(serviceImpl) + ".properties");
                        if (is == null) {
                            is = context.getResourceAsStream(String.valueOf(aServiceConfigDir) + StringUtils.nameOf(serviceBase) + ".properties");
                        }
                        if (is != null) {
                            serviceProps.load(is);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (context != null) {
                        context.log(String.valueOf(StringUtils.nameOf(serviceBase)) + " initializing...");
                    }
                    service.init(aConfig, serviceProps);
                    if (context != null) {
                        context.log(String.valueOf(StringUtils.nameOf(serviceBase)) + " done.");
                    }
                }
                catch (ClassNotFoundException exc) {
                    if (context == null) continue;
                    context.log("ServiceManager: A service implementation with name " + serviceImplName + " cannot be found.", (Throwable)exc);
                    continue;
                }
                catch (ClassCastException exc) {
                    if (context == null) continue;
                    context.log("ServiceManager: Service implementation " + serviceImplName + " is not a service of the required type.", (Throwable)exc);
                    continue;
                }
                catch (InstantiationException exc) {
                    if (context == null) continue;
                    context.log("ServiceManager: Service implementation " + serviceImplName + " cannot be instantiated.", (Throwable)exc);
                    continue;
                }
                catch (Exception exc) {
                    if (context != null) {
                        context.log("ServiceManager: An unidentified error occurred", (Throwable)exc);
                    }
                    service = null;
                }
                if (service == null) continue;
                cServicesMap.put(serviceBase, service);
                cServicesList.add(0, service);
                ++numSuccessful;
            }
            System.out.println("ServiceManager: Services initialized (" + numSuccessful + "/" + numAll + " successful).");
            System.err.println("ServiceManager: Services initialized (" + numSuccessful + "/" + numAll + " successful).");
            if (context != null) {
                context.log("ServiceManager: Services initialized (" + numSuccessful + "/" + numAll + " successful).");
            }
            if (numSuccessful != numAll) {
                throw new Exception("ServiceManager: Services initialized (" + numSuccessful + "/" + numAll + " successful).");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void postInit(ServletConfig aConfig) {
        if (cInitialized) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.apache.pluto.portalImpl.services.ServiceManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            synchronized (clazz) {
                if (!cInitialized) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                cInitialized = false;
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        return;
        {
            ServletContext context = null;
            if (aConfig != null) {
                context = aConfig.getServletContext();
            }
            Iterator iterator = cServicesList.iterator();
            while (iterator.hasNext()) {
                Service service = (Service)iterator.next();
                try {
                    service.postInit(aConfig);
                }
                catch (Exception exc) {
                    if (context == null) continue;
                    context.log("ServiceManager: Service couldn't be started (postInit) after init..", (Throwable)exc);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy(ServletConfig aConfig) {
        if (cInitialized) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.apache.pluto.portalImpl.services.ServiceManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            synchronized (clazz) {
                if (!cInitialized) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                cInitialized = false;
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        return;
        {
            ServletContext context = null;
            if (aConfig != null) {
                context = aConfig.getServletContext();
            }
            Iterator iterator = cServicesList.iterator();
            while (iterator.hasNext()) {
                Service service = (Service)iterator.next();
                try {
                    service.destroy(aConfig);
                }
                catch (Exception exc) {
                    if (context == null) continue;
                    context.log("ServiceManager: Service couldn't be destroyed.", (Throwable)exc);
                }
            }
            cServicesList.clear();
            cServicesMap.clear();
            return;
        }
    }

    public static Service getService(Class aClass) {
        return (Service)cServicesMap.get(aClass);
    }

    public static void hotInit(ServletConfig aConfig, String theService) throws Exception {
        ServiceManager.hotInit(aConfig, SERVICES_CONFIG_FILE, SERVICES_CONFIG_DIR, theService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hotInit(ServletConfig aConfig, String aServiceConfigFile, String aServiceConfigDir, String theService) throws Exception {
        if (!cInitialized) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.apache.pluto.portalImpl.services.ServiceManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            synchronized (clazz) {
                if (cInitialized) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                cInitialized = true;
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        return;
        {
            ServletContext context = null;
            if (aConfig != null) {
                context = aConfig.getServletContext();
            }
            if (context != null) {
                context.log("ServiceManager: HOTHOT Loading service: " + theService);
            }
            Properties props = new Properties();
            try {
                props.load(context.getResourceAsStream(aServiceConfigFile));
            }
            catch (IOException exc) {
                if (context != null) {
                    context.log("ServiceManager: File \"" + aServiceConfigFile + "\" cannot be found or read.");
                }
                throw new Exception("ServiceManager: File \"" + aServiceConfigFile + "\" cannot be found or read.");
            }
            int numAll = 0;
            int numSuccessful = 0;
            Iterator iter = props.names();
            while (iter.hasNext()) {
                Class<?> serviceBase;
                String serviceBaseName = (String)iter.next();
                if (!serviceBaseName.equals(theService)) continue;
                context.log("ServiceManager: Service " + theService + " FOUND!!");
                ++numAll;
                try {
                    serviceBase = Class.forName(serviceBaseName);
                }
                catch (ClassNotFoundException exc) {
                    if (context == null) continue;
                    context.log("ServiceManager: A service with name " + serviceBaseName + " cannot be found.");
                    continue;
                }
                String serviceImplName = props.getString(serviceBaseName);
                Class<?> serviceImpl = null;
                Service service = null;
                try {
                    serviceImpl = Class.forName(serviceImplName);
                    service = (Service)serviceImpl.newInstance();
                    Properties serviceProps = new Properties();
                    try {
                        InputStream is = null;
                        is = context.getResourceAsStream(String.valueOf(aServiceConfigDir) + StringUtils.nameOf(serviceImpl) + ".properties");
                        if (is == null) {
                            is = context.getResourceAsStream(String.valueOf(aServiceConfigDir) + StringUtils.nameOf(serviceBase) + ".properties");
                        }
                        if (is != null) {
                            serviceProps.load(is);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (context != null) {
                        context.log(String.valueOf(StringUtils.nameOf(serviceBase)) + " initializing...");
                    }
                    service.init(aConfig, serviceProps);
                    if (context != null) {
                        context.log(String.valueOf(StringUtils.nameOf(serviceBase)) + " done.");
                    }
                }
                catch (ClassNotFoundException exc) {
                    if (context == null) continue;
                    context.log("ServiceManager: A service implementation with name " + serviceImplName + " cannot be found.", (Throwable)exc);
                    continue;
                }
                catch (ClassCastException exc) {
                    if (context == null) continue;
                    context.log("ServiceManager: Service implementation " + serviceImplName + " is not a service of the required type.", (Throwable)exc);
                    continue;
                }
                catch (InstantiationException exc) {
                    if (context == null) continue;
                    context.log("ServiceManager: Service implementation " + serviceImplName + " cannot be instantiated.", (Throwable)exc);
                    continue;
                }
                catch (Exception exc) {
                    if (context != null) {
                        context.log("ServiceManager: An unidentified error occurred", (Throwable)exc);
                    }
                    service = null;
                }
                if (service == null) continue;
                cServicesMap.put(serviceBase, service);
                cServicesList.add(0, service);
                ++numSuccessful;
            }
            if (context != null) {
                context.log("ServiceManager: Services initialized (" + numSuccessful + "/" + numAll + " successful).");
            }
            if (numSuccessful != numAll) {
                throw new Exception("ServiceManager: Services initialized (" + numSuccessful + "/" + numAll + " successful).");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void postHotInit(ServletConfig aConfig, String theService) {
        if (cInitialized) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.apache.pluto.portalImpl.services.ServiceManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            synchronized (clazz) {
                if (!cInitialized) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                cInitialized = false;
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        return;
        {
            block12: {
                ServletContext context = null;
                if (aConfig != null) {
                    context = aConfig.getServletContext();
                }
                try {
                    Service service = (Service)cServicesMap.get(Class.forName(theService));
                    service.postInit(aConfig);
                }
                catch (Exception exc) {
                    if (context == null) break block12;
                    context.log("ServiceManager:Service couldn't be started (postInit) after init..", (Throwable)exc);
                }
            }
            return;
        }
    }
}

