/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portalImpl.om.entity.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import org.apache.pluto.om.common.Description;
import org.apache.pluto.om.common.DescriptionSet;
import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.common.PreferenceSet;
import org.apache.pluto.om.entity.PortletApplicationEntity;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.entity.PortletEntityCtrl;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.window.PortletWindowList;
import org.apache.pluto.portalImpl.om.common.Support;
import org.apache.pluto.portalImpl.om.common.impl.DescriptionSetImpl;
import org.apache.pluto.portalImpl.om.common.impl.PreferenceSetImpl;
import org.apache.pluto.portalImpl.om.window.impl.PortletWindowListImpl;
import org.apache.pluto.portalImpl.services.ConfigurationException;
import org.apache.pluto.portalImpl.services.portletentityregistry.PortletEntityRegistry;
import org.apache.pluto.util.StringUtils;

public class PortletEntityImpl
implements PortletEntity,
PortletEntityCtrl,
Serializable,
Support {
    private String id = "";
    private String definitionId = "";
    protected PreferenceSet preferences = new PreferenceSetImpl();
    private PreferenceSet origPreferences = new PreferenceSetImpl();
    private PortletApplicationEntity applicationEntity;
    private PortletWindowList portletWindows = new PortletWindowListImpl();
    private ObjectID objectId;
    private DescriptionSet descriptions = new DescriptionSetImpl();

    public ObjectID getId() {
        if (this.objectId == null && this.applicationEntity != null) {
            this.objectId = org.apache.pluto.portalImpl.util.ObjectID.createFromString(this.applicationEntity.getId().toString() + "." + this.id);
        }
        return this.objectId;
    }

    public PreferenceSet getPreferenceSet() {
        return this.preferences;
    }

    public PortletDefinition getPortletDefinition() {
        PortletDefinition def = this.applicationEntity.getPortletApplicationDefinition().getPortletDefinitionList().get((ObjectID)org.apache.pluto.portalImpl.util.ObjectID.createFromString(this.definitionId));
        if (def == null) {
            throw new ConfigurationException("Unable to obtain portlet definition for :" + this.definitionId + " Perhaps a portlet has been defined incorrectly in the portlet registry.");
        }
        return def;
    }

    public void setPortletDefinition(PortletDefinition portletDefinition) {
        this.definitionId = portletDefinition.getId().toString();
    }

    public PortletApplicationEntity getPortletApplicationEntity() {
        return this.applicationEntity;
    }

    public PortletWindowList getPortletWindowList() {
        return this.portletWindows;
    }

    public Description getDescription(Locale locale) {
        return this.descriptions.get(locale);
    }

    public void setId(String id) {
        this.id = id;
        this.objectId = null;
    }

    public void store() throws IOException {
        PortletEntityRegistry.store();
        this.origPreferences = new PreferenceSetImpl();
        ((PreferenceSetImpl)this.origPreferences).addAll((Collection)this.preferences);
    }

    public void reset() throws IOException {
        this.preferences = new PreferenceSetImpl();
        ((PreferenceSetImpl)this.preferences).clear();
        ((PreferenceSetImpl)this.preferences).addAll((Collection)this.origPreferences);
    }

    public void postLoad(Object parameter) throws Exception {
    }

    public void preBuild(Object parameter) throws Exception {
        ((PreferenceSetImpl)this.origPreferences).addAll((Collection)this.preferences);
        this.setPortletApplicationEntity((PortletApplicationEntity)parameter);
    }

    public void postBuild(Object parameter) throws Exception {
    }

    public void preStore(Object parameter) throws Exception {
    }

    public void postStore(Object parameter) throws Exception {
    }

    public Collection getCastorPreferences() {
        return (PreferenceSetImpl)this.preferences;
    }

    protected void setPortletApplicationEntity(PortletApplicationEntity applicationEntity) {
        this.applicationEntity = applicationEntity;
    }

    protected void setPortletWindowList(PortletWindowList portletWindows) {
        this.portletWindows = portletWindows;
    }

    public String getCastorId() {
        return this.id.length() > 0 ? this.id : null;
    }

    public void setCastorId(String id) {
        this.setId(id);
    }

    public String getDefinitionId() {
        return this.definitionId;
    }

    public void setDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuffer buffer = new StringBuffer(1000);
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append(this.getClass().toString());
        buffer.append(":");
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("{");
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("id='");
        buffer.append(this.id);
        buffer.append("'");
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("definition-id='");
        buffer.append(this.definitionId);
        buffer.append("'");
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append(((PreferenceSetImpl)this.preferences).toString(indent));
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append(((DescriptionSetImpl)this.descriptions).toString(indent));
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("}");
        return buffer.toString();
    }
}

