/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portalImpl.om.common.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.portlet.PreferencesValidator;
import org.apache.pluto.om.common.Preference;
import org.apache.pluto.om.common.PreferenceSet;
import org.apache.pluto.om.common.PreferenceSetCtrl;
import org.apache.pluto.portalImpl.om.common.impl.PreferenceImpl;
import org.apache.pluto.portalImpl.services.log.Log;
import org.apache.pluto.services.log.Logger;
import org.apache.pluto.util.StringUtils;

public class PreferenceSetImpl
extends HashSet
implements PreferenceSet,
PreferenceSetCtrl,
Serializable {
    private String castorPreferencesValidator;
    private ClassLoader classLoader;
    private Logger log = Log.getService().getLogger(this.getClass());

    public Preference get(String name) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Preference preference = (Preference)iterator.next();
            if (!preference.getName().equals(name)) continue;
            return preference;
        }
        return null;
    }

    public PreferencesValidator getPreferencesValidator() {
        if (this.classLoader == null) {
            throw new IllegalStateException("Portlet class loader not yet available to load preferences validator.");
        }
        if (this.castorPreferencesValidator == null) {
            return null;
        }
        try {
            Object validator = this.classLoader.loadClass(this.castorPreferencesValidator).newInstance();
            if (validator instanceof PreferencesValidator) {
                return (PreferencesValidator)validator;
            }
            this.log.error("Specified class " + this.castorPreferencesValidator + " is no preferences validator.");
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Preference add(String name, List values) {
        PreferenceImpl preference = new PreferenceImpl();
        preference.setName(name);
        preference.setValues(values);
        super.add(preference);
        return preference;
    }

    public Preference remove(String name) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Preference preference = (Preference)iterator.next();
            if (!preference.getName().equals(name)) continue;
            super.remove(preference);
            return preference;
        }
        return null;
    }

    public void remove(Preference preference) {
        super.remove(preference);
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuffer buffer = new StringBuffer(50);
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append(this.getClass().toString());
        buffer.append(": ");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            buffer.append(((PreferenceImpl)iterator.next()).toString(indent + 2));
        }
        return buffer.toString();
    }

    public String getCastorPreferencesValidator() {
        return this.castorPreferencesValidator;
    }

    public void setCastorPreferencesValidator(String castorPreferencesValidator) {
        this.castorPreferencesValidator = castorPreferencesValidator;
    }

    public Collection getCastorPreferences() {
        return this;
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public boolean addAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            PreferenceImpl pref = (PreferenceImpl)it.next();
            this.add(pref.getName(), pref.getClonedCastorValuesAsList());
        }
        return true;
    }
}

