/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portalImpl.om.common.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.pluto.om.common.Language;
import org.apache.pluto.util.Enumerator;
import org.apache.pluto.util.StringUtils;

public class LanguageImpl
implements Language,
Serializable {
    private Locale locale;
    private String title;
    private String shortTitle;
    private ResourceBundle bundle;
    private ArrayList keywords;

    public LanguageImpl(Locale locale, ResourceBundle bundle, String defaultTitle, String defaultShortTitle, String defaultKeyWords) {
        this.bundle = new ResourceBundleImpl(bundle, new DefaultsResourceBundle(defaultTitle, defaultShortTitle, defaultKeyWords));
        this.locale = locale;
        this.title = this.bundle.getString("javax.portlet.title");
        this.shortTitle = this.bundle.getString("javax.portlet.short-title");
        this.keywords = this.toList(this.bundle.getString("javax.portlet.keywords"));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getTitle() {
        return this.title;
    }

    public String getShortTitle() {
        return this.shortTitle;
    }

    public Iterator getKeywords() {
        return this.keywords.iterator();
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    private ArrayList toList(String value) {
        ArrayList<String> keywords = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            keywords.add(st.nextToken().trim());
        }
        return keywords;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuffer buffer = new StringBuffer(50);
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append(this.getClass().toString());
        buffer.append(":");
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("{");
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("locale='");
        buffer.append(this.locale);
        buffer.append("'");
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("title='");
        buffer.append(this.title);
        buffer.append("'");
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("shortTitle='");
        buffer.append(this.shortTitle);
        buffer.append("'");
        Iterator iterator = this.keywords.iterator();
        if (iterator.hasNext()) {
            StringUtils.newLine((StringBuffer)buffer, (int)indent);
            buffer.append("Keywords:");
        }
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            buffer.append(',');
        }
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("}");
        return buffer.toString();
    }

    public boolean equals(Object o) {
        return o == null ? false : ((LanguageImpl)o).getLocale().equals(this.locale);
    }

    public int hashCode() {
        return this.locale.hashCode();
    }

    public void setKeywords(Collection keywords) {
        this.keywords.clear();
        this.keywords.addAll(keywords);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setShortTitle(String shortTitle) {
        this.shortTitle = shortTitle;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private static class ResourceBundleImpl
    extends ResourceBundle {
        private HashMap data = new HashMap();

        public ResourceBundleImpl(ResourceBundle bundle, ResourceBundle defaults) {
            this.importData(defaults);
            this.importData(bundle);
        }

        private void importData(ResourceBundle bundle) {
            if (bundle != null) {
                Enumeration<String> enumerator = bundle.getKeys();
                while (enumerator.hasMoreElements()) {
                    String key = enumerator.nextElement();
                    Object value = bundle.getObject(key);
                    this.data.put(key, value);
                }
            }
        }

        protected Object handleGetObject(String key) {
            return this.data.get(key);
        }

        public Enumeration getKeys() {
            return new Enumerator(this.data.keySet());
        }
    }

    private static class DefaultsResourceBundle
    extends ListResourceBundle {
        private Object[][] resources;

        public DefaultsResourceBundle(String defaultTitle, String defaultShortTitle, String defaultKeyWords) {
            this.resources = new Object[][]{{"javax.portlet.title", defaultTitle}, {"javax.portlet.short-title", defaultShortTitle}, {"javax.portlet.keywords", defaultKeyWords}};
        }

        protected Object[][] getContents() {
            return this.resources;
        }
    }
}

