/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portalImpl.core;

import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.portalImpl.core.DynamicInformationProviderImpl;
import org.apache.pluto.portalImpl.core.PortalControlParameter;
import org.apache.pluto.portalImpl.core.PortalEnvironment;
import org.apache.pluto.portalImpl.core.PortalURL;
import org.apache.pluto.services.information.PortletURLProvider;

public class PortletURLProviderImpl
implements PortletURLProvider {
    private DynamicInformationProviderImpl provider;
    private PortletWindow portletWindow;
    private PortletMode mode;
    private WindowState state;
    private boolean action;
    private boolean secure;
    private boolean clearParameters;
    private Map parameters;

    public PortletURLProviderImpl(DynamicInformationProviderImpl provider, PortletWindow portletWindow) {
        this.provider = provider;
        this.portletWindow = portletWindow;
    }

    public void setPortletMode(PortletMode mode) {
        this.mode = mode;
    }

    public void setWindowState(WindowState state) {
        this.state = state;
    }

    public void setAction() {
        this.action = true;
    }

    public void setSecure() {
        this.secure = true;
    }

    public void clearParameters() {
        this.clearParameters = true;
    }

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    public String toString() {
        PortalURL url = PortalEnvironment.getPortalEnvironment(this.provider.request).getRequestedPortalURL();
        PortalControlParameter controlURL = new PortalControlParameter(url);
        if (this.mode != null) {
            controlURL.setMode(this.portletWindow, this.mode);
        }
        if (this.state != null) {
            controlURL.setState(this.portletWindow, this.state);
        }
        if (this.clearParameters) {
            controlURL.clearRenderParameters(this.portletWindow);
        }
        controlURL.setPortletId(this.portletWindow);
        if (this.action) {
            controlURL.setAction(this.portletWindow);
        }
        if (this.parameters != null) {
            Iterator names = this.parameters.keySet().iterator();
            while (names.hasNext()) {
                String[] values;
                String[] stringArray;
                String name = (String)names.next();
                Object value = this.parameters.get(name);
                if (value instanceof String) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = (String)value;
                } else {
                    stringArray = values = (String[])value;
                }
                if (this.action) {
                    controlURL.setRequestParam(name, values);
                    continue;
                }
                controlURL.setRenderParam(this.portletWindow, name, values);
            }
        }
        return url.toString(controlURL, new Boolean(this.secure));
    }
}

