/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portalImpl.core;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.portalImpl.aggregation.Fragment;
import org.apache.pluto.portalImpl.core.PortalControlParameter;
import org.apache.pluto.portalImpl.core.PortalEnvironment;
import org.apache.pluto.portalImpl.services.config.Config;

public class PortalURL {
    private static final String insecureServlet = Config.getParameters().getString("servlet.insecure");
    private static final String secureServlet = Config.getParameters().getString("servlet.secure");
    private List startGlobalNavigation = new ArrayList();
    private List startLocalNavigation = new ArrayList();
    private HashMap encodedStartControlParameter = new HashMap();
    private HashMap startStateLessControlParameter = new HashMap();
    private boolean analyzed = false;
    private PortalEnvironment environment;

    public String getBasePortalURL(HttpServletRequest request) {
        return this.getBasePortalURL(PortalEnvironment.getPortalEnvironment(request));
    }

    public String getBasePortalURL(PortalEnvironment env) {
        StringBuffer result = new StringBuffer(256);
        result.append(env.getRequest().getContextPath());
        result.append(env.getRequest().getServletPath());
        return result.toString();
    }

    public PortalURL(PortalEnvironment env) {
        this.environment = env;
    }

    public PortalURL(HttpServletRequest request) {
        this(PortalEnvironment.getPortalEnvironment(request));
    }

    public PortalURL(HttpServletRequest request, Fragment pointTo) {
        this(request);
        pointTo.createURL(this);
    }

    public PortalURL(PortalEnvironment env, Fragment pointTo) {
        this(env);
        pointTo.createURL(this);
    }

    public void addGlobalNavigation(String nav) {
        this.startGlobalNavigation.add(nav);
    }

    public void setLocalNavigation() {
        this.startLocalNavigation = new ArrayList();
    }

    public void addLocalNavigation(String nav) {
        this.startLocalNavigation.add(nav);
    }

    public boolean isPartOfGlobalNavigation(String nav) {
        return this.startGlobalNavigation.contains(nav);
    }

    public boolean isPartOfLocalNavigation(String nav) {
        return this.startLocalNavigation.contains(nav);
    }

    private String urlEncode(String value) {
        value = URLEncoder.encode(value);
        value = value.replaceAll("\\+", "%20");
        return value;
    }

    public String getGlobalNavigationAsString() {
        StringBuffer result = new StringBuffer(200);
        Iterator iterator = this.startGlobalNavigation.iterator();
        if (iterator.hasNext()) {
            result.append((String)iterator.next());
            while (iterator.hasNext()) {
                result.append("/");
                String st = (String)iterator.next();
                result.append(st);
            }
        }
        return result.toString();
    }

    public String getLocalNavigationAsString() {
        StringBuffer result = new StringBuffer(30);
        Iterator iterator = this.startLocalNavigation.iterator();
        if (iterator.hasNext()) {
            result.append((String)iterator.next());
            while (iterator.hasNext()) {
                result.append(".");
                result.append((String)iterator.next());
            }
        }
        return result.toString();
    }

    public String getControlParameterAsString(PortalControlParameter controlParam) {
        Map encodedStateFullParams = this.encodedStartControlParameter;
        if (controlParam != null) {
            encodedStateFullParams = controlParam.getEncodedStateFullControlParameter();
        }
        StringBuffer result = new StringBuffer(100);
        Iterator iterator = encodedStateFullParams.keySet().iterator();
        while (iterator.hasNext()) {
            result.append("/");
            String encodedName = (String)iterator.next();
            String encodedValue = (String)encodedStateFullParams.get(encodedName);
            if (encodedValue == null) continue;
            result.append(PortalControlParameter.encodeParameterName(encodedName));
            result.append("/");
            result.append(this.urlEncode(encodedValue));
        }
        return result.toString();
    }

    public String getRequestParameterAsString(PortalControlParameter controlParam) {
        if (controlParam != null) {
            Map requestParams = controlParam.getRequestParameter();
            StringBuffer result = new StringBuffer(100);
            Iterator iterator = requestParams.keySet().iterator();
            boolean hasNext = iterator.hasNext();
            if (hasNext) {
                result.append("?");
            }
            while (hasNext) {
                String[] stringArray;
                String name = (String)iterator.next();
                Object value = requestParams.get(name);
                if (value instanceof String) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = (String)value;
                } else {
                    stringArray = (String[])value;
                }
                String[] values = stringArray;
                result.append(this.urlEncode(name));
                result.append("=");
                result.append(this.urlEncode(values[0]));
                for (int i = 1; i < values.length; ++i) {
                    result.append("&");
                    result.append(this.urlEncode(name));
                    result.append("=");
                    result.append(this.urlEncode(values[i]));
                }
                hasNext = iterator.hasNext();
                if (!hasNext) continue;
                result.append("&");
            }
            return result.toString();
        }
        return "";
    }

    public String toString() {
        return this.toString(null, null);
    }

    public String toString(PortalControlParameter controlParam, Boolean p_secure) {
        String local;
        String requestParam;
        String control;
        StringBuffer urlBase = new StringBuffer(256);
        boolean secure = false;
        secure = p_secure != null ? p_secure.booleanValue() : this.environment.getRequest().isSecure();
        urlBase.append(this.environment.getRequest().getContextPath());
        urlBase.append(secure ? secureServlet : insecureServlet);
        String url = urlBase.toString();
        String global = this.getGlobalNavigationAsString();
        if (global.length() > 0) {
            url = url + "/";
            url = url + global;
        }
        if ((control = this.getControlParameterAsString(controlParam)).length() > 0) {
            url = url + control;
        }
        if ((requestParam = this.getRequestParameterAsString(controlParam)).length() > 0) {
            url = url + requestParam;
        }
        if ((local = this.getLocalNavigationAsString()).length() > 0) {
            url = url + "#";
            url = url + local;
        }
        return this.environment.getResponse().encodeURL(url);
    }

    Map getClonedEncodedStateFullControlParameter() {
        this.analyzeRequestInformation();
        return (Map)this.encodedStartControlParameter.clone();
    }

    Map getClonedStateLessControlParameter() {
        this.analyzeRequestInformation();
        return (Map)this.startStateLessControlParameter.clone();
    }

    void analyzeControlInformation(PortalControlParameter control) {
        this.encodedStartControlParameter = (HashMap)control.getEncodedStateFullControlParameter();
        this.startStateLessControlParameter = (HashMap)control.getStateLessControlParameter();
    }

    void analyzeRequestInformation() {
        if (this.analyzed) {
            return;
        }
        this.startGlobalNavigation = new ArrayList();
        this.startLocalNavigation = new ArrayList();
        this.encodedStartControlParameter = new HashMap();
        this.startStateLessControlParameter = new HashMap();
        if (this.environment.getRequest().getPathInfo() != null) {
            String pathInfo = this.environment.getRequest().getPathInfo();
            StringTokenizer tokenizer = new StringTokenizer(pathInfo, "/");
            boolean mode = false;
            String encodedName = null;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (PortalControlParameter.isControlParameter(token)) {
                    mode = true;
                    encodedName = token;
                    continue;
                }
                if (!mode) {
                    this.startGlobalNavigation.add(token);
                    continue;
                }
                if (!mode) continue;
                if (PortalControlParameter.isStateFullParameter(encodedName)) {
                    encodedName = PortalControlParameter.decodeParameterName(encodedName);
                    this.encodedStartControlParameter.put(encodedName, token);
                } else {
                    this.startStateLessControlParameter.put(PortalControlParameter.decodeParameterName(encodedName), PortalControlParameter.decodeParameterValue(encodedName, token));
                }
                mode = false;
            }
        }
        this.analyzed = true;
    }

    public void setRenderParameter(PortletWindow portletWindow, String name, String[] values) {
        this.encodedStartControlParameter.put(PortalControlParameter.encodeRenderParamName(portletWindow, name), PortalControlParameter.encodeRenderParamValues(values));
    }

    public void clearRenderParameters(PortletWindow portletWindow) {
        String prefix = PortalControlParameter.getRenderParamKey(portletWindow);
        Iterator keyIterator = this.encodedStartControlParameter.keySet().iterator();
        while (keyIterator.hasNext()) {
            String name = (String)keyIterator.next();
            if (!name.startsWith(prefix)) continue;
            keyIterator.remove();
        }
    }
}

