/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portalImpl.core;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.portalImpl.core.PortalControlParameter;
import org.apache.pluto.portalImpl.core.PortalURL;

public class PortalEnvironment {
    public static final String REQUEST_PORTALENV = "org.apache.pluto.portalImpl.core.PortalEnvironment";
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ServletConfig config;
    private PortalURL requestedPortalURL;
    private PortalControlParameter portalControl;

    public PortalEnvironment(HttpServletRequest request, HttpServletResponse response, ServletConfig config) {
        this.request = request;
        this.response = response;
        this.config = config;
        this.requestedPortalURL = new PortalURL(this);
        this.requestedPortalURL.analyzeRequestInformation();
        this.portalControl = new PortalControlParameter(this.requestedPortalURL);
        this.request.setAttribute(REQUEST_PORTALENV, (Object)this);
    }

    public static PortalEnvironment getPortalEnvironment(HttpServletRequest request) {
        return (PortalEnvironment)request.getAttribute(REQUEST_PORTALENV);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletConfig getConfig() {
        return this.config;
    }

    public PortalURL getRequestedPortalURL() {
        return this.requestedPortalURL;
    }

    public PortalControlParameter getPortalControlParameter() {
        return this.portalControl;
    }

    public void changeRequestedPortalURL(PortalURL url, PortalControlParameter control) {
        this.requestedPortalURL = url;
        this.requestedPortalURL.analyzeControlInformation(control);
        this.portalControl = control;
    }
}

