/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portalImpl.core;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.pluto.portalImpl.services.config.Config;
import org.apache.pluto.services.information.PortalContextProvider;

public class PortalContextProviderImpl
implements PortalContextProvider {
    private String info;
    private Vector modes;
    private Vector states;
    private HashMap properties = new HashMap();

    public PortalContextProviderImpl() {
        this.modes = this.getDefaultModes();
        this.states = this.getDefaultStates();
        this.info = Config.getParameters().getString("portaldriver.info");
    }

    public String getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Property name == null");
        }
        return (String)this.properties.get(name);
    }

    public Collection getPropertyNames() {
        return this.properties.keySet();
    }

    public Collection getSupportedPortletModes() {
        return this.modes;
    }

    public Collection getSupportedWindowStates() {
        return this.states;
    }

    public String getPortalInfo() {
        return this.info;
    }

    private Vector getDefaultModes() {
        Vector<PortletMode> m = new Vector<PortletMode>();
        String[] supportedModes = Config.getParameters().getStrings("supported.portletmode");
        for (int i = 0; i < supportedModes.length; ++i) {
            m.add(new PortletMode(supportedModes[i].toString().toLowerCase()));
        }
        return m;
    }

    private Vector getDefaultStates() {
        Vector<WindowState> s = new Vector<WindowState>();
        String[] supportedStates = Config.getParameters().getStrings("supported.windowstate");
        for (int i = 0; i < supportedStates.length; ++i) {
            s.add(new WindowState(supportedStates[i].toString().toLowerCase()));
        }
        return s;
    }

    public void setProperty(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Property name == null");
        }
        this.properties.put(name, value);
    }

    public void setSupportedPortletModes(Enumeration portletModes) {
        Vector v = new Vector();
        while (portletModes.hasMoreElements()) {
            v.add(portletModes.nextElement());
        }
        this.modes = v;
    }

    public void setSupportedWindowStates(Enumeration windowStates) {
        Vector v = new Vector();
        while (windowStates.hasMoreElements()) {
            v.add(windowStates.nextElement());
        }
        this.states = v;
    }

    public void reset(String portalInfo) {
        this.info = new String(portalInfo);
        this.modes = this.getDefaultModes();
        this.states = this.getDefaultStates();
        this.properties.clear();
    }
}

