/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portalImpl.core;

import java.util.HashSet;
import java.util.Iterator;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.portalImpl.core.PortalEnvironment;
import org.apache.pluto.portalImpl.core.PortletActionProviderImpl;
import org.apache.pluto.portalImpl.core.PortletURLProviderImpl;
import org.apache.pluto.portalImpl.core.ResourceURLProviderImpl;
import org.apache.pluto.portalImpl.services.config.Config;
import org.apache.pluto.services.information.DynamicInformationProvider;
import org.apache.pluto.services.information.PortletActionProvider;
import org.apache.pluto.services.information.PortletURLProvider;
import org.apache.pluto.services.information.ResourceURLProvider;

public class DynamicInformationProviderImpl
implements DynamicInformationProvider {
    private static final int NumberOfKnownMimetypes = 15;
    private ServletConfig config;
    private PortalEnvironment env;
    HttpServletRequest request;

    public DynamicInformationProviderImpl(HttpServletRequest request, ServletConfig config) {
        this.request = request;
        this.config = config;
        this.env = PortalEnvironment.getPortalEnvironment(request);
    }

    public PortletMode getPortletMode(PortletWindow portletWindow) {
        return this.env.getPortalControlParameter().getMode(portletWindow);
    }

    public PortletURLProvider getPortletURLProvider(PortletWindow portletWindow) {
        return new PortletURLProviderImpl(this, portletWindow);
    }

    public ResourceURLProvider getResourceURLProvider(PortletWindow portletWindow) {
        return new ResourceURLProviderImpl(this, portletWindow);
    }

    public PortletActionProvider getPortletActionProvider(PortletWindow portletWindow) {
        return new PortletActionProviderImpl(this.request, this.config, portletWindow);
    }

    public PortletMode getPreviousPortletMode(PortletWindow portletWindow) {
        return this.env.getPortalControlParameter().getPrevMode(portletWindow);
    }

    public WindowState getPreviousWindowState(PortletWindow portletWindow) {
        return this.env.getPortalControlParameter().getPrevState(portletWindow);
    }

    public String getResponseContentType() {
        return "text/html";
    }

    public Iterator getResponseContentTypes() {
        HashSet<String> responseMimeTypes = new HashSet<String>(15);
        responseMimeTypes.add("text/html");
        return responseMimeTypes.iterator();
    }

    public WindowState getWindowState(PortletWindow portletWindow) {
        return this.env.getPortalControlParameter().getState(portletWindow);
    }

    public boolean isPortletModeAllowed(PortletMode mode) {
        String[] supportedModes = Config.getParameters().getStrings("supported.portletmode");
        for (int i = 0; i < supportedModes.length; ++i) {
            if (!supportedModes[i].equalsIgnoreCase(mode.toString())) continue;
            return true;
        }
        return false;
    }

    public boolean isWindowStateAllowed(WindowState state) {
        String[] supportedStates = Config.getParameters().getStrings("supported.windowstate");
        for (int i = 0; i < supportedStates.length; ++i) {
            if (!supportedStates[i].equalsIgnoreCase(state.toString())) continue;
            return true;
        }
        return false;
    }
}

