/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portalImpl.aggregation;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.portlet.PortletMode;
import javax.portlet.UnavailableException;
import javax.portlet.WindowState;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.om.ControllerObjectAccess;
import org.apache.pluto.om.Model;
import org.apache.pluto.om.common.Language;
import org.apache.pluto.om.common.LanguageSet;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.portlet.ContentType;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.servlet.ServletDefinition;
import org.apache.pluto.om.servlet.ServletDefinitionCtrl;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.om.window.PortletWindowCtrl;
import org.apache.pluto.om.window.PortletWindowList;
import org.apache.pluto.om.window.PortletWindowListCtrl;
import org.apache.pluto.portalImpl.aggregation.AbstractFragmentSingle;
import org.apache.pluto.portalImpl.aggregation.Fragment;
import org.apache.pluto.portalImpl.aggregation.navigation.Navigation;
import org.apache.pluto.portalImpl.core.DynamicTitleServiceImpl;
import org.apache.pluto.portalImpl.core.PortalControlParameter;
import org.apache.pluto.portalImpl.core.PortalEnvironment;
import org.apache.pluto.portalImpl.core.PortalURL;
import org.apache.pluto.portalImpl.core.PortletContainerFactory;
import org.apache.pluto.portalImpl.factory.FactoryAccess;
import org.apache.pluto.portalImpl.om.window.impl.PortletWindowImpl;
import org.apache.pluto.portalImpl.services.log.Log;
import org.apache.pluto.portalImpl.services.portletentityregistry.PortletEntityRegistry;
import org.apache.pluto.portalImpl.servlet.ServletObjectAccess;
import org.apache.pluto.portalImpl.servlet.ServletResponseImpl;
import org.apache.pluto.portalImpl.util.ObjectID;
import org.apache.pluto.services.information.DynamicInformationProvider;
import org.apache.pluto.services.information.PortalContextProvider;
import org.apache.pluto.services.log.Logger;

public class PortletFragment
extends AbstractFragmentSingle {
    private PortletWindow portletWindow;
    private Logger log = Log.getService().getLogger(this.getClass());
    public static final String PORTLET_ERROR_MSG = "Error occurred in portlet!";
    static /* synthetic */ Class class$org$apache$pluto$portalImpl$aggregation$PortletFragment$PortletWindowStateInfo;
    static /* synthetic */ Class class$org$apache$pluto$portalImpl$aggregation$PortletFragment$PortletModeInfo;

    public PortletFragment(String id, ServletConfig config, Fragment parent, org.apache.pluto.portalImpl.om.page.Fragment fragDesc, Navigation navigation) throws Exception {
        super(id, config, parent, fragDesc, navigation);
        String portletEntityId = this.getInitParameters().getString("portlet");
        PortletEntity portletEntity = PortletEntityRegistry.getPortletEntity(ObjectID.createFromString(portletEntityId));
        this.portletWindow = new PortletWindowImpl(this.getId());
        ((PortletWindowCtrl)this.portletWindow).setPortletEntity(portletEntity);
        PortletWindowList windowList = portletEntity.getPortletWindowList();
        ((PortletWindowListCtrl)windowList).add(this.portletWindow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WindowState currentState;
        HttpServletRequest wrappedRequest = ServletObjectAccess.getServletRequest(request, this.portletWindow);
        ServletResponseImpl wrappedResponse = (ServletResponseImpl)ServletObjectAccess.getServletResponse(response);
        PrintWriter responseWriter = response.getWriter();
        StringWriter storedWriter = new StringWriter();
        String errorMsg = null;
        try {
            PortletContainerFactory.getPortletContainer().portletLoad(this.portletWindow, wrappedRequest, response);
        }
        catch (PortletContainerException e) {
            this.log.error("Error in Portlet", (Throwable)e);
            errorMsg = this.getErrorMsg();
        }
        catch (Throwable t) {
            this.log.error("Error in Portlet", t);
            if (t instanceof VirtualMachineError) {
                throw (Error)t;
            }
            errorMsg = this.getErrorMsg();
        }
        PortalEnvironment env = (PortalEnvironment)request.getAttribute("org.apache.pluto.portalImpl.core.PortalEnvironment");
        PortalURL thisURL = env.getRequestedPortalURL();
        PortalControlParameter thisControl = new PortalControlParameter(thisURL);
        if (thisControl.isOnePortletWindowMaximized() && !WindowState.MAXIMIZED.equals((Object)(currentState = thisControl.getState(this.portletWindow)))) {
            return;
        }
        PortletDefinition portletDefinition = this.portletWindow.getPortletEntity().getPortletDefinition();
        LanguageSet languageSet = portletDefinition.getLanguageSet();
        Language lang = languageSet.get(request.getLocale());
        String title = lang != null ? lang.getTitle() : "no title available";
        PortletInfo portletInfo = new PortletInfo();
        ServletDefinition servletDefinition = this.portletWindow.getPortletEntity().getPortletDefinition().getServletDefinition();
        if (servletDefinition != null && !servletDefinition.isUnavailable()) {
            PrintWriter writer2 = new PrintWriter(storedWriter);
            wrappedResponse = (ServletResponseImpl)ServletObjectAccess.getStoredServletResponse(response, writer2);
            try {
                PortletContainerFactory.getPortletContainer().renderPortlet(this.portletWindow, wrappedRequest, (HttpServletResponse)wrappedResponse);
            }
            catch (UnavailableException e) {
                this.log.error("Portlet is Unavailable", (Throwable)e);
                writer2.println("the portlet is currently unavailable!");
                ServletDefinitionCtrl servletDefinitionCtrl = (ServletDefinitionCtrl)ControllerObjectAccess.get((Model)this.portletWindow.getPortletEntity().getPortletDefinition().getServletDefinition());
                if (e.isPermanent()) {
                    servletDefinitionCtrl.setAvailable(Long.MAX_VALUE);
                } else {
                    int unavailableSeconds = e.getUnavailableSeconds();
                    if (unavailableSeconds <= 0) {
                        unavailableSeconds = 60;
                    }
                    servletDefinitionCtrl.setAvailable(System.currentTimeMillis() + (long)(unavailableSeconds * 1000));
                }
            }
            catch (Exception e) {
                this.log.error("Error in Portlet", (Throwable)e);
                writer2.println(this.getErrorMsg());
            }
            String dyn_title = ((DynamicTitleServiceImpl)FactoryAccess.getDynamicTitleContainerService()).getDynamicTitle(this.portletWindow, request);
            if (dyn_title != null) {
                title = dyn_title;
            }
        }
        portletInfo.setTitle(title);
        DynamicInformationProvider provider = FactoryAccess.getDynamicProvider(request);
        ContentType supported = portletDefinition.getContentTypeSet().get(wrappedResponse.getContentType());
        PortalContextProvider portalContextProvider = FactoryAccess.getStaticProvider().getPortalContextProvider();
        if (supported != null && portalContextProvider != null) {
            Iterator modes = supported.getPortletModes();
            while (modes.hasNext()) {
                PortletMode mode = (PortletMode)modes.next();
                boolean portalSupport = false;
                Iterator portalSupportedModes = portalContextProvider.getSupportedPortletModes().iterator();
                while (portalSupportedModes.hasNext()) {
                    PortletMode portalSupportedMode = (PortletMode)portalSupportedModes.next();
                    if (!mode.equals((Object)portalSupportedMode)) continue;
                    portalSupport = true;
                    break;
                }
                if (!portalSupport) continue;
                env = (PortalEnvironment)request.getAttribute("org.apache.pluto.portalImpl.core.PortalEnvironment");
                PortalURL modeURL = env.getRequestedPortalURL();
                PortalControlParameter control = new PortalControlParameter(modeURL);
                PortletMode currentMode = control.getMode(this.portletWindow);
                control.setMode(this.portletWindow, mode);
                portletInfo.addPortletMode(mode, modeURL.toString(control, new Boolean(request.isSecure())), mode.equals((Object)currentMode));
            }
            Iterator states = portalContextProvider.getSupportedWindowStates().iterator();
            while (states.hasNext()) {
                WindowState state = (WindowState)states.next();
                env = (PortalEnvironment)request.getAttribute("org.apache.pluto.portalImpl.core.PortalEnvironment");
                PortalURL stateURL = env.getRequestedPortalURL();
                PortalControlParameter control = new PortalControlParameter(stateURL);
                WindowState currentState2 = control.getState(this.portletWindow);
                control.setState(this.portletWindow, state);
                portletInfo.addPortletWindowState(state.toString().substring(0, 3), stateURL.toString(control, new Boolean(request.isSecure())), state.equals((Object)currentState2));
            }
        }
        request.setAttribute("portletInfo", (Object)portletInfo);
        RequestDispatcher rd = this.getServletConfig().getServletContext().getRequestDispatcher(BASE_ROOT + "PortletFragmentHeader.jsp");
        rd.include((ServletRequest)request, (ServletResponse)response);
        try {
            if (errorMsg == null) {
                if (this.portletWindow.getPortletEntity().getPortletDefinition().getServletDefinition().isUnavailable()) {
                    responseWriter.println("the portlet is currently unavailable!");
                } else {
                    responseWriter.println(storedWriter.toString());
                }
            } else {
                responseWriter.println(errorMsg);
            }
        }
        finally {
            RequestDispatcher rdFooter = this.getServletConfig().getServletContext().getRequestDispatcher(BASE_ROOT + "PortletFragmentFooter.jsp");
            rdFooter.include((ServletRequest)request, (ServletResponse)response);
            request.removeAttribute("portletInfo");
        }
    }

    public void createURL(PortalURL url) {
        this.getParent().createURL(url);
        url.addLocalNavigation(this.getId());
    }

    public boolean isPartOfURL(PortalURL url) {
        return true;
    }

    public PortletWindow getPortletWindow() {
        return this.portletWindow;
    }

    protected String getErrorMsg() {
        return PORTLET_ERROR_MSG;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class PortletModeInfo
    implements Comparable {
        private String name;
        private String url;
        private boolean isCurrent;

        public PortletModeInfo(String name, String url, boolean isCurrent) {
            this.name = name;
            this.url = url;
            this.isCurrent = isCurrent;
        }

        public boolean isCurrent() {
            return this.isCurrent;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setCurrent(boolean b) {
            this.isCurrent = b;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setUrl(String string) {
            this.url = string;
        }

        public int compareTo(Object compare) {
            if (!(compare instanceof PortletModeInfo)) {
                throw new ClassCastException(compare + " is not a " + (class$org$apache$pluto$portalImpl$aggregation$PortletFragment$PortletModeInfo == null ? (class$org$apache$pluto$portalImpl$aggregation$PortletFragment$PortletModeInfo = PortletFragment.class$("org.apache.pluto.portalImpl.aggregation.PortletFragment$PortletModeInfo")) : class$org$apache$pluto$portalImpl$aggregation$PortletFragment$PortletModeInfo).getName());
            }
            PortletModeInfo other = (PortletModeInfo)compare;
            return this.getName().compareTo(other.getName());
        }

        public String toString() {
            return this.getName();
        }
    }

    public static class PortletWindowStateInfo
    implements Comparable {
        private String label;
        private String url;
        private boolean isCurrent;

        public int compareTo(Object compare) {
            if (!(compare instanceof PortletWindowStateInfo)) {
                throw new ClassCastException(compare + " is not a " + (class$org$apache$pluto$portalImpl$aggregation$PortletFragment$PortletWindowStateInfo == null ? (class$org$apache$pluto$portalImpl$aggregation$PortletFragment$PortletWindowStateInfo = PortletFragment.class$("org.apache.pluto.portalImpl.aggregation.PortletFragment$PortletWindowStateInfo")) : class$org$apache$pluto$portalImpl$aggregation$PortletFragment$PortletWindowStateInfo).getName());
            }
            PortletWindowStateInfo other = (PortletWindowStateInfo)compare;
            return this.getLabel().compareTo(other.getLabel());
        }

        public PortletWindowStateInfo(String stateLabel, String activationURL, boolean isCurrent) {
            this.label = stateLabel;
            this.url = activationURL;
            this.isCurrent = isCurrent;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String string) {
            this.label = string;
        }

        public boolean isCurrent() {
            return this.isCurrent;
        }

        public String getUrl() {
            return this.url;
        }

        public void setCurrent(boolean b) {
            this.isCurrent = b;
        }

        public void setUrl(String string) {
            this.url = string;
        }

        public String toString() {
            return this.getLabel();
        }
    }

    public static class PortletInfo {
        private String title;
        private List availablePortletModes = new ArrayList();
        private List availablePortletWindowStates = new ArrayList();

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public List getAvailablePortletModes() {
            return this.availablePortletModes;
        }

        public void addPortletMode(PortletMode mode, String activationURL, boolean isCurrent) {
            PortletModeInfo pmi = new PortletModeInfo(mode.toString(), activationURL, isCurrent);
            this.availablePortletModes.add(pmi);
        }

        public List getAvailablePortletWindowStates() {
            return this.availablePortletWindowStates;
        }

        public void addPortletWindowState(String stateLabel, String activationURL, boolean isCurrent) {
            PortletWindowStateInfo pwsi = new PortletWindowStateInfo(stateLabel, activationURL, isCurrent);
            this.availablePortletWindowStates.add(pwsi);
        }
    }
}

