/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portalImpl.aggregation;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.portalImpl.aggregation.Fragment;
import org.apache.pluto.portalImpl.aggregation.navigation.Navigation;
import org.apache.pluto.portalImpl.core.PortalURL;
import org.apache.pluto.portalImpl.om.page.Property;
import org.apache.pluto.portalImpl.services.config.Config;
import org.apache.pluto.portalImpl.services.pageregistry.PageRegistry;
import org.apache.pluto.portalImpl.util.Parameters;
import org.apache.pluto.util.StringUtils;

public abstract class AbstractFragment
implements Fragment {
    public static final String BASE_ROOT = Config.getParameters().getString("aggregation.base.dir", "/WEB-INF/aggregation/");
    private String id;
    private ServletConfig config;
    private Fragment parent;
    private org.apache.pluto.portalImpl.om.page.Fragment fragDesc;
    private Parameters initParameters;
    private Navigation navigation;

    public AbstractFragment(String id, ServletConfig config, Fragment parent, org.apache.pluto.portalImpl.om.page.Fragment fragDesc, Navigation navigation) throws Exception {
        String parentID;
        StringBuffer compId = new StringBuffer();
        if (parent != null && (parentID = parent.getId()) != null) {
            compId.append(parentID);
            compId.append("_");
        }
        if (id != null) {
            compId.append(id);
            this.id = compId.toString();
        }
        this.config = config;
        this.parent = parent;
        this.fragDesc = fragDesc;
        this.navigation = navigation;
        if (this.fragDesc != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            Iterator iterator = this.fragDesc.getProperties().iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                map.put(property.getName(), property.getValue());
            }
            this.initParameters = new Parameters(map);
        }
        PageRegistry.addFragment(this);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.preService(request, response);
        request.setAttribute("fragment", (Object)this);
        String jspName = StringUtils.nameOf(this.getClass()) + ".jsp";
        RequestDispatcher rd = this.getServletConfig().getServletContext().getRequestDispatcher(BASE_ROOT + jspName);
        rd.include((ServletRequest)request, (ServletResponse)response);
        this.postService(request, response);
    }

    public Fragment getParent() {
        return this.parent;
    }

    public String getId() {
        return this.id;
    }

    public Parameters getInitParameters() {
        return this.initParameters;
    }

    public abstract Collection getChildFragments();

    public abstract void addChild(Fragment var1);

    public Navigation getNavigation() {
        return this.navigation;
    }

    public abstract void createURL(PortalURL var1);

    public abstract boolean isPartOfURL(PortalURL var1);

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public String getInitParameterValue(String name) {
        return this.initParameters.getString(name);
    }

    public abstract void preService(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    public abstract void postService(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    protected org.apache.pluto.portalImpl.om.page.Fragment getFragmentDescription() {
        return this.fragDesc;
    }
}

