/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portalImpl;

import java.io.IOException;
import java.util.Properties;
import javax.portlet.PortletException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.portalImpl.aggregation.RootFragment;
import org.apache.pluto.portalImpl.core.PortalControlParameter;
import org.apache.pluto.portalImpl.core.PortalEnvironment;
import org.apache.pluto.portalImpl.core.PortalURL;
import org.apache.pluto.portalImpl.core.PortletContainerEnvironment;
import org.apache.pluto.portalImpl.core.PortletContainerFactory;
import org.apache.pluto.portalImpl.factory.FactoryAccess;
import org.apache.pluto.portalImpl.services.ServiceManager;
import org.apache.pluto.portalImpl.services.config.Config;
import org.apache.pluto.portalImpl.services.factorymanager.FactoryManager;
import org.apache.pluto.portalImpl.services.log.Log;
import org.apache.pluto.portalImpl.services.pageregistry.PageRegistry;
import org.apache.pluto.portalImpl.servlet.ServletObjectAccess;
import org.apache.pluto.services.ContainerService;
import org.apache.pluto.services.log.Logger;

public class Servlet
extends HttpServlet {
    private static String CONTENT_TYPE = "text/html";
    private static String CONTAINER_SUPPORTS_BUFFERING = "portletcontainer.supportsBuffering";
    private Logger log;

    public String getServletInfo() {
        return "portalImpl - Pluto Driver";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String charset = config.getInitParameter("charset");
        if (charset != null && charset.length() > 0) {
            CONTENT_TYPE = "text/html; charset=" + charset;
        }
        try {
            ServiceManager.init(config);
        }
        catch (Throwable exc) {
            this.log("Initialization failed!", exc);
            throw new UnavailableException("Initialization of one or more services failed.");
        }
        try {
            ServiceManager.postInit(config);
        }
        catch (Throwable expos) {
            this.log("Post initialization failed!", expos);
            throw new UnavailableException("Post initialization of one or more services failed.");
        }
        this.log = Log.getService().getLogger(((Object)((Object)this)).getClass());
        if (!PortletContainerFactory.getPortletContainer().isInitialized()) {
            String uniqueContainerName = Config.getParameters().getString("portletcontainer.uniquename", "pluto");
            if (this.log.isInfoEnabled()) {
                this.log.info("Initializing PortletContainer [" + uniqueContainerName + "]...");
            }
            PortletContainerEnvironment environment = new PortletContainerEnvironment();
            environment.addContainerService((ContainerService)Log.getService());
            environment.addContainerService((ContainerService)FactoryManager.getService());
            environment.addContainerService((ContainerService)FactoryAccess.getInformationProviderContainerService());
            environment.addContainerService((ContainerService)FactoryAccess.getDynamicTitleContainerService());
            String allowSetBufferSizeString = Config.getParameters().getString(CONTAINER_SUPPORTS_BUFFERING);
            boolean allowSetBufferSize = false;
            if (allowSetBufferSizeString == null) {
                this.log.warn("org.apache.pluto.portalImpl.Servlet#init(): Couldn't read property \"pluto.allowSetBufferSize\" from config file ConfigService.properties");
            } else {
                allowSetBufferSize = allowSetBufferSizeString.equalsIgnoreCase("yes");
            }
            Properties containerProperties = new Properties();
            containerProperties.put(CONTAINER_SUPPORTS_BUFFERING, new Boolean(allowSetBufferSize));
            try {
                PortletContainerFactory.getPortletContainer().init(uniqueContainerName, config, (org.apache.pluto.services.PortletContainerEnvironment)environment, containerProperties);
            }
            catch (PortletContainerException exc) {
                this.log.error("Initialization of the portlet container failed!", (Throwable)exc);
                throw new UnavailableException("Initialization of the portlet container failed.");
            }
        } else if (this.log.isInfoEnabled()) {
            this.log.info("PortletContainer already initialized");
        }
        this.log.debug("Ready to serve you.");
    }

    public void destroy() {
        if (this.log.isInfoEnabled()) {
            this.log.info("Shutting down portlet container. . .");
        }
        try {
            PortletContainerFactory.getPortletContainer().shutdown();
            ServiceManager.destroy(this.getServletConfig());
            System.gc();
        }
        catch (Throwable t) {
            this.log("Destruction failed!", t);
        }
    }

    public void doGet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException, ServletException {
        PortalEnvironment env;
        PortalURL currentURL;
        PortalControlParameter control;
        PortletWindow actionWindow;
        servletResponse.setContentType(CONTENT_TYPE);
        String theService = servletRequest.getParameter("hotDeploy");
        if (theService != null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Hot deploying portlet. . .");
            }
            String[] svcs = new String[]{"org.apache.pluto.portalImpl.services.portletdefinitionregistry.PortletDefinitionRegistryService", "org.apache.pluto.portalImpl.services.portletentityregistry.PortletEntityRegistryService", "org.apache.pluto.portalImpl.services.pageregistry.PageRegistryService"};
            int len = svcs.length;
            for (int i = 0; i < len; ++i) {
                String svc;
                try {
                    ServiceManager.hotInit(this.getServletConfig(), svcs[i]);
                }
                catch (Throwable e) {
                    svc = svcs[i].substring(svcs[i].lastIndexOf(46) + 1);
                    String msg = "Initialization of " + svc + " service for hot deployment failed!";
                    this.log.error(msg, e);
                    break;
                }
                try {
                    ServiceManager.postHotInit(this.getServletConfig(), svcs[i]);
                    continue;
                }
                catch (Throwable e) {
                    svc = svcs[i].substring(svcs[i].lastIndexOf(46) + 1);
                    String msg = "Post initialization of " + svc + " service for hot deployment failed!";
                    this.log.error(msg, e);
                    break;
                }
            }
        }
        if ((actionWindow = (control = new PortalControlParameter(currentURL = (env = new PortalEnvironment(servletRequest, servletResponse, this.getServletConfig())).getRequestedPortalURL())).getPortletWindowOfAction()) != null) {
            try {
                PortletContainerFactory.getPortletContainer().processPortletAction(actionWindow, ServletObjectAccess.getServletRequest(servletRequest, actionWindow), ServletObjectAccess.getServletResponse(servletResponse));
            }
            catch (PortletException e) {
                this.log.error((Throwable)e);
            }
            catch (PortletContainerException e) {
                this.log.error((Throwable)e);
            }
            catch (Exception e) {
                this.log.error((Throwable)e);
            }
            return;
        }
        try {
            RootFragment root = PageRegistry.getRootFragment();
            root.service(servletRequest, servletResponse);
        }
        catch (Throwable t) {
            this.log.error(t);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }
}

