/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.propertyset.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PropertySetConfig {
    private static PropertySetConfig config;
    private static final Object lock;
    private static final String[] CONFIG_LOCATIONS;
    private HashMap propertySetArgs = new HashMap();
    private HashMap propertySets = new HashMap();
    static /* synthetic */ Class class$com$opensymphony$module$propertyset$config$PropertySetConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertySetConfig() {
        InputStream is = this.load();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        Document doc = null;
        try {
            doc = db.parse(is);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        Element root = (Element)doc.getElementsByTagName("propertysets").item(0);
        NodeList propertySets = root.getElementsByTagName("propertyset");
        for (int i = 0; i < propertySets.getLength(); ++i) {
            Element propertySet = (Element)propertySets.item(i);
            String name = propertySet.getAttribute("name");
            String clazz = propertySet.getAttribute("class");
            this.propertySets.put(name, clazz);
            NodeList args = propertySet.getElementsByTagName("arg");
            HashMap<String, String> argsMap = new HashMap<String, String>();
            for (int j = 0; j < args.getLength(); ++j) {
                Element arg = (Element)args.item(j);
                String argName = arg.getAttribute("name");
                String argValue = arg.getAttribute("value");
                argsMap.put(argName, argValue);
            }
            this.propertySetArgs.put(name, argsMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertySetConfig getConfig() {
        Object object = lock;
        synchronized (object) {
            if (config == null) {
                config = new PropertySetConfig();
            }
            return config;
        }
    }

    public Map getArgs(String name) {
        return (Map)this.propertySetArgs.get(name);
    }

    public String getClassName(String name) {
        return (String)this.propertySets.get(name);
    }

    public static URL getResource(String resourceName, Class callingClass) {
        ClassLoader cl;
        URL url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (url == null) {
            url = (class$com$opensymphony$module$propertyset$config$PropertySetConfig == null ? (class$com$opensymphony$module$propertyset$config$PropertySetConfig = PropertySetConfig.class$("com.opensymphony.module.propertyset.config.PropertySetConfig")) : class$com$opensymphony$module$propertyset$config$PropertySetConfig).getClassLoader().getResource(resourceName);
        }
        if (url == null && (cl = callingClass.getClassLoader()) != null) {
            url = cl.getResource(resourceName);
        }
        if (url == null && resourceName != null && resourceName.charAt(0) != '/') {
            return PropertySetConfig.getResource('/' + resourceName, callingClass);
        }
        return url;
    }

    private InputStream load() throws IllegalArgumentException {
        InputStream is = null;
        for (int i = 0; i < CONFIG_LOCATIONS.length; ++i) {
            String location = CONFIG_LOCATIONS[i];
            try {
                URL resource = PropertySetConfig.getResource(location, this.getClass());
                if (resource != null) {
                    is = resource.openStream();
                }
                if (is == null) continue;
                return is;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (is == null) {
            String exceptionMessage = "Could not load propertyset config using '" + CONFIG_LOCATIONS + "'.  Please check your classpath.";
            throw new IllegalArgumentException(exceptionMessage);
        }
        return is;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        lock = new Object();
        CONFIG_LOCATIONS = new String[]{"propertyset.xml", "/propertyset.xml", "META-INF/propertyset.xml", "/META-INF/propertyset.xml", "META-INF/propertyset-default.xml", "/META-INF/propertyset-default.xml"};
    }
}

