/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Hashtable;
import java.util.Properties;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBColumn;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBData;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBDataSetImpl;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.dbaccess.DBStatement;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.ttc7.LongTTCItem;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.NonPlsqlTTCDataSet;
import oracle.jdbc.ttc7.NtyTTCItem;
import oracle.jdbc.ttc7.O3log;
import oracle.jdbc.ttc7.Oall7;
import oracle.jdbc.ttc7.Oclose;
import oracle.jdbc.ttc7.Ocommoncall;
import oracle.jdbc.ttc7.Odscrarr;
import oracle.jdbc.ttc7.Okod;
import oracle.jdbc.ttc7.Oopen;
import oracle.jdbc.ttc7.Oversion;
import oracle.jdbc.ttc7.RefCursorTTCItem;
import oracle.jdbc.ttc7.RefTTCItem;
import oracle.jdbc.ttc7.TTCAdapter;
import oracle.jdbc.ttc7.TTCConversion;
import oracle.jdbc.ttc7.TTCDataSet;
import oracle.jdbc.ttc7.TTCItem;
import oracle.jdbc.ttc7.TTCStatement;
import oracle.jdbc.ttc7.TTCTypeRep;
import oracle.jdbc.ttc7.TTIdty;
import oracle.jdbc.ttc7.TTIoac;
import oracle.jdbc.ttc7.TTIrxd;
import oracle.jdbc.ttc7.v8TTIoac;
import oracle.jdbc.ttc7.v8TTIpro;
import oracle.net.ns.Communication;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NetException;

public class TTC7Protocol
extends DBAccess {
    private final boolean DEBUG = false;
    public static final short MIN_OVERSION_SUPPORTED = 7230;
    public static final short MIN_TTCVER_SUPPORTED = 4;
    public static final short V8_TTCVER_SUPPORTED = 5;
    public static final short MAX_TTCVER_SUPPORTED = 6;
    private static final String DEFAULT_CONNECT_STRING = "localhost:1521:orcl";
    private static final int STREAM_CHUNK_SIZE = 255;
    public static final int REFCURSOR_SIZE = 5;
    protected long LOGON_MODE = 0L;
    private static final long SYSDBA = 8L;
    private static final long SYSOPER = 16L;
    protected static final byte PARSE_CALL = 1;
    protected static final byte PARSE_EXECUTE_CALL = 2;
    protected static final byte EXECUTE_FETCH_CALL = 3;
    protected static final byte PARSE_EXECUTE_FETCH_CALL = 4;
    protected static final byte FETCH_CALL = 5;
    private final byte TTC_NOTLOGGEDON = 0;
    private final byte TTC_LOGGEDON = 1;
    private byte state = 0;
    private Communication net;
    private MAREngine MEngine;
    private v8TTIpro pro;
    private TTIdty dty;
    private TTIrxd rxd;
    private O3log log1;
    private O3log log2;
    private Oversion ver;
    private Oopen opencall;
    private Odscrarr describe;
    private Oall7 all7;
    private Oclose close;
    private Ocommoncall commoncall;
    private byte[] EMPTY_BYTE = new byte[0];

    public synchronized byte[] DBStatementToRefCursorBytes(DBStatement dBStatement) throws SQLException, IOException {
        byte[] byArray = new byte[4];
        byte by = this.MEngine.value2Buffer(((TTCStatement)dBStatement).getCursor(), byArray, (byte)2);
        return byArray;
    }

    public synchronized DBStatement RefCursorBytesToDBStatement(byte[] byArray) throws SQLException, IOException {
        return new TTCStatement(this.MEngine.unmarshalRefCursor(byArray));
    }

    public synchronized void archive(int n, int n2, String string) throws SQLException {
    }

    public void cancel() throws SQLException, IOException {
        try {
            this.net.sendBreak();
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
    }

    public synchronized void close(DBStatement dBStatement) throws SQLException, IOException {
        TTCStatement tTCStatement = (TTCStatement)dBStatement;
        if (this.state < 1) {
            DBError.check_error(430);
        }
        this.close.init(tTCStatement, (byte)8);
        this.close.marshal();
        this.close.receive();
    }

    public synchronized void closeQuery(DBStatement dBStatement) throws SQLException, IOException {
        TTCStatement tTCStatement = (TTCStatement)dBStatement;
        if (this.state < 1) {
            DBError.check_error(430);
        }
        this.close.init(tTCStatement, (byte)20);
        this.close.marshal();
        this.close.receive();
    }

    public synchronized void commit() throws SQLException, IOException {
        if (this.state < 1) {
            DBError.check_error(430);
        }
        this.commoncall.init((byte)14);
        this.commoncall.marshal();
        this.commoncall.receive();
    }

    private void connect(String string, Properties properties) throws IOException, SQLException {
        if (string == null || properties == null) {
            DBError.check_error(433);
        }
        this.net = new NSProtocol();
        try {
            this.net.connect(string, properties);
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        this.MEngine = new MAREngine(this.net);
        this.pro = new v8TTIpro(this.MEngine);
        this.pro.marshal();
        this.pro.receive();
        short s = this.pro.getOracleVersion();
        short s2 = this.pro.getCharacterSet();
        short s3 = TTCConversion.findAccessCharSet(s2, s);
        TTCConversion tTCConversion = new TTCConversion(s2, s3, s, this.pro.getncharCHARSET());
        this.MEngine.types.setServerConversion(s3 != s2);
        this.MEngine.types.setVersion(s);
        if (DBConversion.isCharSetMultibyte(s3)) {
            if (DBConversion.isCharSetMultibyte(this.pro.getCharacterSet())) {
                this.MEngine.types.setFlags((byte)1);
            } else {
                this.MEngine.types.setFlags((byte)2);
            }
        } else {
            this.MEngine.types.setFlags(this.pro.getFlags());
        }
        this.MEngine.conv = tTCConversion;
    }

    public synchronized DBItem createDBItem(DBType dBType) {
        TTCItem tTCItem;
        int n = dBType.is_stream ? 8 : dBType.type;
        switch (n) {
            case 8: {
                tTCItem = new LongTTCItem(this.MEngine, dBType);
                break;
            }
            case 109: {
                tTCItem = new NtyTTCItem(this.MEngine, dBType);
                break;
            }
            case 111: {
                tTCItem = new RefTTCItem(this.MEngine, dBType);
                break;
            }
            case 102: {
                tTCItem = new RefCursorTTCItem(this.MEngine, dBType);
                break;
            }
            default: {
                tTCItem = new TTCItem(this.MEngine, dBType);
            }
        }
        return tTCItem;
    }

    public synchronized DBType createDBType(int n, boolean bl) throws SQLException {
        TTIoac tTIoac = null;
        short s = this.MEngine.types.getVersion();
        tTIoac = s < 8030 ? new TTIoac(n, this.MEngine, 7230) : new v8TTIoac(n, this.MEngine, 8030);
        if (bl) {
            tTIoac.setFieldsForBinds(n, this.getC2SNlsRatio());
        }
        return tTIoac;
    }

    public synchronized DBType createDBType(int n, boolean bl, boolean bl2) throws SQLException {
        TTIoac tTIoac = (TTIoac)this.createDBType(n, true);
        if (bl2) {
            tTIoac.setPlsqlMaxLength();
        }
        return tTIoac;
    }

    public synchronized DBColumn[] describe(DBStatement dBStatement) throws SQLException, IOException {
        if (dBStatement == null) {
            DBError.check_error(433);
        }
        TTCStatement tTCStatement = (TTCStatement)dBStatement;
        int n = 0;
        DBColumn[] dBColumnArray = null;
        if (this.state < 1) {
            DBError.check_error(430);
        }
        do {
            this.describe.init(tTCStatement, n);
            this.describe.marshal();
        } while ((n += this.describe.numuds) < (dBColumnArray = this.describe.receive(dBColumnArray)).length);
        return dBColumnArray;
    }

    private void doOall7(byte by, byte by2, int n, byte[] byArray, DBType[] dBTypeArray, DBData[] dBDataArray, int n2, DBType[] dBTypeArray2, DBData[] dBDataArray2, int n3) throws SQLException, IOException {
        if (this.state < 1) {
            DBError.check_error(430);
        }
        if (by2 != 1 && by2 != 3 && by2 != 0 && by2 != 2) {
            DBError.check_error(439);
        }
        TTCAdapter tTCAdapter = new TTCAdapter(this.MEngine);
        TTCDataSet tTCDataSet = null;
        NonPlsqlTTCDataSet nonPlsqlTTCDataSet = null;
        if (by2 == 1) {
            tTCDataSet = tTCAdapter.createPlsqlTTCDataSet(dBTypeArray, dBDataArray, dBTypeArray2, dBDataArray2);
            nonPlsqlTTCDataSet = tTCAdapter.createNonPlsqlTTCDataSet(dBTypeArray2, dBDataArray2, 0, false);
        } else {
            tTCDataSet = tTCAdapter.createNonPlsqlTTCDataSet(dBTypeArray, dBDataArray, n2, true);
            nonPlsqlTTCDataSet = tTCAdapter.createNonPlsqlTTCDataSet(dBTypeArray2, dBDataArray2, n3, false);
        }
        this.all7.init(by, by2, n, byArray, tTCDataSet, nonPlsqlTTCDataSet);
        this.all7.marshal();
        this.all7.defines.marshalTypes();
        this.all7.binds.marshalTypes();
        this.all7.rxd.init(tTCDataSet, nonPlsqlTTCDataSet);
        while (this.all7.binds.next()) {
            this.all7.rxd.marshal();
        }
        this.all7.receive();
    }

    public synchronized int executeFetch(DBStatement dBStatement, byte by, DBDataSet dBDataSet, int n, DBDataSet dBDataSet2, int n2) throws SQLException, IOException {
        DBType[] dBTypeArray = null;
        DBData[] dBDataArray = null;
        DBType[] dBTypeArray2 = null;
        DBData[] dBDataArray2 = null;
        if (dBDataSet != null) {
            dBTypeArray = ((DBDataSetImpl)dBDataSet).getDBTypes();
            dBDataArray = ((DBDataSetImpl)dBDataSet).getDBData();
        }
        if (dBDataSet2 != null) {
            dBTypeArray2 = ((DBDataSetImpl)dBDataSet2).getDBTypes();
            dBDataArray2 = ((DBDataSetImpl)dBDataSet2).getDBData();
        }
        if (dBStatement == null || by < 0 || by > 3) {
            DBError.check_error(433);
        }
        try {
            try {
                this.doOall7((byte)3, by, ((TTCStatement)dBStatement).getCursor(), this.EMPTY_BYTE, dBTypeArray, dBDataArray, n, dBTypeArray2, dBDataArray2, n2);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            Object var12_13 = null;
            dBStatement.rows_processed = this.all7.rowsProcessed;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            dBStatement.rows_processed = this.all7.rowsProcessed;
            throw throwable;
        }
        return this.all7.getNumRows();
    }

    public synchronized int fetch(DBStatement dBStatement, DBDataSet dBDataSet, int n) throws SQLException, IOException {
        DBType[] dBTypeArray = null;
        DBData[] dBDataArray = null;
        if (dBDataSet != null) {
            dBTypeArray = ((DBDataSetImpl)dBDataSet).getDBTypes();
            dBDataArray = ((DBDataSetImpl)dBDataSet).getDBData();
        }
        if (dBStatement == null) {
            DBError.check_error(433);
        }
        this.doOall7((byte)5, (byte)0, ((TTCStatement)dBStatement).getCursor(), this.EMPTY_BYTE, null, null, 0, dBTypeArray, dBDataArray, n);
        return this.all7.getNumRows();
    }

    public synchronized int fetch(DBStatement dBStatement, DBDataSet dBDataSet, int n, int n2) throws SQLException, IOException {
        this.all7.rxd.unmarshal(n - 1, n2 - 1);
        if (this.all7.rxd.rxdDataSet.isLastCol()) {
            this.all7.getColumnsUptoNextSream();
        }
        return this.all7.getNumRows();
    }

    public synchronized int getC2SNlsRatio() {
        return this.MEngine.conv.getNLSRATIO();
    }

    public synchronized Properties getDBAccessProperties() throws SQLException {
        return null;
    }

    public synchronized int getDefaultPrefetch() {
        return 10;
    }

    public synchronized int getDefaultStreamChunkSize() {
        return 255;
    }

    public int getMaxCharSize() throws SQLException {
        return this.MEngine.conv.getMaxCharSize();
    }

    public synchronized int getNlsRatio() {
        return this.MEngine.conv.getServer2ClientNlsRatio();
    }

    public synchronized void getObjectValueFromRef(DBItem dBItem, DBType dBType, DBItem dBItem2, DBType dBType2) throws SQLException {
        dBType2.otype = new OracleTypeADT(((OracleTypeADT)dBType.otype).getFullName(), (Connection)((OracleTypeADT)dBType.otype).getConnection());
        try {
            Okod okod = new Okod(this.MEngine, dBItem, dBItem2);
            okod.marshal();
            okod.receive();
        }
        catch (IOException iOException) {}
    }

    public synchronized void getOracleTypeADT(OracleTypeADT oracleTypeADT) throws SQLException {
    }

    public synchronized byte[] getVersion() throws SQLException {
        if (this.state < 1) {
            DBError.check_error(430);
        }
        return this.ver.getVersion();
    }

    public synchronized short getVersionNumber() throws SQLException {
        if (this.state < 1) {
            DBError.check_error(430);
        }
        return this.ver.getVersionNumber();
    }

    public synchronized void initNls(OracleConnection oracleConnection) throws SQLException {
        this.setNlsParamsClient(oracleConnection);
    }

    public synchronized void logoff() throws SQLException, IOException {
        if (this.state < 1) {
            DBError.check_error(429);
        }
        this.commoncall.init((byte)9);
        this.commoncall.marshal();
        this.commoncall.receive();
        this.net.disconnect();
        this.state = 0;
    }

    public synchronized DBConversion logon(String string, String string2, String string3, Properties properties) throws SQLException, IOException {
        try {
            if (this.state > 0) {
                DBError.check_error(428);
            }
            if (string == null || string2 == null) {
                DBError.check_error(433);
            }
            if (string.length() == 0 || string2.length() == 0) {
                DBError.check_error(443);
            }
            if (string3 == null) {
                string3 = DEFAULT_CONNECT_STRING;
            }
            this.connect(string3, properties);
            this.all7 = new Oall7(this.MEngine);
            this.commoncall = new Ocommoncall(this.MEngine);
            this.opencall = new Oopen(this.MEngine);
            this.close = new Oclose(this.MEngine);
            TTCTypeRep cfr_ignored_0 = this.MEngine.types;
            this.describe = (Odscrarr)this.MEngine.types.newTTIFunObject((byte)1, this.MEngine);
            TTCTypeRep cfr_ignored_1 = this.MEngine.types;
            this.dty = (TTIdty)this.MEngine.types.newTTCMsgObject((byte)2, this.MEngine);
            this.dty.marshal();
            this.dty.receive();
            String string4 = (String)((Hashtable)properties).get("internal_logon");
            if (string4 != null) {
                if (string4.equalsIgnoreCase("sysoper")) {
                    this.LOGON_MODE = 16L;
                } else if (string4.equalsIgnoreCase("sysdba")) {
                    this.LOGON_MODE = 8L;
                }
            }
            this.log1 = new O3log(this.MEngine, string, properties, this.LOGON_MODE);
            this.log1.marshal();
            this.log1.receive1st();
            this.log2 = new O3log(this.MEngine, string, string2, this.log1.encryptedSK, properties, this.LOGON_MODE);
            this.log2.marshal();
            while (true) {
                try {
                    this.log2.receive2nd();
                }
                catch (SQLWarning sQLWarning) {
                    this.setWarnings(DBError.addSqlWarning(this.getWarnings(), sQLWarning));
                    continue;
                }
                break;
            }
            this.net.setO3logSessionKey(this.log2.getSessionKey());
            this.ver = new Oversion(this.MEngine);
            this.ver.marshal();
            this.ver.receive();
            short s = this.ver.getVersionNumber();
            if (s < 7230) {
                DBError.check_error(441);
            }
            this.MEngine.types.setVersion(s);
            this.state = 1;
            return this.MEngine.conv;
        }
        catch (SQLException sQLException) {
            try {
                this.net.disconnect();
            }
            catch (Exception exception) {}
            this.state = 0;
            throw sQLException;
        }
    }

    public synchronized DBStatement open() throws SQLException, IOException {
        if (this.state < 1) {
            DBError.check_error(430);
        }
        this.opencall.init();
        this.opencall.marshal();
        int n = this.opencall.receive();
        return new TTCStatement(n);
    }

    public synchronized DBColumn[] parseExecuteDescribe(DBStatement dBStatement, byte[] byArray, DBDataSet dBDataSet) throws SQLException, IOException {
        DBType[] dBTypeArray = null;
        DBData[] dBDataArray = null;
        if (dBDataSet != null) {
            dBTypeArray = ((DBDataSetImpl)dBDataSet).getDBTypes();
            dBDataArray = ((DBDataSetImpl)dBDataSet).getDBData();
        }
        if (dBStatement == null || byArray == null) {
            DBError.check_error(433);
        }
        if (this.state < 1) {
            DBError.check_error(430);
        }
        try {
            try {
                this.doOall7((byte)2, (byte)0, ((TTCStatement)dBStatement).getCursor(), byArray, dBTypeArray, dBDataArray, 1, null, null, 0);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            Object var7_8 = null;
            dBStatement.rows_processed = this.all7.rowsProcessed;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            dBStatement.rows_processed = this.all7.rowsProcessed;
            throw throwable;
        }
        DBColumn[] dBColumnArray = this.describe(dBStatement);
        return dBColumnArray;
    }

    public synchronized int parseExecuteFetch(DBStatement dBStatement, byte by, byte[] byArray, DBDataSet dBDataSet, int n, DBDataSet dBDataSet2, int n2) throws SQLException, IOException {
        DBType[] dBTypeArray = null;
        DBData[] dBDataArray = null;
        DBType[] dBTypeArray2 = null;
        DBData[] dBDataArray2 = null;
        if (dBDataSet != null) {
            dBTypeArray = ((DBDataSetImpl)dBDataSet).getDBTypes();
            dBDataArray = ((DBDataSetImpl)dBDataSet).getDBData();
        }
        if (dBDataSet2 != null) {
            dBTypeArray2 = ((DBDataSetImpl)dBDataSet2).getDBTypes();
            dBDataArray2 = ((DBDataSetImpl)dBDataSet2).getDBData();
        }
        if (dBStatement == null || byArray == null || by < 0 || by > 3) {
            DBError.check_error(433);
        }
        try {
            try {
                this.doOall7((byte)4, by, ((TTCStatement)dBStatement).getCursor(), byArray, dBTypeArray, dBDataArray, n, dBTypeArray2, dBDataArray2, n2);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            Object var13_14 = null;
            dBStatement.rows_processed = this.all7.rowsProcessed;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            dBStatement.rows_processed = this.all7.rowsProcessed;
            throw throwable;
        }
        return this.all7.getNumRows();
    }

    public synchronized int read(DBStatement dBStatement, byte[] byArray, int n) throws SQLException, IOException {
        int n2 = -1;
        TTCStatement tTCStatement = (TTCStatement)dBStatement;
        if (this.state < 1) {
            DBError.check_error(430);
        }
        if (this.all7 == null || n > 255 || n < 0) {
            DBError.check_error(433);
        }
        if (!this.all7.streamingOn) {
            DBError.check_error(434);
        }
        n2 = this.all7.meg.unmarshalUB1();
        if (tTCStatement.isHeader()) {
            if (!this.all7.meg.escapeSequenceNull(n2)) {
                if (n2 == 254) {
                    n2 = this.all7.meg.unmarshalUB1();
                } else {
                    DBError.check_error(401);
                }
            } else {
                n2 = -1;
            }
            tTCStatement.headerRead();
        }
        if (n2 > 0) {
            this.all7.meg.unmarshalNBytes(byArray, 0, n2);
        } else {
            n2 = -1;
            tTCStatement.headerReset();
        }
        if (n2 == -1) {
            this.all7.rxd.rxdDataSet.incrementUnmarshaledcols();
            this.all7.rxd.rxdDataSet.processIndicator();
            if (this.all7.rxd.rxdDataSet.isLastCol()) {
                this.all7.getColumnsUptoNextSream();
                this.all7.rxd.rxdDataSet.incrementeUnmarshaledRows();
            }
        }
        return n2;
    }

    public synchronized void rollback() throws SQLException, IOException {
        if (this.state < 1) {
            DBError.check_error(430);
        }
        this.commoncall.init((byte)15);
        this.commoncall.marshal();
        this.commoncall.receive();
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException, IOException {
        if (this.state < 1) {
            DBError.check_error(430);
        }
        if (bl) {
            this.commoncall.init((byte)12);
        } else {
            this.commoncall.init((byte)13);
        }
        this.commoncall.marshal();
        this.commoncall.receive();
    }

    public synchronized void setObjectValueFromRef(DBItem dBItem, DBType dBType, DBItem dBItem2, DBType dBType2) throws SQLException {
    }

    public synchronized void shutdown(int n) throws SQLException {
    }

    public synchronized void startup(String string, int n) throws SQLException {
    }
}

