#
# Ľṹ `tqa_administrators`
#

CREATE TABLE IF NOT EXISTS tqa_administrators (
  administratorsID int(30) unsigned NOT NULL auto_increment,
  userGroupID int(6) unsigned NOT NULL default '0',
  departmentID int(6) unsigned NOT NULL default '0',
  gradeID int(6) unsigned NOT NULL default '0',
  classID int(6) unsigned NOT NULL default '0',
  administratorsName varchar(100) binary NOT NULL default '',
  nickName varchar(40) NOT NULL default '',
  usersNum varchar(60) binary NOT NULL default '',
  usersGender int(1) unsigned NOT NULL default '0',
  email varchar(50) binary NOT NULL default '',
  passWord varchar(32) NOT NULL default '',
  isAdmin int(1) unsigned NOT NULL default '0',
  isLeader int(1) unsigned NOT NULL default '0',
  isDirect int(1) unsigned NOT NULL default '0',
  isInit int(1) unsigned NOT NULL default '0',
  isActive int(1) unsigned NOT NULL default '1',
  isAnonymous int(1) unsigned NOT NULL default '0',
  lastVisitTime int(11) unsigned NOT NULL default '0',
  loginNum int(6) unsigned NOT NULL default '0',
  loginAddress varchar(15) binary NOT NULL default '',
  loginTime int(11) unsigned NOT NULL default '0',
  createDate int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (administratorsID),
  KEY isAdmin (isAdmin),
  KEY isActive (isActive),
  KEY userGroupID (userGroupID),
  KEY isLeader (isLeader),
  KEY isDirect (isDirect),
  KEY usersGender (usersGender),
  KEY departmentID (departmentID),
  KEY gradeID (gradeID),
  KEY classID (classID),
  KEY isAnonymous (isAnonymous)
) TYPE=MyISAM;

#
# Ľṹ `tqa_administratorsgroup`
#

CREATE TABLE IF NOT EXISTS tqa_administratorsgroup (
  administratorsGroupID int(6) unsigned NOT NULL auto_increment,
  administratorsGroupName varchar(60) NOT NULL default '',
  PRIMARY KEY  (administratorsGroupID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_administratorslog`
#

CREATE TABLE IF NOT EXISTS tqa_administratorslog (
  administratorsLogID int(50) unsigned NOT NULL auto_increment,
  administratorsID int(30) unsigned NOT NULL default '0',
  operationTitle varchar(255) NOT NULL default '',
  operationIP varchar(32) NOT NULL default '',
  createDate int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (administratorsLogID),
  KEY administratorsID (administratorsID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_administratorsloginlog`
#

CREATE TABLE IF NOT EXISTS tqa_administratorsloginlog (
  administratorsLoginLogID int(4) unsigned NOT NULL auto_increment,
  administratorsName varchar(50) NOT NULL default '',
  passWord varchar(30) NOT NULL default '',
  loginTime int(11) unsigned NOT NULL default '0',
  ipAddress varchar(15) NOT NULL default '',
  isAdminLogin int(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (administratorsLoginLogID),
  KEY isAdminLogin (isAdminLogin)
) TYPE=MyISAM;

#
# Ľṹ `tqa_anonymous`
#

CREATE TABLE IF NOT EXISTS tqa_anonymous (
  anonymousID int(30) unsigned NOT NULL auto_increment,
  departmentID int(6) unsigned NOT NULL default '0',
  gradeID int(6) unsigned NOT NULL default '0',
  classID int(6) unsigned NOT NULL default '0',
  administratorsName varchar(20) binary NOT NULL default '',
  passWord varchar(32) NOT NULL default '',
  loginAddress varchar(15) binary NOT NULL default '',
  loginTime int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (anonymousID),
  KEY departmentID (departmentID),
  KEY gradeID (gradeID),
  KEY classID (classID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_answers`
#

CREATE TABLE IF NOT EXISTS tqa_answers (
  answersID int(30) unsigned NOT NULL auto_increment,
  answersName varchar(100) NOT NULL default '',
  surveyID int(20) unsigned NOT NULL default '0',
  assessID int(30) unsigned NOT NULL default '0',
  indicatorsID int(30) unsigned NOT NULL default '0',
  weight float(6,2) unsigned NOT NULL default '0.00',
  optionID int(30) unsigned NOT NULL default '0',
  orderByID int(30) unsigned NOT NULL default '0',
  PRIMARY KEY  (answersID),
  KEY surveyID (surveyID),
  KEY assessID (assessID),
  KEY indicatorID (indicatorsID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_archiving`
#

CREATE TABLE IF NOT EXISTS tqa_archiving (
  archivingID int(20) unsigned NOT NULL auto_increment,
  surveyID int(20) unsigned NOT NULL default '0',
  surveyTitle varchar(255) NOT NULL default '',
  surveyName varchar(64) NOT NULL default '',
  administratorsID int(30) unsigned NOT NULL default '0',
  isPublic int(1) unsigned NOT NULL default '1',
  beginTime date NOT NULL default '0000-00-00',
  endTime date NOT NULL default '0000-00-00',
  archivingOwner int(30) unsigned NOT NULL default '0',
  archivingFile varchar(100) NOT NULL default '',
  archivingTime int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (archivingID),
  KEY surveyID (surveyID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_assess`
#

CREATE TABLE IF NOT EXISTS tqa_assess (
  assessID int(30) unsigned NOT NULL auto_increment,
  assessTitle varchar(255) binary NOT NULL default '',
  surveyID int(20) unsigned NOT NULL default '0',
  isCache int(1) unsigned NOT NULL default '0',
  isWaiting int(1) unsigned NOT NULL default '0',
  waitingTime int(2) unsigned NOT NULL default '0',
  surveyType int(1) unsigned NOT NULL default '1',
  surveyCoursesID int(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (assessID),
  KEY surveyType (surveyType),
  KEY surveyCoursesID (surveyCoursesID)
) TYPE=MyISAM;

ALTER TABLE  `tqa_assess` ADD  `isRequired` INT( 1 ) UNSIGNED DEFAULT  '1' NOT NULL AFTER  `waitingTime` ;

#
# Ľṹ `tqa_base_setting`
#

CREATE TABLE IF NOT EXISTS tqa_base_setting (
  baseSettingID int(1) unsigned NOT NULL auto_increment,
  sendFrom varchar(40) NOT NULL default '',
  sendName varchar(40) NOT NULL default '',
  mailServer varchar(40) NOT NULL default '',
  smtp25 varchar(10) NOT NULL default '25',
  smtpName varchar(40) NOT NULL default '',
  smtpPassword varchar(40) NOT NULL default '',
  isSmtp enum('y','n') NOT NULL default 'n',
  isAllowIP int(1) unsigned NOT NULL default '0',
  license varchar(100) NOT NULL default '',
  licensetime varchar(100) NOT NULL default '',
  PRIMARY KEY  (baseSettingID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_class`
#

CREATE TABLE IF NOT EXISTS tqa_class (
  classID int(6) unsigned NOT NULL auto_increment,
  className varchar(60) binary NOT NULL default '',
  gradeID int(6) unsigned NOT NULL default '0',
  coursesID int(6) unsigned NOT NULL default '0',
  headTeacher int(30) unsigned NOT NULL default '0',
  isAnonymous int(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (classID),
  KEY gradeID (gradeID),
  KEY headTeacher (headTeacher),
  KEY coursesID (coursesID),
  KEY isAnonymous (isAnonymous)
) TYPE=MyISAM;

#
# Ľṹ `tqa_class_rel`
#

CREATE TABLE IF NOT EXISTS tqa_class_rel (
  relID int(10) unsigned NOT NULL auto_increment,
  classID int(6) unsigned NOT NULL default '0',
  coursesID int(4) unsigned NOT NULL default '0',
  teachersID int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (relID),
  KEY teachersID (teachersID),
  KEY coursesID (coursesID),
  KEY classID (classID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_class_student`
#

CREATE TABLE IF NOT EXISTS tqa_class_student (
  relID int(30) unsigned NOT NULL auto_increment,
  coursesID int(6) unsigned NOT NULL default '0',
  classID int(6) unsigned NOT NULL default '0',
  studentID int(30) unsigned NOT NULL default '0',
  PRIMARY KEY  (relID),
  KEY studentID (studentID),
  KEY classID (classID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_conditions`
#

CREATE TABLE IF NOT EXISTS tqa_conditions (
  conditionsID int(10) unsigned NOT NULL auto_increment,
  surveyID int(20) unsigned NOT NULL default '0',
  questionID int(30) unsigned NOT NULL default '0',
  administratorsID int(30) unsigned NOT NULL default '0',
  condOnID int(30) unsigned NOT NULL default '0',
  optionID int(20) unsigned NOT NULL default '0',
  qtnID int(20) unsigned NOT NULL default '0',
  PRIMARY KEY  (conditionsID),
  KEY surveyID (surveyID),
  KEY questionID (questionID),
  KEY administratorsID (administratorsID),
  KEY optionID (optionID),
  KEY condOnID (condOnID),
  KEY qtnID (qtnID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_courses`
#

CREATE TABLE IF NOT EXISTS tqa_courses (
  coursesID int(4) unsigned NOT NULL auto_increment,
  coursesNum varchar(40) binary NOT NULL default '',
  coursesName varchar(254) binary NOT NULL default '',
  isElective int(1) unsigned NOT NULL default '0',
  isRange int(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (coursesID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_department`
#

CREATE TABLE IF NOT EXISTS tqa_department (
  departmentID int(6) unsigned NOT NULL auto_increment,
  departmentName varchar(60) binary NOT NULL default '',
  PRIMARY KEY  (departmentID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_downs`
#

CREATE TABLE IF NOT EXISTS tqa_downs (
  downsID int(3) unsigned NOT NULL auto_increment,
  downsName varchar(100) NOT NULL default '',
  downsContent text NOT NULL,
  filename varchar(100) NOT NULL default '',
  filesize decimal(10,2) NOT NULL default '0.00',
  isPublic enum('y','n') NOT NULL default 'y',
  createDate int(11) unsigned NOT NULL default '0',
  updateDate int(11) unsigned NOT NULL default '0',
  orderByID int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (downsID)
) TYPE=MyISAM;

INSERT INTO tqa_downs VALUES (1, 'EnableTQAϵͳûֲ', 'EnableTQAѧۺϵͳ(ս̰)οֲ᣺ϵͳûֲ', 'EnableTQAUserManual.html', '1.00', 'y', 1279894252, 1279894252, 1);

#
# Ľṹ `tqa_grade`
#

CREATE TABLE IF NOT EXISTS tqa_grade (
  gradeID int(6) unsigned NOT NULL auto_increment,
  gradeName varchar(60) binary NOT NULL default '',
  departmentID int(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (gradeID),
  KEY departmentID (departmentID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_indexs`
#

CREATE TABLE IF NOT EXISTS tqa_indexs (
  indexsID int(30) unsigned NOT NULL auto_increment,
  indexsName text NOT NULL,
  surveyID int(20) unsigned NOT NULL default '0',
  assessID int(30) unsigned NOT NULL default '0',
  indicatorsID int(30) unsigned NOT NULL default '0',
  weight float(6,2) unsigned NOT NULL default '0.00',
  optionID int(30) unsigned NOT NULL default '0',
  orderByID int(30) unsigned NOT NULL default '0',
  PRIMARY KEY  (indexsID),
  KEY surveyID (surveyID),
  KEY assessID (assessID),
  KEY indicatorID (indicatorsID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_indicators`
#

CREATE TABLE IF NOT EXISTS tqa_indicators (
  indicatorsID int(30) unsigned NOT NULL auto_increment,
  indicatorsName varchar(100) binary NOT NULL default '',
  indicatorsNotes text NOT NULL,
  surveyID int(20) unsigned NOT NULL default '0',
  assessID int(30) unsigned NOT NULL default '0',
  weight float(6,2) unsigned NOT NULL default '0.00',
  orderByID int(30) unsigned NOT NULL default '0',
  PRIMARY KEY  (indicatorsID),
  KEY surveyID (surveyID),
  KEY assessID (assessID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_ip_allow`
#

CREATE TABLE IF NOT EXISTS tqa_ip_allow (
  allowIpID int(6) unsigned NOT NULL auto_increment,
  startIP varchar(15) NOT NULL default '',
  endIP varchar(15) NOT NULL default '',
  PRIMARY KEY  (allowIpID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_ip_banned`
#

CREATE TABLE IF NOT EXISTS tqa_ip_banned (
  bannedID int(30) unsigned NOT NULL auto_increment,
  ipAddress varchar(15) NOT NULL default '',
  PRIMARY KEY  (bannedID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_question`
#

CREATE TABLE IF NOT EXISTS tqa_question (
  questionID int(30) unsigned NOT NULL auto_increment,
  questionName text NOT NULL,
  questionNotes text NOT NULL,
  alias varchar(100) NOT NULL default '',
  surveyID int(20) unsigned NOT NULL default '0',
  administratorsID int(30) unsigned NOT NULL default '0',
  questionType int(2) unsigned NOT NULL default '0',
  isPublic int(1) unsigned NOT NULL default '1',
  isRequired int(1) unsigned NOT NULL default '0',
  isRandOptions int(1) unsigned NOT NULL default '0',
  isCheckType int(1) unsigned NOT NULL default '0',
  isSelect int(1) unsigned NOT NULL default '0',
  isLogicAnd int(1) unsigned NOT NULL default '0',
  isColArrange int(1) unsigned NOT NULL default '0',
  perRowCol int(4) unsigned NOT NULL default '0',
  isHaveOther int(1) unsigned NOT NULL default '0',
  otherText varchar(200) NOT NULL default '',
  isNeg int(1) unsigned NOT NULL default '0',
  isHaveWhy int(1) unsigned NOT NULL default '0',
  minOption int(2) unsigned NOT NULL default '0',
  maxOption int(2) unsigned NOT NULL default '0',
  rows int(2) unsigned NOT NULL default '5',
  length int(2) unsigned NOT NULL default '50',
  minSize int(2) unsigned NOT NULL default '0',
  maxSize int(2) unsigned NOT NULL default '2',
  startScale int(1) unsigned NOT NULL default '0',
  endScale int(1) unsigned NOT NULL default '0',
  weight int(2) unsigned NOT NULL default '0',
  orderByID int(30) unsigned NOT NULL default '0',
  PRIMARY KEY  (questionID),
  KEY surveyID (surveyID),
  KEY administratorsID (administratorsID),
  KEY questionType (questionType),
  KEY isRequired (isRequired),
  KEY isPublic (isPublic)
) TYPE=MyISAM;

#
# Ľṹ `tqa_question_checkbox`
#

CREATE TABLE IF NOT EXISTS tqa_question_checkbox (
  question_checkboxID int(20) unsigned NOT NULL auto_increment,
  surveyID int(20) unsigned NOT NULL default '0',
  administratorsID int(30) unsigned NOT NULL default '0',
  questionID int(30) unsigned NOT NULL default '0',
  optionOptionID int(10) unsigned NOT NULL default '0',
  optionName varchar(255) NOT NULL default '',
  optionMargin int(4) unsigned NOT NULL default '0',
  optionNameFile varchar(100) NOT NULL default '',
  isExclusive int(1) unsigned NOT NULL default '0',
  isHaveText int(1) unsigned NOT NULL default '1',
  optionSize int(2) unsigned NOT NULL default '20',
  isRequired int(1) unsigned NOT NULL default '1',
  isCheckType int(1) unsigned NOT NULL default '0',
  minOption int(2) unsigned NOT NULL default '0',
  maxOption int(2) unsigned NOT NULL default '0',
  createDate int(11) unsigned NOT NULL default '0',
  orderByID int(20) unsigned NOT NULL default '0',
  PRIMARY KEY  (question_checkboxID),
  KEY surveyID (surveyID),
  KEY administratorsID (administratorsID),
  KEY questionID (questionID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_question_info`
#

CREATE TABLE IF NOT EXISTS tqa_question_info (
  question_infoID int(20) unsigned NOT NULL auto_increment,
  surveyID int(20) unsigned NOT NULL default '0',
  administratorsID int(30) unsigned NOT NULL default '0',
  questionID int(30) unsigned NOT NULL default '0',
  optionName text NOT NULL,
  PRIMARY KEY  (question_infoID),
  KEY surveyID (surveyID),
  KEY administratorsID (administratorsID),
  KEY questionID (questionID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_question_radio`
#

CREATE TABLE IF NOT EXISTS tqa_question_radio (
  question_radioID int(20) unsigned NOT NULL auto_increment,
  surveyID int(20) unsigned NOT NULL default '0',
  administratorsID int(30) unsigned NOT NULL default '0',
  questionID int(30) unsigned NOT NULL default '0',
  optionOptionID int(10) unsigned NOT NULL default '0',
  optionName varchar(255) NOT NULL default '',
  optionMargin int(4) unsigned NOT NULL default '0',
  optionNameFile varchar(100) NOT NULL default '',
  isHaveText int(1) unsigned NOT NULL default '1',
  optionSize int(2) unsigned NOT NULL default '20',
  isRequired int(1) unsigned NOT NULL default '1',
  isCheckType int(1) unsigned NOT NULL default '0',
  minOption int(2) unsigned NOT NULL default '0',
  maxOption int(2) unsigned NOT NULL default '0',
  createDate int(11) unsigned NOT NULL default '0',
  orderByID int(20) unsigned NOT NULL default '0',
  PRIMARY KEY  (question_radioID),
  KEY surveyID (surveyID),
  KEY administratorsID (administratorsID),
  KEY questionID (questionID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_question_range_answer`
#

CREATE TABLE IF NOT EXISTS tqa_question_range_answer (
  question_range_answerID int(20) unsigned NOT NULL auto_increment,
  surveyID int(20) unsigned NOT NULL default '0',
  administratorsID int(30) unsigned NOT NULL default '0',
  questionID int(30) unsigned NOT NULL default '0',
  optionAnswer varchar(200) NOT NULL default '',
  PRIMARY KEY  (question_range_answerID),
  KEY surveyID (surveyID),
  KEY administratorsID (administratorsID),
  KEY questionID (questionID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_question_range_option`
#

CREATE TABLE IF NOT EXISTS tqa_question_range_option (
  question_range_optionID int(20) unsigned NOT NULL auto_increment,
  surveyID int(20) unsigned NOT NULL default '0',
  administratorsID int(30) unsigned NOT NULL default '0',
  questionID int(30) unsigned NOT NULL default '0',
  optionName text NOT NULL,
  PRIMARY KEY  (question_range_optionID),
  KEY surveyID (surveyID),
  KEY administratorsID (administratorsID),
  KEY questionID (questionID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_question_rank`
#

CREATE TABLE IF NOT EXISTS tqa_question_rank (
  question_rankID int(20) unsigned NOT NULL auto_increment,
  surveyID int(20) unsigned NOT NULL default '0',
  administratorsID int(30) unsigned NOT NULL default '0',
  questionID int(30) unsigned NOT NULL default '0',
  optionName text NOT NULL,
  PRIMARY KEY  (question_rankID),
  KEY surveyID (surveyID),
  KEY administratorsID (administratorsID),
  KEY questionID (questionID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_question_yesno`
#

CREATE TABLE IF NOT EXISTS tqa_question_yesno (
  question_yesnoID int(20) unsigned NOT NULL auto_increment,
  surveyID int(20) unsigned NOT NULL default '0',
  administratorsID int(30) unsigned NOT NULL default '0',
  questionID int(30) unsigned NOT NULL default '0',
  optionName varchar(255) NOT NULL default '',
  optionOptionID int(10) unsigned NOT NULL default '0',
  optionSize int(2) unsigned NOT NULL default '20',
  isRequired int(1) unsigned NOT NULL default '0',
  isCheckType int(1) unsigned NOT NULL default '0',
  minOption int(2) unsigned NOT NULL default '0',
  maxOption int(2) unsigned NOT NULL default '0',
  orderByID int(20) unsigned NOT NULL default '0',
  PRIMARY KEY  (question_yesnoID),
  KEY surveyID (surveyID),
  KEY administratorsID (administratorsID),
  KEY questionID (questionID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_report_define`
#

CREATE TABLE IF NOT EXISTS tqa_report_define (
  defineID int(10) unsigned NOT NULL auto_increment,
  surveyID int(20) unsigned NOT NULL default '0',
  questionID int(30) unsigned NOT NULL default '0',
  condOnID int(30) unsigned NOT NULL default '0',
  optionID int(20) unsigned NOT NULL default '0',
  qtnID int(20) unsigned NOT NULL default '0',
  condOnID2 int(30) unsigned NOT NULL default '0',
  optionID2 int(20) unsigned NOT NULL default '0',
  qtnID2 int(20) unsigned NOT NULL default '0',
  defineType int(1) unsigned NOT NULL default '1',
  PRIMARY KEY  (defineID),
  KEY surveyID (surveyID),
  KEY questionID (questionID),
  KEY optionID (optionID),
  KEY qtnID (qtnID),
  KEY defineType (defineType),
  KEY condOnID (condOnID),
  KEY condOnID2 (condOnID2),
  KEY optionID2 (optionID2),
  KEY qtnID2 (qtnID2)
) TYPE=MyISAM;

#
# Ľṹ `tqa_response_group_list`
#

CREATE TABLE IF NOT EXISTS tqa_response_group_list (
  responseGroupListID int(20) unsigned NOT NULL auto_increment,
  value int(20) unsigned NOT NULL default '0',
  valueType int(1) unsigned NOT NULL default '0',
  surveyID int(20) unsigned NOT NULL default '0',
  PRIMARY KEY  (responseGroupListID),
  KEY surveyID (surveyID),
  KEY value (value)
) TYPE=MyISAM;

#
# Ľṹ `tqa_survey`
#

CREATE TABLE IF NOT EXISTS tqa_survey (
  surveyID int(20) unsigned NOT NULL auto_increment,
  surveyName varchar(64) NOT NULL default '',
  isPublic int(1) unsigned NOT NULL default '1',
  status int(1) unsigned NOT NULL default '0',
  surveyType int(1) unsigned NOT NULL default '0',
  isDefault int(1) unsigned NOT NULL default '0',
  weightValue int(2) unsigned NOT NULL default '0',
  weightSt float(6,2) unsigned NOT NULL default '0.00',
  weightTh float(6,2) unsigned NOT NULL default '0.00',
  weightLd float(6,2) unsigned NOT NULL default '0.00',
  weightDr float(6,2) unsigned NOT NULL default '0.00',
  surveyTitle varchar(255) NOT NULL default '',
  surveySubTitle text NOT NULL,
  surveyInfo text NOT NULL,
  administratorsID int(30) unsigned NOT NULL default '0',
  isCheckIP int(1) unsigned NOT NULL default '1',
  maxIpTime int(6) unsigned NOT NULL default '1000',
  maxResponseNum int(4) unsigned NOT NULL default '0',
  isPreStep int(1) unsigned NOT NULL default '0',
  isWaiting int(1) unsigned NOT NULL default '0',
  waitingTime int(2) unsigned NOT NULL default '10',
  isCache int(1) unsigned NOT NULL default '1',
  beginTime date NOT NULL default '0000-00-00',
  endTime date NOT NULL default '0000-00-00',
  joinTime int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (surveyID),
  KEY administratorsID (administratorsID),
  KEY STATUS (status),
  KEY isPublic (isPublic),
  KEY surveyType (surveyType)
) TYPE=MyISAM;

#
# Ľṹ `tqa_teachers_rel`
#

CREATE TABLE IF NOT EXISTS tqa_teachers_rel (
  relID int(20) unsigned NOT NULL auto_increment,
  teachersID int(10) unsigned NOT NULL default '0',
  evalTeachersID int(10) unsigned NOT NULL default '0',
  relType int(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (relID)
) TYPE=MyISAM;

#
# Ľṹ `tqa_view_user_list`
#

CREATE TABLE IF NOT EXISTS tqa_view_user_list (
  viewUserListID int(20) unsigned NOT NULL default '0',
  administratorsID int(30) unsigned NOT NULL default '0',
  surveyID int(20) unsigned NOT NULL default '0',
  assessID int(30) unsigned NOT NULL default '0',
  KEY administratorsID (administratorsID),
  KEY surveyID (surveyID),
  KEY assessID (assessID)
) TYPE=MyISAM;

ALTER TABLE  `tqa_base_setting` ADD  `isMyData` INT( 1 ) UNSIGNED DEFAULT  '1' NOT NULL AFTER  `licensetime` ,
ADD  `isHeaderMgt` INT( 1 ) UNSIGNED DEFAULT  '1' NOT NULL AFTER  `isMyData` ;
