<%@ page contentType="text/html;charset=UTF-8" errorPage="error.jsp"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import="java.util.Calendar"%>
<%@ page import="java.net.URLEncoder"%>
<%@ page import="com.hongshee.ejforum.util.PageUtils"%>
<%@ page import="com.hongshee.ejforum.util.AppUtils"%>
<%@ page import="com.hongshee.ejforum.common.ForumSetting"%>
<%@ page import="com.hongshee.ejforum.common.IConstants"%>
<%@ page import="com.hongshee.ejforum.common.CacheManager"%>
<%@ page import="com.hongshee.ejforum.data.UserDAO.UserInfo"%>
<%@ page import="com.hongshee.ejforum.data.BoardDAO.BoardVO"%>
<%@ page import="com.hongshee.ejforum.data.BoardDAO.CatVO"%>
<%@ page import="com.hongshee.ejforum.data.SectionDAO.SectionVO"%>
<%@ page import="com.hongshee.ejforum.data.TopicDAO"%>
<%@ page import="com.hongshee.ejforum.data.ReplyDAO"%>
<%@ page import="com.hongshee.ejforum.data.TopicDAO.TopicVO"%>
<%@ page import="com.hongshee.ejforum.data.TopicDAO.TopicInfo"%>
<%@ page import="com.hongshee.ejforum.data.ReplyDAO.PostVO"%>
<%@ page import="com.hongshee.ejforum.data.GroupDAO.GroupVO"%>
<%@ page import="com.hongshee.ejforum.data.AttachDAO.AttachVO"%>
<%
	UserInfo userinfo = PageUtils.getSessionUser(request,response);
	
	ForumSetting setting = ForumSetting.getInstance();
	int pageRows = setting.postsPerPage;
	int pageNo = 1;

	int topicID = PageUtils.getIntParam(request,"tid");
	int replyID = PageUtils.getIntParam(request,"rid");
    if (replyID > 0)
	{
		pageNo = ReplyDAO.getInstance().getPageNo(topicID, replyID, pageRows, userinfo);
	}
	else
	{
		String strPageNo = request.getParameter("page");
		pageNo = PageUtils.getPageNo(strPageNo);
	}
	
	String baseUrl = response.encodeURL("./topic.jsp");
	String sibling = request.getParameter("goto");
	
	TopicVO aTopic = null;
	if (sibling != null && sibling.length() > 0)
		aTopic = TopicDAO.getInstance().getSiblingTopic(request, topicID, pageRows, userinfo, baseUrl, sibling);
	else
		aTopic = TopicDAO.getInstance().getTopic(request, topicID, pageNo, pageRows, userinfo, baseUrl);
		
	if (aTopic == null)
	{		
		request.setAttribute("errorMsg", "此主题不存在或已经被删除");
		request.getRequestDispatcher("/error.jsp").forward(request, response);
		return;
	}
	
	long modifiedSince = request.getDateHeader("If-Modified-Since");
	if (modifiedSince > 0 && aTopic.lastModified > 0 && aTopic.lastModified <= modifiedSince)
	{
		response.sendError(HttpServletResponse.SC_NOT_MODIFIED);
		return;
	}
	topicID = aTopic.topicID;

	CacheManager cache = CacheManager.getInstance();
	int boardID = aTopic.boardID;
	BoardVO aBoard = cache.getBoard(boardID);
	SectionVO aSection = cache.getSection(aBoard.sectionID);

	GroupVO userGroup = PageUtils.getGroupVO(userinfo, aSection, aBoard);
	if (!PageUtils.isPermitted(aBoard,userGroup,userinfo,IConstants.PERMIT_VISIT_FORUM))
	{
		if (userinfo == null)  // Guest
		{
			String fromPath = request.getRequestURI();
			String queryStr = request.getQueryString();
			if (queryStr != null)
				fromPath = fromPath + "?" + queryStr;
			request.setAttribute("fromPath", fromPath);
			request.getRequestDispatcher("/login.jsp").forward(request, response);
			return;
		}
		else
		{
			request.setAttribute("errorMsg", "很抱歉，您缺乏足够的访问权限");
			request.getRequestDispatcher("/error.jsp").forward(request, response);
			return;
		}
	}

	boolean isModerator = false;
	if (userGroup.groupID == 'A' || userGroup.groupID == 'M' || userGroup.groupID == 'S')
		isModerator = true;

	if (aTopic.state=='R' && !isModerator)
	{		
		request.setAttribute("errorMsg", "此主题已经被删除");
		request.getRequestDispatcher("/error.jsp").forward(request, response);
		return;
	}

	String ctxPath = request.getContextPath();
	String serverName = request.getServerName();
	if (ctxPath.length()>1)
		serverName = serverName + ctxPath;
	String forumStyle = PageUtils.getForumStyle(request, response, aBoard);
	
	String forumName = setting.getForumName();
	String title = PageUtils.getTitle(forumName);
	String[] menus = PageUtils.getHeaderMenu(request, userinfo);

	StringBuilder sbuf = new StringBuilder();
	sbuf.append("./forum-").append(boardID).append(".html");
	String forumUrl = response.encodeURL(sbuf.toString());
	String homeUrl = response.encodeURL("./index.jsp");

	sbuf.setLength(0);
	sbuf.append("./post.jsp?fid=").append(boardID);
	if (aTopic.catID >= 0)
		sbuf.append("&cid=").append(aTopic.catID);
	String postUrl = response.encodeURL(sbuf.toString());

	sbuf.setLength(0);
	sbuf.append(baseUrl).append("?tid=").append(topicID).append("&fid=").append(boardID);
	sbuf.append("&cid=").append(aTopic.catID);
	baseUrl = sbuf.toString();

	sbuf.setLength(0);
	sbuf.append("report.jsp?fid=").append(boardID)
	    .append("&tid=").append(topicID).append("&page=").append(pageNo);
	String reportUrl = response.encodeURL(sbuf.toString());

    ArrayList sections = cache.getSections();
	
	String sectionLink = null;
	if (setting.showSectionLink.equalsIgnoreCase("yes"))
	{
		sbuf.setLength(0);
		sbuf.append(" &raquo;&nbsp; <A href=\"./index.jsp?sid=").append(aBoard.sectionID)
			.append("\">").append(aSection.sectionName).append("</A>");
		sectionLink = response.encodeURL(sbuf.toString());
	}
	String jumpMode = setting.jumpMode;

	String catLink = null;
	CatVO aCat = null;

	if (aBoard.isCatOK == 'T' && aTopic.catID >= 0)
	{
		if (aTopic.catID == 0)
			aCat = aBoard.unCat;
		else
			aCat = aBoard.getCatVO(aTopic.catID);
		if (aCat != null)
		{
			sbuf.setLength(0);
			sbuf.append(" &raquo;&nbsp; <A href=\"./forum-").append(boardID).append(".html?cid=")
				.append(aCat.catID).append("\">").append(aCat.catName).append("</A>");
			catLink = response.encodeURL(sbuf.toString());
		}
	}
	
	if (aTopic.isVisited)
	{
        TopicInfo topicInfo = aBoard.getTopic(topicID);
        if (topicInfo != null)
		{
            topicInfo.visits = topicInfo.visits + 1;
			topicInfo.diggs = aTopic.diggups - aTopic.diggdns;
		}
		if (aCat != null) {
            topicInfo = aCat.getTopic(topicID);
            if (topicInfo != null)
			{
                topicInfo.visits = topicInfo.visits + 1;
				topicInfo.diggs = aTopic.diggups - aTopic.diggdns;
			}
        }
	}
	
    boolean isShowTopicBtn = true;
    if (aBoard.acl != null)
    {
        int p1 = aBoard.acl.indexOf("F_"); // new topic right
        if (p1 >= 0)
        {
            String groups = null;
            int p2 = aBoard.acl.indexOf(',', p1);
            if (p2>0)
                groups = aBoard.acl.substring(p1+1,p2);
            else
                groups = aBoard.acl.substring(p1+1);
			
            if (groups.length() <= 4 && !isModerator) // Only moderator allowed
            {
		        if (userinfo != null && aBoard.members != null)
        		{
		            if (aBoard.members.indexOf(userinfo.userID + ",") < 0)
		                isShowTopicBtn = false;
		        }
				else
	                isShowTopicBtn = false;
            }
        }
    }
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<HTML xmlns="http://www.w3.org/1999/xhtml">
<HEAD>
<TITLE><%= aTopic.title %><% if (aCat!=null && aCat.catID>0){ out.write(" - "); out.write(aCat.catName); } %> - <%= aBoard.plainName %> - <%= title %></TITLE>
<%= PageUtils.getMetas(title, aBoard) %>
<LINK href="styles/<%= forumStyle %>/ejforum.css" type=text/css rel=stylesheet>
</HEAD>
<BODY onkeydown="if(event.keyCode==27) return false;">
<SCRIPT src="js/common.js" type=text/javascript></SCRIPT>
<SCRIPT src="js/topic.js" type=text/javascript></SCRIPT>
<SCRIPT src="js/ajax.js" type=text/javascript></SCRIPT>
<%= PageUtils.getTopInfo(request) %>
<DIV class=wrap>
<DIV id=header>
<%= PageUtils.getHeader(request, aSection, title) %>
<%= PageUtils.getHeadAdBanner(request, aSection, aBoard) %></DIV>
<%= menus[0] %>
<DIV id=foruminfo>
<DIV id=nav><A href="<%= homeUrl %>"><%= forumName %></A><% if (sectionLink!=null) out.write(sectionLink); %> &raquo;&nbsp; 
<A href="<%= forumUrl %>"><%= aBoard.boardName %></A><% if (catLink!=null) out.write(catLink); %> &raquo;&nbsp; <%= aTopic.title %></DIV>
<DIV id=headsearch>
<FORM id="frmsearch" name="frmsearch" 
	  action="http://www.google.com.hk/search" onsubmit="doSearch(); return false;" method=get target="google_window">
<INPUT type=hidden value="<%= serverName %>" name=sitesearch> 
<div onclick="javascript:window.open('http://www.google.com.hk/')" 
 style="cursor:pointer;float:left;width:70px;height:23px;background: url(images/google.png)! important;background: none; filter: 
 progid:DXImageTransform.Microsoft.AlphaImageLoader(src='images/google.png',sizingMethod='scale')"></div>&nbsp;
<INPUT maxLength=255 size=12 name=q class="search"><INPUT type=hidden value="UTF-8" name=ie><INPUT type=hidden value="UTF-8" name=oe><INPUT type=hidden value=zh-CN name=hl>&nbsp;
<a href="#" onclick="doSearch(); return false;" style="vertical-align:middle">
<img src="styles/<%= forumStyle %>/images/search.gif" border="0" alt="站内搜索" align="absbottom"/></a>
</FORM></DIV></DIV>
<DIV id=ad_text></DIV>
<DIV class=pages_btns>
<div class="pages"><a href="<%= baseUrl %>&goto=prev" class="prev">&lsaquo;&lsaquo; 上一主题</a><a 
href="<%= baseUrl %>&goto=next" class="next">下一主题 &rsaquo;&rsaquo;</a></div>
<%
	if (aTopic.pageHTML != null)
	{
%>	  
	<%= aTopic.pageHTML %>
<%
	}
	if (isShowTopicBtn) {
%>
<SPAN class=postbtn id="newtopic" onmouseover="$('newtopic').id = 'newtopictmp';this.id = 'newtopic';showMenu(this.id);">
<A href="<%= postUrl %>"><IMG src="styles/<%= forumStyle %>/images/newtopic.gif" border=0></A></SPAN>
<% } %>
<SPAN class=replybtn><A href="javascript:replyTopic();">
<IMG alt="发表回复" src="styles/<%= forumStyle %>/images/reply.gif" border=0></A></SPAN></DIV>
<UL class="popmenu_popup newtopicmenu" id="newtopic_menu" style="display: none">
<LI><a href="<%= postUrl %>">发新话题</a></LI>
<LI class="vote"><a href="<%= postUrl %>&act=vote">发布投票</a></LI>
<LI class="reward"><a href="<%= postUrl %>&act=reward">发布悬赏</a></LI>
</UL>
<%
	PostVO aPost = null;
	String userID = null;
	String nickname = null;
	String avatar = null;
	String avatarPath = ctxPath + "/upload/avatar/";
	GroupVO aGroup = null;
	boolean isManager = false;
	boolean isAuthor = false;
    String moderators = PageUtils.getModerators(aSection, aBoard);
	String showAvatar = setting.showAvatar;
	String showBrief = setting.showBrief;
	String spaceURL = response.encodeURL("uspace.jsp?uid=");
	StringBuilder userPostIDs = null;
	int seqno = 0;
	int startSeq = (aTopic.pageNo - 1) * pageRows;
	if (aTopic.pageNo > 1) startSeq++;

	Calendar cal = Calendar.getInstance();
	cal.add(Calendar.DATE, -3);

	boolean isTopicAuthor = false;
	if (userinfo != null && userinfo.userID.equalsIgnoreCase(aTopic.userID))
	{
		isTopicAuthor = true;
		session.setAttribute("userTopicID", String.valueOf(topicID));
	}
	
	for (int i=0; i<aTopic.postList.size(); i++)
	{
		aPost = (PostVO)aTopic.postList.get(i);
		if (aPost.isHidePost == 'T')
		{
			userID = "";
			nickname = "匿名";
		}
		else
		{
			userID = aPost.u_userID;
			nickname = (aPost.u_nickname==null || aPost.u_nickname.length()==0) ? userID : aPost.u_nickname;
		}

		aGroup = PageUtils.getGroupVO(userID, aPost.u_groupID, aPost.u_credits, moderators);
		avatar = aPost.u_avatar;
		if (avatar == null || avatar.length() == 0)
			avatar = "sample/unknown.gif";
		else if (aGroup.rights.indexOf(IConstants.PERMIT_UPLOAD_AVATAR) < 0 && !avatar.startsWith("sample/"))
			avatar = "sample/unknown.gif";

		int count1 = -1;
		int count2 = aGroup.stars;
		if (aGroup.stars > 5)
		{
			count1 = aGroup.stars / 5;
			count2 = aGroup.stars % 5;
		}
		seqno = startSeq + i;
%>
<DIV class="mainbox viewtopic">
<%
		if (i == 0) {
%>
<SPAN class=headactions>
<A class=notabs href="./member/my_addfavor.jsp?tid=<%= topicID %>&fid=<%= boardID %>">收藏</A>&nbsp;</SPAN>
<H1><A href="./topic-<%= topicID %>.html"><%= aTopic.title %><% if (aTopic.isDigest=='T') out.write("&nbsp;&nbsp;~ 精华"); %></A>&nbsp;</H1>
<%
		}
%>
<TABLE id="rid<%= aPost.replyID %>" cellSpacing=0 cellPadding=0>
  <TBODY>
  <TR>
    <TD class=postauthor rowspan="3">
  	  <CITE><A href="<%= spaceURL %><%= userID %>" target=_blank><%= nickname.length()==0?"游客":nickname %></A></CITE> 
<%
	if (showAvatar.equals("yes")) {
		int maxAvatarSize = setting.maxAvatarPixels;
%>
      <DIV class=avatar>
	  	<A href="<%= spaceURL %><%= userID %>" target=_blank 
			title="<%= nickname.length()==0?"游客":nickname%>"><IMG src="<%= avatarPath %><%= avatar %>" 
			border=0 onload="resizeImage(this, <%= maxAvatarSize %>);"></A></DIV>
<%
	}
%>	  
      <P><EM><%= aGroup.groupName %></EM>&nbsp;
		<%	for (int j=0; j<count1; j++) { %><IMG alt="Rank: <%= aGroup.stars %>" 
		src="images/star_5.gif" align="absmiddle" border="0"><% } for (int j=0; j<count2; j++) { %><IMG 
		alt="Rank: <%= aGroup.stars %>" src="images/star_1.gif" align="absmiddle" border="0"><% } %>
	  </P>
	  <DL class="profile">
	  	<DT>帖子&nbsp;</DT><DD><%= aPost.u_posts %>&nbsp;</DD>
	  	<DT>积分&nbsp;</DT><DD><%= aPost.u_credits %>&nbsp;</DD>
	  </DL>				      
	  <UL>
	  	<LI class=friend><A href="./member/my_addfriend.jsp?uid=<%= userID %>" target=_blank>加为好友</A></LI>
        <LI class=sms><A href="./member/sms_compose.jsp?uid=<%= userID %>" target=_blank>发短消息</A></LI>
	  </UL></TD>
    <TD class=postdetail>
      <DIV class=postinfo><STRONG title="ID:<%= aPost.replyID %>"><%= seqno %><SUP>#</SUP></STRONG> 
	  发表于 <%= aPost.createTime %>&nbsp;
<% 		
		if(isModerator && aPost.remoteIP != null){ 
			out.write("IP: "); out.write(aPost.remoteIP); out.write("&nbsp;"); 
		}
		if (seqno == 0 && aTopic.updateUser != null && aTopic.updateUser.length() > 0) {
			out.write(" &nbsp;更新于 "); out.write(aTopic.updateTime); 
			out.write(" &nbsp;by&nbsp; "); out.write(aTopic.updateUser); out.write("&nbsp; ");
		}
		if (replyID > 0 && replyID == aPost.replyID) { 
			out.write("<font color='red'>(&nbsp;回帖ID: " + replyID  + "&nbsp;)</font>");
		}
		if (aPost.state == 'R') { 
			out.write("<font color='red'>&nbsp;(&nbsp;已删除&nbsp;)</font>");
		}
%>		
	  </DIV>
      <DIV class="postcontent">
<%		
		if (seqno == 0 && aTopic.reward > 0) 
		{
			out.write("<p style='PADDING-BOTTOM: 15px; float: right'><span class='notice'><img src='styles/");
			out.write(forumStyle); out.write("/images/reward.gif' border='0' align='absmiddle'/> &nbsp;积分&nbsp;");
			out.write(String.valueOf(aTopic.reward)); out.write("</span></p>\n");
		}			  
		if (aPost.isBest == 'T') 
			out.write("<p style='PADDING-BOTTOM: 15px; float: right'><span class='notice'>"
					  + "<img src='images/answer.gif' border='0' align='absmiddle'/> &nbsp;最佳回复</span></p>\n");
		if (aPost.title != null && aPost.title.length() > 0) {
			out.write("<H2>"); out.write(aPost.title); out.write("</H2>");
		}
%>		
      <DIV id="content_<%= seqno %>" class=contentmsg><%= aPost.content %></DIV>
<%
		if (aTopic.specType == 'V' && aTopic.pollInfo != null && seqno == 0) 
		{
			String[] opts = aTopic.pollInfo.options.split("\n");
			if (aTopic.pollInfo.optCounts == null) 
			{
				long validDays = -1;  // no limit
            	if (aTopic.pollInfo.expireStamp > 0)
				{
					validDays = aTopic.pollInfo.expireStamp - System.currentTimeMillis();
					if (validDays <= 0)
						validDays = 0;
					else
						validDays = validDays / 86400000 + 1;
					if (validDays > 10000)
						validDays = -1;
				}
					
				String info = null;
				if (validDays == 0)
					info = "已过投票有效期";
				else if (validDays > 0)
					info = validDays + "天后过期";
				
				if(userinfo == null && aTopic.pollInfo.isPublic == 'F')
				{
					if (info == null)
						info = "仅会员才能投票";
					else
						info = "仅会员才能投票 " + info;
				}
%>
		<form id="pollform" name="pollform" method="post" action="perform.jsp?act=vot&tid=<%= topicID %>">
		<input type=hidden name="cmd" value="poll"/>
		<input type=hidden name="pub" value="<%= aTopic.pollInfo.isPublic %>"/>
		<div class="box pollinfo"><table cellSpacing=0 cellPadding=0>
			<tr><th colspan=3><em><% if(info!=null){ out.write("(&nbsp;");out.write(info);out.write("&nbsp;)"); } %></em>
			投票选项（<%= aTopic.pollInfo.isSingle=='T'?"单选":"多选" %>）</th></tr>
<%
				for (int j=0; j<opts.length; j++) {
%>
			<tr><td width="10">
 			   	<%  if (aTopic.pollInfo.isSingle == 'T') {  %>
			  	<input class="radio" type="radio" name="optid" value="<%= j+1 %>"/>
 			   	<%  } else {  %>
			  	<input class="checkbox" type="checkbox" name="optid" value="<%= j+1 %>"/>
 			   	<%  }  %>
			  </td>
			  <td><%= opts[j] %></td><td width="100"></td>
			</tr>
<%
				}
%>			
		<tr><td colspan=3 style="padding:9px; border-bottom:none">
		<% if(validDays!=0){ %><button class="button" onclick="doPolling();return false;">投票</button>&nbsp;<% } %>
		<% if(userinfo==null||validDays==0){ %><button class="button" onclick="doPollView();return false;">查看</button>&nbsp;<% } %>
		</td></tr>
		</table></div></form>
<%
			} else {
				String info = null;
				if(aTopic.pollInfo.voted == 'V')
					info = "(&nbsp;您已经投过一票&nbsp;)";
				else if (aTopic.pollInfo.voted == 'S')
					info = "(&nbsp;投票成功, 谢谢!&nbsp;)";

				int opt_sum = 0;
				for (int j=0; j<aTopic.pollInfo.optCounts.length; j++) {
					opt_sum = opt_sum + aTopic.pollInfo.optCounts[j];
					if (j >= opts.length) break;
				}
				if (opt_sum == 0) opt_sum = 1;
%>
		<div class="box pollinfo"><table cellSpacing=0 cellPadding=0>
			<tr><th colspan=2><EM><% if(info!=null) out.write(info); %></EM>
				投票结果（<%= aTopic.pollInfo.isSingle=='T'?"单选":"多选" %>, 共<%= opt_sum %>人参与）</th></tr>
<%
				int opt_count = 0;
				int opt_rate = 0;
				for (int j=0; j<opts.length; j++) {
					if (j < aTopic.pollInfo.optCounts.length)
						opt_count = aTopic.pollInfo.optCounts[j];
					else
						opt_count = 0;
					opt_rate = opt_count * 100 / opt_sum;
%>
			<tr><td width="45%">&nbsp;<%= j+1 %>. <%= opts[j] %> </td>
			  <td>
			  	<div style="width:<%= 3*opt_rate+4 %>px"><div 
			 		 class="pollbar"></div></div>&nbsp;&nbsp;<%= opt_count %> (<%= opt_rate %>%)
			</td></tr>
<%
				}
%>			
		</table></div>
<%
			}
		}
		if (aPost.attaches > 0 && aTopic.attachList != null) 
		{
			StringBuilder attaches = null;
			AttachVO aAttach = null;
			String attachTitle = null;
			int attachCount = 0;
			String attachURL = response.encodeURL("attach?aid=");
			
			for (int j=0; j<aTopic.attachList.size(); j++)
			{
				aAttach = (AttachVO)aTopic.attachList.get(j);
				if (aAttach.replyID != aPost.replyID) continue;
				attachCount++;
				if (attachCount == 1) 
				{
					attaches = new StringBuilder("<DIV class='box attachlist'><BR/>\n");
					attaches.append("<P class='attach'>附件</P>\n");
					if (!PageUtils.isPermitted(aBoard,userGroup,userinfo,IConstants.PERMIT_DOWNLOAD))
					{
						attaches.append("<EM style='padding-left:6px'>您所在的用户组无法下载或查看附件</EM>\n");
						break;
					}
				}
				if (aAttach.title == null || aAttach.title.length() == 0)
					attachTitle = "";
				else
					attachTitle = "<p>" + aAttach.title + "</p>";

				attaches.append("<dl class='p_attachlist'><dt>\n")
						.append("<img src='styles/").append(forumStyle)
						.append("/images/i_attach.gif' border='0' class='absmiddle'/>&nbsp;&nbsp;\n")
						.append("<a href='").append(attachURL).append(aAttach.attachID).append("' class='bold'>")
						.append(aAttach.filename).append("</a>&nbsp;&nbsp;<em class='num'>(")
						.append(aAttach.filesize*1.0/1000).append(" KB)</em></dt>\n");
				attaches.append("<dd><p>").append(aAttach.createTime).append(", 下载次数: <em class='num'>")
						.append(aAttach.downloads).append("</em>, 下载所需积分: <em class='num'>")
						.append(aAttach.credits).append("</em></p>").append(attachTitle).append("</dd></dl>\n");
			} // end for
			if (attaches != null && attachCount > 0) 
			{
				attaches.append("</DIV>");
				out.write(attaches.toString());
			}
		}
%>
  </DIV></TD></TR>
  <TR>
    <TD class=postsign>
<%
		if (seqno == 0 && aBoard.scoreType != 'N') {
%>
		<center><div class="diggit">
		<a href="#" onclick="diggit('<%= boardID %>','<%= topicID %>','up');return false;"><div><span 
			id="diggup_<%= topicID %>"><%= aTopic.diggups %></span><br/>顶</div></a>
		<a href="#" onclick="diggit('<%= boardID %>','<%= topicID %>','down');return false;"><div><span 
			id="diggdn_<%= topicID %>"><%= aTopic.diggdns %></span><br/>踩</div></a>
		</div></center>
<%			
		}
		if (showBrief.equals("yes") && aPost.u_brief != null && aPost.u_brief.trim().length() > 0) {
	  		out.write("<DIV class='signature'>"); out.write(aPost.u_brief); out.write("</DIV>");
		}
		if (seqno == 0) out.write(PageUtils.getTopicAdBanner(request, aBoard));
%>
	</TD>
  </TR>
  <TR>
    <TD class=postfooter>
      <DIV class=postactions><P>
<%  
	    if (userinfo != null && userinfo.userID.equalsIgnoreCase(aPost.u_userID)
			&& !AppUtils.isBeforeDate(aPost.createTime,cal.getTime()))
			isAuthor = true;
		else
			isAuthor = false;

		if (isAuthor)
		{
			if (userPostIDs == null)
				userPostIDs = new StringBuilder();
			if (seqno == 0)
				userPostIDs.append('t').append(topicID).append(',');
			else
				userPostIDs.append('r').append(aPost.replyID).append(',');
		}
		
		if (seqno == 0 && (isAuthor || userGroup.rights.indexOf(IConstants.PERMIT_MOVE_POST) >= 0)) {
		  isManager = true;
%>
	     	<a href="javascript:doManage('move', '0');">移动主题</a>&nbsp;&nbsp;
<%	  	}
		if (isAuthor || userGroup.rights.indexOf(IConstants.PERMIT_EDIT_POST) >= 0) {  
		  isManager = true;	
%>
	     <a href="javascript:doEdit('<%= aPost.replyID %>');">修改</a>&nbsp;&nbsp;
<%
		}
		if (userGroup.rights.indexOf(IConstants.PERMIT_DELETE_POST) >= 0 && aPost.state != 'R') {  
		  isManager = true;	
%>
 	     <a href="javascript:doManage('delete', '<%= aPost.replyID %>');">删除</a>&nbsp;&nbsp;
<% 		}
		if (aTopic.state != 'C') {
%>
	     <a href="javascript:doReply('<%= seqno %>','<%= nickname %>');">回复</a>&nbsp;&nbsp;
<%		} 		%>
	  	 <a href="javascript:doQuote('<%= seqno %>','<%= nickname %>','<%= aPost.createTime %>');">引用</a>&nbsp;&nbsp;
		 <a href="javascript:doReport('<%= aPost.replyID %>');">举报</a>&nbsp;&nbsp;
<% 		if (seqno > 0 && isTopicAuthor) {
	  		isManager = true; 
%>
	     <a href="javascript:doManage('setbest', '<%= aPost.replyID %>');">最佳回复</a>&nbsp;&nbsp;
<% 		}      %>		 
	     <SPAN title="顶部" class="scrolltop" onclick="scroll(0,0)">TOP</SPAN> </P>
<%      if (seqno == 0) { out.write("<DIV>"); out.write(setting.topicbarCode); out.write("</DIV>"); }      %>
	 </DIV></TD></TR></TBODY></TABLE></DIV>
<%
	}
	if (userPostIDs != null)
		session.setAttribute("userPostIDs", userPostIDs.toString());
%>
<DIV class=pages_btns>
<div class="pages"><a href="<%= baseUrl %>&goto=prev" class="prev">&lsaquo;&lsaquo; 上一主题</a><a 
					  href="<%= baseUrl %>&goto=next" class="next">下一主题 &rsaquo;&rsaquo;</a></div>
<%
	if (aTopic.pageHTML != null)
	{
%>	  
	<%= aTopic.pageHTML %>
<%
	}
	if (isShowTopicBtn) {
%>
<SPAN class=postbtn id="newtopictmp" onmouseover="$('newtopic').id = 'newtopictmp';this.id = 'newtopic';showMenu(this.id);">
<A href="<%= postUrl %>"><IMG src="styles/<%= forumStyle %>/images/newtopic.gif" border=0></A></SPAN>
<% } %>
<SPAN class=replybtn><A href="javascript:replyTopic();">
<IMG alt="发表回复" src="styles/<%= forumStyle %>/images/reply.gif" border=0></A></SPAN></DIV>
<SCRIPT type=text/javascript>
var replyUrl = "<%= postUrl %>" + "&tid=<%= topicID %>";
var reportUrl = "<%= reportUrl %>";
var isClosed = <%= aTopic.state=='C'?"true":(aTopic.replies>=setting.maxReplies?"true":"false") %>;
var isDigest = <%= aTopic.isDigest=='T'?"true":"false" %>;
<% 
	if (isManager) {
		sbuf.setLength(0);
		sbuf.append("manage.jsp?fid=").append(boardID)
	    	.append("&chkTopicID=").append(topicID).append("&page=").append(pageNo);
		if(aTopic.catID > 0)
			sbuf.append("&cid=").append(aTopic.catID);
%>
var manageUrl = "<%= response.encodeURL(sbuf.toString()) %>";
function doEdit(replyId) 
{
<%	if (!isModerator) {   %>
	if (isDigest && replyId == '0')
	{
		alert('此主题已被加为精华，不能再修改  ');
		return;
	}	
	if (isClosed)
	{
		alert('此主题已经关闭，不能再修改  ');
		return;
	}	
<%	}  %>
	$('frmpost').action = replyUrl + "&rid=" + replyId + "&act=edit&page=<%= pageNo %>";
	$('frmpost').subject.value = "";
	$('frmpost').content.value = "";
	$('frmpost').submit();
}
function doManage(action, replyId)
{
<%	if (!isModerator) {   %>
	if (action == 'move')
	{
		if (isDigest)
		{
			alert('此主题已被加为精华，不能再移动  ');
			return;
		}
		if (isClosed)
		{
			alert('此主题已经关闭，不能再移动  ');
			return;
		}	
	}
	if (action == 'setbest' && isClosed)
	{
		alert('此主题已经关闭，不能再设置最佳回复  ');
		return;
	}
	
<%	}  %>
	$('frmpost').action = manageUrl + "&rid=" + replyId + "&act=" + action;
	$('frmpost').subject.value = "";
	$('frmpost').content.value = "";
	$('frmpost').submit();
}
<% 
	} 
%>
</SCRIPT>
<DIV class=legend id=footfilter><DIV class=jump_sort>
<SELECT onchange="if(this.options[this.selectedIndex].value != ''){window.location = this.options[this.selectedIndex].value;}">
<OPTION value="" selected>版块跳转 ...</OPTION> 
<%
	if (sections != null)
	{
		SectionVO tmpSection = null;
		BoardVO tmpBoard = null;
		String tmpUrl = null;
		StringBuilder sb = new StringBuilder();
		
		for (int i=0; i<sections.size(); i++)	
		{
			tmpSection = (SectionVO)sections.get(i);
			if (tmpSection.boardList == null) continue;
			if (!jumpMode.equals("all") && tmpSection.sectionID != aSection.sectionID) continue;

			sb.append("<OPTGROUP label=\"").append(tmpSection.sectionName).append("\">\n");
			
			for (int j=0; j<tmpSection.boardList.size(); j++)
			{
				tmpBoard = (BoardVO)tmpSection.boardList.get(j);
				if (tmpBoard.state == 'I' && !isModerator) continue;
				sbuf.setLength(0);
				sbuf.append("./forum-").append(tmpBoard.boardID).append(".html");
				tmpUrl = response.encodeURL(sbuf.toString());
				sb.append("<OPTION value=\"").append(tmpUrl).append("\">&nbsp; &gt; ")
				  .append(tmpBoard.boardName).append("</OPTION>\n");
			}
			sb.append("</OPTGROUP>");
		}
		out.write(sb.toString());
	}
%>
</SELECT>
<form id="frmpost" name="frmpost" action="<%= postUrl %>" method="post">
<INPUT type=hidden value="<%= AppUtils.replaceStr(aTopic.title,"\"","&quot;") %>" name="topic">
<INPUT type=hidden value="" name="subject">
<INPUT type=hidden value="" name="content">
<INPUT type=hidden value="<%= aTopic.isReplyNotice %>" name="notice">
</form>
</DIV></DIV>
<%
	if (setting.fastReply.equals("yes") && aTopic.state!='C' && aTopic.replies<setting.maxReplies)
	{
		sbuf.setLength(0);
		sbuf.append("perform.jsp?act=post_quick").append("&fid=").append(boardID);
		if (aCat != null)
			sbuf.append("&cid=").append(aCat.catID);
		sbuf.append("&tid=").append(topicID).append("&page=").append(pageNo);
		if (aTopic.title != null && aTopic.title.length() > 0)
			sbuf.append("&topic=").append(URLEncoder.encode(aTopic.title, "UTF-8"));
		String performUrl = sbuf.toString();
		boolean allowHTML = userGroup.rights.indexOf(IConstants.PERMIT_USE_HTML) >= 0;
%>
<SCRIPT src="js/post.js" type=text/javascript></SCRIPT>
<form id="postform" name="postform" action="<%= performUrl %>" method="post" onsubmit="checkQuickPost(this);return false;">
<INPUT type=hidden value="<%= aTopic.isReplyNotice %>" name="notice">
<div id="quickreply" class="box">
<span class="headactions"><a href="help/credits_rule.jsp" target="_blank">查看积分策略说明</a></span>
<h4>快速回复主题</h4>
<TABLE cellSpacing=0 cellPadding=0>
  <TBODY>
  <TR>
    <TD style="width:168px">标题</TD>
    <TD><div style="float:right; padding:3px;">
		<% if (userinfo==null) { %><a href="login.jsp">登录</a> <a href="register.jsp">注册</a>
		<% }else{ %>用户名 <%= userinfo.userID %><% } %></div>
		<INPUT id=subject tabIndex=2 size=55 name=subject maxlength=100> <em class="tips">&nbsp;(可选)</em>
	</TD></TR>
  <TR>
   <TD valign=top style="width:168px">内容 <br><br>
    <UL>
      <LI><a href="help/post.jsp#faq04" 
	  	target=_blank>HTML&nbsp;代码</a>&nbsp;&nbsp;<EM><%= allowHTML?"可用":"禁用" %></EM></LI>
      <LI><a href="help/post.jsp#faq03" 
	  	target=_blank>插入图片&nbsp;[img]</a> &nbsp;<EM><%= aBoard.isImageOK=='T'?"可用":"禁用" %></EM></LI>
      <LI><a href="help/post.jsp#faq03" 
	  	target=_blank>插入媒体&nbsp;[media]</a> &nbsp;<EM><%= aBoard.isMediaOK=='T'?"可用":"禁用" %></EM></LI>
    </UL>
	</TD>
    <TD><TEXTAREA id=editor_content tabIndex=5 style="BEHAVIOR:url(#default#userdata);WIDTH:99%;HEIGHT:120px"
		 name="content" rows=5 cols=60></TEXTAREA>
	</TD></TR>
  <TR>
	<TH></TH>
	<TH align=left style="padding-bottom:12px; padding-right:12px"><a href="###" style="float:right" 
		   onclick="if (confirm('此操作将覆盖当前帖子内容，确定要恢复数据吗？')) loadData();">恢复自动保存的数据</a>
		<BUTTON id="postbtn" tabIndex=9 name="post_reply" type=submit class=submit style="width:110px">发表回复</BUTTON>
    </TH></TR>
</TBODY></TABLE>
</div></form>
<SCRIPT type=text/javascript>
var wysiwyg = 0;
var textobj = $('editor_content');
<% 	  if (request.getParameter("load") != null) {    %>
			loadData();
<% 	  }    %>
</SCRIPT>
<% } %>
</DIV>
<% if(menus[1]!=null) out.write(menus[1]); %>
<% if(menus[2]!=null) out.write(menus[2]); %>
<%= PageUtils.getFootAdBanner(request, aSection, aBoard) %>
<%= PageUtils.getFooter(request, forumStyle) %>
</BODY></HTML>