<%@ page contentType="text/html;charset=UTF-8" errorPage="../error.jsp"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import="java.util.HashMap"%>
<%@ page import="com.hongshee.ejforum.util.PageUtils"%>
<%@ page import="com.hongshee.ejforum.common.ForumSetting"%>
<%@ page import="com.hongshee.ejforum.common.IConstants"%>
<%@ page import="com.hongshee.ejforum.data.GroupDAO.GroupVO"%>
<%@ page import="com.hongshee.ejforum.data.UserDAO.UserInfo"%>
<%@ page import="com.hongshee.ejforum.data.StatDAO"%>
<%@ page import="com.hongshee.ejforum.data.TagDAO"%>
<%@ page import="com.hongshee.ejforum.data.TagDAO.TagInfo"%>
<%
	UserInfo userinfo = PageUtils.getSessionUser(request,response);
    GroupVO aGroup = PageUtils.getGroupVO(userinfo);
	if (aGroup.rights.indexOf(IConstants.PERMIT_VIEW_STAT) < 0)
	{
		request.setAttribute("errorMsg", "您没有查看统计数据的权限");
		request.getRequestDispatcher("/error.jsp").forward(request, response);
		return;
	}	
	String forumName = ForumSetting.getInstance().getForumName();
	String title = PageUtils.getTitle(forumName);
	String[] menus = PageUtils.getHeaderMenu(request, userinfo);
	String homeUrl = "../index.jsp";
	String forumStyle = PageUtils.getForumStyle(request, response, null);
	
	ArrayList tagList = TagDAO.getInstance().getTopTagsInfo();
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<HTML xmlns="http://www.w3.org/1999/xhtml">
<HEAD>
<TITLE>关键字排行 - <%= title %></TITLE>
<%= PageUtils.getMetas(title, null) %>
<LINK href="../styles/<%= forumStyle %>/ejforum.css" type=text/css rel=stylesheet>
</HEAD>
<BODY onkeydown="if(event.keyCode==27) return false;">
<SCRIPT src="../js/common.js" type=text/javascript></SCRIPT>
<%= PageUtils.getTopInfo(request) %>
<DIV class=wrap>
<DIV id=header>
<%= PageUtils.getHeader(request, title) %>
<%= PageUtils.getHeadAdBanner(request, null) %></DIV>
<%= menus[0] %>
<DIV id=nav><A href="<%= homeUrl %>"><%= forumName %></A> &raquo;&nbsp; 
<A href="./baseinfo.jsp">论坛统计</A> &raquo;&nbsp; 关键字 </DIV>
<DIV class=container>
<DIV class=side>
<DIV>
<H2>统计选项</H2>
<UL>
  <LI><H3><A href="baseinfo.jsp">基本概况</A> </H3></LI>
  <LI><H3><A href="flux.jsp">访问量记录</A> </H3></LI>
  <LI><H3><A href="top_boards.jsp">版块排行</A> </H3></LI>
<%
   HashMap statMap = StatDAO.getInstance().getBaseStatInfo();
   String cats = (String)statMap.get("cats");
   if (cats != null && Integer.parseInt(cats) > 0) {
%>
  <LI><H3><A href="top_cats.jsp">分类排行</A> </H3></LI>
<%
   }
%>
  <LI><H3><A href="top_topics.jsp">主题排行</A> </H3></LI>
  <LI class=side_on><H3><A href="top_tags.jsp">关键字排行</A> </H3></LI>
  <LI><H3><A href="top_users.jsp">会员排行</A> </H3></LI>
  <LI><H3><A href="admins.jsp">管理团队</A> </H3></LI>
</UL></DIV></DIV>
<DIV class=content>
<DIV class=mainbox>
<H1>关键字排行</H1>
<TABLE cellSpacing=0 cellPadding=0>
  <THEAD>
  <TR>
    <TD width="16%">关键字</TD>
    <TD width="17%">搜索次数&nbsp;/&nbsp;记录数</TD>
    <TD width="16%">关键字</TD>
    <TD width="17%">搜索次数&nbsp;/&nbsp;记录数</TD>
    <TD width="16%">关键字</TD>
    <TD width="17%">搜索次数&nbsp;/&nbsp;记录数</TD></TR></THEAD>
  <TBODY>
<%
	if (tagList != null)
	{
		TagInfo aTag = null;
		int rows = (tagList.size() + 2) / 3;
		for (int i=0; i<rows; i++)
		{
			aTag = (TagInfo)tagList.get(i*3);
%>  
  <TR>
    <TD><A href="../search_result.jsp?searchfield=content&keys=<%= aTag.tagname %>" target=_blank><%= aTag.tagname %></A></TD>
    <TD><%= aTag.queryCount %> / <%= aTag.recordCount %></TD>
<%
			if (i*3+1 < tagList.size()) {
				aTag = (TagInfo)tagList.get(i*3+1);
%>	
    <TD><A href="../search_result.jsp?searchfield=content&keys=<%= aTag.tagname %>" target=_blank><%= aTag.tagname %></A></TD>
    <TD><%= aTag.queryCount %> / <%= aTag.recordCount %></TD>
<%				
			} else {
%>	
    <TD>&nbsp;</TD>
    <TD>&nbsp;</TD>
<%
			}
			if (i*3+2 < tagList.size()) {
				aTag = (TagInfo)tagList.get(i*3+2);
%>	
    <TD><A href="../search_result.jsp?searchfield=content&keys=<%= aTag.tagname %>" target=_blank><%= aTag.tagname %></A></TD>
    <TD><%= aTag.queryCount %> / <%= aTag.recordCount %></TD>
<%				
			} else {
%>	
    <TD>&nbsp;</TD>
    <TD>&nbsp;</TD>
<%
			}
%>			
  </TR>
<%
		}
	}
%>	
</TBODY></TABLE></DIV>
</DIV></DIV></DIV>
<%= menus[1]==null?"":menus[1] %>
<%= menus[2]==null?"":menus[2] %>
<%= PageUtils.getFooter(request,forumStyle) %>
</BODY></HTML>
