<%@ page contentType="text/html;charset=UTF-8" errorPage="../error.jsp"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import="java.util.HashMap"%>
<%@ page import="com.hongshee.ejforum.util.PageUtils"%>
<%@ page import="com.hongshee.ejforum.common.ForumSetting"%>
<%@ page import="com.hongshee.ejforum.common.CacheManager"%>
<%@ page import="com.hongshee.ejforum.common.IConstants"%>
<%@ page import="com.hongshee.ejforum.data.GroupDAO.GroupVO"%>
<%@ page import="com.hongshee.ejforum.data.UserDAO.UserInfo"%>
<%@ page import="com.hongshee.ejforum.data.StatDAO"%>
<%@ page import="com.hongshee.ejforum.data.BoardDAO.BoardVO"%>
<%@ page import="com.hongshee.ejforum.data.BoardDAO.CatVO"%>
<%@ page import="com.hongshee.ejforum.data.SectionDAO.SectionVO"%>
<%
	UserInfo userinfo = PageUtils.getSessionUser(request,response);
    GroupVO aGroup = PageUtils.getGroupVO(userinfo);
	if (aGroup.rights.indexOf(IConstants.PERMIT_VIEW_STAT) < 0)
	{
		request.setAttribute("errorMsg", "您没有查看统计数据的权限");
		request.getRequestDispatcher("/error.jsp").forward(request, response);
		return;
	}	
	String forumName = ForumSetting.getInstance().getForumName();
	String title = PageUtils.getTitle(forumName);
	String[] menus = PageUtils.getHeaderMenu(request, userinfo);
	String homeUrl = "../index.jsp";
	String forumStyle = PageUtils.getForumStyle(request, response, null);
	int sectionID = PageUtils.getIntParam(request,"sid");
	CacheManager cache = CacheManager.getInstance();
	
	Object[] result = StatDAO.getInstance().getTopCatsInfo(sectionID);
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<HTML xmlns="http://www.w3.org/1999/xhtml">
<HEAD>
<TITLE>分类排行 - <%= title %></TITLE>
<%= PageUtils.getMetas(title, null) %>
<LINK href="../styles/<%= forumStyle %>/ejforum.css" type=text/css rel=stylesheet>
</HEAD>
<BODY onkeydown="if(event.keyCode==27) return false;">
<SCRIPT src="../js/common.js" type=text/javascript></SCRIPT>
<%= PageUtils.getTopInfo(request) %>
<DIV class=wrap>
<DIV id=header>
<%= PageUtils.getHeader(request, title) %>
<%= PageUtils.getHeadAdBanner(request, null) %></DIV>
<%= menus[0] %>
<DIV id=nav><A href="<%= homeUrl %>"><%= forumName %></A> &raquo;&nbsp; 
<A href="./baseinfo.jsp">论坛统计</A> &raquo;&nbsp; 分类排行 </DIV>
<DIV class=container>
<DIV class=side>
<DIV>
<H2>统计选项</H2>
<UL>
  <LI><H3><A href="baseinfo.jsp">基本概况</A> </H3></LI>
  <LI><H3><A href="flux.jsp">访问量记录</A> </H3></LI>
  <LI><H3><A href="top_boards.jsp">版块排行</A> </H3></LI>
  <LI class=side_on><H3><A href="top_cats.jsp">分类排行</A> </H3></LI>
  <LI><H3><A href="top_topics.jsp">主题排行</A> </H3></LI>
  <LI><H3><A href="top_tags.jsp">关键字排行</A> </H3></LI>
  <LI><H3><A href="top_users.jsp">会员排行</A> </H3></LI>
  <LI><H3><A href="admins.jsp">管理团队</A> </H3></LI>
</UL></DIV></DIV>
<DIV class=content>
<DIV class=mainbox>
<H1>分类排行</H1>
<TABLE cellSpacing=0 cellPadding=0>
  <THEAD>
  <TR>
    <TD width="25%">主题排行榜</TD>
    <TD width="8%"></TD>
    <TD width="25%">回复排行榜</TD>
    <TD width="8%"></TD>
    <TD width="25%">浏览排行榜（按主题平均）</TD>
    <TD width="8%"></TD></TR></THEAD>
  <TBODY>
<%
	if (result != null && result[0] != null && result[1] != null && result[2] != null)
	{
		ArrayList topTopicsCats = (ArrayList)result[0];
		ArrayList topRepliesCats = (ArrayList)result[1];
		ArrayList topVisitsCats = (ArrayList)result[2];
		BoardVO aBoard = null;
		CatVO aCat = null;
		HashMap record = null;
		int boardID = 0;
		int catID = 0;
		String catName = null;
		StringBuilder sbuf = new StringBuilder();

		for (int i=0; i<topTopicsCats.size(); i++)
		{
			record = (HashMap)topTopicsCats.get(i);
			boardID = Integer.parseInt((String)record.get("BOARDID"));
			catID = Integer.parseInt((String)record.get("CATID"));
			catName = null;

			sbuf.setLength(0);
			sbuf.append("../forum-").append(boardID).append(".html?cid=").append(catID);
			
			aBoard = (BoardVO)cache.getBoard(boardID);
			if (aBoard != null)
			{
				aCat = aBoard.getCatVO(catID);
				if (aCat != null)
					catName = aCat.catName + "&nbsp;-&nbsp;" + aBoard.boardName;
			}
%>  
  <TR>
    <TD><A href="<%= sbuf.toString() %>" target=_blank><%= catName==null?"未知分类":catName %></A></TD>
    <TD><%= (String)record.get("CT") %></TD>
<%
			if (i<topRepliesCats.size())
			{
				record = (HashMap)topRepliesCats.get(i);
				boardID = Integer.parseInt((String)record.get("BOARDID"));
				catID = Integer.parseInt((String)record.get("CATID"));
				catName = null;

				sbuf.setLength(0);
				sbuf.append("../forum-").append(boardID).append(".html?cid=").append(catID);
			
				aBoard = (BoardVO)cache.getBoard(boardID);
				if (aBoard != null)
				{
					aCat = aBoard.getCatVO(catID);
					if (aCat != null)
						catName = aCat.catName + "&nbsp;-&nbsp;" + aBoard.boardName;
				}
%>	
    <TD><A href="<%= sbuf.toString() %>" target=_blank><%= catName==null?"未知分类":catName %></A></TD>
    <TD><%= (String)record.get("CT") %></TD>
<%				
			}
			else
			{
%>	
    <TD>&nbsp;</TD>
    <TD>&nbsp;</TD>
<%
			}
			if (i<topVisitsCats.size())
			{
				record = (HashMap)topVisitsCats.get(i);
				boardID = Integer.parseInt((String)record.get("BOARDID"));
				catID = Integer.parseInt((String)record.get("CATID"));
				catName = null;

				sbuf.setLength(0);
				sbuf.append("../forum-").append(boardID).append(".html?cid=").append(catID);
			
				aBoard = (BoardVO)cache.getBoard(boardID);
				if (aBoard != null)
				{
					aCat = aBoard.getCatVO(catID);
					if (aCat != null)
						catName = aCat.catName + "&nbsp;-&nbsp;" + aBoard.boardName;
				}
%>
    <TD><A href="<%= sbuf.toString() %>" target=_blank><%= catName==null?"未知分类":catName %></A></TD>
    <TD><%= (String)record.get("CT") %></TD></TR>
<%				
			}
			else
			{
%>	
    <TD>&nbsp;</TD>
    <TD>&nbsp;</TD></TR>
<%
			}
		}
	}	
%>	
</TBODY></TABLE></DIV>
<DIV class=legend id=footfilter><DIV class=jump_sort>&nbsp;
<SELECT onchange="if(this.options[this.selectedIndex].value != ''){window.location = this.options[this.selectedIndex].value;}">
<OPTION value="top_cats.jsp?sid=0"<% if (sectionID == 0) out.write(" selected"); %>>请选择分区 ...</OPTION>
<OPTION value="top_cats.jsp?sid=999"<% if (sectionID == 999) out.write(" selected"); %>>&nbsp;&gt; 全部分区</OPTION>
<%
    ArrayList sections = cache.getSections();
	if (sections != null)
	{
		SectionVO tmpSection = null;
		StringBuilder sb = new StringBuilder();
		for (int i=0; i<sections.size(); i++)	
		{
			tmpSection = (SectionVO)sections.get(i);
			sb.append("<OPTION value=\"top_cats.jsp?sid=").append(tmpSection.sectionID).append("\"");
			if (sectionID == tmpSection.sectionID)
				sb.append(" selected");
			sb.append(">&nbsp;&gt; ")
			  .append(tmpSection.sectionName).append("</OPTION>\n");
		}
		out.write(sb.toString());
	}
%>
</SELECT></DIV></DIV>
</DIV></DIV></DIV>
<%= menus[1]==null?"":menus[1] %>
<%= menus[2]==null?"":menus[2] %>
<%= PageUtils.getFooter(request,forumStyle) %>
</BODY></HTML>
