<%@ page contentType="text/html;charset=UTF-8" errorPage="../error.jsp"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import="java.util.HashMap"%>
<%@ page import="com.hongshee.ejforum.util.PageUtils"%>
<%@ page import="com.hongshee.ejforum.common.ForumSetting"%>
<%@ page import="com.hongshee.ejforum.common.IConstants"%>
<%@ page import="com.hongshee.ejforum.common.CacheManager"%>
<%@ page import="com.hongshee.ejforum.data.GroupDAO.GroupVO"%>
<%@ page import="com.hongshee.ejforum.data.UserDAO.UserInfo"%>
<%@ page import="com.hongshee.ejforum.data.StatDAO"%>
<%@ page import="com.hongshee.ejforum.data.SectionDAO.SectionVO"%>
<%
	UserInfo userinfo = PageUtils.getSessionUser(request,response);
    GroupVO aGroup = PageUtils.getGroupVO(userinfo);
	if (aGroup.rights.indexOf(IConstants.PERMIT_VIEW_STAT) < 0)
	{
		request.setAttribute("errorMsg", "您没有查看统计数据的权限");
		request.getRequestDispatcher("/error.jsp").forward(request, response);
		return;
	}	
	String forumName = ForumSetting.getInstance().getForumName();
	String title = PageUtils.getTitle(forumName);
	String[] menus = PageUtils.getHeaderMenu(request, userinfo);
	String homeUrl = "../index.jsp";
	String forumStyle = PageUtils.getForumStyle(request, response, null);

	HashMap statInfo = StatDAO.getInstance().getBaseStatInfo();
	int topics = Integer.parseInt((String)statInfo.get("topics"));
	int cats = Integer.parseInt((String)statInfo.get("cats"));
	int replies = Integer.parseInt((String)statInfo.get("replies"));
	int visits = Integer.parseInt((String)statInfo.get("visits"));
	int users = Integer.parseInt((String)statInfo.get("users"));
	int postUsers = Integer.parseInt((String)statInfo.get("postUsers"));
	int userLogins = Integer.parseInt((String)statInfo.get("userLogins"));
	int credits = Integer.parseInt((String)statInfo.get("credits"));

	if (topics < 1) topics = 1;
	if (users < 1) users = 1;
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<HTML xmlns="http://www.w3.org/1999/xhtml">
<HEAD>
<TITLE>基本概况 - <%= title %></TITLE>
<%= PageUtils.getMetas(title, null) %>
<LINK href="../styles/<%= forumStyle %>/ejforum.css" type=text/css rel=stylesheet>
</HEAD>
<BODY onkeydown="if(event.keyCode==27) return false;">
<SCRIPT src="../js/common.js" type=text/javascript></SCRIPT>
<%= PageUtils.getTopInfo(request) %>
<DIV class=wrap>
<DIV id=header>
<%= PageUtils.getHeader(request, title) %>
<%= PageUtils.getHeadAdBanner(request, null) %></DIV>
<%= menus[0] %>
<DIV id=nav><A href="<%= homeUrl %>"><%= forumName %></A> &raquo;&nbsp; 
<A href="./baseinfo.jsp">论坛统计</A> &raquo;&nbsp; 基本概况</DIV>
<DIV class=container>
<DIV class=side>
<DIV>
<H2>统计选项</H2>
<UL>
  <LI class=side_on><H3><A href="baseinfo.jsp">基本概况</A> </H3></LI>
  <LI><H3><A href="flux.jsp">访问量记录</A> </H3></LI>
  <LI><H3><A href="top_boards.jsp">版块排行</A> </H3></LI>
<%
   String str_cats = (String)statInfo.get("cats");
   if (str_cats != null && Integer.parseInt(str_cats) > 0) {
%>
  <LI><H3><A href="top_cats.jsp">分类排行</A> </H3></LI>
<%
   }
%>
  <LI><H3><A href="top_topics.jsp">主题排行</A> </H3></LI>
  <LI><H3><A href="top_tags.jsp">关键字排行</A> </H3></LI>
  <LI><H3><A href="top_users.jsp">会员排行</A> </H3></LI>
  <LI><H3><A href="admins.jsp">管理团队</A> </H3></LI>
</UL></DIV></DIV>
<DIV class=content>
<DIV class=mainbox>
<H3>论坛统计</H3>
<TABLE cellSpacing=0 cellPadding=0>
  <TBODY>
  <TR>
    <TH width="22%">版块数</TH>
    <TD width="11%"><%= (String)statInfo.get("boards") %></TD>
    <TH width="22%">主题分类数</TH>
    <TD width="11%"><%= cats %></TD>
    <TH width="22%">主题数</TH>
    <TD width="11%"><%= topics %></TD>
  </TR>
  <TR>
    <TH>精华数</TH>
    <TD><%= (String)statInfo.get("digests") %></TD>
    <TH>回复数</TH>
    <TD><%= replies %></TD>
    <TH>附件数</TH>
    <TD><%= (String)statInfo.get("attaches") %></TD>
  </TR>
  <TR>
    <TH>图片主题数</TH>
    <TD><%= (String)statInfo.get("images") %></TD>
    <TH>悬赏主题数</TH>
    <TD><%= (String)statInfo.get("rewards") %></TD>
    <TH>投票主题数</TH>
    <TD><%= (String)statInfo.get("votes") %></TD>
  </TR>
  <TR>
    <TH>主题平均回复数</TH>
    <TD><%= replies/topics %></TD>
    <TH>主题平均浏览数</TH>
    <TD><%= visits/topics %></TD>
    <TH>&nbsp;</TH>
    <TD>&nbsp;</TD>
  </TR>
  </TBODY></TABLE></DIV>
<DIV class=mainbox>
<H3>会员统计</H3>
<TABLE cellSpacing=0 cellPadding=0>
  <TBODY>
  <TR>
    <TH width="22%">注册会员数</TH>
    <TD width="11%"><%= users %></TD>
    <TH width="22%">发帖会员数</TH>
    <TD width="11%"><%= postUsers %></TD>
    <TH width="22%">管理成员数</TH>
    <TD width="11%"><%= (String)statInfo.get("adminUsers") %></TD>
  </TR>
  <TR>
    <TH>每人平均登录次数</TH>
    <TD><%= userLogins/users %></TD>
    <TH>每人平均发帖数</TH>
    <TD><%= (topics + replies)/postUsers %></TD>
    <TH>每人平均积分数</TH>
    <TD><%= credits/users %></TD>
  </TR>
  <TR>
    <TH>短消息总数</TH>
    <TD><%= (String)statInfo.get("msgs") %></TD>
    <TH>收藏记录总数</TH>
    <TD><%= (String)statInfo.get("bookmarks") %></TD>
    <TH>好友记录总数</TH>
    <TD><%= (String)statInfo.get("friends") %></TD>
  </TR>
  </TBODY></TABLE></DIV>
<DIV class=mainbox>
<H1>分区统计</H1>
<TABLE cellSpacing=0 cellPadding=0>
  <THEAD>
  <TR>
    <TD>分区名称</TD>
    <TD>主题数</TD>
    <TD>回复数</TD>
    <TD>浏览数</TD>
  </TR></THEAD>
  <TBODY>
<%
	CacheManager cache = CacheManager.getInstance();
    ArrayList sections = cache.getSections();
	if (sections != null)
	{
		SectionVO aSection = null;
		StringBuilder sbuf = new StringBuilder();
		for (int i=0; i<sections.size(); i++)
		{
			aSection = (SectionVO)sections.get(i);
			sbuf.setLength(0);
			sbuf.append("../index.jsp?sid=").append(aSection.sectionID);
%>  
  <TR>
    <TD><A href="<%= sbuf.toString() %>" target=_blank><%= aSection.sectionName %></A></TD>
    <TD><%= aSection.topics %></TD>
    <TD><%= aSection.replies %></TD>
    <TD><%= aSection.visits %></TD></TR>
<%
		}
	}	
%>	
</TBODY></TABLE></DIV>  
<DIV class=remark><img src="../images/notice.gif" border="0" align="absmiddle"/>&nbsp;
统计数据每天更新一次，最新统计时间是 <%= (String)statInfo.get("statTime") %></DIV>  
</DIV></DIV></DIV>
<%= menus[1]==null?"":menus[1] %>
<%= menus[2]==null?"":menus[2] %>
<%= PageUtils.getFooter(request,forumStyle) %>
</BODY></HTML>
