/*
	[EasyJForum] (C)2007 Hongshee Soft.
	$file: post.js $
	$Date: 2007/11/30 $
*/

function checkQuickPost(theform) {
	var content = trim(theform.content.value);
	var tmpStr = trim(content.replace(/&nbsp;|<[^>]*>/ig,''));
	if(tmpStr == "") {
		alert('请填写内容栏');
		theform.content.focus();
		return;
	}
	saveData();
	theform.content.value = content;
	theform.submit();
	$('postbtn').disabled = true;
}

function loadData() 
{
	var formdata = getSessionData('data');
	if(isInArray(trim(formdata), ['', 'null', 'false', null, false]))
		return;

	var elems = formdata.split(/\x0B\x0B/);
	var obj, elem, elvalue;
	for(var i=0; i < elems.length; i++) 
	{
		elem = trim(elems[i]).split(/\x0B/);
		obj = $('postform').elements[elem[0]];
		if(typeof(obj) == 'undefined') continue;
		elvalue = typeof(elem[3])!='undefined' ? elem[3] : '';

		if(elem[1] == 'INPUT') {
			if(elem[2] == 'text') {
				obj.value = elvalue;
			} else if(elem[2] == 'checkbox' && elvalue == obj.value) {
				obj.checked = true;
			}
		} else if(elem[1] == 'TEXTAREA') {
			if(elem[0] == 'content') {
				if(typeof wysiwyg == 'undefined' || wysiwyg) {
					editdoc.body.innerHTML = elvalue;
				} else {
					textobj.value = elvalue;
				}
			} else {
				obj.value = elvalue;
			}
		} else if(elem[1] == 'SELECT') {
			obj.value = elvalue;
		}
	}
}

function saveData()
{
	var formdata = '';
	var elvalue;
	for(var i = 0; i < $('postform').elements.length; i++) {
		var el = $('postform').elements[i];
		if(el.name != '' && el.name != 'verifycode' && el.name.substr(0, 6) != 'attach'
		    && (el.tagName == 'TEXTAREA' || el.tagName == 'SELECT' || (el.tagName == 'INPUT' 
			&& (el.type == 'text' || el.type == 'checkbox'))))
		{
			if (el.name == 'content')
				elvalue = wysiwyg ? editdoc.body.innerHTML : textobj.value;
			else
				elvalue = el.value;
			elvalue = trim(elvalue);
			
			if(el.type == 'checkbox' && !el.checked)
				continue;
			formdata += el.name + String.fromCharCode(11) + el.tagName 
					 			+ String.fromCharCode(11) + el.type 
								+ String.fromCharCode(11) + elvalue + String.fromCharCode(11, 11);
		}
	}
	setSessionData('data', formdata);
}

function setSessionData(name, value)
{
	try {
		if(window.sessionStorage) {
			sessionStorage.setItem('EasyJForum_' + name, escape(value));
		} else {
			var xmlDoc = textobj.XMLDocument;
			var root = xmlDoc.firstChild;
			var node;
			if(root.childNodes.length > 0)
				node = root.firstChild;
			else
			{
				node = xmlDoc.createNode(1, 'POST', '');
				xmlDoc.documentElement.appendChild(node);
			}
			node.setAttribute(name, value);
			textobj.save('EasyJForum');
		}
	} catch(e) {}
}

function getSessionData(name) {
	var value = '';
	try {
		if(window.sessionStorage) {
			value = unescape(sessionStorage.getItem('EasyJForum_' + name));
		} else {
			textobj.load('EasyJForum');
			var oXMLDoc = textobj.XMLDocument;
			var nodes = oXMLDoc.documentElement.childNodes;
			value = nodes.item(nodes.length-1).getAttribute(name);
		}
	} catch(e) {}
	if (value == null)	return '';
	else return value.toString();
}