<%@ page contentType="text/html;charset=UTF-8" errorPage="error.jsp"%>
<%@ page import="com.hongshee.ejforum.util.PageUtils"%>
<%@ page import="com.hongshee.ejforum.common.CacheManager"%>
<%@ page import="com.hongshee.ejforum.common.ForumSetting"%>
<%@ page import="com.hongshee.ejforum.common.IConstants"%>
<%@ page import="com.hongshee.ejforum.data.UserDAO.UserInfo"%>
<%@ page import="com.hongshee.ejforum.data.GroupDAO.GroupVO"%>
<%@ page import="com.hongshee.ejforum.data.BoardDAO.BoardVO"%>
<%@ page import="com.hongshee.ejforum.data.SectionDAO.SectionVO"%>
<%
	UserInfo userinfo = PageUtils.getSessionUser(request,response);
	CacheManager cache = CacheManager.getInstance();
	
	BoardVO currentBoard = null;
	int boardID = PageUtils.getIntParam(request,"fid");
	if (boardID > 0)
	{
		currentBoard = cache.getBoard(boardID);
		if (currentBoard != null)
		{
			SectionVO aSection = cache.getSection(currentBoard.sectionID);
			String moderators = PageUtils.getModerators(aSection, currentBoard);
			GroupVO userGroup = PageUtils.getGroupVO(userinfo, moderators);
			if (!PageUtils.isPermitted(currentBoard,userGroup,userinfo,IConstants.PERMIT_VISIT_FORUM))
			{
				if (userinfo == null)  // Guest
				{
					String fromPath = request.getRequestURI();
					String queryStr = request.getQueryString();
					if (queryStr != null)
						fromPath = fromPath + "?" + queryStr;
					request.setAttribute("fromPath", fromPath);
					request.getRequestDispatcher("/login.jsp").forward(request, response);
					return;
				}
				else
				{
					request.setAttribute("errorMsg", "很抱歉，您缺乏足够的访问权限");
					request.getRequestDispatcher("/error.jsp").forward(request, response);
					return;
				}
			}
		}
	}

	String ctxPath = request.getContextPath();
	String forumName = ForumSetting.getInstance().getForumName();
	String title = PageUtils.getTitle(forumName);
	String[] menus = PageUtils.getHeaderMenu(request, userinfo);
	String homeUrl = ctxPath + "/index.jsp";
	String rootPath = PageUtils.getForumURL(request);
	String forumStyle = PageUtils.getForumStyle(request, response, null);
	String rssSub = ForumSetting.getInstance().getString(ForumSetting.FUNCTIONS, "RssSub");
	boolean isShowRss = rssSub.equals("yes");
	
	String sPrivate = "";
    GroupVO aGroup = cache.getGroup('G');
    if (aGroup.rights.indexOf(IConstants.PERMIT_VISIT_FORUM) < 0)
		sPrivate = " (&nbsp;私密&nbsp;)";
					
	int cols = 3;
	String colWidth = String.valueOf(100 / cols) + "%";
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<HTML xmlns="http://www.w3.org/1999/xhtml">
<HEAD>
<TITLE>RSS 订阅 - <%= title %></TITLE>
<%= PageUtils.getMetas(title, null) %>
<LINK href="styles/<%= forumStyle %>/ejforum.css" type=text/css rel=stylesheet>
</HEAD>
<BODY onkeydown="if(event.keyCode==27) return false;">
<SCRIPT src="js/common.js" type=text/javascript></SCRIPT>
<%= PageUtils.getTopInfo(request) %>
<DIV class=wrap>
<DIV id=header>
<%= PageUtils.getHeader(request, title) %>
<%= PageUtils.getHeadAdBanner(request, null) %>
</DIV>
<%= menus[0] %>
<DIV id=foruminfo>
<DIV id=nav><A href="<%= homeUrl %>"><%= forumName %></A> &raquo;&nbsp; RSS 订阅</DIV>
</DIV>
<DIV class=box><SPAN class=headactions>
<IMG id=tips_img onclick="toggle_collapse('tips');" src="styles/<%= forumStyle %>/images/collapsed_no.gif"></SPAN> 
<H4>订阅提示</H4>
<TABLE id=tips cellSpacing=0 cellPadding=0 class="forumlinks">
  <TBODY>
  <TR>
    <TH><a href="http://www.wisol.net.cn/wisc.jsp" style="FLOAT: right; padding-top:14px" target="_blank">
		<img src="http://www.wisol.net.cn/images/wisol_120x50.gif" alt="Wisol Reader"/></a>
	<ul style="padding-left:27px; text-align:left">
		<li><%= PageUtils.getString("feeds_tip_1") %></li>
		<li><%= PageUtils.getString("feeds_tip_2") %></li>
		<li><%= PageUtils.getString("feeds_tip_3") %></li>
		<li><%= PageUtils.getString("feeds_tip_4") %></li>
		<li><%= PageUtils.getString("feeds_tip_5") %></li>
	</ul></TH>
  </TR></TBODY></TABLE></DIV>
<%
	if (currentBoard == null) {
%>
<DIV class="mainbox forumlist">
<H3><A href="./index.jsp">论坛全局</A></H3>
<TABLE id="section_all" cellSpacing=0 cellPadding=0>
	<TBODY><TR>
    <TH width="<%= colWidth %>">
      <H2><A href="<%= homeUrl %>" id="g_all_name"><%= forumName %></A></H2>
      <P style="margin-bottom:2px">包含本论坛所有版块的&nbsp;RSS&nbsp;地址列表</P>
      <P class="moderators"><IMG src="images/opml.gif" border="0" align="absmiddle">&nbsp;
	     -&nbsp; <A href="<%= rootPath %>opml?sid=all&style=0" target=_blank>标题式</A>&nbsp;
         -&nbsp; <A href="<%= rootPath %>opml?sid=all&style=1" target=_blank id="g_all_url">全文式</A>&nbsp;
		 <% if (isShowRss) { %>-&nbsp; <A href="javascript:subGroup('g_all')">订阅</A><% } %>
	  </P></TH>
    <TH width="<%= colWidth %>">
      <H2><A href="./spec_topics.jsp?spec=new" id="c_new_name"><%= forumName %>_最新发表</A></H2>
      <P style="margin-bottom:2px">包含本论坛若干个最新发表的主题<%= sPrivate %></P>
      <P class="moderators"><IMG src="images/rss.gif" border="0" align="absmiddle">&nbsp;
	     -&nbsp; <A href="<%= rootPath %>rss?fid=new&style=0&page=1" target=_blank>标题式</A>&nbsp;
         -&nbsp; <A href="<%= rootPath %>rss?fid=new&style=1&page=1" target=_blank id="c_new_url">全文式</A>&nbsp;
		 <% if (isShowRss) { %>-&nbsp; <A href="javascript:subChannel('c_new')">订阅</A><% } %>
	  </P></TH>
    <TH width="<%= colWidth %>">
      <H2><A href="./spec_topics.jsp?spec=hot" id="c_hot_name"><%= forumName %>_最新热贴</A></H2>
      <P style="margin-bottom:2px">包含本论坛若干个最新的热门主题<%= sPrivate %></P>
      <P class="moderators"><IMG src="images/rss.gif" border="0" align="absmiddle">&nbsp;
	     -&nbsp; <A href="<%= rootPath %>rss?fid=hot&style=0&page=1" target=_blank>标题式</A>&nbsp;
         -&nbsp; <A href="<%= rootPath %>rss?fid=hot&style=1&page=1" target=_blank id="c_hot_url">全文式</A>&nbsp;
		 <% if (isShowRss) { %>-&nbsp; <A href="javascript:subChannel('c_hot')">订阅</A><% } %>
	  </P></TH>
	</TR></TBODY>
</TABLE></DIV>
<%
	}
%>
<%= PageUtils.getRSSFeeds(rootPath, currentBoard, isShowRss) %>
</DIV>
<%= menus[1]==null?"":menus[1] %>
<%= menus[2]==null?"":menus[2] %>
<%= PageUtils.getFooter(request, forumStyle) %>
</BODY></HTML>
