<%@ page contentType="text/html;charset=UTF-8"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import="com.hongshee.ejforum.util.PageUtils"%>
<%@ page import="com.hongshee.ejforum.common.ForumSetting"%>
<%@ page import="com.hongshee.ejforum.common.IConstants"%>
<%@ page import="com.hongshee.ejforum.common.CacheManager"%>
<%@ page import="com.hongshee.ejforum.data.UserDAO.UserInfo"%>
<%@ page import="com.hongshee.ejforum.data.BoardDAO"%>
<%@ page import="com.hongshee.ejforum.data.BoardDAO.BoardVO"%>
<%@ page import="com.hongshee.ejforum.data.BoardDAO.CatVO"%>
<%@ page import="com.hongshee.ejforum.data.SectionDAO.SectionVO"%>
<%@ page import="com.hongshee.ejforum.data.GroupDAO.GroupVO"%>
<%
	PageUtils.checkReferer(request); // Enhance security
	String ctxPath = request.getContextPath();
	
	UserInfo userinfo = PageUtils.getSessionUser(request,response);
    PageUtils.checkAdminIP(request);
    if (userinfo == null)
    {
		String fromPath = ctxPath + "/forum.jsp?" + request.getQueryString();
        request.setAttribute("fromPath", fromPath);
        request.getRequestDispatcher("/login.jsp").forward(request, response);
		return;
    }

	int boardID = PageUtils.getIntParam(request,"fid");

	CacheManager cache = CacheManager.getInstance();
	BoardVO aBoard = cache.getBoard(boardID);
	SectionVO aSection = cache.getSection(aBoard.sectionID);
	
	if (aBoard.isCatOK != 'T')
	{
		request.setAttribute("errorMsg", "此版块不支持主题分类");
		request.getRequestDispatcher("/error.jsp").forward(request, response);
		return;
	}

	GroupVO userGroup = PageUtils.getGroupVO(userinfo, aSection, aBoard);
	boolean isModerator = false;
	if (userGroup.groupID == 'A' || userGroup.groupID == 'M' || userGroup.groupID == 'S')
		isModerator = true;

	if (!isModerator || (userGroup.groupID != 'A' && userGroup.rights.indexOf(IConstants.PERMIT_EDIT_CATS) < 0))
	{		
		request.setAttribute("errorMsg", "缺乏操作权限");
		request.getRequestDispatcher("/error.jsp").forward(request, response);
		return;
	}

	String action = PageUtils.getParam(request,"act");
	CatVO currentCat = null;
	
	if (action.equals("add"))
	{
		String msg = BoardDAO.getInstance().addCategory(request, boardID);
		if (!msg.equals(PageUtils.OK))
		{
			request.setAttribute("errorMsg", msg);
			request.getRequestDispatcher("/error.jsp").forward(request, response);
			return;
		}
	}
	else if (action.equals("del"))
	{
		int catID = PageUtils.getIntParam(request,"cid");
		BoardDAO.getInstance().deleteCategory(request, boardID, catID);
	}
	else if (action.equals("edit"))
	{
		int catID = PageUtils.getIntParam(request,"cid");
		currentCat = aBoard.getCatVO(catID);
	}
	else if (action.equals("mod"))
	{
		BoardDAO.getInstance().modifyCategory(request, boardID);
	}
	else if (action.equals("up") || action.equals("down"))
	{
		int catID = PageUtils.getIntParam(request,"cid");
		BoardDAO.getInstance().modCategorySeqno(request, boardID, catID, action);
	}

	String actTitle = "编辑主题分类";
	
	String forumName = ForumSetting.getInstance().getForumName();
	String title = PageUtils.getTitle(forumName);
	String[] menus = PageUtils.getHeaderMenu(request, userinfo);
	
	StringBuilder sbuf = new StringBuilder();
	sbuf.append("./forum-").append(aBoard.boardID).append(".html");
	String forumUrl = sbuf.toString();
	String homeUrl = "./index.jsp";
	String forumStyle = PageUtils.getForumStyle(request, response, aBoard);
	
	sbuf.setLength(0);
	sbuf.append("category.jsp?fid=").append(boardID);
	String performUrl = sbuf.toString();

	ForumSetting setting = ForumSetting.getInstance();
	String showSectionLink = setting.getString(ForumSetting.DISPLAY, "showSectionLink");
	String sectionLink = null;
	if (showSectionLink.equalsIgnoreCase("yes"))
	{
		sbuf.setLength(0);
		sbuf.append(" &raquo;&nbsp; <A href=\"./index.jsp?sid=").append(aBoard.sectionID)
			.append("\">").append(aSection.sectionName).append("</A>");
		sectionLink = sbuf.toString();
	}
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<HTML xmlns="http://www.w3.org/1999/xhtml">
<HEAD>
<TITLE><%= actTitle %> - <%= aBoard.plainName %> - <%= title %></TITLE>
<LINK href="styles/<%= forumStyle %>/ejforum.css" type=text/css rel=stylesheet>
</HEAD>
<BODY onkeydown="if(event.keyCode==27) return false;">
<SCRIPT src="js/common.js" type=text/javascript></SCRIPT>
<%= PageUtils.getTopInfo(request) %>
<DIV class=wrap>
<DIV id=header>
<%= PageUtils.getHeader(request, title) %>
</DIV>
<%= menus[0] %>
<DIV id=nav><A href="<%= homeUrl %>"><%= forumName %></A><%= sectionLink==null?"":sectionLink %> &raquo;&nbsp; 
<A href="<%= forumUrl %>"><%= aBoard.boardName %></A> &raquo;&nbsp; <%= actTitle %></DIV>
<form method="post" action="<%= performUrl %>" id="postform" name="postform" onsubmit="return false;">
	<div class="mainbox">
	<h1><%= actTitle %></h1>
	<table cellspacing="0" cellpadding="0">
	<thead>
		<tr>
			<td align="center" width="75">分类编号</td>
			<td width="190">分类名称</td>
			<td align="center" width="75">主题数</td>
			<td>操作</td>
		</tr>
	</thead>
<%
	if (currentCat != null) {
%>
		<tr>
			<td align="center"><%= currentCat.catID %>
				<input type="hidden" name="catID" id="catID" value="<%= currentCat.catID %>"/></td>
			<td><input type="text" name="catName" id="catName" size="30" maxlength="30" value="<%= currentCat.catName %>"/></td>
			<td align="center"><%= currentCat.topics %></td>
			<td>[&nbsp;<a href="javascript:doManage('mod','',0);">修改</a>&nbsp;]</td>
		</tr>
<%
	} else if (aBoard.catList != null) {
		CatVO aCat = null;
		for (int i=0; i<aBoard.catList.size(); i++) {
			aCat = (CatVO)aBoard.catList.get(i);
%>	
		<tr>
			<td align="center"><%= aCat.catID %></td>
			<td><%= aCat.catName %></td>
			<td align="center"><%= aCat.topics %></td>
			<td>[&nbsp;<a href="javascript:doManage('edit','<%= aCat.catID %>',0);">修改</a>&nbsp;] 
				[&nbsp;<a href="javascript:doManage('del','<%= aCat.catID %>',<%= aCat.topics %>);">删除</a>&nbsp;] 
			    [&nbsp;<a href="javascript:doManage('up','<%= aCat.catID %>',0);">上移</a>&nbsp;] 
				[&nbsp;<a href="javascript:doManage('down','<%= aCat.catID %>',0);">下移</a>&nbsp;]</td>
		</tr>
<%		
		}
	}
	if (currentCat == null) {
%>
		<tr>
			<td align="center"><input type="text" name="catID" id="catID" size="3" maxlength="3"/></td>
			<td><input type="text" name="catName" id="catName" size="30" maxlength="30"/></td>
			<td>&nbsp;</td>
			<td>[&nbsp;<a href="javascript:doManage('add','',0);">添加</a>&nbsp;]&nbsp;&nbsp;&nbsp;&nbsp;
				--- &nbsp;&nbsp;&nbsp;分类编号应为正整数，且同一版块下的编号不能重复，建议从"1"开始依序递增</td>
		</tr>	
<%
	}
%>
	</table>
	</div>
</form>
<script type="text/javascript">
	var performUrl = "<%= performUrl %>";
	function doManage(action, catID, count)
	{
		var theform = document.postform;
		if (action == "add")
		{
			if (trim(theform.catID.value) == "")
			{
    			alert('请输入分类编号');
      			theform.catID.focus();
				return;
			}
			if (trim(theform.catName.value) == "")
			{
    			alert('请输入分类名称');
      			theform.catName.focus();
				return;
			}
		    var filter = /^[1-9][0-9]*$/;
		    if (!filter.test(trim(theform.catID.value))) {
    			alert('分类编号必须为正整数');
      			theform.catID.focus();
				return;
			}
		}
		else if (action == "del")
		{
			if (confirm("您确定要删除此分类吗？"))
			{
				if (count > 0)
				{
					if (confirm('此分类下的主题将会失去其分类属性，继续吗？'))
						location = performUrl + "&act=del&cid=" + catID;
				}
				else
					location = performUrl + "&act=del&cid=" + catID;
			}
			return;
		}
		else if (action == "up" || action == "down" || action == "edit")
		{
			location = performUrl + "&act=" + action + "&cid=" + catID;
			return;
		}
		else if (action == "mod")
		{
			if (trim(theform.catName.value) == "")
			{
    			alert('请输入分类名称');
      			theform.catName.focus();
				return;
			}
		}
		theform.action = performUrl + "&act=" + action;
		theform.submit();
	}
</script>
</DIV>
<%= menus[1]==null?"":menus[1] %>
<%= menus[2]==null?"":menus[2] %>
<%= PageUtils.getFooter(request, forumStyle) %>
</BODY></HTML>