DROP TABLE IF EXISTS ejf_tags;
DROP TABLE IF EXISTS ejf_backup_task;
DROP TABLE IF EXISTS ejf_error_log;
DROP TABLE IF EXISTS ejf_admin_log;
DROP TABLE IF EXISTS ejf_credits_log;
DROP TABLE IF EXISTS ejf_censor_log;
DROP TABLE IF EXISTS ejf_report_log;
DROP TABLE IF EXISTS ejf_moderator_log;

DROP TABLE IF EXISTS ejf_feed_stat;
DROP TABLE IF EXISTS ejf_visit_stat;
DROP TABLE IF EXISTS ejf_friend;
DROP TABLE IF EXISTS ejf_bookmark;
DROP TABLE IF EXISTS ejf_short_msg;
DROP TABLE IF EXISTS ejf_trash_box;

DROP TABLE IF EXISTS ejf_attach;
DROP TABLE IF EXISTS ejf_reply;
DROP TABLE IF EXISTS ejf_vote;
DROP TABLE IF EXISTS ejf_voting;
DROP TABLE IF EXISTS ejf_topic;
DROP TABLE IF EXISTS ejf_board;
DROP TABLE IF EXISTS ejf_section;
DROP TABLE IF EXISTS ejf_deposit;
DROP TABLE IF EXISTS ejf_user;
DROP TABLE IF EXISTS ejf_group;

DROP TABLE IF EXISTS ejf_archive_reply;
DROP TABLE IF EXISTS ejf_archive_topic;

SET IGNORECASE TRUE;

-- **********************************************************
-- * ejf_group table
-- * GroupType: M - Member Group, S - System
-- * GroupID: 1-9 - Member User, M - Moderator, 
-- *            S - Super Moderator, A - Admin, G - Guest
-- **********************************************************

CREATE TABLE ejf_group(
    groupID         CHAR(1)         NOT NULL,
    groupName       VARCHAR(15)     NOT NULL,
    groupType       CHAR(1)         DEFAULT 'M',
    minCredits      INT             DEFAULT 0,
    stars           INT             DEFAULT 1,
    rights          VARCHAR(50)     NOT NULL,
    createTime      DATETIME,
    updateTime      TIMESTAMP,
    PRIMARY KEY(groupID));

-- **********************************************************
-- * ejf_user table
-- * State: N - Normal, P - Seal Posting, S - Sealed,
-- *        A - Auditing
-- * GroupID: Admin group ID
-- **********************************************************

CREATE CACHED TABLE ejf_user(
    userID          VARCHAR(15)     NOT NULL,
    nickname        VARCHAR(15)     ,
    pwd             VARCHAR(32)     NOT NULL,
    email           VARCHAR(40)     NOT NULL,
    icq             VARCHAR(40)     ,
    webpage         VARCHAR(60)     ,
    avatar          VARCHAR(50)     ,
    gender          CHAR(1)         DEFAULT 'U',
    birth           VARCHAR(10)     ,
    city            VARCHAR(20)     ,
    remoteIP        VARCHAR(25)     ,
    brief           VARCHAR(200)    ,
    isMailPub       CHAR(1)         DEFAULT 'F',
    posts           INT             DEFAULT 0,
    unreadSMs       INT             DEFAULT 0,
    credits         INT             DEFAULT 0,
    groupID         CHAR(1)         DEFAULT '1',
    lastVisited     DATETIME,
    visitCount		INT				DEFAULT 1,
    loginCount		TINYINT			DEFAULT 0,
    loginExpire		DATETIME, 
    setpwdExpire	DATETIME, 
    state           CHAR(1)         DEFAULT 'N',
    createTime      DATETIME,
    updateTime      TIMESTAMP,
    PRIMARY KEY(userID),
    UNIQUE(email));

-- ************************************************
-- * ejf_deposit table
-- ************************************************

CREATE TABLE ejf_deposit(
    userID          VARCHAR(15)     NOT NULL,
    createTime      DATETIME 		NOT NULL,
    deposit         INT             DEFAULT 0);

-- ************************************************
-- * ejf_section table
-- * caton: T - Top, R - Right
-- * ruleon: T - Top, B - Bottom
-- * imageMode: P - Picture, S - Slide
-- * State: N - Normal
-- ************************************************

CREATE TABLE ejf_section(
    sectionID       INT             GENERATED BY DEFAULT AS IDENTITY(START WITH 1),
    sectionName     VARCHAR(20)     NOT NULL,
    seqno           INT             DEFAULT 1,
    cols            INT             DEFAULT 1,
    moderator       VARCHAR(60)     ,
    filter          VARCHAR(10)     ,
    caton           CHAR(1)         DEFAULT 'T',
    ruleon          CHAR(1)         DEFAULT 'T',
    logo			VARCHAR(100)    ,
    showHotlinks	VARCHAR(10)     ,
    hotlinkRows     TINYINT         DEFAULT 8,
    isOnBoard       CHAR(1)         DEFAULT 'F',
    imageMode       CHAR(1)         DEFAULT 'P',
    imageFile		VARCHAR(255)    ,
    imageLink		VARCHAR(255)    ,
    imageTitle		VARCHAR(255)    ,
    headAdCode      LONGVARCHAR     ,
    footAdCode      LONGVARCHAR     ,
    state           CHAR(1)         DEFAULT 'N',
    createTime      DATETIME,
    updateTime      TIMESTAMP,
    PRIMARY KEY(sectionID));

-- ************************************************
-- * ejf_board table
-- * ScoreType: N - No score, P - Public, M - Member
-- * State: N - Normal, I - Invisible
-- ************************************************

CREATE TABLE ejf_board(
    boardID         INT             GENERATED BY DEFAULT AS IDENTITY(START WITH 1),
    sectionID       INT             NOT NULL,
    boardName       VARCHAR(20)     NOT NULL,
    highColor     	VARCHAR(6)      ,
    seqno           INT             DEFAULT 1,
    brief           VARCHAR(100)    ,
    iconFile		VARCHAR(100)    ,
    keywords        VARCHAR(100)    ,
    moderator       VARCHAR(60)     ,
    viewStyle       VARCHAR(20)     ,
    sortField       VARCHAR(20)     ,
    isImageOK       CHAR(1)         DEFAULT 'T',
    isMediaOK       CHAR(1)         DEFAULT 'F',
    isGuestPostOK   CHAR(1)         DEFAULT 'F',
    allowGroups     VARCHAR(20)     ,
    acl			    VARCHAR(100)    ,
    isCatOK   		CHAR(1)         DEFAULT 'F',
    listType	    VARCHAR(10)     ,
    cats		    VARCHAR(255)    ,
    scoreType       CHAR(1)         DEFAULT 'N',
	ruleCode      	LONGVARCHAR		,
    headAdCode      LONGVARCHAR     ,
    footAdCode      LONGVARCHAR     ,
    topicAdCode     LONGVARCHAR	    , 
    members      	LONGVARCHAR		,
    state           CHAR(1)         DEFAULT 'N',
    createTime      DATETIME,
    updateTime      TIMESTAMP,
    PRIMARY KEY(boardID),
    FOREIGN KEY(sectionID)
        REFERENCES ejf_section(sectionID));

-- *********************************************************
-- * ejf_topic table
-- * State: N - Normal, C - Closed, R - Recycled
-- * TopScope: 1 - Global, 2 - Section, 3 - Board, N - None
-- * AttachIcon: I - Image, F - Flash, A - Attach
-- * SpecType: N - Normal, V - Vote
-- * IsReplyNotice: F - False, T - Mail, S - SMS, B - Both
-- *********************************************************

CREATE CACHED TABLE ejf_topic(
    topicID         INT             GENERATED BY DEFAULT AS IDENTITY(START WITH 1),
    boardID         INT             NOT NULL,
    sectionID       INT             DEFAULT 0,
    catID	        TINYINT		    DEFAULT 0,
    userID          VARCHAR(15)     NOT NULL,
    nickname        VARCHAR(15)     ,
    remoteIP        VARCHAR(25)     ,
    title           VARCHAR(100)    NOT NULL,
    content         LONGVARCHAR     ,
    reward          SMALLINT        DEFAULT 0,
    visits          INT             DEFAULT 0,
    replies         INT             DEFAULT 0,
    diggups         INT             DEFAULT 0,
    diggdns         INT             DEFAULT 0,
    attaches	    TINYINT         DEFAULT 0,
    attachIcon      VARCHAR(5)      ,
    lastPostUser    VARCHAR(15)     NOT NULL,
    lastNickname    VARCHAR(15)     ,
    lastPostTime    DATETIME        ,
    isDigest        CHAR(1)         DEFAULT 'F',
    isReplyNotice   CHAR(1)         DEFAULT 'F',
    isHidePost      CHAR(1)         DEFAULT 'F',
    isSolved	    CHAR(1)         DEFAULT 'F',
    specType        CHAR(1)         DEFAULT 'N',
    topScope        CHAR(1)         DEFAULT 'N',
    topExpireDate   DATETIME        ,
    highColor     	VARCHAR(8)      ,
    highExpireDate 	DATETIME        ,
    state           CHAR(1)         DEFAULT 'N',
    createTime      DATETIME 		,		
    updateTime      TIMESTAMP		,		
    updateUser      VARCHAR(15)     ,
    PRIMARY KEY(topicID),
    FOREIGN KEY(boardID)
        REFERENCES ejf_board(boardID));

CREATE INDEX ejf_topic_list ON ejf_topic (boardID,sectionID,state,topScope,catID);

SELECT * INTO CACHED ejf_archive_topic FROM ejf_topic;

-- ************************************************
-- * ejf_vote table
-- ************************************************

CREATE CACHED TABLE ejf_vote(
    topicID         INT             NOT NULL,
    options    		LONGVARCHAR		NOT NULL,
    voters 	        LONGVARCHAR     ,
    isPublic		CHAR(1) 		DEFAULT 'T',
    isSingle		CHAR(1) 		DEFAULT 'T',
	expireDate		DATETIME		,
    FOREIGN KEY(topicID)
        REFERENCES ejf_topic(topicID) ON DELETE CASCADE);

-- ************************************************
-- * ejf_voting table
-- ************************************************

CREATE CACHED TABLE ejf_voting(
    topicID         INT             NOT NULL,
    optID			INT    			NOT NULL,
    optCount		INT    			DEFAULT 0,
    updateTime      TIMESTAMP,
    FOREIGN KEY(topicID)
        REFERENCES ejf_topic(topicID) ON DELETE CASCADE);

-- ************************************************
-- * ejf_reply table
-- * State: N - Normal, R - Recycled
-- ************************************************

CREATE CACHED TABLE ejf_reply(
    replyID         INT             GENERATED BY DEFAULT AS IDENTITY(START WITH 1),
    topicID         INT             NOT NULL,
    userID          VARCHAR(15)     NOT NULL,
    remoteIP        VARCHAR(25)     ,
    title           VARCHAR(100)    ,
    content         LONGVARCHAR     NOT NULL,
    attaches	    TINYINT         DEFAULT 0,
    isHidePost      CHAR(1)         DEFAULT 'F',
    isBest		    CHAR(1)         DEFAULT 'F',
    state           CHAR(1)         DEFAULT 'N',
    createTime      DATETIME,
    updateTime      TIMESTAMP,
    PRIMARY KEY(replyID),
    FOREIGN KEY(topicID)
        REFERENCES ejf_topic(topicID) ON DELETE CASCADE);

SELECT * INTO CACHED ejf_archive_reply FROM ejf_reply;

-- *******************************************************
-- * ejf_attach table
-- * State: N - Normal, I - Image, F - Flash, R - Recycled
-- *******************************************************

CREATE CACHED TABLE ejf_attach(
    attachID        INT             GENERATED BY DEFAULT AS IDENTITY(START WITH 1),
    topicID         INT             NOT NULL,
    replyID         INT             DEFAULT 0,
    userID          VARCHAR(15)     NOT NULL,
    localname	    VARCHAR(50)    	NOT NULL,
    localID        	SMALLINT    	DEFAULT 0,
    filename        VARCHAR(50)    	NOT NULL,
    filesize        INT             DEFAULT 0,
    credits         INT             DEFAULT 0,
    title        	VARCHAR(50)     ,
    downloads       INT             DEFAULT 0,
    state           CHAR(1)         DEFAULT 'N',
    createTime      DATETIME,
    updateTime      TIMESTAMP,
    PRIMARY KEY(attachID),
    FOREIGN KEY(topicID)
        REFERENCES ejf_topic(topicID) ON DELETE CASCADE);

-- ************************************************
-- * ejf_trash_box table
-- ************************************************

CREATE CACHED TABLE ejf_trash_box(
    topicID         INT             NOT NULL,
    replyID         INT             DEFAULT 0,
    boardID         INT             NOT NULL,
    boardName       VARCHAR(20)     NOT NULL,
    topicTitle      VARCHAR(100)    NOT NULL,
    userID          VARCHAR(15)     NOT NULL,
    deleteUser      VARCHAR(15)     NOT NULL,
    createTime      DATETIME,
    PRIMARY KEY(topicID,replyID));

-- ************************************************
-- * ejf_short_msg table
-- * Outflag: N - Normal, D - Deleted
-- * State: N - New, R - Read, D - Deleted
-- ************************************************

CREATE CACHED TABLE ejf_short_msg(
    msgID           INT             GENERATED BY DEFAULT AS IDENTITY(START WITH 1),
    title	        VARCHAR(100)    NOT NULL,
    message         VARCHAR(200)    ,
    userID          VARCHAR(15)     NOT NULL,
    fromUser        VARCHAR(15)     NOT NULL,
    outflag         CHAR(1)         DEFAULT 'N',
    state           CHAR(1)         DEFAULT 'N',
    createTime      DATETIME,
    updateTime      TIMESTAMP,
    PRIMARY KEY(msgID),
    FOREIGN KEY(userID)
        REFERENCES ejf_user(userID) ON DELETE CASCADE);

-- ************************************************
-- * ejf_bookmark table
-- ************************************************

CREATE CACHED TABLE ejf_bookmark(
    markID          INT             GENERATED BY DEFAULT AS IDENTITY(START WITH 1),
    userID          VARCHAR(15)     NOT NULL,
    url         	VARCHAR(100)    NOT NULL,
    title         	VARCHAR(100)    NOT NULL,
    boardName      	VARCHAR(20)     ,
    createTime      DATETIME,
    PRIMARY KEY(markID),
    FOREIGN KEY(userID)
        REFERENCES ejf_user(userID) ON DELETE CASCADE);

-- ************************************************
-- * ejf_friend table
-- ************************************************

CREATE CACHED TABLE ejf_friend(
    userID          VARCHAR(15)     NOT NULL,
    friendID        VARCHAR(15)     NOT NULL,
    remark          VARCHAR(50)     ,
    createTime      DATETIME,
    PRIMARY KEY(userID,friendID),
    FOREIGN KEY(userID)
        REFERENCES ejf_user(userID) ON DELETE CASCADE);

-- ************************************************
-- * ejf_visit_stat table
-- ************************************************

CREATE CACHED TABLE ejf_visit_stat (
    statDate      	VARCHAR(10)		NOT NULL,
    topics          INT             DEFAULT 0,
    replies         INT             DEFAULT 0,
    users          	INT             DEFAULT 0,
    visits          INT             DEFAULT 0,
    PRIMARY KEY(statDate));

-- ************************************************
-- * ejf_feed_stat table
-- ************************************************

CREATE TABLE ejf_feed_stat (
    boardID      	VARCHAR(10)		NOT NULL,
    visits          INT             DEFAULT 1,
    createTime      DATETIME,
    PRIMARY KEY(boardID));

-- ************************************************
-- * ejf_moderator_log table
-- ************************************************

CREATE CACHED TABLE ejf_moderator_log (
    logID           INT             GENERATED BY DEFAULT AS IDENTITY(START WITH 1),
    userID          VARCHAR(15)     NOT NULL,
    groupName       VARCHAR(15)     NOT NULL,
    remoteIP        VARCHAR(25)     ,
    boardID         INT             NOT NULL,
    boardName       VARCHAR(20)     NOT NULL,
    topicID         INT             NOT NULL,
    topicTitle      VARCHAR(100)    NOT NULL,
    replyID         INT             DEFAULT 0,
    action          VARCHAR(10)     NOT NULL,
    reason          VARCHAR(40)     NOT NULL,
    createTime      DATETIME,
    PRIMARY KEY(logID));

-- ************************************************
-- * ejf_report_log table
-- ************************************************

CREATE CACHED TABLE ejf_report_log (
    logID           INT             GENERATED BY DEFAULT AS IDENTITY(START WITH 1),
    userID          VARCHAR(15)     ,
    reportedUser    VARCHAR(15)     ,
    boardID         INT             NOT NULL,
    boardName       VARCHAR(20)     NOT NULL,
    topicID        	INT             NOT NULL,
    topicTitle     	VARCHAR(100)    NOT NULL,
    replyID         INT             DEFAULT 0,
    reason          VARCHAR(40)     NOT NULL,
    createTime      DATETIME,
    PRIMARY KEY(logID));

-- ************************************************
-- * ejf_censor_log table
-- ************************************************

CREATE CACHED TABLE ejf_censor_log (
    logID           INT             GENERATED BY DEFAULT AS IDENTITY(START WITH 1),
    userID          VARCHAR(15)     ,
    boardID         INT             NOT NULL,
    boardName       VARCHAR(20)     NOT NULL,
    topicID        	INT             NOT NULL,
    topicTitle     	VARCHAR(100)    NOT NULL,
    replyID         INT             DEFAULT 0,
    reason          VARCHAR(40)     NOT NULL,
    createTime      DATETIME,
    PRIMARY KEY(logID));

-- ************************************************
-- * ejf_credits_log table
-- ************************************************

CREATE CACHED TABLE ejf_credits_log (
    logID           INT             GENERATED BY DEFAULT AS IDENTITY(START WITH 1),
    userID          VARCHAR(15)     NOT NULL,
    fromUser        VARCHAR(15)     ,
    credits         SMALLINT	    DEFAULT 0,
    action          VARCHAR(10)     NOT NULL,
    createTime      DATETIME,
    PRIMARY KEY(logID));

-- ************************************************
-- * ejf_admin_log table
-- ************************************************

CREATE CACHED TABLE ejf_admin_log (
    logID           INT             GENERATED BY DEFAULT AS IDENTITY(START WITH 1),
    userID          VARCHAR(15)     NOT NULL,
    groupName       VARCHAR(15)     NOT NULL,
    remoteIP        VARCHAR(25)     ,
    action          VARCHAR(10)     NOT NULL,
    remark          VARCHAR(40)     ,
    createTime      DATETIME,
    PRIMARY KEY(logID));

-- ************************************************
-- * ejf_error_log table
-- ************************************************

CREATE CACHED TABLE ejf_error_log (
    logID           INT             GENERATED BY DEFAULT AS IDENTITY(START WITH 1),
    userID          VARCHAR(15)     NOT NULL,
    remoteIP        VARCHAR(25)     ,
    action          VARCHAR(10)     NOT NULL,
    errorInfo       VARCHAR(100)    ,
    createTime      DATETIME,
    PRIMARY KEY(logID));

-- ************************************************
-- * ejf_backup_task table
-- * runAt: N - Now, D - Daily, W - Weekly
-- * runMode: A - All, I - Increasely
-- ************************************************

CREATE CACHED TABLE ejf_backup_task (
    taskID	        INT             GENERATED BY DEFAULT AS IDENTITY(START WITH 1),
    inputFile       VARCHAR(255)    NOT NULL,
    outputFile      VARCHAR(255)    NOT NULL,
    runAt	        CHAR(1)     	DEFAULT 'N',
    sendmail        CHAR(1)     	DEFAULT 'T',
    runMode	        CHAR(1)     	DEFAULT 'A',
    isOnlyFile      CHAR(1)     	DEFAULT 'T',
    runStamp		VARCHAR(20)		,
    remark		    VARCHAR(50)     ,
    createTime      DATETIME,
    PRIMARY KEY(taskID));

-- ***************************************************
-- * ejf_tags table, at most 1000 records
-- * State: N - Not Existed, E - Existed
-- ***************************************************

CREATE CACHED TABLE ejf_tags (
    tagname         VARCHAR(20)     NOT NULL,
    queryCount    	INT	    DEFAULT 1,
    recordCount    	INT	    DEFAULT 0,
    createTime      DATETIME,
    updateTime      TIMESTAMP,
    PRIMARY KEY (tagname));


SET WRITE_DELAY 100 MILLIS;

-- ************************************************
-- *  
-- * Insert init data into tables
-- *  
-- ************************************************

--
-- Groups
--
INSERT INTO ejf_group(groupID,groupName,groupType,minCredits,stars,rights,createTime)
               VALUES('A', 'Ա', 'S', 0, 9, 'ABCDEFGWXHIJKLMNOPQRSTUVY', NOW());
INSERT INTO ejf_group(groupID,groupName,groupType,minCredits,stars,rights,createTime)  
               VALUES('S', '', 'S', 0, 8, 'ABCDEFGWXHIJKLMNOQRSTY', NOW());
INSERT INTO ejf_group(groupID,groupName,groupType,minCredits,stars,rights,createTime) 
               VALUES('M', '', 'S', 0, 7, 'ABCDEFGWXHJKLMNOQRST', NOW());
INSERT INTO ejf_group(groupID,groupName,groupType,minCredits,stars,rights,createTime) 
               VALUES('G', 'ο', 'S', 0, 0, 'ABCJ', NOW());
INSERT INTO ejf_group(groupID,groupName,groupType,minCredits,stars,rights,createTime) 
               VALUES('1', 'ؤ', 'M', -999999, 0, 'ACG', NOW());
INSERT INTO ejf_group(groupID,groupName,groupType,minCredits,stars,rights,createTime) 
               VALUES('2', 'ƶ', 'M', -50, 1, 'ACFG', NOW());
INSERT INTO ejf_group(groupID,groupName,groupType,minCredits,stars,rights,createTime) 
               VALUES('3', '·', 'M', 0, 1, 'ABCEFGJK', NOW());
INSERT INTO ejf_group(groupID,groupName,groupType,minCredits,stars,rights,createTime) 
               VALUES('4', 'Ա', 'M', 50, 2, 'ABCEFGWXJK', NOW());
INSERT INTO ejf_group(groupID,groupName,groupType,minCredits,stars,rights,createTime) 
               VALUES('5', 'мԱ', 'M', 500, 3, 'ABCEFGWXHJK', NOW());
INSERT INTO ejf_group(groupID,groupName,groupType,minCredits,stars,rights,createTime) 
               VALUES('6', '߼Ա', 'M', 1500, 4, 'ABCDEFGWXHJK', NOW());
INSERT INTO ejf_group(groupID,groupName,groupType,minCredits,stars,rights,createTime) 
               VALUES('7', '̳Ԫ', 'M', 3000, 5, 'ABCDEFGWXHJKT', NOW());

--
-- Sections & Boards
--
INSERT INTO ejf_section(sectionName,seqno,createTime) VALUES ('ĬϷ', 1, NOW());
INSERT INTO ejf_board(sectionID,boardName,seqno,brief,allowGroups,acl,createTime) VALUES(IDENTITY(), 'Ĭϰ', 1, '', 'AMSG1234567','', NOW());
INSERT INTO ejf_section(sectionName,seqno,createTime) VALUES ('վ', 2, NOW());
INSERT INTO ejf_board(sectionID,boardName,seqno,brief,allowGroups,acl,createTime) VALUES(IDENTITY(), '̳', 1, '̳淢⣬뽱;', 'AMSG1234567', 'F_AMS', NOW());
INSERT INTO ejf_board(sectionID,boardName,seqno,brief,allowGroups,acl,createTime) VALUES(IDENTITY(), 'վ', 2, '鷢ϵͳBUG', 'AMSG1234567', '', NOW());
