<%@ page contentType="text/html;charset=UTF-8" errorPage="../error.jsp"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import="java.util.HashMap"%>
<%@ page import="com.hongshee.ejforum.util.PageUtils"%>
<%@ page import="com.hongshee.ejforum.common.ForumSetting"%>
<%@ page import="com.hongshee.ejforum.common.IConstants"%>
<%@ page import="com.hongshee.ejforum.common.CacheManager"%>
<%@ page import="com.hongshee.ejforum.data.GroupDAO.GroupVO"%>
<%@ page import="com.hongshee.ejforum.data.UserDAO.UserInfo"%>
<%@ page import="com.hongshee.ejforum.data.StatDAO"%>
<%@ page import="com.hongshee.ejforum.data.SectionDAO.SectionVO"%>
<%
	UserInfo userinfo = PageUtils.getSessionUser(request,response);
    GroupVO aGroup = PageUtils.getGroupVO(userinfo);
	if (aGroup.rights.indexOf(IConstants.PERMIT_VIEW_STAT) < 0)
	{
		request.setAttribute("errorMsg", "您没有查看统计数据的权限");
		request.getRequestDispatcher("/error.jsp").forward(request, response);
		return;
	}	
	String forumName = ForumSetting.getInstance().getForumName();
	String title = PageUtils.getTitle(forumName);
	String[] menus = PageUtils.getHeaderMenu(request, userinfo);
	String homeUrl = "../index.jsp";
	String forumStyle = PageUtils.getForumStyle(request, response, null);
	int sectionID = PageUtils.getIntParam(request,"sid");
	CacheManager cache = CacheManager.getInstance();
	
	String strPageNo = request.getParameter("page");
	int pageNo = PageUtils.getPageNo(strPageNo);
	int pageRows = 15;
	
	Object[] result = null;
	if (pageNo == 1)
		result = StatDAO.getInstance().getTopTopicsInfo(sectionID, pageNo, pageRows, false);
	else	
		result = StatDAO.getInstance().getTopTopicsInfo(sectionID, pageNo, pageRows, true);
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<HTML xmlns="http://www.w3.org/1999/xhtml">
<HEAD>
<TITLE>主题排行 - <%= title %></TITLE>
<%= PageUtils.getMetas(title, null) %>
<LINK href="../styles/<%= forumStyle %>/ejforum.css" type=text/css rel=stylesheet>
</HEAD>
<BODY onkeydown="if(event.keyCode==27) return false;">
<SCRIPT src="../js/common.js" type=text/javascript></SCRIPT>
<%= PageUtils.getTopInfo(request) %>
<DIV class=wrap>
<DIV id=header>
<%= PageUtils.getHeader(request, title) %>
<%= PageUtils.getHeadAdBanner(request, null) %></DIV>
<%= menus[0] %>
<DIV id=nav><A href="<%= homeUrl %>"><%= forumName %></A> &raquo;&nbsp; 
<A href="./baseinfo.jsp">论坛统计</A> &raquo;&nbsp; 主题排行 </DIV>
<DIV class=container>
<DIV class=side>
<DIV>
<H2>统计选项</H2>
<UL>
  <LI><H3><A href="baseinfo.jsp">基本概况</A> </H3></LI>
  <LI><H3><A href="flux.jsp">访问量记录</A> </H3></LI>
  <LI><H3><A href="top_boards.jsp">版块排行</A> </H3></LI>
<%
   HashMap statMap = StatDAO.getInstance().getBaseStatInfo();
   String cats = (String)statMap.get("cats");
   if (cats != null && Integer.parseInt(cats) > 0) {
%>
  <LI><H3><A href="top_cats.jsp">分类排行</A> </H3></LI>
<%
   }
%>
  <LI class=side_on><H3><A href="top_topics.jsp">主题排行</A> </H3></LI>
  <LI><H3><A href="top_tags.jsp">关键字排行</A> </H3></LI>
  <LI><H3><A href="top_users.jsp">会员排行</A> </H3></LI>
  <LI><H3><A href="admins.jsp">管理团队</A> </H3></LI>
</UL></DIV></DIV>
<DIV class=content>
<%
	if (result != null && result[1] != null && result[2] != null)
	{
		ArrayList topVisitsTopics = (ArrayList)result[1];
		ArrayList topRepliesTopics = (ArrayList)result[2];
		ArrayList topDiggsTopics = (ArrayList)result[3];
		String colWidth = "44%";
		if (topDiggsTopics != null && topDiggsTopics.size() > 0)
			colWidth = "27%";
%>
<DIV class=mainbox>
<H1>最近30天主题排行</H1>
<TABLE cellSpacing=0 cellPadding=0>
  <THEAD>
  <TR>
    <TD width="<%= colWidth %>">浏览排行榜</TD>
    <TD width="6%"></TD>
    <TD width="<%= colWidth %>">回复排行榜</TD>
    <TD width="6%"></TD>
<%  	if (topDiggsTopics != null && topDiggsTopics.size() > 0) {  %>
    <TD width="<%= colWidth %>">评价排行榜</TD>
    <TD width="6%"></TD>
<% 		} 	   %>
	</TR></THEAD>
  <TBODY>
<%	
		StringBuilder sbuf = new StringBuilder();
		HashMap record = null;
	
		for (int i=0; i<topVisitsTopics.size(); i++)
		{
			record = (HashMap)topVisitsTopics.get(i);
			sbuf.setLength(0);
			sbuf.append("../topic-").append((String)record.get("TOPICID")).append(".html");
%>  
  <TR>
    <TD><A href="<%= sbuf.toString() %>" target="_blank"><%= (String)record.get("TITLE") %></A></TD>
    <TD><%= (String)record.get("VISITS") %></TD>
<%
			record = (HashMap)topRepliesTopics.get(i);
			sbuf.setLength(0);
			sbuf.append("../topic-").append((String)record.get("TOPICID")).append(".html");
%>	
    <TD><A href="<%= sbuf.toString() %>" target="_blank"><%= (String)record.get("TITLE") %></A></TD>
    <TD><%= (String)record.get("REPLIES") %></TD>
<%
		  	if (topDiggsTopics != null && topDiggsTopics.size() > 0) {
				if (topDiggsTopics.size() > i) {
					record = (HashMap)topDiggsTopics.get(i);
					sbuf.setLength(0);
					sbuf.append("../topic-").append((String)record.get("TOPICID")).append(".html");
%>	
    <TD><A href="<%= sbuf.toString() %>" target="_blank"><%= (String)record.get("TITLE") %></A></TD>
    <TD><%= (String)record.get("DIGGS") %></TD>
<%
				}else{
%>				
    <TD>&nbsp;</TD>
    <TD>&nbsp;</TD>
<%	
				}
			}
			out.write("</TR>");
		}
%>
</TBODY></TABLE></DIV>
<%
	}
	ArrayList topVisitsTopics = (ArrayList)result[4];
	ArrayList topRepliesTopics = (ArrayList)result[5];
	ArrayList topDiggsTopics = (ArrayList)result[6];
	String colWidth = "44%";
	if (topDiggsTopics != null && topDiggsTopics.size() > 0)
		colWidth = "27%";
%>	
<DIV class=mainbox>
<H1>全部主题排行</H1>
<TABLE cellSpacing=0 cellPadding=0>
  <THEAD>
  <TR>
    <TD width="<%= colWidth %>">被浏览最多的主题</TD>
    <TD width="6%"></TD>
    <TD width="<%= colWidth %>">被回复最多的主题</TD>
    <TD width="6%"></TD>
<% 	if (topDiggsTopics != null && topDiggsTopics.size() > 0) {  %>
    <TD width="<%= colWidth %>">评价排行榜</TD>
    <TD width="6%"></TD>
<%	}  %>
	</TR></THEAD>
  <TBODY>
<%
	if (result != null && topRepliesTopics != null && topRepliesTopics != null)
	{
		StringBuilder sbuf = new StringBuilder();
		HashMap record = null;
	
		for (int i=0; i<topVisitsTopics.size(); i++)
		{
			record = (HashMap)topVisitsTopics.get(i);
			sbuf.setLength(0);
			sbuf.append("../topic-").append((String)record.get("TOPICID")).append(".html");
%>  
  <TR>
    <TD><A href="<%= sbuf.toString() %>" target="_blank"><%= (String)record.get("TITLE") %></A></TD>
    <TD><%= (String)record.get("VISITS") %></TD>
<%
			record = (HashMap)topRepliesTopics.get(i);
			sbuf.setLength(0);
			sbuf.append("../topic-").append((String)record.get("TOPICID")).append(".html");
%>	
    <TD><A href="<%= sbuf.toString() %>" target="_blank"><%= (String)record.get("TITLE") %></A></TD>
    <TD><%= (String)record.get("REPLIES") %></TD>
<%
		  	if (topDiggsTopics != null && topDiggsTopics.size() > 0) {
				if (topDiggsTopics.size() > i) {
					record = (HashMap)topDiggsTopics.get(i);
					sbuf.setLength(0);
					sbuf.append("../topic-").append((String)record.get("TOPICID")).append(".html");
%>	
    <TD><A href="<%= sbuf.toString() %>" target="_blank"><%= (String)record.get("TITLE") %></A></TD>
    <TD><%= (String)record.get("DIGGS") %></TD>
<%
				}else{
%>				
    <TD>&nbsp;</TD>
    <TD>&nbsp;</TD>
<%	
				}
			}
			out.write("</TR>");
		}
	}	
%>
</TBODY></TABLE></DIV>
<DIV class=pages_btns>
<%
	if (result != null && result[0] != null) {
%>	  
	<%= result[0] %>
<SCRIPT type=text/javascript>
var myUrl = "./top_topics.jsp?sid=<%= sectionID %>";
function viewPage(pageno)
{
	window.location = myUrl + "&page=" + pageno;
}
</SCRIPT>
<%
	}
%>
</DIV>
<DIV class=legend id=footfilter><DIV class=jump_sort>&nbsp;
<SELECT onchange="if(this.options[this.selectedIndex].value != ''){window.location = this.options[this.selectedIndex].value;}">
<OPTION value="top_topics.jsp?sid=0"<% if (sectionID == 0) out.write(" selected"); %>>请选择分区 ...</OPTION>
<OPTION value="top_topics.jsp?sid=999"<% if (sectionID == 999) out.write(" selected"); %>>&nbsp;&gt; 全部分区</OPTION>
<%
    ArrayList sections = cache.getSections();
	if (sections != null)
	{
		SectionVO tmpSection = null;
		StringBuilder sb = new StringBuilder();
		for (int i=0; i<sections.size(); i++)	
		{
			tmpSection = (SectionVO)sections.get(i);
			sb.append("<OPTION value=\"top_topics.jsp?sid=").append(tmpSection.sectionID).append("\"");
			if (sectionID == tmpSection.sectionID)
				sb.append(" selected");
			sb.append(">&nbsp;&gt; ")
			  .append(tmpSection.sectionName).append("</OPTION>\n");
		}
		out.write(sb.toString());
	}
%>
</SELECT></DIV></DIV>
</DIV></DIV></DIV>
<%= menus[1]==null?"":menus[1] %>
<%= menus[2]==null?"":menus[2] %>
<%= PageUtils.getFooter(request,forumStyle) %>
</BODY></HTML>
