<%@ page contentType="text/html;charset=UTF-8" errorPage="error.jsp"%>
<%@ page import="java.util.ArrayList,java.util.Date"%>
<%@ page import="com.hongshee.ejforum.util.PageUtils"%>
<%@ page import="com.hongshee.ejforum.util.AppUtils"%>
<%@ page import="com.hongshee.ejforum.common.ForumSetting"%>
<%@ page import="com.hongshee.ejforum.common.IConstants"%>
<%@ page import="com.hongshee.ejforum.common.CacheManager"%>
<%@ page import="com.hongshee.ejforum.data.UserDAO.UserInfo"%>
<%@ page import="com.hongshee.ejforum.data.BoardDAO.BoardVO"%>
<%@ page import="com.hongshee.ejforum.data.BoardDAO.CatVO"%>
<%@ page import="com.hongshee.ejforum.data.SectionDAO.SectionVO"%>
<%@ page import="com.hongshee.ejforum.data.TopicDAO"%>
<%@ page import="com.hongshee.ejforum.data.TopicDAO.TopicInfo"%>
<%@ page import="com.hongshee.ejforum.data.GroupDAO.GroupVO"%>
<%
	UserInfo userinfo = PageUtils.getSessionUser(request,response);
	int boardID = PageUtils.getIntParam(request,"fid");

	CacheManager cache = CacheManager.getInstance();
	BoardVO aBoard = cache.getBoard(boardID);
	if (aBoard == null)
	{
		request.setAttribute("errorMsg", "很抱歉，没有找到您所要访问的版块");
		request.getRequestDispatcher("/error.jsp").forward(request, response);
		return;
	}	

	int sectionID = aBoard.sectionID;
	SectionVO aSection = cache.getSection(sectionID);
	
	String moderators = PageUtils.getModerators(aSection, aBoard);
	String moderatorLink = PageUtils.getModeratorLink(moderators);
	
	GroupVO userGroup = PageUtils.getGroupVO(userinfo, moderators);
	if (!PageUtils.isPermitted(aBoard,userGroup,userinfo,IConstants.PERMIT_VISIT_FORUM))
	{
		if (userinfo == null)  // Guest
		{
			String fromPath = request.getRequestURI();
			String queryStr = request.getQueryString();
			if (queryStr != null)
				fromPath = fromPath + "?" + queryStr;
			request.setAttribute("fromPath", fromPath);
			request.getRequestDispatcher("/login.jsp").forward(request, response);
			return;
		}
		else
		{
			request.setAttribute("errorMsg", "很抱歉，您缺乏足够的访问权限");
			request.getRequestDispatcher("/error.jsp").forward(request, response);
			return;
		}
	}

	boolean isModerator = false;
	if (userGroup.groupID == 'A' || userGroup.groupID == 'M' || userGroup.groupID == 'S')
		isModerator = true;

	if (aBoard.state == 'I' && !isModerator)
	{
		request.setAttribute("errorMsg", "很抱歉，此版块已经关闭");
		request.getRequestDispatcher("/error.jsp").forward(request, response);
		return;
	}

	String ctxPath = request.getContextPath();
	String serverName = request.getServerName();
	if (ctxPath.length()>1)
		serverName = serverName + ctxPath;

	ForumSetting setting = ForumSetting.getInstance();
	
	String strPageNo = request.getParameter("page");
	int pageNo = PageUtils.getPageNo(strPageNo);
	int pageRows = setting.topicsPerPage;

	StringBuilder sbuf = new StringBuilder("./post.jsp?fid=");
	sbuf.append(boardID);
	
	CatVO currentCat = null;
	int catID = -1;
	if (aBoard.isCatOK == 'T')
	{
        String value = request.getParameter("cid");
        if (value != null && value.trim().length() > 0)
		{
			catID = Integer.parseInt(value);
			if (catID > 0)
			{
				sbuf.append("&cid=").append(catID);
				currentCat = aBoard.getCatVO(catID);
			}
			else if (catID == 0)
			{
				currentCat = aBoard.unCat;
			}
		}
	}
	String postUrl = response.encodeURL(sbuf.toString());

	sbuf.setLength(0);
	sbuf.append("./forum.jsp?fid=").append(boardID);
	
	if (catID >= 0)
		sbuf.append("&cid=").append(catID);

	String spec = request.getParameter("spec");
	if (spec == null || spec.length() == 0)
	{
		if (aBoard.isCatOK == 'T')
			spec = aBoard.listType;
		if (spec == null || spec.length() == 0)
			spec = "all";
		else	
			sbuf.append("&spec=").append(spec);
	}
	else
		sbuf.append("&spec=").append(spec);
			
	String forumName = setting.getForumName();
	String title = PageUtils.getTitle(forumName);
	String[] menus = PageUtils.getHeaderMenu(request, userinfo);

	String sortField = request.getParameter("sort");
	if (sortField == null || sortField.length() == 0)
	{
		sortField = aBoard.sortField;
		if (sortField == null || sortField.length() == 0)
			sortField = PageUtils.SORT_FIELD;
	}
	else
		sbuf.append("&sort=").append(sortField);

	String baseUrl = response.encodeURL(sbuf.toString());

	sbuf.setLength(0);
	sbuf.append("./forum-").append(boardID).append(".html");
	String forumUrl = response.encodeURL(sbuf.toString());
	String homeUrl = response.encodeURL("./index.jsp");
	String forumStyle = PageUtils.getForumStyle(request, response, aBoard);

	sbuf.setLength(0);
	sbuf.append("./rss?fid=").append(boardID);
	if (catID >= 0)
		sbuf.append("&cid=").append(catID);
		
	String feedUrl = null;
	if (setting.RssStyle.equals("B"))
		feedUrl = sbuf.append("&style=0&page=1").toString();
	else	
		feedUrl = sbuf.append("&style=1&page=1").toString();

    ArrayList sections = cache.getSections();
	
	String sectionLink = null;
	if (setting.showSectionLink.equalsIgnoreCase("yes"))
	{
		sbuf.setLength(0);
		sbuf.append(" &raquo;&nbsp; <A href=\"./index.jsp?sid=").append(sectionID)
			.append("\">").append(aSection.sectionName).append("</A>");
		sectionLink = response.encodeURL(sbuf.toString());
	}
	String jumpMode = setting.jumpMode;

	Object[] result = TopicDAO.getInstance().getTopicList(aBoard, currentCat, sortField, spec, baseUrl, pageNo, pageRows);
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<HTML xmlns="http://www.w3.org/1999/xhtml">
<HEAD>
<TITLE><% if(currentCat!=null){ out.write(currentCat.catName); out.write(" - "); } %><%= aBoard.plainName %> - <%= title %></TITLE>
<%= PageUtils.getMetas(title, aBoard) %>
<%= PageUtils.getRSSLink(request, forumName, aSection, aBoard, currentCat) %>
<LINK href="styles/<%= forumStyle %>/ejforum.css" type=text/css rel=stylesheet>
</HEAD>
<BODY onkeydown="if(event.keyCode==27) return false;">
<SCRIPT src="js/common.js" type=text/javascript></SCRIPT>
<SCRIPT src="js/ajax.js" type=text/javascript></SCRIPT>
<%= PageUtils.getTopInfo(request) %>
<DIV class=wrap>
<DIV id=header>
<%= PageUtils.getHeader(request, aSection, title) %>
<%= PageUtils.getHeadAdBanner(request, aSection, aBoard) %>
</DIV>
<%= menus[0] %>
<DIV id=foruminfo>
<DIV id=nav>
<P><A href="<%= homeUrl %>"><%= forumName %></A><% if (sectionLink!=null) out.write(sectionLink); %> &raquo;&nbsp; 
<%= aBoard.boardName %></P>
<P>版主: <%= moderatorLink==null?"空缺中":moderatorLink %></P></DIV>
<DIV id=headsearch>
<FORM id="frmsearch" name="frmsearch" 
	  action="http://www.google.com.hk/search" onsubmit="doSearch(); return false;" method=get target="google_window">
<INPUT type=hidden value="<%= serverName %>" name=sitesearch> 
<div onclick="javascript:window.open('http://www.google.com.hk/')" 
 style="cursor:pointer;float:left;width:70px;height:23px;background: url(images/google.png)! important;background: none; filter: 
 progid:DXImageTransform.Microsoft.AlphaImageLoader(src='images/google.png',sizingMethod='scale')"></div>&nbsp;
<INPUT maxLength=255 size=12 name=q class="search"><INPUT type=hidden value="UTF-8" name=ie><INPUT type=hidden value="UTF-8" name=oe><INPUT type=hidden value=zh-CN name=hl>&nbsp;
<a href="#" onclick="doSearch(); return false;" style="vertical-align:middle">
<img src="styles/<%= forumStyle %>/images/search.gif" border="0" alt="站内搜索" align="absbottom"/></a>
</FORM></DIV></DIV>
<DIV id=ad_text></DIV>
<%
	if (aSection.isOnBoard == 'T')
	{
		int hotCols = 0;
		String showHotlinks = aSection.showHotlinks;
		if (showHotlinks != null && showHotlinks.length() >= 3)
			hotCols = showHotlinks.length();
		if (hotCols >= 3) {
			String colWidth = String.valueOf(100/hotCols) + "%";
%>
<DIV class="mainbox forumlist" style="padding-top:0px">
<TABLE cellSpacing=0 cellPadding=0>
  <THEAD class=category>
  <TR>
	  <% if (showHotlinks.indexOf('I') >= 0){ %><TD style="padding-bottom: 1px" 
	  			align=center>≡&nbsp;最新图片&nbsp;≡</TD><% } %>
	  <% if (showHotlinks.indexOf('N') >= 0){ %><TD style="padding-bottom: 1px" 
	  			align=center>≡&nbsp;最新发表&nbsp;≡</TD><% } %>
	  <% if (showHotlinks.indexOf('H') >= 0){ %><TD style="padding-bottom: 1px" 
	  			align=center>≡&nbsp;热门主题&nbsp;≡</TD><% } %>
	  <% if (showHotlinks.indexOf('R') >= 0){ %><TD style="padding-bottom: 1px" 
	  			align=center>≡&nbsp;人气主题&nbsp;≡</TD><% } %>
	  <% if (showHotlinks.indexOf('D') >= 0){ %><TD style="padding-bottom: 1px" 
	  			align=center>≡&nbsp;最新精华&nbsp;≡</TD><% } %>
	  <% if (showHotlinks.indexOf('C') >= 0){ %><TD style="padding-bottom: 1px" 
	  			align=center>≡&nbsp;热门分类&nbsp;≡</TD><% } %>
  </TR></THEAD>
  <TBODY>
  <TR>
<% 		
		int rows = aSection.hotlinkRows;
		if (showHotlinks.indexOf('I') >= 0)
		{
			out.write("<TD align=center width='");out.write(colWidth);out.write("' style='padding-left:5px;padding-top:2px'>\n");
			char imageMode = aSection.imageMode;
			String imageFile = aSection.imageFile;
            int width = 310;
            int height = 205 + (rows-10)*20;
			if (hotCols > 3) width = 245;
			
			if (imageMode == 'P')
			{
    	        StringBuilder tagBuf = new StringBuilder();
				if (imageFile.toLowerCase().indexOf(".swf") > 0)
				{
					String[] width_height = imageFile.split(",");
	                width = PageUtils.getIntValue(width_height, 1, width);
    	            height = PageUtils.getIntValue(width_height, 2, height);

        	        tagBuf.append("<script type=text/javascript>showFlash('")
            	          .append(width_height[0]).append("','").append(width).append("','")
                	      .append(height).append("');</script>");
				}
				else
				{
					String imageLink = aSection.imageLink;
					String imageTitle = aSection.imageTitle;
					imageTitle = AppUtils.replaceStr(imageTitle,"\"", "&quot;");
					if (imageLink.length() > 0)
						tagBuf.append("<a href=\"").append(imageLink).append("\" target=\"_blank\">");
        	        tagBuf.append("<img src=\"").append(imageFile).append("\" alt=\"").append(imageTitle)
						  .append("\" width=\"").append(width).append("\" height=\"").append(height)
            	          .append("\" border=\"0\">");
					if (imageLink.length() > 0)
						tagBuf.append("</a>");
				}
				out.write(tagBuf.toString());
			}
			else
			{
				String imageLink = aSection.imageLink;
				String imageTitle = aSection.imageTitle;
				imageTitle = AppUtils.replaceStr(imageTitle,"\"", "&quot;");
%>
<SCRIPT type=text/javascript>
// config 参数设置 -- 自动播放时间(秒)|文字颜色|文字背景色|文字背景透明度|按键数字颜色|当前按键颜色|普通按键色彩 --
var config='3|0xffffff|0x0099ff|50|0xffffff|0x0099ff|0x666666';
var files='<%= imageFile %>';
var links='<%= imageLink %>';
var texts="<%= imageTitle %>";
showSlide('<%= ctxPath %>/images/focus.swf',"<%= width %>","<%= height %>");
</SCRIPT>
<%
			}
			out.write("</TD>\n");
		} 
		if (showHotlinks.indexOf('N') >= 0){	
			out.write("<TD valign=top width='");out.write(colWidth);out.write("' style='MARGIN:1px'>\n");
			out.write(cache.getRecentTopics(aSection,rows));
			out.write("</TD>\n");
		} 
		if (showHotlinks.indexOf('H') >= 0){
			out.write("<TD valign=top width='");out.write(colWidth);out.write("' style='MARGIN:1px'>\n");
			out.write(cache.getHotTopics(aSection,rows));
			out.write("</TD>\n");
		} 
		if (showHotlinks.indexOf('R') >= 0){
			out.write("<TD valign=top width='");out.write(colWidth);out.write("' style='MARGIN:1px'>\n");
			out.write(cache.getRankTopics(aSection,rows));
			out.write("</TD>\n");
		} 
		if (showHotlinks.indexOf('D') >= 0){ 	
			out.write("<TD valign=top width='");out.write(colWidth);out.write("' style='MARGIN:1px'>\n");
			out.write(cache.getDigestTopics(aSection,rows));
			out.write("</TD>\n");
		}  	  
		if (showHotlinks.indexOf('C') >= 0){ 	
			out.write("<TD valign=top width='");out.write(colWidth);out.write("' style='MARGIN:1px'>\n");
			if (cache.isNewHotCats())
				cache.setHotCatSeps(new String[]{"","&nbsp;-&nbsp;","","《","》"});
			out.write(cache.getHotCats(aSection,rows));
			out.write("</TD>\n");
		}
%>
  </TR></TBODY></TABLE></DIV>
<%
	}}
	if (aSection.ruleon == 'T' && aBoard.ruleCode != null && aBoard.ruleCode.length() > 0) {
%>
<DIV class="mainbox forumlist" style="padding-top:0px">
<TABLE cellSpacing=0 cellPadding=0>
  <TBODY class="info">
  <TR><TD class="subject">本版规则</TD></TR>
  <TR><TD><%= aBoard.ruleCode %></TD></TR>
  </TBODY></TABLE></DIV>
<%
	}
	if (aSection.caton == 'T' && aBoard.isCatOK == 'T' && aBoard.catList != null && aBoard.catList.size() > 0) {
%>
<DIV class="mainbox" style="margin-bottom:11px">
	<H3>主题分类</H3>
<TABLE id="catlist" cellSpacing=0 cellPadding=0>
<TBODY><TR>
    <TH align="left" valign="top" class="cats">
<%
		CatVO aCat = null;
		for (int i=0; i<aBoard.catList.size(); i++) {
			aCat = (CatVO)aBoard.catList.get(i);
			if (aCat.catID != catID) {
%>	
		<A href="./forum-<%= boardID %>.html?cid=<%= aCat.catID %>">
<%
			}
%>		
	<b><%= aCat.catName %></b>&nbsp;(<%= aCat.topics %>)<% if(aCat.catID!=catID) out.write("</A>"); %>&nbsp;&nbsp;|&nbsp;
<%
		}
		if (catID != 0) {
%>
      <A href="./forum-<%= boardID %>.html?cid=0">
<%
		}
%>		
	  <b>其它</b>&nbsp;(<%= aBoard.unCat.topics %>)<% if(catID!=0) out.write("</A>"); %>&nbsp;
    </TH>
</TR></TBODY>
</TABLE></DIV>
<%
	}
%>  
<DIV class=pages_btns>
<%
	if (result != null && result[0] != null)
	{
%>	  
	<%= result[0] %>
<%
	}
%>
<SPAN class=postbtn id="newtopic" onmouseover="$('newtopic').id = 'newtopictmp';this.id = 'newtopic';showMenu(this.id);">
<A href="<%= postUrl %>"><IMG alt=发新话题 
src="styles/<%= forumStyle %>/images/newtopic.gif" border=0></A></SPAN>
</DIV>
<UL class="popmenu_popup newtopicmenu" id="newtopic_menu" style="display: none">
<LI><a href="<%= postUrl %>">发新话题</a></LI>		
<LI class="vote"><a href="<%= postUrl %>&act=vote">发布投票</a></LI>
<LI class="reward"><a href="<%= postUrl %>&act=reward">发布悬赏</a></LI>
</UL>
<DIV id=headfilter>
<UL class=tabs>
  <LI<% if(spec.equals("all") && currentCat == null) out.write(" class=spec"); %>><A href="<%= forumUrl %>">全部</A></LI>
<% if (aSection.filter == null || aSection.filter.indexOf('H')>=0) { %>  
  <LI<% if(spec.equals("hot")) out.write(" class=spec"); %>><A 
  		href="forum.jsp?fid=<%= boardID %>&spec=hot">热门</A></LI>
<% } %>
  <LI<% if(spec.equals("digest")) out.write(" class=spec"); %>><A 
  		href="forum.jsp?fid=<%= boardID %>&spec=digest">精华</A></LI>
<% if (aSection.filter == null || aSection.filter.indexOf('I')>=0) { %>
  <LI<% if(spec.equals("pic")) out.write(" class=spec"); %>><A 
  		href="forum.jsp?fid=<%= boardID %>&spec=pic">图片</A></LI>
<% }
   if (aSection.filter == null || aSection.filter.indexOf('V')>=0) { %>
  <LI<% if(spec.equals("vote")) out.write(" class=spec"); %>><A 
  		href="forum.jsp?fid=<%= boardID %>&spec=vote">投票</A></LI>
<% }
   if (aSection.filter == null || aSection.filter.indexOf('R')>=0) { %>
  <LI<% if(spec.equals("reward")) out.write(" class=spec"); %>><A 
  		href="forum.jsp?fid=<%= boardID %>&spec=reward">悬赏</A></LI>
<% } %>
  <LI style="border:none"><A title="RSS Feed" href="<%= feedUrl %>" target=_blank>
  	  <IMG alt="RSS Feed" src="images/rss.gif" border="0"></A></LI>
</UL>
</DIV>
<DIV class="mainbox topiclist">
<%
	if (aSection.caton == 'R' && aBoard.isCatOK == 'T' && aBoard.catList != null && aBoard.catList.size() > 0) {
%>
<SPAN class=headactions>
<%
		CatVO aCat = null;
		for (int i=0; i<aBoard.catList.size(); i++) {
			if (i>=10) break;
			aCat = (CatVO)aBoard.catList.get(i);
			if (aCat.catID != catID) {
%>	
		<A class=notabs href="./forum-<%= boardID %>.html?cid=<%= aCat.catID %>">
<%
			}
%>		
	<em><b><%= aCat.catName %></b>&nbsp;(<%= aCat.topics %>)</em><% if(aCat.catID!=catID) out.write("</A>"); %>&nbsp;&nbsp;|&nbsp;
<%
		}
		if (catID != 0) {
%>
      <A class=notabs href="./forum-<%= boardID %>.html?cid=0">
<%
		}
%>		
	  <em><b>其它</b>&nbsp;(<%= aBoard.unCat.topics %>)</em><% if(catID!=0) out.write("</A>"); %></SPAN>
<%
	}
%>
<H1><A href="<%= forumUrl %>"><%= aBoard.boardName %></A>&nbsp;</H1>
<%
	if (isModerator) {
		sbuf.setLength(0);
		sbuf.append("manage.jsp?fid=").append(boardID)
			.append("&page=").append(pageNo);
		if(catID > 0)
			sbuf.append("&cid=").append(catID);
%>
<FORM name="frmmanage" action="<%= response.encodeURL(sbuf.toString()) %>" method=post>
<%
	}
%>
<TABLE cellSpacing=0 cellPadding=0>
  <THEAD class=category>
  <TR>
    <TD>&nbsp;</TD>
    <TD>主题</TD>
    <TD class=author>作者</TD>
<% if (aBoard.scoreType != 'N') { %>
    <TD class=nums style='width:90px'>回复&nbsp;/&nbsp;查看&nbsp;/&nbsp;评价</TD>
<% }else{ %>
    <TD class=nums>回复&nbsp;/&nbsp;查看</TD>
<% } %>
    <TD class=lastpost>最后发表</TD></TR></THEAD>
<%
	if (result != null && result[1] != null)
	{
		ArrayList topicList = (ArrayList)result[1];

		TopicInfo aTopic = null;
		String topicUrl = null;
		String topicTitle = null;
		String lastPostUrl = null;
		boolean hasTopTopics = false;
		String userID = null;
		String nickname = null;
		String lastNickname = null;
		String topicIcon = null;
		int hotTopicPosts = setting.hotTopicPosts;
		int hotTopicVisits = setting.hotTopicVisits;
		String spaceURL = response.encodeURL("uspace.jsp?uid=");
		CatVO aCat = null;
		int lastCatID = 0;
		
		for (int i=0; i<topicList.size(); i++)
		{
			aTopic = (TopicInfo)topicList.get(i);
			if (aTopic.topScope == 'N' && hasTopTopics) {
				hasTopTopics = false;
%>			
</TABLE>
<TABLE cellSpacing=0 cellPadding=0>
  <THEAD class=separation>
  <TR>
    <TD>&nbsp;</TD>
    <TD colSpan=4>版块主题</TD></TR></THEAD>
<%
			}
			sbuf.setLength(0);
			sbuf.append("./topic-").append(aTopic.topicID).append(".html");
			topicUrl = response.encodeURL(sbuf.toString());
			lastPostUrl = response.encodeURL(sbuf.toString() + "?page=999");
			
			topicTitle = aTopic.title;
			if (aTopic.topScope == 'N' || aTopic.topScope == '3')
			{
				if (aTopic.catID > 0 && aBoard.isCatOK == 'T')
				{
					if (aTopic.catID != lastCatID)
					{
						aCat = aBoard.getCatVO(aTopic.catID);
						lastCatID = aTopic.catID;
					}
					if (aCat != null)
					{
						sbuf.setLength(0);
						topicTitle = sbuf.append("<EM>[").append(aCat.catName).append("]</EM>&nbsp;")
						 				   .append(aTopic.title).toString();
					}
				}
			}
			
			if (aTopic.isHidePost == 'T')
			{
				userID = "";
				nickname = "匿名";
			}
			else
			{
				userID = aTopic.userID;	
				nickname = (aTopic.nickname==null || aTopic.nickname.length()==0) ? userID : aTopic.nickname;
			}
			lastNickname = 
				(aTopic.lastNickname==null || aTopic.lastNickname.length()==0) ? aTopic.lastPostUser : aTopic.lastNickname;

			if (aTopic.state == 'C')
				topicIcon = "folder_lock.gif";
			else if (aTopic.replies >= hotTopicPosts 
						|| aTopic.visits + aTopic.diggs * setting.diggsVsVisits >= hotTopicVisits)
				topicIcon = "folder_hot.gif";
			else
				topicIcon = "folder_common.gif";
%>	
  <TBODY>
  <TR>
    <TD class=folder><A title=新窗口打开 href='<%= topicUrl %>' target=_blank><IMG src="images/<%= topicIcon %>"></A></TD>
    <TD>
<%
			if (aTopic.isDigest == 'T') {
%>	
		<LABEL><IMG alt="精华" src="images/digest.gif" align="absmiddle">&nbsp;</LABEL>
<%
			}
			if (aTopic.topScope != 'N')
			{
				hasTopTopics = true;
%>	
		<LABEL><IMG alt="<%= aTopic.topScope=='1'?"全局置顶":(aTopic.topScope=='2'?"分区置顶":"本版置顶") %>" 
				src="images/top_<%= aTopic.topScope %>.gif" align="absmiddle">&nbsp;</LABEL> 
<%
			}
			if (isModerator) {
%>
		<input class="checkbox" type="checkbox" name="chkTopicID" value="<%= aTopic.topicID %>"/>
<%
			}
			String highColor = null;
			if (aTopic.highColor != null && aTopic.highColor.length() > 0)
			{
				if (aTopic.highColor.startsWith("B_"))
					highColor = " style=\"color:" + aTopic.highColor.substring(2) + ";font-weight:bold\"";
				else	
					highColor = " style=\"color:" + aTopic.highColor + "\"";
			}
%>		
		<A href='<%= topicUrl %>'<% if(highColor!=null) out.write(highColor); %> class="headline"><%= topicTitle %></A> 
<%
			if (aTopic.attachIcon != null) {
			 	if (aTopic.attachIcon.indexOf('I') >= 0) {
					out.write("<LABEL class=\"pic\">(&nbsp;图&nbsp;)&nbsp;</LABEL>");
				}
			 	else if (aTopic.attachIcon.indexOf('F') >= 0) {
					out.write("<LABEL class=\"pic\">(&nbsp;媒&nbsp;)&nbsp;</LABEL>");
				}
				if (aTopic.attachIcon.indexOf('A') >= 0) {
					out.write("<LABEL class=\"attach\">&nbsp;</LABEL>");
				}
			}
			if (aTopic.reward > 0) {
				out.write("<LABEL class=\"reward\">&nbsp;[&nbsp;积分&nbsp;"); 
				out.write(String.valueOf(aTopic.reward));  out.write("&nbsp;");
				if (aTopic.isSolved == 'T')
					out.write("&nbsp;已解决&nbsp;");
				out.write("]</LABEL>");
			}
			if (aTopic.specType == 'V') {
				out.write("<LABEL class=\"poll\">&nbsp;</LABEL>");
			}
%>		
		</TD>
    <TD class=author><CITE><A href="<%= spaceURL %><%= userID %>"><%= nickname.length()==0?"游客":nickname %></A> 
      </CITE><EM><%= aTopic.createTime %></EM></TD>
<% if (aBoard.scoreType != 'N') { %>
    <TD class=nums style='width:90px'>
		<SPAN><%= aTopic.replies %></SPAN> / <EM><%= aTopic.visits %></EM> / <SPAN><%= aTopic.diggs %></SPAN></TD>
<% }else{ %>
    <TD class=nums><SPAN><%= aTopic.replies %></SPAN> / <EM><%= aTopic.visits %></EM></TD>
<% } %>
    <TD class=lastpost><EM><A href="<%= lastPostUrl %>"><%= aTopic.lastPostTime %></A></EM>
		<CITE>by <A href="<%= spaceURL %><%= aTopic.lastPostUser %>"><%= lastNickname.length()==0?"游客":lastNickname %></A>
		</CITE>
    </TD></TR></TBODY>
<%
		}
	} 
	else 
	{
%>
	<tbody><tr><td class=folder>&nbsp;</td><td colspan="4">本版块或指定的范围内尚无主题。</td></tr></tbody>
<%
	}
%>	
</TABLE>
<%
	if (isModerator) {
%>
<div class="management">
	<input type="hidden" name="act"/>
	<label><input class="checkbox" type="checkbox" name="chkall" onclick="checkall(this.form, 'chkTopicID')"/> 全选</label>
	<% if (userGroup.rights.indexOf(IConstants.PERMIT_DELETE_POST) >= 0) { %>
		<button onclick="doManage('delete');return false;">删除主题</button>&nbsp;
	<% }
	   if (userGroup.rights.indexOf(IConstants.PERMIT_MOVE_POST) >= 0) { %>
		<button onclick="doManage('move');return false;">移动主题</button>&nbsp;
	<% } %>	
	<button onclick="doManage('highlight');return false;">高亮显示</button>&nbsp;
	<% if (userGroup.rights.indexOf(IConstants.PERMIT_CLOSE_POST) >= 0) { %>
		<button onclick="doManage('close');return false;">关闭/打开主题</button>&nbsp;
	<% } %>
	<button onclick="doManage('top');return false;">置顶/解除置顶</button>&nbsp;
	<button onclick="doManage('digest');return false;">加入/解除精华</button>&nbsp;
	<% if (aBoard.isCatOK == 'T') { %>
		<button onclick="doManage('cats');return false;">编辑主题分类</button>
	<% } %>
<script type="text/javascript">
	function doManage(action) 
	{
		var theform = document.frmmanage;
		if (action == "cats")
		{
			location = theform.action.replace("manage.jsp","category.jsp");
			return false;
		}
		var hasCheckedID = false;
		if (typeof(theform.chkTopicID) != "undefined")
		{
			if (typeof(theform.chkTopicID.length) != "undefined")
			{
				for (i=0; i<theform.chkTopicID.length; i++){
					if (theform.chkTopicID[i].checked){
						hasCheckedID = true;
						break;
					}
				}
			}
			else if (theform.chkTopicID.checked)
				hasCheckedID = true;
		}
		if (!hasCheckedID){
			alert("请至少选中一个主题");
			return false;
		}
		theform.act.value = action;
		theform.submit();
	}
</script>
</div>
</FORM>
<%
	}
%>
</DIV>
<DIV class=pages_btns>
<%
	if (result != null && result[0] != null)
	{
%>	  
	<%= result[0] %>
<%
	}
%>
<SPAN class=postbtn id="newtopictmp" onmouseover="$('newtopic').id = 'newtopictmp';this.id = 'newtopic';showMenu(this.id);">
<A href="<%= postUrl %>"><IMG alt=发新话题 src="styles/<%= forumStyle %>/images/newtopic.gif"></A></SPAN></DIV>
<%
	if (aSection.ruleon == 'B' && aBoard.ruleCode != null && aBoard.ruleCode.length() > 0) {
%>
<DIV class="mainbox forumlist" style="padding-top:0px">
<TABLE cellSpacing=0 cellPadding=0>
  <TBODY class="info">
  <TR><TD class="subject">本版规则</TD></TR>
  <TR><TD><%= aBoard.ruleCode %></TD></TR>
  </TBODY></TABLE></DIV>
<%
	}
%>
<DIV class=legend id=footfilter><DIV class=jump_sort><form id="frmsort" name="frmsort" 
action="<%= forumUrl %><% if(catID>=0){ out.write("?cid="); out.write(String.valueOf(catID)); } %>" method="post">
<SELECT onchange="if(this.options[this.selectedIndex].value != ''){window.location = this.options[this.selectedIndex].value;}">
<OPTION value="" selected>版块跳转 ...</OPTION> 
<%
	if (sections != null)
	{
		SectionVO tmpSection = null;
		BoardVO tmpBoard = null;
		String tmpUrl = null;
		StringBuilder sb = new StringBuilder();
		
		for (int i=0; i<sections.size(); i++)	
		{
			tmpSection = (SectionVO)sections.get(i);
			if (tmpSection.boardList == null) continue;
			if (!jumpMode.equals("all") && tmpSection.sectionID != aSection.sectionID) continue;
			
			sb.append("<OPTGROUP label=\"").append(tmpSection.sectionName).append("\">\n");
			
			for (int j=0; j<tmpSection.boardList.size(); j++)
			{
				tmpBoard = (BoardVO)tmpSection.boardList.get(j);
				if (tmpBoard.state == 'I' && !isModerator) continue;
				sbuf.setLength(0);
				sbuf.append("./forum-").append(tmpBoard.boardID).append(".html");
				tmpUrl = response.encodeURL(sbuf.toString());
				sb.append("<OPTION value=\"").append(tmpUrl).append("\">&nbsp; &gt; ")
				  .append(tmpBoard.boardName).append("</OPTION>\n");
			}
			sb.append("</OPTGROUP>");
		}
		out.write(sb.toString());
	}
%>
</SELECT>&nbsp;
<SELECT name="sort" id="sortfield" onchange="$('frmsort').submit();"> 
<OPTION value="lastPostTime" selected>按回复时间排序</OPTION> 
<OPTION value="createTime">按发布时间排序</OPTION>
<OPTION value="replies">按回复数量排序</OPTION>
<OPTION value="visits">按浏览次数排序</OPTION>
<% if (aBoard.scoreType != 'N') { %>
<OPTION value="diggs">按评价得分排序</OPTION>
<% } %>
<OPTION value="A_lastPostTime">按回复时间排序(升序)</OPTION>
<OPTION value="A_createTime">按发布时间排序(升序)</OPTION></SELECT>
<INPUT type=hidden value="<%= spec %>" name="spec"></form></DIV>
<DIV><LABEL><IMG alt=正常主题 
src="images/folder_common.gif">正常主题</LABEL> <LABEL><IMG alt=热门主题 
src="images/folder_hot.gif">热门主题</LABEL> <LABEL><IMG alt=关闭主题 
src="images/folder_lock.gif">关闭主题</LABEL> </DIV>
</DIV>
<SCRIPT type=text/javascript>
$('sortfield').value = "<%= sortField %>";
</SCRIPT>
</DIV>
<% if(menus[1]!=null) out.write(menus[1]); %>
<% if(menus[2]!=null) out.write(menus[2]); %>
<%= PageUtils.getFootAdBanner(request, aSection, aBoard) %>
<%= PageUtils.getFooter(request, forumStyle) %>
</BODY></HTML>
