/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp.datasources;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.apache.tomcat.dbcp.dbcp.SQLNestedException;
import org.apache.tomcat.dbcp.dbcp.datasources.InstanceKeyObjectFactory;
import org.apache.tomcat.dbcp.dbcp.datasources.PooledConnectionAndInfo;

public abstract class InstanceKeyDataSource
implements DataSource,
Referenceable,
Serializable {
    private static final String GET_CONNECTION_CALLED = "A Connection was already requested from this source, further initialization is not allowed.";
    private static final String BAD_TRANSACTION_ISOLATION = "The requested TransactionIsolation level is invalid.";
    protected static final int UNKNOWN_TRANSACTIONISOLATION = -1;
    private boolean getConnectionCalled = false;
    private ConnectionPoolDataSource cpds = null;
    private String dataSourceName = null;
    private boolean defaultAutoCommit = true;
    private int defaultTransactionIsolation = -1;
    private int maxActive = 8;
    private int maxIdle = 8;
    private int maxWait = (int)Math.min(Integer.MAX_VALUE, -1L);
    private boolean defaultReadOnly = false;
    private String description = null;
    Properties jndiEnvironment = null;
    private int loginTimeout = 0;
    private PrintWriter logWriter = null;
    private boolean _testOnBorrow = false;
    private boolean _testOnReturn = false;
    private int _timeBetweenEvictionRunsMillis = (int)Math.min(Integer.MAX_VALUE, -1L);
    private int _numTestsPerEvictionRun = 3;
    private int _minEvictableIdleTimeMillis = (int)Math.min(Integer.MAX_VALUE, 1800000L);
    private boolean _testWhileIdle = false;
    private String validationQuery = null;
    private boolean testPositionSet = false;
    protected String instanceKey = null;

    protected void assertInitializationAllowed() throws IllegalStateException {
        if (this.getConnectionCalled) {
            throw new IllegalStateException(GET_CONNECTION_CALLED);
        }
    }

    public abstract void close() throws Exception;

    public ConnectionPoolDataSource getConnectionPoolDataSource() {
        return this.cpds;
    }

    public void setConnectionPoolDataSource(ConnectionPoolDataSource v) {
        this.assertInitializationAllowed();
        if (this.dataSourceName != null) {
            throw new IllegalStateException("Cannot set the DataSource, if JNDI is used.");
        }
        if (this.cpds != null) {
            throw new IllegalStateException("The CPDS has already been set. It cannot be altered.");
        }
        this.cpds = v;
        this.instanceKey = InstanceKeyObjectFactory.registerNewInstance(this);
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String v) {
        this.assertInitializationAllowed();
        if (this.cpds != null) {
            throw new IllegalStateException("Cannot set the JNDI name for the DataSource, if already set using setConnectionPoolDataSource.");
        }
        if (this.dataSourceName != null) {
            throw new IllegalStateException("The DataSourceName has already been set. It cannot be altered.");
        }
        this.dataSourceName = v;
        this.instanceKey = InstanceKeyObjectFactory.registerNewInstance(this);
    }

    public boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean v) {
        this.assertInitializationAllowed();
        this.defaultAutoCommit = v;
    }

    public boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(boolean v) {
        this.assertInitializationAllowed();
        this.defaultReadOnly = v;
    }

    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(int v) {
        this.assertInitializationAllowed();
        switch (v) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException(BAD_TRANSACTION_ISOLATION);
            }
        }
        this.defaultTransactionIsolation = v;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String v) {
        this.description = v;
    }

    public String getJndiEnvironment(String key) {
        String value = null;
        if (this.jndiEnvironment != null) {
            value = this.jndiEnvironment.getProperty(key);
        }
        return value;
    }

    public void setJndiEnvironment(String key, String value) {
        if (this.jndiEnvironment == null) {
            this.jndiEnvironment = new Properties();
        }
        this.jndiEnvironment.setProperty(key, value);
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int v) {
        this.loginTimeout = v;
    }

    public PrintWriter getLogWriter() {
        if (this.logWriter == null) {
            this.logWriter = new PrintWriter(System.out);
        }
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter v) {
        this.logWriter = v;
    }

    public final boolean isTestOnBorrow() {
        return this.getTestOnBorrow();
    }

    public boolean getTestOnBorrow() {
        return this._testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.assertInitializationAllowed();
        this._testOnBorrow = testOnBorrow;
        this.testPositionSet = true;
    }

    public final boolean isTestOnReturn() {
        return this.getTestOnReturn();
    }

    public boolean getTestOnReturn() {
        return this._testOnReturn;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.assertInitializationAllowed();
        this._testOnReturn = testOnReturn;
        this.testPositionSet = true;
    }

    public int getTimeBetweenEvictionRunsMillis() {
        return this._timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(int timeBetweenEvictionRunsMillis) {
        this.assertInitializationAllowed();
        this._timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public int getNumTestsPerEvictionRun() {
        return this._numTestsPerEvictionRun;
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.assertInitializationAllowed();
        this._numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public int getMinEvictableIdleTimeMillis() {
        return this._minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(int minEvictableIdleTimeMillis) {
        this.assertInitializationAllowed();
        this._minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public final boolean isTestWhileIdle() {
        return this.getTestWhileIdle();
    }

    public boolean getTestWhileIdle() {
        return this._testWhileIdle;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.assertInitializationAllowed();
        this._testWhileIdle = testWhileIdle;
        this.testPositionSet = true;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.assertInitializationAllowed();
        this.validationQuery = validationQuery;
        if (!this.testPositionSet) {
            this.setTestOnBorrow(true);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        if (this.instanceKey == null) {
            throw new SQLException("Must set the ConnectionPoolDataSource through setDataSourceName or setConnectionPoolDataSource before calling getConnection.");
        }
        this.getConnectionCalled = true;
        PooledConnectionAndInfo info = null;
        try {
            info = this.getPooledConnectionAndInfo(username, password);
        }
        catch (NoSuchElementException e) {
            this.closeDueToException(info);
            throw new SQLNestedException("Cannot borrow connection from pool", e);
        }
        catch (RuntimeException e) {
            this.closeDueToException(info);
            throw e;
        }
        catch (SQLException e) {
            this.closeDueToException(info);
            throw e;
        }
        catch (Exception e) {
            this.closeDueToException(info);
            throw new SQLNestedException("Cannot borrow connection from pool", e);
        }
        if (!(null != password ? password.equals(info.getPassword()) : null == info.getPassword())) {
            this.closeDueToException(info);
            throw new SQLException("Given password did not match password used to create the PooledConnection.");
        }
        Connection con = info.getPooledConnection().getConnection();
        this.setupDefaults(con, username);
        con.clearWarnings();
        return con;
    }

    protected abstract PooledConnectionAndInfo getPooledConnectionAndInfo(String var1, String var2) throws SQLException;

    protected abstract void setupDefaults(Connection var1, String var2) throws SQLException;

    private void closeDueToException(PooledConnectionAndInfo info) {
        if (info != null) {
            try {
                info.getPooledConnection().getConnection().close();
            }
            catch (Exception e) {
                this.getLogWriter().println("[ERROR] Could not return connection to pool during exception handling. " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ConnectionPoolDataSource testCPDS(String username, String password) throws NamingException, SQLException {
        ConnectionPoolDataSource cpds = this.cpds;
        if (cpds == null) {
            InitialContext ctx = null;
            ctx = this.jndiEnvironment == null ? new InitialContext() : new InitialContext(this.jndiEnvironment);
            Object ds = ctx.lookup(this.dataSourceName);
            if (!(ds instanceof ConnectionPoolDataSource)) throw new SQLException("Illegal configuration: DataSource " + this.dataSourceName + " (" + ds.getClass().getName() + ")" + " doesn't implement javax.sql.ConnectionPoolDataSource");
            cpds = (ConnectionPoolDataSource)ds;
        }
        PooledConnection conn = null;
        try {
            conn = username != null ? cpds.getPooledConnection(username, password) : cpds.getPooledConnection();
            if (conn == null) {
                throw new SQLException("Cannot connect using the supplied username/password");
            }
            Object var7_6 = null;
            if (conn == null) return cpds;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            conn.close();
            return cpds;
        }
        catch (SQLException e) {}
        return cpds;
    }

    protected byte whenExhaustedAction(int maxActive, int maxWait) {
        byte whenExhausted = 1;
        if (maxActive <= 0) {
            whenExhausted = 2;
        } else if (maxWait == 0) {
            whenExhausted = 0;
        }
        return whenExhausted;
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), InstanceKeyObjectFactory.class.getName(), null);
        ref.add(new StringRefAddr("instanceKey", this.instanceKey));
        return ref;
    }
}

