/*
 * Decompiled with CFR 0.152.
 */
package com.hongshee.ejforum.util;

import com.hongshee.common.util.MyLogger;
import com.hongshee.ejforum.common.AppContext;
import com.hongshee.ejforum.common.AppException;
import com.hongshee.ejforum.common.CacheManager;
import com.hongshee.ejforum.common.ForumSetting;
import com.hongshee.ejforum.data.ActionLogDAO;
import com.hongshee.ejforum.data.BoardDAO;
import com.hongshee.ejforum.data.GroupDAO;
import com.hongshee.ejforum.data.OptionVO;
import com.hongshee.ejforum.data.SectionDAO;
import com.hongshee.ejforum.data.StatDAO;
import com.hongshee.ejforum.data.UserDAO;
import com.hongshee.ejforum.util.AppUtils;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageUtils {
    private static Logger a = MyLogger.getLogger(PageUtils.class.getName());
    private static String b = "3.0";
    private static String c = null;
    private static String d = "";
    private static Properties e = new Properties();
    private static long f = 0L;
    public static String OK = "OK";
    public static String SORT_FIELD = "lastPostTime";
    public static String charset = null;

    public static void log(HttpServletRequest object, String string, String string2, Throwable throwable) {
        a.log(Level.WARNING, string2, throwable);
        ActionLogDAO.getInstance().addErrorLog((HttpServletRequest)object, string, string2);
        object = ForumSetting.getInstance().getString(5, "mailEvents");
        if (object.indexOf("error") >= 0) {
            AppUtils.sendMail2Admin("EasyJForum error info", throwable.toString());
        }
    }

    public static void loadResources(String stringArray) throws Exception {
        File file = new File((String)stringArray);
        if (file.exists() && file.lastModified() > f) {
            stringArray = AppUtils.getStringFromFile((String)stringArray, "GBK");
            stringArray = stringArray.split("\r\n");
            boolean bl = false;
            String string = null;
            Object var2_3 = null;
            int n = 0;
            while (n < stringArray.length) {
                int n2;
                if (!stringArray[n].startsWith("#") && (n2 = stringArray[n].indexOf(61)) > 0) {
                    string = stringArray[n].substring(0, n2).trim();
                    String string2 = stringArray[n].substring(n2 + 1);
                    string2 = string2.startsWith(" ") ? " " + string2.trim() : string2.trim();
                    if (string2.endsWith("$")) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    e.setProperty(string, string2);
                }
                ++n;
            }
            f = file.lastModified();
        }
    }

    public static String getString(String string) {
        return e.getProperty(string);
    }

    public static String getString(String string, String string2) {
        if ((string = e.getProperty(string)) != null) {
            string = AppUtils.replaceStr(string, "$1", string2);
        }
        return string;
    }

    public static String getVersion() {
        return b;
    }

    public static String getTitle(String charSequence) {
        charSequence = new StringBuilder((String)charSequence);
        String string = ForumSetting.getInstance().appendTitle;
        if (string.length() > 0) {
            ((StringBuilder)charSequence).append(" - ").append(string);
        }
        return ((StringBuilder)charSequence).toString();
    }

    public static String getMetas(String string, BoardDAO.BoardVO boardVO) {
        Object object = ForumSetting.getInstance();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<META http-equiv=Content-Type content=\"text/html;charset=").append(charset).append("\">\n");
        stringBuilder.append("<META name=keywords content=\"");
        if (boardVO != null && boardVO.keywords != null && boardVO.keywords.length() > 0) {
            stringBuilder.append(boardVO.keywords).append(",");
        }
        stringBuilder.append(((ForumSetting)object).keywords).append("\">\n");
        stringBuilder.append("<META name=description content=\"");
        object = ((ForumSetting)object).description;
        if (((String)object).length() > 0) {
            stringBuilder.append((String)object);
        } else {
            stringBuilder.append(string);
            if (boardVO != null) {
                stringBuilder.append(" - ").append(boardVO.plainName);
            }
        }
        stringBuilder.append("\">\n");
        stringBuilder.append("<META name=generator content=\"EasyJForum ").append(b).append("\">\n");
        stringBuilder.append("<META name=author content=\"EasyJForum Team\">\n");
        stringBuilder.append("<META name=copyright content=\"Hongshee Software\">");
        return stringBuilder.toString();
    }

    public static String getRSSLink(HttpServletRequest object, String string, SectionDAO.SectionVO sectionVO, BoardDAO.BoardVO boardVO, BoardDAO.CatVO catVO) {
        String string2 = ForumSetting.getInstance().RssStyle;
        string2 = string2.equals("B") ? "0" : "1";
        object = PageUtils.getForumURL(object);
        StringBuilder stringBuilder = new StringBuilder();
        if (boardVO != null && sectionVO != null) {
            stringBuilder.append("<LINK title=\"");
            if (catVO != null && catVO.catID >= 0) {
                stringBuilder.append(catVO.catName).append(" - ").append(boardVO.plainName);
            } else {
                stringBuilder.append(boardVO.plainName).append(" - ").append(string);
            }
            stringBuilder.append("\" href=\"").append((String)object).append("rss?fid=").append(boardVO.boardID);
            if (catVO != null && catVO.catID >= 0) {
                stringBuilder.append("&cid=").append(catVO.catID);
            }
            stringBuilder.append("&style=").append(string2).append("&page=1\" type=application/rss+xml rel=alternate>\n");
            if (boardVO.isCatOK == 'T' && boardVO.catList != null && (catVO == null || catVO.catID == 0)) {
                stringBuilder.append("<LINK title=\"").append(boardVO.plainName).append(" - ").append(string).append("\" href=\"").append((String)object).append("opml?fid=").append(boardVO.boardID).append("&style=").append(string2).append("\" type=text/x-opml rel=outline>");
            }
        } else if (sectionVO != null) {
            stringBuilder.append("<LINK title=\"").append(sectionVO.sectionName).append(" - ").append(string).append("\" href=\"").append((String)object).append("opml?sid=").append(sectionVO.sectionID).append("&style=").append(string2).append("\" type=text/x-opml rel=outline>");
        } else {
            stringBuilder.append("<LINK title=\"").append(string).append("\" href=\"").append((String)object).append("opml?sid=all&style=").append(string2).append("\" type=text/x-opml rel=outline>");
        }
        return stringBuilder.toString();
    }

    public static String getRSSFeeds(String charSequence, BoardDAO.BoardVO boardVO, boolean bl) {
        charSequence = new StringBuilder();
        if (bl) {
            ((StringBuilder)charSequence).append("<SCRIPT type=text/javascript>\n");
            ((StringBuilder)charSequence).append("function checkAgent(){\n").append("if(!is_ie){\n").append("if(confirm(\"\u60a8\u4f7f\u7528\u7684\u662f\u975e IE \u5185\u6838\u7684\u6d4f\u89c8\u5668\uff0c\u4e0d\u80fd\u4f7f\u7528\u6b64\u8ba2\u9605\u529f\u80fd\u3002\\n").append("\u5efa\u8bae\u60a8\u5b89\u88c5 Wisol Reader\uff0c\u662f\u5426\u8f6c\u5230\u5176\u4e0b\u8f7d\u9875\u9762\uff1f\")){\n").append("window.open(\"http://www.wisol.net.cn/wisc.jsp\");return false;}\n").append("}else if(navigator.userAgent.indexOf('HS/Wisc') < 0){\n").append("if(confirm(\"\u8ba2\u9605\u524d\u9700\u8981\u5b89\u88c5 Wisol Reader\uff0c\u662f\u5426\u8f6c\u5230\u5176\u4e0b\u8f7d\u9875\u9762\uff1f\")){\n").append("window.open(\"http://www.wisol.net.cn/wisc.jsp\");}return false;}\n").append("return true;\n}\n");
            ((StringBuilder)charSequence).append("function subGroup(elemId){\n").append("if(!checkAgent()) return;\n").append("var obj = $(elemId + '_url');\n").append("var url = obj.href;\n").append("if(url.indexOf('?') < 0)\n").append("location.href='wisc://'+url+'?wisc_grpname='+$(elemId+'_name').innerHTML;\n").append("else\n").append("location.href='wisc://'+url+'&wisc_grpname='+$(elemId+'_name').innerHTML;\n").append("}\n");
            ((StringBuilder)charSequence).append("function subChannel(elemId){\n").append("if(!checkAgent()) return;\n").append("var obj = $(elemId + '_url');\n").append("var url = obj.href;\n").append("if(url.indexOf('?') < 0)\n").append("location.href='wisc://'+url+'?wisc_chnname='+$(elemId+'_name').innerHTML;\n").append("else\n").append("location.href='wisc://'+url+'&wisc_chnname='+$(elemId+'_name').innerHTML;\n").append("}\n");
            ((StringBuilder)charSequence).append("</SCRIPT>\n");
        }
        if (boardVO == null) {
            CacheManager cacheManager = CacheManager.getInstance();
            ArrayList<SectionDAO.SectionVO> arrayList = cacheManager.getSections();
            if (arrayList != null) {
                SectionDAO.SectionVO sectionVO = null;
                boardVO = null;
                String string = null;
                String string2 = null;
                int n = 0;
                String string3 = String.valueOf(String.valueOf(33)) + "%";
                StringBuilder stringBuilder = new StringBuilder();
                String string4 = ForumSetting.getInstance().getForumName();
                n = 0;
                while (n < arrayList.size()) {
                    sectionVO = arrayList.get(n);
                    if (sectionVO.boardList != null) {
                        ((StringBuilder)charSequence).append("<DIV class=\"mainbox forumlist\">\n");
                        ((StringBuilder)charSequence).append("<H3><A href=\"./index.jsp?sid=").append(sectionVO.sectionID).append("\">").append(sectionVO.sectionName).append("</A></H3>\n");
                        ((StringBuilder)charSequence).append("<TABLE id=\"section_").append(n).append("\" cellSpacing=0 cellPadding=0>\n");
                        string2 = "./opml?sid=" + sectionVO.sectionID;
                        ((StringBuilder)charSequence).append("<TBODY><TR>\n");
                        ((StringBuilder)charSequence).append("<TH width=\"").append(string3).append("\">\n");
                        ((StringBuilder)charSequence).append("<H2><A href=\"./index.jsp?sid=").append(sectionVO.sectionID).append("\" id=\"g_").append(sectionVO.sectionID).append("_name\">").append(string4).append('_').append(sectionVO.sectionName).append("</A></H2>\n");
                        ((StringBuilder)charSequence).append("<P style=\"margin-bottom:2px\">").append("\u5305\u542b\u672c\u5206\u533a\u6240\u6709\u7248\u5757\u7684&nbsp;RSS&nbsp;\u5730\u5740\u5217\u8868</P>\n");
                        ((StringBuilder)charSequence).append("<P class=\"moderators\">").append("<IMG src=\"images/opml.gif\" border=0 align=absmiddle>&nbsp;\n");
                        ((StringBuilder)charSequence).append("-&nbsp; <A href=\"").append(string2).append("&style=0&page=1\" target=_blank>\u6807\u9898\u5f0f</A>&nbsp;\n");
                        ((StringBuilder)charSequence).append("-&nbsp; <A href=\"").append(string2).append("&style=1&page=1\" target=_blank id=\"g_").append(sectionVO.sectionID).append("_url\">\u5168\u6587\u5f0f</A>&nbsp;\n");
                        if (bl) {
                            ((StringBuilder)charSequence).append("-&nbsp; <A href=\"javascript:subGroup('g_").append(sectionVO.sectionID).append("')\">\u8ba2\u9605</A>");
                        }
                        ((StringBuilder)charSequence).append("</P></TH>\n");
                        int n2 = sectionVO.boardList.size();
                        int n3 = 0;
                        int n4 = 0;
                        while (n4 < n2) {
                            BoardDAO.BoardVO boardVO2 = sectionVO.boardList.get(n4);
                            if (boardVO2.state != 'I') {
                                stringBuilder.setLength(0);
                                stringBuilder.append("./forum-").append(boardVO2.boardID).append(".html");
                                string = stringBuilder.toString();
                                string2 = "./rss?fid=" + boardVO2.boardID;
                                if ((n3 + 1) % 3 == 0) {
                                    ((StringBuilder)charSequence).append("<TBODY><TR>\n");
                                }
                                ((StringBuilder)charSequence).append("<TH width=\"").append(string3).append("\">\n");
                                ((StringBuilder)charSequence).append("<H2><A href=\"").append(string).append("\" id=\"c_").append(boardVO2.boardID).append("_name\">").append(boardVO2.boardName).append("</A></H2>\n");
                                ((StringBuilder)charSequence).append("<P style=\"margin-bottom:2px\">\u4e3b\u9898: ").append(boardVO2.topics).append(", \u5e16\u6570: ").append(boardVO2.posts);
                                if (boardVO2.allowGroups == null || boardVO2.allowGroups.indexOf(71) < 0) {
                                    ((StringBuilder)charSequence).append(" &nbsp;(&nbsp;\u79c1\u5bc6&nbsp;)");
                                }
                                ((StringBuilder)charSequence).append("</P>\n");
                                ((StringBuilder)charSequence).append("<P class=\"moderators\">").append("<IMG src=\"images/rss.gif\" border=0 align=absmiddle>&nbsp;\n");
                                ((StringBuilder)charSequence).append("-&nbsp; <A href=\"").append(string2).append("&style=0&page=1\" target=_blank>\u6807\u9898\u5f0f</A>&nbsp;\n");
                                ((StringBuilder)charSequence).append("-&nbsp; <A href=\"").append(string2).append("&style=1&page=1\" target=_blank id=\"c_").append(boardVO2.boardID).append("_url\">\u5168\u6587\u5f0f</A>&nbsp;\n");
                                if (bl) {
                                    ((StringBuilder)charSequence).append("-&nbsp; <A href=\"javascript:subChannel('c_").append(boardVO2.boardID).append("')\">\u8ba2\u9605</A>&nbsp;\n");
                                }
                                if (boardVO2.isCatOK == 'T' && boardVO2.catList != null && boardVO2.catList.size() > 0) {
                                    ((StringBuilder)charSequence).append("-&nbsp; <A href=\"feeds.jsp?fid=").append(boardVO2.boardID).append("\">\u5206\u7c7b</A>");
                                }
                                ((StringBuilder)charSequence).append("</P></TH>\n");
                                if ((n3 + 2) % 3 == 0) {
                                    ((StringBuilder)charSequence).append("</TR></TBODY>\n");
                                }
                                ++n3;
                            }
                            ++n4;
                        }
                        n4 = 3 - (n3 + 1) % 3;
                        if (n4 < 3) {
                            int n5 = 0;
                            while (n5 < n4) {
                                ((StringBuilder)charSequence).append("<TH width=\"").append(string3).append("\" style=\"BACKGROUND-IMAGE:none\">&nbsp;</TH>");
                                ++n5;
                            }
                            ((StringBuilder)charSequence).append("</TR></TBODY>\n");
                        }
                        ((StringBuilder)charSequence).append("</TABLE></DIV>\n");
                    }
                    ++n;
                }
            }
        } else {
            Object object = null;
            String string = null;
            String string5 = null;
            String string6 = String.valueOf(String.valueOf(33)) + "%";
            StringBuilder stringBuilder = new StringBuilder();
            object = ForumSetting.getInstance().getForumName();
            ((StringBuilder)charSequence).append("<DIV class=\"mainbox forumlist\">\n");
            ((StringBuilder)charSequence).append("<H3><A href=\"./forum-").append(boardVO.boardID).append(".html\">").append(boardVO.boardName).append("</A></H3>\n");
            ((StringBuilder)charSequence).append("<TABLE id=\"forum_0\" cellSpacing=0 cellPadding=0>\n");
            string = "./opml?fid=" + boardVO.boardID;
            ((StringBuilder)charSequence).append("<TBODY><TR>\n");
            ((StringBuilder)charSequence).append("<TH width=\"").append(string6).append("\">\n");
            ((StringBuilder)charSequence).append("<H2><A href=\"./forum-").append(boardVO.boardID).append(".html\" id=\"g_").append(boardVO.boardID).append("_name\">").append((String)object).append('_').append(boardVO.boardName).append("</A></H2>\n");
            ((StringBuilder)charSequence).append("<P style=\"margin-bottom:2px\">").append("\u5305\u542b\u672c\u7248\u5757\u6240\u6709\u5206\u7c7b\u7684&nbsp;RSS&nbsp;\u5730\u5740\u5217\u8868</P>\n");
            ((StringBuilder)charSequence).append("<P class=\"moderators\">").append("<IMG src=\"images/opml.gif\" border=0 align=absmiddle>&nbsp;\n");
            ((StringBuilder)charSequence).append("-&nbsp; <A href=\"").append(string).append("&style=0\" target=_blank>\u6807\u9898\u5f0f</A>&nbsp;\n");
            ((StringBuilder)charSequence).append("-&nbsp; <A href=\"").append(string).append("&style=1\" target=_blank id=\"g_").append(boardVO.boardID).append("_url\">\u5168\u6587\u5f0f</A>&nbsp;\n");
            if (bl) {
                ((StringBuilder)charSequence).append("-&nbsp; <A href=\"javascript:subGroup('g_").append(boardVO.boardID).append("')\">\u8ba2\u9605</A>");
            }
            ((StringBuilder)charSequence).append("</P></TH>\n");
            int n = 0;
            if (boardVO.catList != null) {
                n = boardVO.catList.size() + 1;
            }
            int n6 = 0;
            int n7 = 0;
            while (n7 < n) {
                object = n7 < n - 1 ? boardVO.catList.get(n7) : boardVO.unCat;
                stringBuilder.setLength(0);
                stringBuilder.append("./forum-").append(boardVO.boardID).append(".html?cid=").append(((BoardDAO.CatVO)object).catID);
                string5 = stringBuilder.toString();
                stringBuilder.setLength(0);
                stringBuilder.append("./rss?fid=").append(boardVO.boardID).append("&cid=").append(((BoardDAO.CatVO)object).catID);
                string = stringBuilder.toString();
                if ((n6 + 1) % 3 == 0) {
                    ((StringBuilder)charSequence).append("<TBODY><TR>\n");
                }
                ((StringBuilder)charSequence).append("<TH width=\"").append(string6).append("\">\n");
                ((StringBuilder)charSequence).append("<H2><A href=\"").append(string5).append("\" id=\"c_").append(((BoardDAO.CatVO)object).catID).append("_name\">").append(((BoardDAO.CatVO)object).catName).append("</A></H2>\n");
                ((StringBuilder)charSequence).append("<P style=\"margin-bottom:2px\">\u4e3b\u9898: ").append(((BoardDAO.CatVO)object).topics);
                ((StringBuilder)charSequence).append("</P>\n");
                ((StringBuilder)charSequence).append("<P class=\"moderators\">").append("<IMG src=\"images/rss.gif\" border=0 align=absmiddle>&nbsp;\n");
                ((StringBuilder)charSequence).append("-&nbsp; <A href=\"").append(string).append("&style=0&page=1\" target=_blank>\u6807\u9898\u5f0f</A>&nbsp;\n");
                ((StringBuilder)charSequence).append("-&nbsp; <A href=\"").append(string).append("&style=1&page=1\" target=_blank id=\"c_").append(((BoardDAO.CatVO)object).catID).append("_url\">\u5168\u6587\u5f0f</A>&nbsp;\n");
                if (bl) {
                    ((StringBuilder)charSequence).append("-&nbsp; <A href=\"javascript:subChannel('c_").append(((BoardDAO.CatVO)object).catID).append("')\">\u8ba2\u9605</A>&nbsp;\n");
                }
                ((StringBuilder)charSequence).append("</P></TH>\n");
                if ((n6 + 2) % 3 == 0) {
                    ((StringBuilder)charSequence).append("</TR></TBODY>\n");
                }
                ++n6;
                ++n7;
            }
            n7 = 3 - (n6 + 1) % 3;
            if (n7 < 3) {
                int n8 = 0;
                while (n8 < n7) {
                    ((StringBuilder)charSequence).append("<TH width=\"").append(string6).append("\" style=\"BACKGROUND-IMAGE:none\">&nbsp;</TH>");
                    ++n8;
                }
                ((StringBuilder)charSequence).append("</TR></TBODY>\n");
            }
            ((StringBuilder)charSequence).append("</TABLE></DIV>\n");
        }
        return ((StringBuilder)charSequence).toString();
    }

    public static String getTopInfo(HttpServletRequest object) {
        object = ForumSetting.getInstance().topCode;
        if (object.trim().length() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<DIV id=topinfo>").append((String)object).append("</DIV>");
            return stringBuilder.toString();
        }
        return d;
    }

    public static String getHeader(HttpServletRequest httpServletRequest, String string) {
        return PageUtils.getHeader(httpServletRequest, null, string);
    }

    public static String getHeader(HttpServletRequest object, SectionDAO.SectionVO object2, String stringArray) {
        String string = object.getContextPath();
        String string2 = null;
        if (object2 != null) {
            string2 = ((SectionDAO.SectionVO)object2).logo;
        }
        if (string2 == null || string2.length() == 0) {
            object2 = ForumSetting.getInstance();
            string2 = ((ForumSetting)object2).getString(1, "forumLogo");
        } else {
            stringArray = ((SectionDAO.SectionVO)object2).sectionName;
        }
        object2 = PageUtils.getForumURL((HttpServletRequest)object);
        object = new StringBuilder();
        ((StringBuilder)object).append("<H2>");
        if (string2.indexOf(".swf") > 0) {
            stringArray = string2.split(",");
            object2 = String.valueOf(object2) + "images/" + stringArray[0];
            if (stringArray.length > 2) {
                ((StringBuilder)object).append("<SCRIPT type=text/javascript>showFlash('").append((String)object2).append("','").append(stringArray[1]).append("','").append(stringArray[2]).append("');</SCRIPT>");
            } else {
                ((StringBuilder)object).append("<SCRIPT type=text/javascript>showFlash('").append((String)object2).append("','120','60');</SCRIPT>");
            }
        } else {
            ((StringBuilder)object).append("<A href=\"").append(string).append("/\"><IMG alt=\"").append((String)stringArray).append("\" src=\"").append(string).append("/images/").append(string2).append("\" border=0></A>");
        }
        ((StringBuilder)object).append("</H2>");
        return ((StringBuilder)object).toString();
    }

    public static String[] getHeaderMenu(HttpServletRequest object, UserDAO.UserInfo userInfo) {
        String[] stringArray = new String[3];
        String string = object.getContextPath();
        String string2 = object.getServerName();
        if (!string.equals("/")) {
            string2 = String.valueOf(string2) + string;
        }
        GroupDAO.GroupVO groupVO = PageUtils.getGroupVO(userInfo);
        ForumSetting forumSetting = ForumSetting.getInstance();
        StringBuilder stringBuilder = new StringBuilder();
        if (groupVO.rights.indexOf(90) < 0 && forumSetting.showSearchImage.equalsIgnoreCase("yes")) {
            stringBuilder.append("<UL class=\"popmenu_popup headermenu_popup\"").append(" id=advsearch_menu style=\"DISPLAY: none;width:60px\">\n");
            stringBuilder.append("<LI style=\"width:60px\"><A href=\"").append(string).append("/advsearch.jsp\">\u7f51\u9875\u641c\u7d22</A></LI>\n");
            stringBuilder.append("<LI style=\"width:60px\"><A href=\"javascript:searchImages('").append(string2).append("');\">\u56fe\u7247\u641c\u7d22</A></LI>\n");
            stringBuilder.append("</UL>");
        }
        stringBuilder.append("<DIV id=headermenu><UL>");
        if (userInfo != null) {
            object = object.getSession(false);
            long l = -1L;
            if (object != null) {
                l = object.getCreationTime();
            }
            stringBuilder.append("<LI><CITE><A href=\"").append(string).append("/uspace.jsp?uid=").append(userInfo.userID).append("\">").append(userInfo.userID).append("</A></CITE></LI>\n");
            stringBuilder.append("<LI><A href=\"").append(string).append("/perform.jsp?act=lgt");
            if (l > 0L) {
                stringBuilder.append("&sid=").append(l);
            }
            stringBuilder.append("\">\u9000\u51fa</A></LI>\n");
            stringBuilder.append("<LI><A href=\"").append(string).append("/member/sms_list.jsp\">\u77ed\u6d88\u606f");
            if (userInfo.unreadSMs > 0) {
                stringBuilder.append("<B>(").append(userInfo.unreadSMs).append(")</B>");
            }
            stringBuilder.append("</A></LI>\n");
        } else {
            stringBuilder.append("<LI><A href=\"").append(string).append("/register.jsp\">\u6ce8\u518c</A></LI>\n");
            stringBuilder.append("<LI><A href=\"").append(string).append("/login.jsp\">\u767b\u5f55</A></LI>\n");
        }
        if (userInfo != null) {
            stringBuilder.append("<LI class=dropmenu id=myspace onmouseover='showMenu(this.id)'").append(" style='BACKGROUND-POSITION:94%'><A href=\"").append(string).append("/member/my_topics.jsp\">\u6211\u7684\u7a7a\u95f4</A></LI>\n");
        }
        if (forumSetting.menuEx1 != null && forumSetting.menuEx1[0].length() > 0 && (forumSetting.menuEx1[2].equalsIgnoreCase("yes") || userInfo != null)) {
            stringBuilder.append("<LI><A href=\"");
            if (forumSetting.menuEx1[1].startsWith("/")) {
                stringBuilder.append(string);
            }
            stringBuilder.append(forumSetting.menuEx1[1]).append("\">").append(forumSetting.menuEx1[0]).append("</A></LI>\n");
        }
        stringBuilder.append("<LI><A href=\"").append(string).append("/feeds.jsp").append("\">\u8ba2\u9605</A></LI>\n");
        if (forumSetting.menuEx2 != null && forumSetting.menuEx2[0].length() > 0 && (forumSetting.menuEx2[2].equalsIgnoreCase("yes") || userInfo != null)) {
            stringBuilder.append("<LI><A href=\"");
            if (forumSetting.menuEx2[1].startsWith("/")) {
                stringBuilder.append(string);
            }
            stringBuilder.append(forumSetting.menuEx2[1]).append("\">").append(forumSetting.menuEx2[0]).append("</A></LI>\n");
        }
        if (groupVO.rights.indexOf(66) >= 0) {
            stringBuilder.append("<LI><A href=\"").append(string).append("/userlist.jsp").append("\">\u4f1a\u5458\u5217\u8868</A></LI>\n");
        }
        if (groupVO.rights.indexOf(90) < 0) {
            if (forumSetting.showSearchImage.equalsIgnoreCase("yes")) {
                stringBuilder.append("<LI class=dropmenu id=advsearch onmouseover='showMenu(this.id)'").append(" style='BACKGROUND-POSITION:94%'><A href=\"");
            } else {
                stringBuilder.append("<LI><A href=\"");
            }
            stringBuilder.append(string).append("/advsearch.jsp").append("\">\u641c\u7d22</A></LI>\n");
        }
        if (groupVO.rights.indexOf(68) >= 0) {
            stringBuilder.append("<LI class=dropmenu id=stats onmouseover='showMenu(this.id)'").append(" style='BACKGROUND-POSITION:94%'><A href=\"").append(string).append("/stat/baseinfo.jsp").append("\">\u7edf\u8ba1</A></LI>\n");
        }
        if (forumSetting.menuEx3 != null && forumSetting.menuEx3[0].length() > 0 && (forumSetting.menuEx3[2].equalsIgnoreCase("yes") || userInfo != null)) {
            stringBuilder.append("<LI><A href=\"");
            if (forumSetting.menuEx3[1].startsWith("/")) {
                stringBuilder.append(string);
            }
            stringBuilder.append(forumSetting.menuEx3[1]).append("\">").append(forumSetting.menuEx3[0]).append("</A></LI>\n");
        }
        if (userInfo != null && groupVO.groupType == 'S') {
            stringBuilder.append("<LI><A href=\"").append(string).append("/admin/login.jsp").append("\" target=\"_blank\">\u540e\u53f0\u7ba1\u7406</A></LI>\n");
        }
        stringBuilder.append("<LI><A href=\"").append(string).append("/help/index.jsp\">\u5e2e\u52a9</A></LI>");
        object = forumSetting.tsExchange;
        if (((String)object).equals("chs") || ((String)object).equals("cht")) {
            stringBuilder.append("<LI><A name=\"StranLink\" id=\"StranLink\">\u7e41\u9ad4\u4e2d\u6587</A></LI>");
        }
        stringBuilder.append("</UL></DIV>\n");
        stringArray[0] = stringBuilder.toString();
        if (userInfo != null) {
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("<UL class=\"popmenu_popup headermenu_popup\"").append(" id=myspace_menu style=\"DISPLAY: none;\">\n");
            stringBuilder2.append("<LI><A href=\"").append(string).append("/uspace.jsp?uid=").append(userInfo.userID).append("\">\u4e2a\u4eba\u4fe1\u606f\u9875</A></LI>\n");
            stringBuilder2.append("<LI><A href=\"").append(string).append("/member/my_profile.jsp\">\u7f16\u8f91\u4e2a\u4eba\u8d44\u6599</A></LI>\n");
            stringBuilder2.append("<LI><A href=\"").append(string).append("/member/sms_list.jsp\">\u77ed\u6d88\u606f</A></LI>\n");
            stringBuilder2.append("<LI><A href=\"").append(string).append("/member/my_topics.jsp\">\u6211\u7684\u8bdd\u9898</A></LI>\n");
            stringBuilder2.append("<LI><A href=\"").append(string).append("/member/my_favors.jsp\">\u6211\u7684\u6536\u85cf</A></LI>\n");
            stringBuilder2.append("<LI><A href=\"").append(string).append("/member/my_friends.jsp\">\u6211\u7684\u597d\u53cb</A></LI>");
            stringBuilder2.append("<LI><A href=\"").append(string).append("/member/my_rights.jsp\">\u6211\u7684\u6743\u9650</A></LI>\n");
            stringBuilder2.append("<LI><A href=\"").append(string).append("/member/my_credits.jsp\">\u79ef\u5206\u4ea4\u6613\u8bb0\u5f55</A></LI>\n");
            stringBuilder2.append("</UL>");
            stringArray[1] = stringBuilder2.toString();
        }
        if (groupVO.rights.indexOf(68) >= 0) {
            StringBuilder stringBuilder3 = new StringBuilder();
            stringBuilder3.append("<UL class=\"popmenu_popup headermenu_popup\"").append(" id=stats_menu style=\"DISPLAY: none;\">\n");
            stringBuilder3.append("<LI><A href=\"").append(string).append("/stat/baseinfo.jsp\">\u57fa\u672c\u6982\u51b5</A></LI>\n");
            stringBuilder3.append("<LI><A href=\"").append(string).append("/stat/flux.jsp\">\u8bbf\u95ee\u91cf\u8bb0\u5f55</A></LI>\n");
            stringBuilder3.append("<LI><A href=\"").append(string).append("/stat/top_boards.jsp\">\u7248\u5757\u6392\u884c</A></LI>\n");
            HashMap<String, String> hashMap = StatDAO.getInstance().getBaseStatInfo();
            object = hashMap.get("cats");
            if (object != null && Integer.parseInt((String)object) > 0) {
                stringBuilder3.append("<LI><A href=\"").append(string).append("/stat/top_cats.jsp\">\u5206\u7c7b\u6392\u884c</A></LI>\n");
            }
            stringBuilder3.append("<LI><A href=\"").append(string).append("/stat/top_topics.jsp\">\u4e3b\u9898\u6392\u884c</A></LI>\n");
            stringBuilder3.append("<LI><A href=\"").append(string).append("/stat/top_tags.jsp\">\u5173\u952e\u5b57\u6392\u884c</A></LI>\n");
            stringBuilder3.append("<LI><A href=\"").append(string).append("/stat/top_users.jsp\">\u4f1a\u5458\u6392\u884c</A></LI>\n");
            stringBuilder3.append("<LI><A href=\"").append(string).append("/stat/admins.jsp\">\u7ba1\u7406\u56e2\u961f</A></LI>");
            stringBuilder3.append("</UL>");
            stringArray[2] = stringBuilder3.toString();
        }
        return stringArray;
    }

    public static String getFooter(HttpServletRequest httpServletRequest, String string) {
        ForumSetting forumSetting = ForumSetting.getInstance();
        String string2 = forumSetting.timezone;
        String string3 = forumSetting.footerMailAddr;
        String string4 = forumSetting.siteUrl;
        String string5 = forumSetting.certCode;
        String string6 = forumSetting.showStyleList;
        Object object = forumSetting.dateFormat;
        object = AppUtils.replaceStr((String)object, "mm", "MM");
        object = new SimpleDateFormat(String.valueOf(object) + " HH:mm");
        ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("GMT" + string2));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<DIV id=footer><DIV class=wrap><DIV id=footlinks>");
        stringBuilder.append("<P>\u5f53\u524d\u65f6\u533a&nbsp;GMT");
        stringBuilder.append(string2).append(", \u73b0\u5728\u65f6\u95f4\u662f&nbsp;");
        stringBuilder.append(((DateFormat)object).format(new Date())).append("</P>\n<P>");
        boolean bl = true;
        if (string3.length() > 0) {
            stringBuilder.append("<A href=\"mailto:");
            stringBuilder.append(string3);
            stringBuilder.append("\">\u8054\u7cfb\u6211\u4eec</A>");
            bl = false;
        }
        if (string4.length() > 0) {
            if (!bl) {
                stringBuilder.append("&nbsp;-&nbsp;");
            }
            stringBuilder.append("<A href=\"");
            stringBuilder.append(string4);
            stringBuilder.append("\" target=_blank>").append(forumSetting.website).append("</A>");
            bl = false;
        }
        if (string5.length() > 0) {
            if (!bl) {
                stringBuilder.append("&nbsp;-&nbsp;");
            }
            stringBuilder.append("<A href=\"http://www.miibeian.gov.cn\" target=_blank>").append(string5).append("</A>");
            bl = false;
        }
        if (!bl) {
            stringBuilder.append("&nbsp;-&nbsp;");
        }
        stringBuilder.append("<span class=\"scrolltop\" title=\"\u9876\u90e8\" onclick=\"").append("window.scrollTo(0,0);\">TOP</span>");
        if (string6.equals("yes")) {
            stringBuilder.append("&nbsp;-&nbsp;");
            stringBuilder.append("<SPAN class=dropmenu id=stylelist onmouseover=showMenu(this.id)").append(">\u754c\u9762\u98ce\u683c</SPAN>\n");
            stringBuilder.append("<DIV class=\"popmenu_popup poplist\" id=stylelist_menu style=\"DISPLAY: none\"><UL>\n");
            OptionVO[] optionVOArray = forumSetting.getStyles();
            if (optionVOArray != null) {
                string3 = null;
                int n = 0;
                while (n < optionVOArray.length) {
                    if (optionVOArray[n].name.charAt(0) == '1') {
                        string3 = optionVOArray[n].name.substring(2);
                        if (string3.equals(string)) {
                            stringBuilder.append("<LI class=current>");
                        } else {
                            stringBuilder.append("<LI>");
                        }
                        stringBuilder.append("<A href=\"javascript:changeStyle('");
                        stringBuilder.append(string3).append("')\">");
                        stringBuilder.append(optionVOArray[n].value);
                        stringBuilder.append("</A></LI>");
                    }
                    ++n;
                }
            }
            stringBuilder.append("</UL></DIV>");
        }
        stringBuilder.append("</P></DIV>\n");
        stringBuilder.append("<P class=copyright> Powered by <STRONG><A href=\"").append("http://www.easyjforum.cn/\" target=_blank>");
        stringBuilder.append("EasyJForum</A></STRONG> <EM>").append(b).append("</EM> &copy; 2005-").append(Calendar.getInstance().get(1));
        stringBuilder.append(" <A\n href=\"http://www.hongshee.com/\"").append(" target=_blank>Hongshee software</A></P>");
        String string7 = forumSetting.footRemark;
        if (string7.length() > 0) {
            stringBuilder.append("<P id=footnote>").append(string7).append("</P>");
        }
        stringBuilder.append("</DIV></DIV>");
        string3 = forumSetting.tsExchange;
        if (string3.equals("chs") || string3.equals("cht")) {
            string4 = httpServletRequest.getContextPath();
            stringBuilder.append("<script src=\"").append(string4).append("/js/ts_exchange.js\" type=\"text/javascript\"></script>\n");
            stringBuilder.append("<script type=\"text/javascript\">");
            if (string3.equals("chs")) {
                stringBuilder.append("var Default_isFT = 0;");
            } else {
                stringBuilder.append("var Default_isFT = 1;");
            }
            stringBuilder.append("addLoadEvent(ts_exchange_init);");
            stringBuilder.append("</script>\n");
        }
        return stringBuilder.toString();
    }

    public static String getHeadAdBanner(HttpServletRequest httpServletRequest, BoardDAO.BoardVO boardVO) {
        return PageUtils.getHeadAdBanner(httpServletRequest, null, boardVO);
    }

    public static String getHeadAdBanner(HttpServletRequest object, SectionDAO.SectionVO object2, BoardDAO.BoardVO boardVO) {
        object = new StringBuilder();
        if (boardVO != null && boardVO.headAdCode != null && boardVO.headAdCode.length() > 0) {
            ((StringBuilder)object).append("<DIV id=ad_headerbanner>").append(boardVO.headAdCode).append("</DIV>");
        } else if (object2 != null && ((SectionDAO.SectionVO)object2).headAdCode != null && ((SectionDAO.SectionVO)object2).headAdCode.length() > 0) {
            ((StringBuilder)object).append("<DIV id=ad_headerbanner>").append(((SectionDAO.SectionVO)object2).headAdCode).append("</DIV>");
        } else {
            object2 = ForumSetting.getInstance().headAdCode;
            if (((String)object2).length() > 0) {
                ((StringBuilder)object).append("<DIV id=ad_headerbanner>").append((String)object2).append("</DIV>");
            }
        }
        return ((StringBuilder)object).toString();
    }

    public static String getFootAdBanner(HttpServletRequest httpServletRequest, BoardDAO.BoardVO boardVO) {
        return PageUtils.getFootAdBanner(httpServletRequest, null, boardVO);
    }

    public static String getFootAdBanner(HttpServletRequest object, SectionDAO.SectionVO object2, BoardDAO.BoardVO boardVO) {
        object = new StringBuilder();
        if (boardVO != null && boardVO.footAdCode != null && boardVO.footAdCode.length() > 0) {
            ((StringBuilder)object).append("<DIV id=ad_footerbanner>").append(boardVO.footAdCode).append("</DIV>");
        } else if (object2 != null && ((SectionDAO.SectionVO)object2).footAdCode != null && ((SectionDAO.SectionVO)object2).footAdCode.length() > 0) {
            ((StringBuilder)object).append("<DIV id=ad_footerbanner>").append(((SectionDAO.SectionVO)object2).footAdCode).append("</DIV>");
        } else {
            object2 = ForumSetting.getInstance().footAdCode;
            if (((String)object2).length() > 0) {
                ((StringBuilder)object).append("<DIV id=ad_footerbanner>").append((String)object2).append("</DIV>");
            }
        }
        return ((StringBuilder)object).toString();
    }

    public static String getTopicAdBanner(HttpServletRequest object, BoardDAO.BoardVO object2) {
        object = new StringBuilder();
        if (object2 != null && ((BoardDAO.BoardVO)object2).topicAdCode != null && ((BoardDAO.BoardVO)object2).topicAdCode.length() > 0) {
            ((StringBuilder)object).append("<DIV id=ad_topicbanner>").append(((BoardDAO.BoardVO)object2).topicAdCode).append("</DIV>");
        } else {
            object2 = ForumSetting.getInstance().topicAdCode;
            if (((String)object2).length() > 0) {
                ((StringBuilder)object).append("<DIV id=ad_topicbanner>").append((String)object2).append("</DIV>");
            }
        }
        return ((StringBuilder)object).toString();
    }

    public static String getAdminFooter(HttpServletRequest object) {
        object = new StringBuilder();
        ((StringBuilder)object).append("<DIV class=footer><HR width=\"100%\" noShade size=0>\n");
        ((StringBuilder)object).append("Powered by <A style=\"color:#666666\" href=\"").append("http://www.easyjforum.cn/\" target=_blank>");
        ((StringBuilder)object).append("<B>EasyJForum</B></A> ").append(b).append(" &nbsp;&copy; 2005-").append(Calendar.getInstance().get(1));
        ((StringBuilder)object).append(" <A\n style=\"color:#666666\" href=\"http://www.hongshee.com/\"").append(" target=_blank>Hongshee software</A></DIV>");
        return ((StringBuilder)object).toString();
    }

    public static String getSysMailFooter(HttpServletRequest httpServletRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<br><br>\n<a href=\"").append(PageUtils.getForumURL(httpServletRequest)).append("\" target=\"_blank\">").append(ForumSetting.getInstance().getForumName()).append("</a><br>").append(AppUtils.getCurrentDateStr()).append("\n");
        return stringBuilder.toString();
    }

    public static String getModeratorLink(String stringArray) {
        CharSequence charSequence = null;
        if ((stringArray = stringArray == null ? null : stringArray.split(",")) != null && stringArray.length > 0) {
            charSequence = new StringBuilder();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].length() != 0) {
                    if (((StringBuilder)charSequence).length() > 0) {
                        ((StringBuilder)charSequence).append(", ");
                    }
                    ((StringBuilder)charSequence).append("<A href=\"uspace.jsp?uid=").append(stringArray[n]);
                    ((StringBuilder)charSequence).append("\" target=\"_blank\">").append(stringArray[n]).append("</A>");
                }
                ++n;
            }
            charSequence = ((StringBuilder)charSequence).toString();
        }
        return charSequence;
    }

    public static int getIntValue(String[] stringArray, int n, int n2) {
        if (stringArray.length > n) {
            try {
                n2 = Integer.parseInt(stringArray[n]);
            }
            catch (Exception exception) {}
        }
        return n2;
    }

    public static int getPageNo(String string) {
        int n = 1;
        if (string != null && string.length() > 0) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {}
            if (n < 1) {
                n = 1;
            }
        }
        return n;
    }

    public static String getPageHTMLStr(int n, int n2, int n3, int n4) {
        return PageUtils.getPageHTMLStr(n, n2, n3, n4, null);
    }

    public static String getPageHTMLStr(int n, int n2, int n3, int n4, String string) {
        n3 = (n - 1) / n3 + 1;
        int n5 = 1;
        if (n2 > 10) {
            n5 = n2 - 9;
        }
        if (n3 > n4 && n4 != 0) {
            n3 = n4;
        }
        if ((n4 = n5 + 9) > n3) {
            n4 = n3;
        }
        StringBuilder stringBuilder = new StringBuilder("<DIV class=pages>");
        stringBuilder.append("<EM>&nbsp;").append(n).append("&nbsp;</EM>");
        if (n2 > 1) {
            if (string == null) {
                stringBuilder.append("<a href=\"javascript:viewPage('");
                stringBuilder.append(n2 - 1);
                stringBuilder.append("');\" class=\"prev\">&nbsp;&lsaquo;&lsaquo;&nbsp;</a>");
            } else {
                stringBuilder.append("<a href=\"").append(string);
                stringBuilder.append("&page=").append(n2 - 1);
                stringBuilder.append("\" class=\"prev\">&nbsp;&lsaquo;&lsaquo;&nbsp;</a>");
            }
        }
        n = n5;
        while (n <= n4) {
            if (n == n2) {
                stringBuilder.append("<strong>&nbsp;").append(n).append("&nbsp;</strong>");
            } else if (string == null) {
                stringBuilder.append("<a href=\"javascript:viewPage('");
                stringBuilder.append(n);
                stringBuilder.append("');\">&nbsp;");
                stringBuilder.append(n);
                stringBuilder.append("&nbsp;</a>");
            } else {
                stringBuilder.append("<a href=\"").append(string);
                stringBuilder.append("&page=").append(n);
                stringBuilder.append("\">&nbsp;");
                stringBuilder.append(n);
                stringBuilder.append("&nbsp;</a>");
            }
            ++n;
        }
        if (n4 < n3) {
            if (string == null) {
                stringBuilder.append("<a href=\"javascript:viewPage('");
                stringBuilder.append(n3);
                stringBuilder.append("');\">...&nbsp;");
                stringBuilder.append(n3);
                stringBuilder.append("&nbsp;</a>");
            } else {
                stringBuilder.append("<a href=\"").append(string);
                stringBuilder.append("&page=").append(n3);
                stringBuilder.append("\">...&nbsp;");
                stringBuilder.append(n3);
                stringBuilder.append("&nbsp;</a>");
            }
        }
        if (n2 < n3) {
            if (string == null) {
                stringBuilder.append("<a href=\"javascript:viewPage('");
                stringBuilder.append(n2 + 1);
                stringBuilder.append("');\" class=\"next\">&nbsp;&rsaquo;&rsaquo;&nbsp;</a>");
            } else {
                stringBuilder.append("<a href=\"").append(string);
                stringBuilder.append("&page=").append(n2 + 1);
                stringBuilder.append("\" class=\"next\">&nbsp;&rsaquo;&rsaquo;&nbsp;</a>");
            }
        }
        stringBuilder.append("</DIV>");
        return stringBuilder.toString();
    }

    public static String decodeParam(String string, HttpServletRequest object) {
        block5: {
            block4: {
                if (string == null) break block4;
                string = string.trim();
                if ((object = object.getCharacterEncoding()) != null && !((String)object).equalsIgnoreCase("ISO-8859-1") || string.length() <= 0) break block5;
                try {
                    string = new String(string.getBytes("ISO-8859-1"), charset);
                }
                catch (Exception exception) {}
            }
            string = d;
        }
        return string;
    }

    public static String decodeAttr(String string) {
        block5: {
            block4: {
                if (string == null) break block4;
                if ((string = string.trim()).length() <= 0) break block5;
                try {
                    string = new String(string.getBytes("ISO-8859-1"), charset);
                }
                catch (Exception exception) {}
            }
            string = d;
        }
        return string;
    }

    public static String getParam(HttpServletRequest httpServletRequest, String string) {
        return PageUtils.decodeParam(httpServletRequest.getParameter(string), httpServletRequest);
    }

    public static int getIntParam(HttpServletRequest object, String string) {
        if ((object = object.getParameter(string)) == null || ((String)object).trim().length() == 0) {
            return 0;
        }
        return Integer.parseInt((String)object);
    }

    public static String getHTMLParam(HttpServletRequest object, String string) {
        object = PageUtils.decodeParam(object.getParameter(string), object);
        object = AppUtils.replaceStr((String)object, "\"", "&quot;");
        object = AppUtils.replaceStr((String)object, "<", "&lt;");
        object = AppUtils.replaceStr((String)object, ">", "&gt;");
        return object;
    }

    public static String[] getParamValues(HttpServletRequest httpServletRequest, String stringArray) {
        if ((stringArray = httpServletRequest.getParameterValues((String)stringArray)) != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = PageUtils.decodeParam(stringArray[n], httpServletRequest);
                ++n;
            }
        }
        return stringArray;
    }

    public static String getQueryFields(HttpServletRequest httpServletRequest) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        String[] stringArray = null;
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string.equals("page") || string.startsWith("exe_") || (stringArray = httpServletRequest.getParameterValues(string)) == null || stringArray.length <= 0) continue;
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null && stringArray[n].length() > 0) {
                    stringBuilder.append("<input type=hidden name=\"").append(string).append("\"").append(" value=\"").append(AppUtils.replaceStr(PageUtils.decodeParam(stringArray[n], httpServletRequest), "\"", "&quot;")).append("\">\n");
                }
                ++n;
            }
        }
        return stringBuilder.toString();
    }

    public static GroupDAO.GroupVO getGroupVO(UserDAO.UserInfo userInfo) {
        CacheManager cacheManager = CacheManager.getInstance();
        return PageUtils.getGroupVO(userInfo, cacheManager.getModerators());
    }

    public static GroupDAO.GroupVO getGroupVO(String string, char c, int n, String string2) {
        Object object = null;
        object = CacheManager.getInstance();
        object = string != null && string.length() > 0 ? (c == 'A' ? ((CacheManager)object).getGroup(c) : (string2.indexOf("," + string.toLowerCase() + ",") >= 0 ? (c <= '9' ? ((CacheManager)object).getGroup('M') : ((CacheManager)object).getGroup(c)) : ((CacheManager)object).getGroup(n))) : ((CacheManager)object).getGroup('G');
        return object;
    }

    public static GroupDAO.GroupVO getGroupVO(UserDAO.UserInfo userInfo, SectionDAO.SectionVO object, BoardDAO.BoardVO boardVO) {
        Object object2 = null;
        object2 = CacheManager.getInstance();
        if (userInfo == null) {
            object2 = ((CacheManager)object2).getGroup('G');
        } else {
            object = PageUtils.getModerators((SectionDAO.SectionVO)object, boardVO);
            object2 = PageUtils.getGroupVO(userInfo.userID, userInfo.groupID, userInfo.credits, (String)object);
        }
        return object2;
    }

    public static GroupDAO.GroupVO getGroupVO(UserDAO.UserInfo userInfo, String string) {
        Object object = null;
        object = CacheManager.getInstance();
        object = userInfo == null ? ((CacheManager)object).getGroup('G') : PageUtils.getGroupVO(userInfo.userID, userInfo.groupID, userInfo.credits, string);
        return object;
    }

    public static String getModerators(SectionDAO.SectionVO sectionVO, BoardDAO.BoardVO boardVO) {
        StringBuilder stringBuilder = new StringBuilder(",");
        if (sectionVO.moderator != null) {
            stringBuilder.append(sectionVO.moderator).append(',');
        }
        if (boardVO != null && boardVO.moderator != null) {
            stringBuilder.append(boardVO.moderator).append(',');
        }
        return stringBuilder.toString();
    }

    public static boolean isPermitted(BoardDAO.BoardVO boardVO, GroupDAO.GroupVO groupVO, UserDAO.UserInfo userInfo, char c) {
        boolean bl = false;
        if (groupVO.rights.indexOf(c) >= 0) {
            bl = true;
            if (boardVO.acl != null) {
                int n = boardVO.acl.indexOf(String.valueOf(c) + "_");
                c = (char)n;
                if (n >= 0) {
                    Object var5_5 = null;
                    int n2 = boardVO.acl.indexOf(44, (int)c);
                    String string = n2 > 0 ? boardVO.acl.substring(c + '\u0001', n2) : boardVO.acl.substring(c + '\u0001');
                    if (string.indexOf(groupVO.groupID) < 0) {
                        bl = false;
                    }
                }
            } else if (boardVO.allowGroups.indexOf(groupVO.groupID) < 0) {
                bl = false;
            }
        }
        if (!bl && userInfo != null && boardVO.memberSet != null && boardVO.memberSet.contains(userInfo.userID.toLowerCase())) {
            bl = true;
        }
        return bl;
    }

    public static String getRelativePath(String string) {
        Object var1_1 = null;
        int n = string.indexOf("://");
        String string2 = n > 0 ? ((n = string.indexOf("/", n + 3)) > 0 ? string.substring(n) : "/") : string;
        return string2;
    }

    public static String getRootPath(String string) {
        Object var1_1 = null;
        int n = string.indexOf("://");
        String string2 = n > 0 ? ((n = string.indexOf("/", n + 3)) > 0 ? string.substring(0, n) : string) : d;
        return string2;
    }

    public static String getForumURL(HttpServletRequest httpServletRequest) {
        if (c == null && httpServletRequest != null) {
            c = String.valueOf(PageUtils.getRootPath(httpServletRequest.getRequestURL().toString())) + httpServletRequest.getContextPath() + "/";
        }
        return c;
    }

    public static String getForumStyle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BoardDAO.BoardVO boardVO) {
        String string = httpServletRequest.getParameter("style");
        if (string == null || string.length() == 0) {
            Cookie cookie = PageUtils.getCookie(httpServletRequest, "ejf_cssid");
            if (cookie != null) {
                string = cookie.getValue();
            }
            if (string == null || string.length() == 0 || string.equals("default")) {
                if (boardVO != null && boardVO.viewStyle != null) {
                    string = boardVO.viewStyle;
                }
                if (string == null || string.length() == 0 || string.equals("default")) {
                    string = ForumSetting.getInstance().getDefaultStyle();
                }
            } else if (!string.equals("default") && !ForumSetting.getInstance().isExistedStyle(string)) {
                string = ForumSetting.getInstance().getDefaultStyle();
                boardVO = new Cookie("ejf_cssid", string);
                boardVO.setMaxAge(0);
                boardVO.setPath(httpServletRequest.getContextPath());
                httpServletResponse.addCookie((Cookie)boardVO);
            }
        } else {
            Cookie cookie = new Cookie("ejf_cssid", string);
            cookie.setMaxAge(315360000);
            cookie.setPath(httpServletRequest.getContextPath());
            httpServletResponse.addCookie(cookie);
        }
        return string;
    }

    public static String getPathFromReferer(HttpServletRequest httpServletRequest) {
        String string;
        String string2 = null;
        string2 = httpServletRequest.getHeader("Referer");
        string2 = string2 != null ? ((string = PageUtils.getRootPath(string2)).indexOf(httpServletRequest.getServerName()) > 0 ? PageUtils.getRelativePath(string2) : "/") : "/";
        return string2;
    }

    public static void checkReferer(HttpServletRequest httpServletRequest) throws Exception {
        String string = httpServletRequest.getHeader("Referer");
        if (string != null && (string = PageUtils.getRootPath(string)).indexOf(httpServletRequest.getServerName()) < 0) {
            throw new AppException("Illegal request");
        }
    }

    public static boolean isUserAgent(HttpServletRequest object) {
        boolean bl = false;
        String string = object.getHeader("Referer");
        if (string != null && string.length() > 0 && (object = object.getHeader("User-Agent")) != null && (((String)object).indexOf("MSIE") >= 0 || ((String)object).indexOf("Gecko") >= 0 || ((String)object).indexOf("Chrome") >= 0 || ((String)object).indexOf("Safari") >= 0 || ((String)object).indexOf("Opera") >= 0)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isUserAgent2(HttpServletRequest object) {
        boolean bl = false;
        if ((object = object.getHeader("User-Agent")) != null && (((String)object).indexOf("MSIE") >= 0 || ((String)object).indexOf("Gecko") >= 0 || ((String)object).indexOf("Chrome") >= 0 || ((String)object).indexOf("Safari") >= 0 || ((String)object).indexOf("Opera") >= 0)) {
            bl = true;
        }
        return bl;
    }

    public static void checkIP(String string, HttpSession httpSession) throws Exception {
        boolean bl = true;
        if (string == null || string.length() == 0) {
            bl = false;
        } else {
            Object object = (Integer)httpSession.getAttribute("ipOK");
            if (object == null) {
                object = ForumSetting.getInstance();
                String[] stringArray = object.getAllowedIPs();
                if (stringArray.length > 0 && stringArray[0].length() > 0) {
                    bl = false;
                    int n = 0;
                    while (n < stringArray.length) {
                        if (stringArray[n].length() > 0 && string.startsWith(stringArray[n])) {
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                } else {
                    object = object.getBannedIPs();
                    int n = 0;
                    while (n < ((String[])object).length) {
                        if (object[n].length() > 0 && string.startsWith(object[n])) {
                            bl = false;
                            break;
                        }
                        ++n;
                    }
                }
                if (bl) {
                    httpSession.setAttribute("ipOK", (Object)1);
                }
            }
        }
        if (!bl) {
            httpSession.invalidate();
            throw new AppException("\u6b64 IP \u5730\u5740\u5bf9\u672c\u8bba\u575b\u7684\u8bbf\u95ee\u5df2\u88ab\u7981\u6b62");
        }
    }

    public static void checkAdminIP(HttpServletRequest object) throws Exception {
        String[] stringArray = ForumSetting.getInstance();
        if ((stringArray = stringArray.getAllowedAdminIPs()).length > 0 && stringArray[0].length() > 0) {
            boolean bl = false;
            object = PageUtils.getRemoteAddr((HttpServletRequest)object);
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].length() > 0 && ((String)object).startsWith(stringArray[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                throw new AppException("\u6b64 IP \u5730\u5740\u5bf9\u540e\u53f0\u7ba1\u7406\u7684\u8bbf\u95ee\u5df2\u88ab\u7981\u6b62");
            }
        }
    }

    public static String getRemoteAddr(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("x-forwarded-for");
        if (string == null) {
            string = httpServletRequest.getRemoteAddr();
        } else {
            int n = string.lastIndexOf(44);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            string = string.trim();
        }
        if (string == null || string.length() == 0) {
            string = "0.0.0.0";
        }
        return string;
    }

    public static Cookie getCookie(HttpServletRequest cookieArray, String string) {
        Cookie cookie = null;
        if ((cookieArray = cookieArray.getCookies()) != null) {
            int n = 0;
            while (n < cookieArray.length) {
                if (cookieArray[n].getName().equals(string)) {
                    cookie = cookieArray[n];
                    break;
                }
                ++n;
            }
        }
        return cookie;
    }

    public static UserDAO.UserInfo getSessionUser(HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest = httpServletRequest.getSession();
        return (UserDAO.UserInfo)httpServletRequest.getAttribute("userinfo");
    }

    public static UserDAO.UserInfo getSessionUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object = httpServletRequest.getSession();
        PageUtils.checkIP(PageUtils.getRemoteAddr(httpServletRequest), object);
        if (object.getAttribute("isAgent") == null && PageUtils.isUserAgent2(httpServletRequest)) {
            object.setAttribute("isAgent", (Object)"true");
            AppContext.getInstance().incSessionCount();
            AppContext.getInstance().setTopOnlines();
        }
        if ((object = (UserDAO.UserInfo)object.getAttribute("userinfo")) == null) {
            try {
                long l;
                Cookie cookie = PageUtils.getCookie(httpServletRequest, "ejf_lsessid");
                if (cookie != null && ((String[])(cookie = AppUtils.decode32(cookie.getValue()).split("\\|"))).length == 2 && (l = Long.parseLong(cookie[0])) > System.currentTimeMillis()) {
                    cookie = cookie[1];
                    UserDAO userDAO = UserDAO.getInstance();
                    object = userDAO.doQuickLogin((String)cookie, l, httpServletRequest);
                    if (object == null) {
                        cookie = new Cookie("ejf_lsessid", null);
                        cookie.setMaxAge(0);
                        cookie.setPath(httpServletRequest.getContextPath());
                        httpServletResponse.addCookie(cookie);
                    }
                }
            }
            catch (Exception exception) {}
        }
        return object;
    }

    public static UserDAO.UserInfo getLoginedUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        UserDAO.UserInfo userInfo = PageUtils.getSessionUser(httpServletRequest, httpServletResponse);
        if (userInfo == null) {
            String string = httpServletRequest.getRequestURI();
            String string2 = httpServletRequest.getQueryString();
            if (string2 != null) {
                string = String.valueOf(string) + "?" + string2;
            }
            httpServletRequest.setAttribute("fromPath", (Object)string);
            httpServletRequest.getRequestDispatcher("/login.jsp").forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        } else {
            PageUtils.checkReferer(httpServletRequest);
        }
        return userInfo;
    }

    public static UserDAO.UserInfo getAdminUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        UserDAO.UserInfo userInfo = PageUtils.getLoginedUser(httpServletRequest, httpServletResponse);
        if (userInfo == null) {
            return null;
        }
        if (userInfo.groupID == 'A') {
            PageUtils.checkAdminIP(httpServletRequest);
        }
        if (!userInfo.isAdminOn) {
            httpServletRequest.removeAttribute("fromPath");
            httpServletRequest.getRequestDispatcher("/admin/login.jsp").forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return null;
        }
        return userInfo;
    }

    public static ArrayList<UserDAO.UserInfo> getSessionAdminUsers() {
        ArrayList<UserDAO.UserInfo> arrayList = new ArrayList<UserDAO.UserInfo>();
        Object object = AppContext.getInstance().getSessions();
        object = object.iterator();
        Object object2 = null;
        object2 = null;
        while (object.hasNext()) {
            object2 = (HttpSession)object.next();
            if ((object2 = (UserDAO.UserInfo)object2.getAttribute("userinfo")) == null || !object2.isAdminOn) continue;
            arrayList.add((UserDAO.UserInfo)object2);
        }
        return arrayList;
    }

    public static UserDAO.UserInfo getSessionUser(String string) {
        Object object = null;
        Object object2 = AppContext.getInstance().getSessions();
        object2 = object2.iterator();
        Object object3 = null;
        object3 = null;
        while (object2.hasNext()) {
            object3 = (HttpSession)object2.next();
            if ((object3 = (UserDAO.UserInfo)object3.getAttribute("userinfo")) == null || !object3.userID.equalsIgnoreCase(string)) continue;
            object = object3;
        }
        return object;
    }
}

