/*
 * Decompiled with CFR 0.152.
 */
package com.hongshee.ejforum.data;

import com.hongshee.ejforum.common.CacheManager;
import com.hongshee.ejforum.common.ForumSetting;
import com.hongshee.ejforum.data.ActionLogDAO;
import com.hongshee.ejforum.data.BoardDAO;
import com.hongshee.ejforum.data.EntityDAO;
import com.hongshee.ejforum.data.TopicDAO;
import com.hongshee.ejforum.util.PageUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrashBoxDAO
extends EntityDAO {
    private static TrashBoxDAO a = null;

    private TrashBoxDAO() {
    }

    public static synchronized TrashBoxDAO getInstance() {
        if (a == null) {
            a = new TrashBoxDAO();
        }
        return a;
    }

    public void addTrashes(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String string, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.adapter.TrashBox_Insert);
            int n = 0;
            while (n < stringArray3.length) {
                preparedStatement.setString(1, stringArray3[n]);
                if (stringArray5 == null) {
                    preparedStatement.setString(2, "0");
                } else {
                    preparedStatement.setString(2, stringArray5[n]);
                }
                preparedStatement.setString(3, stringArray[n]);
                preparedStatement.setString(4, stringArray2[n]);
                preparedStatement.setString(5, stringArray4[n]);
                preparedStatement.setString(6, stringArray6[n]);
                preparedStatement.setString(7, string);
                preparedStatement.addBatch();
                ++n;
            }
            preparedStatement.executeBatch();
        }
        finally {
            this.dbManager.closePStatement(preparedStatement);
        }
    }

    public void deleteTrashes(HttpServletRequest httpServletRequest) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = TrashBoxDAO.a(httpServletRequest, arrayList);
        Connection connection = this.dbManager.getConnection();
        try {
            try {
                connection.setAutoCommit(false);
                Object object = "select topicID,replyID from ejf_trash_box" + string;
                object = this.execSelectSql((String)object, arrayList, connection);
                if (object != null && ((ArrayList)object).size() > 0) {
                    this.a((ArrayList<HashMap>)object, connection);
                }
                object = "delete from ejf_trash_box" + string;
                this.execUpdateSql((String)object, arrayList, connection);
                ActionLogDAO.getInstance().addAdminLog(httpServletRequest, "\u5220\u9664\u56de\u6536\u7ad9\u5e16\u5b50", "", connection);
                connection.commit();
            }
            catch (SQLException sQLException) {
                connection.rollback();
                throw sQLException;
            }
        }
        finally {
            this.dbManager.closeConnection(connection);
        }
    }

    public void deleteTrash(HttpServletRequest httpServletRequest) throws Exception {
        String string = httpServletRequest.getParameter("tid");
        Object object = httpServletRequest.getParameter("rid");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = " where topicID=? and replyID=?";
        arrayList.add(string);
        arrayList.add(object);
        ArrayList<HashMap> arrayList2 = new ArrayList<HashMap>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TOPICID", string);
        hashMap.put("REPLYID", (String)object);
        arrayList2.add(hashMap);
        object = this.dbManager.getConnection();
        try {
            try {
                object.setAutoCommit(false);
                this.a(arrayList2, (Connection)object);
                string2 = "delete from ejf_trash_box" + string2;
                this.execUpdateSql(string2, arrayList, (Connection)object);
                ActionLogDAO.getInstance().addAdminLog(httpServletRequest, "\u5220\u9664\u56de\u6536\u7ad9\u5e16\u5b50", "Topic ID:" + string, (Connection)object);
                object.commit();
            }
            catch (SQLException sQLException) {
                object.rollback();
                throw sQLException;
            }
        }
        finally {
            this.dbManager.closeConnection((Connection)object);
        }
    }

    public void archiveTrash(HttpServletRequest httpServletRequest) throws Exception {
        String string = httpServletRequest.getParameter("tid");
        Object object = httpServletRequest.getParameter("rid");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = " where topicID=? and replyID=?";
        arrayList.add(string);
        arrayList.add(object);
        ArrayList<HashMap> arrayList2 = new ArrayList<HashMap>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TOPICID", string);
        hashMap.put("REPLYID", (String)object);
        arrayList2.add(hashMap);
        object = this.dbManager.getConnection();
        try {
            try {
                object.setAutoCommit(false);
                this.b(arrayList2, (Connection)object);
                string2 = "delete from ejf_trash_box" + string2;
                this.execUpdateSql(string2, arrayList, (Connection)object);
                ActionLogDAO.getInstance().addAdminLog(httpServletRequest, "\u5f52\u6863\u56de\u6536\u7ad9\u5e16\u5b50", "Topic ID:" + string, (Connection)object);
                object.commit();
            }
            catch (SQLException sQLException) {
                object.rollback();
                throw sQLException;
            }
        }
        finally {
            this.dbManager.closeConnection((Connection)object);
        }
    }

    public void archiveTrashes(HttpServletRequest httpServletRequest) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = TrashBoxDAO.a(httpServletRequest, arrayList);
        Connection connection = this.dbManager.getConnection();
        try {
            try {
                connection.setAutoCommit(false);
                Object object = "select topicID,replyID from ejf_trash_box" + string;
                object = this.execSelectSql((String)object, arrayList, connection);
                if (object != null && ((ArrayList)object).size() > 0) {
                    this.b((ArrayList<HashMap>)object, connection);
                }
                object = "delete from ejf_trash_box" + string;
                this.execUpdateSql((String)object, arrayList, connection);
                ActionLogDAO.getInstance().addAdminLog(httpServletRequest, "\u5f52\u6863\u56de\u6536\u7ad9\u5e16\u5b50", "", connection);
                connection.commit();
            }
            catch (SQLException sQLException) {
                connection.rollback();
                throw sQLException;
            }
        }
        finally {
            this.dbManager.closeConnection(connection);
        }
    }

    public void cleanExpiredTrashes() throws Exception {
        int n = ForumSetting.getInstance().getInt(5, "trashKeepMonths");
        if (n <= 0) {
            return;
        }
        Connection connection = this.dbManager.getConnection();
        try {
            Cloneable cloneable = Calendar.getInstance();
            cloneable.add(2, n * -1);
            Object object = new SimpleDateFormat("yyyy-MM-dd");
            object = ((DateFormat)object).format(cloneable.getTime());
            cloneable = new ArrayList<Date>();
            ((ArrayList)cloneable).add(Date.valueOf((String)object));
            this.execUpdateSql(this.adapter.TrashBox_CleanExpired, (ArrayList<Object>)cloneable, connection);
            this.execUpdateSql(this.adapter.TrashBox_RemoveTopic, null, connection);
            this.execUpdateSql(this.adapter.TrashBox_RemoveReply, null, connection);
        }
        finally {
            this.dbManager.closeConnection(connection);
        }
    }

    public void restoreTrashes(HttpServletRequest httpServletRequest) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = TrashBoxDAO.a(httpServletRequest, arrayList);
        Connection connection = this.dbManager.getConnection();
        try {
            try {
                connection.setAutoCommit(false);
                Object object = "select topicID, replyID from ejf_trash_box" + string;
                object = this.execSelectSql((String)object, arrayList, connection);
                if (object != null && ((ArrayList)object).size() > 0) {
                    this.c((ArrayList<HashMap>)object, connection);
                    BoardDAO.getInstance().statBoardInfo(connection);
                }
                object = "delete from ejf_trash_box" + string;
                this.execUpdateSql((String)object, arrayList, connection);
                ActionLogDAO.getInstance().addAdminLog(httpServletRequest, "\u8fd8\u539f\u56de\u6536\u7ad9\u5e16\u5b50", "", connection);
                connection.commit();
            }
            catch (SQLException sQLException) {
                connection.rollback();
                throw sQLException;
            }
        }
        finally {
            this.dbManager.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreTrash(HttpServletRequest httpServletRequest) throws Exception {
        String string = httpServletRequest.getParameter("tid");
        Object object = httpServletRequest.getParameter("rid");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object2 = " where topicID=? and replyID=?";
        arrayList.add(string);
        arrayList.add(object);
        ArrayList<HashMap> arrayList2 = new ArrayList<HashMap>();
        Object object3 = new HashMap<String, String>();
        ((HashMap)object3).put("TOPICID", string);
        ((HashMap)object3).put("REPLYID", object);
        arrayList2.add((HashMap)object3);
        object3 = this.dbManager.getConnection();
        try {
            try {
                object3.setAutoCommit(false);
                this.c(arrayList2, (Connection)object3);
                object2 = "delete from ejf_trash_box" + (String)object2;
                this.execUpdateSql((String)object2, arrayList, (Connection)object3);
                int n = PageUtils.getIntParam(httpServletRequest, "fid");
                object2 = CacheManager.getInstance();
                BoardDAO.BoardVO boardVO = ((CacheManager)object2).getBoard(n);
                if (object != null && !((String)object).equals("0")) {
                    TopicDAO.getInstance().statTopicPosts(string, (Connection)object3);
                    if (boardVO != null) {
                        object = boardVO;
                        synchronized (object) {
                            ++boardVO.posts;
                            boardVO.topicList = null;
                            boardVO.unCat.topicList = null;
                            if (boardVO.catList != null) {
                                int n2 = 0;
                                while (n2 < boardVO.catList.size()) {
                                    boardVO.catList.get((int)n2).topicList = null;
                                    ++n2;
                                }
                            }
                        }
                    }
                } else if (boardVO != null) {
                    object = new HashMap<Integer, BoardDAO.BoardVO>();
                    ((HashMap)object).put(boardVO.boardID, boardVO);
                    BoardDAO.getInstance().getBoardStatInfo((HashMap<Integer, BoardDAO.BoardVO>)object, (Connection)object3);
                }
                ActionLogDAO.getInstance().addAdminLog(httpServletRequest, "\u8fd8\u539f\u56de\u6536\u7ad9\u5e16\u5b50", "Topic ID:" + string, (Connection)object3);
                object3.commit();
            }
            catch (SQLException sQLException) {
                object3.rollback();
                throw sQLException;
            }
        }
        finally {
            this.dbManager.closeConnection((Connection)object3);
        }
    }

    private void a(ArrayList<HashMap> arrayList, Connection connection) throws SQLException {
        Statement statement = null;
        Statement statement2 = null;
        try {
            int n = 0;
            boolean bl = false;
            Object var6_8 = null;
            int n2 = 0;
            while (n2 < arrayList.size()) {
                HashMap hashMap = arrayList.get(n2);
                n = Integer.parseInt((String)hashMap.get("TOPICID"));
                int n3 = Integer.parseInt((String)hashMap.get("REPLYID"));
                if (n3 > 0) {
                    if (statement2 == null) {
                        statement2 = connection.prepareStatement(this.adapter.Reply_Remove);
                    }
                    statement2.setInt(1, n3);
                    statement2.addBatch();
                } else {
                    if (statement == null) {
                        statement = connection.prepareStatement(this.adapter.Topic_Remove);
                    }
                    statement.setInt(1, n);
                    statement.addBatch();
                }
                ++n2;
            }
            if (statement != null) {
                statement.executeBatch();
            }
            if (statement2 != null) {
                statement2.executeBatch();
            }
        }
        catch (Throwable throwable) {
            this.dbManager.closePStatement((PreparedStatement)statement);
            this.dbManager.closePStatement((PreparedStatement)statement2);
            throw throwable;
        }
        this.dbManager.closePStatement((PreparedStatement)statement);
        this.dbManager.closePStatement((PreparedStatement)statement2);
    }

    private void b(ArrayList<HashMap> arrayList, Connection connection) throws SQLException {
        Statement statement = null;
        Statement statement2 = null;
        Statement statement3 = null;
        Statement statement4 = null;
        Statement statement5 = null;
        try {
            int n = 0;
            boolean bl = false;
            Object var9_11 = null;
            int n2 = 0;
            while (n2 < arrayList.size()) {
                HashMap hashMap = arrayList.get(n2);
                n = Integer.parseInt((String)hashMap.get("TOPICID"));
                int n3 = Integer.parseInt((String)hashMap.get("REPLYID"));
                if (n3 > 0) {
                    if (statement2 == null) {
                        statement2 = connection.prepareStatement(this.adapter.Reply_Archive);
                    }
                    statement2.setInt(1, n3);
                    statement2.addBatch();
                    if (statement4 == null) {
                        statement4 = connection.prepareStatement(this.adapter.Reply_Remove);
                    }
                    statement4.setInt(1, n3);
                    statement4.addBatch();
                } else {
                    if (statement == null) {
                        statement = connection.prepareStatement(this.adapter.Topic_Archive);
                    }
                    statement.setInt(1, n);
                    statement.addBatch();
                    if (statement5 == null) {
                        statement5 = connection.prepareStatement(this.adapter.Reply_ArchiveByTopic);
                    }
                    statement5.setInt(1, n);
                    statement5.addBatch();
                    if (statement3 == null) {
                        statement3 = connection.prepareStatement(this.adapter.Topic_Remove);
                    }
                    statement3.setInt(1, n);
                    statement3.addBatch();
                }
                ++n2;
            }
            if (statement2 != null) {
                statement2.executeBatch();
            }
            if (statement4 != null) {
                statement4.executeBatch();
            }
            if (statement != null) {
                statement.executeBatch();
            }
            if (statement5 != null) {
                statement5.executeBatch();
            }
            if (statement3 != null) {
                statement3.executeBatch();
            }
        }
        catch (Throwable throwable) {
            this.dbManager.closePStatement((PreparedStatement)statement);
            this.dbManager.closePStatement((PreparedStatement)statement2);
            this.dbManager.closePStatement((PreparedStatement)statement3);
            this.dbManager.closePStatement((PreparedStatement)statement4);
            this.dbManager.closePStatement((PreparedStatement)statement5);
            throw throwable;
        }
        this.dbManager.closePStatement((PreparedStatement)statement);
        this.dbManager.closePStatement((PreparedStatement)statement2);
        this.dbManager.closePStatement((PreparedStatement)statement3);
        this.dbManager.closePStatement((PreparedStatement)statement4);
        this.dbManager.closePStatement((PreparedStatement)statement5);
    }

    private void c(ArrayList<HashMap> arrayList, Connection connection) throws SQLException {
        Statement statement = null;
        Statement statement2 = null;
        try {
            int n = 0;
            boolean bl = false;
            Object var6_8 = null;
            int n2 = 0;
            while (n2 < arrayList.size()) {
                HashMap hashMap = arrayList.get(n2);
                n = Integer.parseInt((String)hashMap.get("TOPICID"));
                int n3 = Integer.parseInt((String)hashMap.get("REPLYID"));
                if (n3 > 0) {
                    if (statement2 == null) {
                        statement2 = connection.prepareStatement(this.adapter.Reply_ModState);
                    }
                    statement2.setString(1, "N");
                    statement2.setInt(2, n3);
                    statement2.addBatch();
                } else {
                    if (statement == null) {
                        statement = connection.prepareStatement(this.adapter.Topic_ModState);
                    }
                    statement.setString(1, "N");
                    statement.setInt(2, n);
                    statement.addBatch();
                }
                ++n2;
            }
            if (statement != null) {
                statement.executeBatch();
            }
            if (statement2 != null) {
                statement2.executeBatch();
            }
        }
        catch (Throwable throwable) {
            this.dbManager.closePStatement((PreparedStatement)statement);
            this.dbManager.closePStatement((PreparedStatement)statement2);
            throw throwable;
        }
        this.dbManager.closePStatement((PreparedStatement)statement);
        this.dbManager.closePStatement((PreparedStatement)statement2);
    }

    private static String a(HttpServletRequest object, ArrayList<Object> arrayList) {
        StringBuilder stringBuilder = new StringBuilder(" where 1=1");
        Object object2 = PageUtils.getParam((HttpServletRequest)object, "trashType");
        if (object2 != null && ((String)object2).equals("topic")) {
            stringBuilder.append(" and replyID=0");
        } else {
            stringBuilder.append(" and replyID>0");
        }
        object2 = PageUtils.getParam((HttpServletRequest)object, "boardID");
        if (object2 != null && ((String)object2).length() > 0 && !((String)object2).equals("all")) {
            stringBuilder.append(" and boardID=?");
            arrayList.add(object2);
        }
        if ((object2 = PageUtils.getParam((HttpServletRequest)object, "topicTitle")) != null && ((String)object2).length() > 0) {
            stringBuilder.append(" and topicTitle like ?");
            arrayList.add("%" + (String)object2 + "%");
        }
        if ((object2 = PageUtils.getParam((HttpServletRequest)object, "userID")) != null && ((String)object2).length() > 0) {
            if (((String)object2).indexOf(42) >= 0) {
                stringBuilder.append(" and userID like ?");
                arrayList.add(((String)object2).replace('*', '%'));
            } else {
                stringBuilder.append(" and userID=?");
                arrayList.add(object2);
            }
        }
        if ((object2 = PageUtils.getParam((HttpServletRequest)object, "deleteUser")) != null && ((String)object2).length() > 0) {
            if (((String)object2).indexOf(42) >= 0) {
                stringBuilder.append(" and deleteUser like ?");
                arrayList.add(((String)object2).replace('*', '%'));
            } else {
                stringBuilder.append(" and deleteUser=?");
                arrayList.add(object2);
            }
        }
        if ((object = PageUtils.getParam((HttpServletRequest)object, "days")) != null && ((String)object).length() > 0) {
            try {
                object2 = Calendar.getInstance();
                ((Calendar)object2).add(5, -1 * Integer.parseInt((String)object) + 1);
                object = new Date(((Calendar)object2).getTimeInMillis());
                stringBuilder.append(" and createTime<=?");
                arrayList.add(object);
            }
            catch (Exception exception) {}
        }
        return stringBuilder.toString();
    }

    public Object[] searchTrashBox(HttpServletRequest object, int n) throws SQLException {
        Object[] objectArray = new Object[2];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        object = TrashBoxDAO.a(object, arrayList);
        String string = "select COUNT(*) from ejf_trash_box" + (String)object;
        object = "select * from ejf_trash_box" + (String)object;
        int n2 = 0;
        Connection connection = null;
        try {
            connection = this.dbManager.getConnection();
            n2 = this.execSelectCountSql(string, arrayList, connection);
            if (n2 > 0) {
                object = this.adapter.getPageQuerySql(new StringBuilder((String)object).append(" order by createTime DESC"), n, 15, n2);
                object = this.execSelectSql((String)object, arrayList, connection);
                objectArray[1] = object;
            }
        }
        finally {
            this.dbManager.closeConnection(connection);
        }
        if (n2 > 0) {
            objectArray[0] = PageUtils.getPageHTMLStr(n2, n, 15, 0);
        }
        return objectArray;
    }
}

