/*
 * Decompiled with CFR 0.152.
 */
package com.hongshee.ejforum.data;

import com.hongshee.common.util.MyLogger;
import com.hongshee.ejforum.common.AppContext;
import com.hongshee.ejforum.common.CacheManager;
import com.hongshee.ejforum.data.BoardDAO;
import com.hongshee.ejforum.data.EntityDAO;
import com.hongshee.ejforum.data.SectionDAO;
import com.hongshee.ejforum.util.AppUtils;
import com.hongshee.ejforum.util.PageUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatDAO
extends EntityDAO {
    private static Logger a = MyLogger.getLogger(StatDAO.class.getName());
    private static StatDAO b = null;
    private HashMap<String, String> c = new HashMap();
    private Hashtable<String, Integer> d = new Hashtable();

    private StatDAO() {
    }

    public static synchronized StatDAO getInstance() {
        if (b == null) {
            b = new StatDAO();
        }
        return b;
    }

    public HashMap<String, String> getBaseStatInfo() {
        if (this.c.size() == 0) {
            try {
                this.statVisits();
            }
            catch (Exception exception) {
                a.log(Level.SEVERE, exception.getMessage(), exception);
                AppUtils.sendMail2Admin("Error at getting base stat info", exception.toString());
            }
        }
        return this.c;
    }

    public synchronized void increaseFeedVisits(String string) {
        Integer n = this.d.get(string);
        n = n == null ? Integer.valueOf(1) : Integer.valueOf(n + 1);
        this.d.put(string, n);
    }

    public void addFeedVisits() throws SQLException {
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        Connection connection = this.dbManager.getConnection();
        try {
            HashSet<String> hashSet = this.a(connection);
            Iterator<Map.Entry<String, Integer>> iterator = this.d.entrySet().iterator();
            Map.Entry<String, Integer> entry = null;
            preparedStatement2 = connection.prepareStatement(this.adapter.FeedStat_AddVisits);
            preparedStatement = connection.prepareStatement(this.adapter.FeedStat_Insert);
            while (iterator.hasNext()) {
                entry = iterator.next();
                if (hashSet.contains(entry.getKey())) {
                    preparedStatement2.setInt(1, entry.getValue());
                    preparedStatement2.setString(2, entry.getKey());
                    preparedStatement2.addBatch();
                    continue;
                }
                preparedStatement.setString(1, entry.getKey());
                preparedStatement.setInt(2, entry.getValue());
                preparedStatement.addBatch();
            }
            preparedStatement2.executeBatch();
            preparedStatement.executeBatch();
            this.d.clear();
        }
        catch (Throwable throwable) {
            this.dbManager.closePStatement(preparedStatement);
            this.dbManager.closePStatement(preparedStatement2);
            this.dbManager.closeConnection(connection);
            throw throwable;
        }
        this.dbManager.closePStatement(preparedStatement);
        this.dbManager.closePStatement(preparedStatement2);
        this.dbManager.closeConnection(connection);
    }

    private HashSet<String> a(Connection object) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = object.prepareStatement(this.adapter.FeedStat_SelectAll);
            resultSet = preparedStatement.executeQuery();
            object = new HashSet();
            while (resultSet.next()) {
                ((HashSet)object).add(resultSet.getString(1));
            }
            this.dbManager.closeResultSet(resultSet);
            this.dbManager.closePStatement(preparedStatement);
            return object;
        }
        catch (Throwable throwable) {
            this.dbManager.closeResultSet(resultSet);
            this.dbManager.closePStatement(preparedStatement);
            throw throwable;
        }
    }

    public void statVisits() throws SQLException {
        int n = 0;
        ArrayList<HashMap> arrayList = this.getAdminUsersInfo();
        if (arrayList != null) {
            n = arrayList.size();
        }
        arrayList = null;
        Connection connection = this.dbManager.getConnection();
        try {
            int n2;
            int n3;
            int n4;
            CacheManager cacheManager = CacheManager.getInstance();
            Object object = null;
            object = null;
            int n5 = 0;
            ArrayList<HashMap> arrayList2 = this.execSelectSql(this.adapter.VisitStat_GetImageTopics, null, connection);
            if (arrayList2 != null) {
                n4 = 0;
                while (n4 < arrayList2.size()) {
                    object = (String)arrayList2.get(n4).get("SECTIONID");
                    if ((object = cacheManager.getSection(Integer.parseInt((String)object))) != null) {
                        ((SectionDAO.SectionVO)object).imageTopics = (String)arrayList2.get(n4).get("CT");
                        n5 += Integer.parseInt(((SectionDAO.SectionVO)object).imageTopics);
                    }
                    ++n4;
                }
            }
            n4 = 0;
            arrayList2 = this.execSelectSql(this.adapter.VisitStat_GetDigestTopics, null, connection);
            if (arrayList2 != null) {
                n3 = 0;
                while (n3 < arrayList2.size()) {
                    object = (String)arrayList2.get(n3).get("SECTIONID");
                    if ((object = cacheManager.getSection(Integer.parseInt((String)object))) != null) {
                        ((SectionDAO.SectionVO)object).digestTopics = (String)arrayList2.get(n3).get("CT");
                        n4 += Integer.parseInt(((SectionDAO.SectionVO)object).digestTopics);
                    }
                    ++n3;
                }
            }
            n3 = 0;
            arrayList2 = this.execSelectSql(this.adapter.VisitStat_GetRewardTopics, null, connection);
            if (arrayList2 != null) {
                n2 = 0;
                while (n2 < arrayList2.size()) {
                    object = (String)arrayList2.get(n2).get("SECTIONID");
                    if ((object = cacheManager.getSection(Integer.parseInt((String)object))) != null) {
                        ((SectionDAO.SectionVO)object).rewardTopics = (String)arrayList2.get(n2).get("CT");
                        n3 += Integer.parseInt(((SectionDAO.SectionVO)object).rewardTopics);
                    }
                    ++n2;
                }
            }
            n2 = this.execSelectCountSql(this.adapter.VisitStat_GetVoteTopics, null, connection);
            int n6 = this.execSelectCountSql(this.adapter.VisitStat_GetPostUsers, null, connection);
            int n7 = this.execSelectCountSql(this.adapter.VisitStat_GetUserLogins, null, connection);
            int n8 = this.execSelectCountSql(this.adapter.VisitStat_GetAttaches, null, connection);
            int n9 = this.execSelectCountSql(this.adapter.VisitStat_GetUserCredits, null, connection);
            int n10 = this.execSelectCountSql(this.adapter.VisitStat_GetShortMsgs, null, connection);
            int n11 = this.execSelectCountSql(this.adapter.VisitStat_GetBookmarks, null, connection);
            int n12 = this.execSelectCountSql(this.adapter.VisitStat_GetFriends, null, connection);
            int n13 = 0;
            int n14 = 0;
            BoardDAO.BoardVO boardVO = null;
            ArrayList<SectionDAO.SectionVO> arrayList3 = cacheManager.getSections();
            int n15 = 0;
            while (n15 < arrayList3.size()) {
                object = arrayList3.get(n15);
                n13 += ((SectionDAO.SectionVO)object).boardList.size();
                int n16 = 0;
                while (n16 < ((SectionDAO.SectionVO)object).boardList.size()) {
                    boardVO = ((SectionDAO.SectionVO)object).boardList.get(n16);
                    if (boardVO.isCatOK == 'T' && boardVO.catList != null) {
                        n14 += boardVO.catList.size();
                    }
                    ++n16;
                }
                ++n15;
            }
            this.c.put("images", String.valueOf(n5));
            this.c.put("votes", String.valueOf(n2));
            this.c.put("digests", String.valueOf(n4));
            this.c.put("rewards", String.valueOf(n3));
            this.c.put("postUsers", String.valueOf(n6));
            this.c.put("adminUsers", String.valueOf(n));
            this.c.put("userLogins", String.valueOf(n7));
            this.c.put("attaches", String.valueOf(n8));
            this.c.put("boards", String.valueOf(n13));
            this.c.put("cats", String.valueOf(n14));
            this.c.put("credits", String.valueOf(n9));
            this.c.put("msgs", String.valueOf(n10));
            this.c.put("bookmarks", String.valueOf(n11));
            this.c.put("friends", String.valueOf(n12));
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -1);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String string = simpleDateFormat.format(calendar.getTime());
            int n17 = this.execSelectCountSql(this.adapter.VisitStat_GetTopicVisits, null, connection);
            n5 = this.execSelectCountSql(this.adapter.VisitStat_GetTopics, null, connection);
            n6 = this.execSelectCountSql(this.adapter.VisitStat_GetReplies, null, connection);
            n4 = this.execSelectCountSql(this.adapter.VisitStat_GetUsers, null, connection);
            this.c.put("visits", String.valueOf(n17));
            this.c.put("topics", String.valueOf(n5));
            this.c.put("replies", String.valueOf(n6));
            this.c.put("users", String.valueOf(n4));
            this.c.put("statTime", AppUtils.getCurrentTimeStr());
            ArrayList<Object> arrayList4 = new ArrayList<Object>();
            arrayList4.add(string);
            this.execUpdateSql(this.adapter.VisitStat_Delete, arrayList4, connection);
            arrayList = connection.prepareStatement(this.adapter.VisitStat_Insert);
            arrayList.setString(1, string);
            arrayList.setInt(2, n5);
            arrayList.setInt(3, n6);
            arrayList.setInt(4, n4);
            arrayList.setInt(5, n17);
            arrayList.executeUpdate();
            ArrayList<HashMap> arrayList5 = this.execSelectSql(this.adapter.VisitStat_TopVisitsSections, null, connection);
            if (arrayList5 != null) {
                int n18 = 0;
                while (n18 < arrayList5.size()) {
                    Object object2 = (String)arrayList5.get(n18).get("SECTIONID");
                    if ((object2 = cacheManager.getSection(Integer.parseInt((String)object2))) != null) {
                        ((SectionDAO.SectionVO)object2).topics = Integer.parseInt((String)arrayList5.get(n18).get("TOPICS"));
                        ((SectionDAO.SectionVO)object2).replies = Integer.parseInt((String)arrayList5.get(n18).get("REPLIES"));
                        ((SectionDAO.SectionVO)object2).visits = Integer.parseInt((String)arrayList5.get(n18).get("VISITS"));
                    }
                    ++n18;
                }
            }
        }
        catch (Throwable throwable) {
            this.dbManager.closePStatement((PreparedStatement)((Object)arrayList));
            this.dbManager.closeConnection(connection);
            throw throwable;
        }
        this.dbManager.closePStatement((PreparedStatement)((Object)arrayList));
        this.dbManager.closeConnection(connection);
    }

    public Object[] getVisitStatInfo(int n, int n2) throws SQLException {
        Object[] objectArray = new Object[3];
        String string = this.adapter.VisitStat_GetList;
        HashMap<String, String> hashMap = this.adapter.VisitStat_GetMonths;
        int n3 = 0;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbManager.getConnection();
            preparedStatement = connection.prepareStatement((String)((Object)hashMap));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ++n3;
            }
            if (n3 > 0) {
                this.dbManager.closeResultSet(resultSet);
                this.dbManager.closePStatement(preparedStatement);
                preparedStatement = connection.prepareStatement(string);
                resultSet = preparedStatement.executeQuery();
                int n4 = (n3 - 1) / n2 + 1;
                if (n > n4 || n == 999) {
                    n = n4;
                }
                ArrayList<HashMap<String, String>> arrayList = new ArrayList();
                hashMap = null;
                int[] nArray = new int[4];
                int n5 = (n - 1) * n2;
                int n6 = 0;
                while (resultSet.next()) {
                    if (++n6 < n5 || n6 > n5 + n2) continue;
                    if (n6 == n5) {
                        nArray[0] = resultSet.getInt("tc");
                        nArray[1] = resultSet.getInt("rc");
                        nArray[2] = resultSet.getInt("uc");
                        nArray[3] = resultSet.getInt("vc");
                        continue;
                    }
                    hashMap = new HashMap();
                    if (n6 == 1) {
                        nArray[0] = 0;
                        nArray[1] = 0;
                        nArray[2] = 0;
                        nArray[3] = 0;
                    }
                    hashMap.put("statMonth", resultSet.getString("ym"));
                    hashMap.put("topics", (String)((Object)Integer.valueOf(resultSet.getInt("tc") - nArray[0])));
                    hashMap.put("replies", (String)((Object)Integer.valueOf(resultSet.getInt("rc") - nArray[1])));
                    hashMap.put("users", (String)((Object)Integer.valueOf(resultSet.getInt("uc") - nArray[2])));
                    hashMap.put("visits", (String)((Object)Integer.valueOf(resultSet.getInt("vc") - nArray[3])));
                    arrayList.add(hashMap);
                    nArray[0] = resultSet.getInt("tc");
                    nArray[1] = resultSet.getInt("rc");
                    nArray[2] = resultSet.getInt("uc");
                    nArray[3] = resultSet.getInt("vc");
                }
                objectArray[1] = arrayList;
                arrayList = this.adapter.VisitStat_GetLatestDays;
                arrayList = this.adapter.getPageQuerySql(new StringBuilder((String)((Object)arrayList)), 1, 11, 11);
                ArrayList<HashMap> arrayList2 = this.execSelectSql((String)((Object)arrayList), null, connection);
                arrayList = new ArrayList<HashMap<String, String>>();
                if (arrayList2 != null && arrayList2.size() > 0) {
                    HashMap hashMap2 = arrayList2.get(arrayList2.size() - 1);
                    nArray[0] = Integer.parseInt((String)hashMap2.get("TOPICS"));
                    nArray[1] = Integer.parseInt((String)hashMap2.get("REPLIES"));
                    nArray[2] = Integer.parseInt((String)hashMap2.get("USERS"));
                    nArray[3] = Integer.parseInt((String)hashMap2.get("VISITS"));
                    if (arrayList2.size() < 11) {
                        hashMap = new HashMap<String, String>();
                        hashMap.put("statDate", (String)hashMap2.get("STATDATE"));
                        hashMap.put("topics", (String)((Object)Integer.valueOf(nArray[0])));
                        hashMap.put("replies", (String)((Object)Integer.valueOf(nArray[1])));
                        hashMap.put("users", (String)((Object)Integer.valueOf(nArray[2])));
                        hashMap.put("visits", (String)((Object)Integer.valueOf(nArray[3])));
                        arrayList.add(hashMap);
                    }
                    int n7 = arrayList2.size() - 2;
                    while (n7 >= 0) {
                        hashMap2 = arrayList2.get(n7);
                        hashMap = new HashMap<String, String>();
                        hashMap.put("statDate", (String)hashMap2.get("STATDATE"));
                        hashMap.put("topics", (String)((Object)Integer.valueOf(Integer.parseInt((String)hashMap2.get("TOPICS")) - nArray[0])));
                        hashMap.put("replies", (String)((Object)Integer.valueOf(Integer.parseInt((String)hashMap2.get("REPLIES")) - nArray[1])));
                        hashMap.put("users", (String)((Object)Integer.valueOf(Integer.parseInt((String)hashMap2.get("USERS")) - nArray[2])));
                        hashMap.put("visits", (String)((Object)Integer.valueOf(Integer.parseInt((String)hashMap2.get("VISITS")) - nArray[3])));
                        arrayList.add(hashMap);
                        nArray[0] = Integer.parseInt((String)hashMap2.get("TOPICS"));
                        nArray[1] = Integer.parseInt((String)hashMap2.get("REPLIES"));
                        nArray[2] = Integer.parseInt((String)hashMap2.get("USERS"));
                        nArray[3] = Integer.parseInt((String)hashMap2.get("VISITS"));
                        --n7;
                    }
                }
                objectArray[2] = arrayList;
            }
        }
        catch (Throwable throwable) {
            this.dbManager.closeResultSet(resultSet);
            this.dbManager.closePStatement(preparedStatement);
            this.dbManager.closeConnection(connection);
            throw throwable;
        }
        this.dbManager.closeResultSet(resultSet);
        this.dbManager.closePStatement(preparedStatement);
        this.dbManager.closeConnection(connection);
        if (n3 > 0) {
            int n8 = (n3 - 1) / n2 + 1;
            if (n8 <= 1) {
                return objectArray;
            }
            objectArray[0] = PageUtils.getPageHTMLStr(n3, n, n2, 0);
        }
        return objectArray;
    }

    public Object[] getTopBoardsInfo(int n) throws SQLException {
        Object[] objectArray = new Object[4];
        CacheManager cacheManager = CacheManager.getInstance();
        Cloneable cloneable = cacheManager.getSections();
        ArrayList<HashMap> arrayList = new ArrayList();
        Object object = new ArrayList<BoardDAO.BoardVO>();
        SectionDAO.SectionVO sectionVO = null;
        BoardDAO.BoardVO boardVO = null;
        int n2 = 0;
        while (n2 < ((ArrayList)cloneable).size()) {
            sectionVO = ((ArrayList)cloneable).get(n2);
            if (n <= 0 || n >= 999 || n == sectionVO.sectionID) {
                int n3 = 0;
                while (n3 < sectionVO.boardList.size()) {
                    boardVO = sectionVO.boardList.get(n3);
                    int n4 = 0;
                    while (n4 < arrayList.size()) {
                        if (boardVO.topics >= ((BoardDAO.BoardVO)arrayList.get((int)n4)).topics) break;
                        ++n4;
                    }
                    arrayList.add(n4, (HashMap)((Object)boardVO));
                    n4 = 0;
                    while (n4 < ((ArrayList)object).size()) {
                        if (boardVO.posts - boardVO.topics >= ((BoardDAO.BoardVO)((ArrayList)object).get((int)n4)).posts - ((BoardDAO.BoardVO)((ArrayList)object).get((int)n4)).topics) break;
                        ++n4;
                    }
                    ((ArrayList)object).add(n4, boardVO);
                    ++n3;
                }
            }
            ++n2;
        }
        objectArray[0] = arrayList;
        objectArray[1] = object;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            block17: {
                cloneable = Calendar.getInstance();
                ((Calendar)cloneable).add(5, -30);
                arrayList = this.adapter.VisitStat_TopVisitsBoards;
                if (n > 0 && n < 999) {
                    arrayList = AppUtils.replaceStr(arrayList, "'R'", "'R' and sectionID=" + n);
                }
                if ((arrayList = this.execSelectSql((String)((Object)arrayList), null, connection = this.dbManager.getConnection())) != null) {
                    object = null;
                    int n5 = 0;
                    while (n5 < arrayList.size()) {
                        object = (String)((HashMap)arrayList.get(n5)).get("BOARDID");
                        boardVO = cacheManager.getBoard(Integer.parseInt((String)object));
                        if (boardVO != null) {
                            boardVO.visits = Integer.parseInt((String)((HashMap)arrayList.get(n5)).get("CT"));
                        }
                        ++n5;
                    }
                }
                arrayList = this.adapter.VisitStat_30DaysTopBoards;
                if (n > 0 && n < 999) {
                    arrayList = AppUtils.replaceStr((String)((Object)arrayList), "'R'", "'R' and sectionID=" + n);
                }
                preparedStatement = connection.prepareStatement((String)((Object)arrayList));
                preparedStatement.setDate(1, new Date(((Calendar)cloneable).getTimeInMillis()));
                resultSet = preparedStatement.executeQuery();
                object = new ArrayList();
                HashMap<String, Object> hashMap = null;
                while (resultSet.next()) {
                    boardVO = cacheManager.getBoard(resultSet.getInt("boardID"));
                    if (boardVO == null) continue;
                    hashMap = new HashMap<String, Object>();
                    hashMap.put("sectionID", String.valueOf(boardVO.sectionID));
                    hashMap.put("boardID", String.valueOf(boardVO.boardID));
                    hashMap.put("boardName", boardVO.boardName);
                    hashMap.put("ct", resultSet.getString("ct"));
                    ((ArrayList)object).add(hashMap);
                }
                objectArray[2] = object;
                cloneable = new ArrayList();
                arrayList = this.execSelectSql(this.adapter.FeedStat_TopBoards, null, connection);
                if (arrayList == null) break block17;
                object = null;
                int n6 = 0;
                while (n6 < arrayList.size()) {
                    block19: {
                        block20: {
                            block18: {
                                object = (String)arrayList.get(n6).get("BOARDID");
                                if (((String)object).equals("hot") || ((String)object).equals("new")) break block18;
                                boardVO = cacheManager.getBoard(Integer.parseInt((String)object));
                                if (boardVO == null || n > 0 && n < 999 && n != boardVO.sectionID) break block19;
                                hashMap = new HashMap<String, String>();
                                hashMap.put("feedName", boardVO.boardName);
                                break block20;
                            }
                            if (n > 0 && n < 999) break block19;
                            hashMap = new HashMap<String, Object>();
                            hashMap.put("feedName", object);
                        }
                        hashMap.put("feedID", object);
                        hashMap.put("ct", (String)arrayList.get(n6).get("VISITS"));
                        ((ArrayList)cloneable).add(hashMap);
                    }
                    ++n6;
                }
            }
            objectArray[3] = cloneable;
        }
        catch (Throwable throwable) {
            this.dbManager.closeResultSet(resultSet);
            this.dbManager.closePStatement(preparedStatement);
            this.dbManager.closeConnection(connection);
            throw throwable;
        }
        this.dbManager.closeResultSet(resultSet);
        this.dbManager.closePStatement(preparedStatement);
        this.dbManager.closeConnection(connection);
        return objectArray;
    }

    public Object[] getTopCatsInfo(int n) throws SQLException {
        Object[] objectArray = new Object[3];
        Connection connection = null;
        try {
            String string = this.adapter.VisitStat_TopTopicsCats;
            if (n > 0 && n < 999) {
                string = AppUtils.replaceStr(string, "'R'", "'R' and sectionID=" + n);
            }
            string = this.adapter.getPageQuerySql(new StringBuilder(string), 1, 15, 15);
            connection = this.dbManager.getConnection();
            objectArray[0] = this.execSelectSql(string, null, connection);
            string = this.adapter.VisitStat_TopRepliesCats;
            if (n > 0 && n < 999) {
                string = AppUtils.replaceStr(string, "'R'", "'R' and sectionID=" + n);
            }
            string = this.adapter.getPageQuerySql(new StringBuilder(string), 1, 15, 15);
            objectArray[1] = this.execSelectSql(string, null, connection);
            string = this.adapter.VisitStat_TopVisitsCats;
            if (n > 0 && n < 999) {
                string = AppUtils.replaceStr(string, "'R'", "'R' and sectionID=" + n);
            }
            string = this.adapter.getPageQuerySql(new StringBuilder(string), 1, 15, 15);
            objectArray[2] = this.execSelectSql(string, null, connection);
        }
        catch (Throwable throwable) {
            this.dbManager.closeConnection(connection);
            throw throwable;
        }
        this.dbManager.closeConnection(connection);
        return objectArray;
    }

    public ArrayList<HashMap> getHotCatsInfo(int n, int n2) throws SQLException {
        String string = ((StatDAO)((Object)arrayList)).adapter.VisitStat_TopVisitsCats;
        if (n2 > 0 && n2 < 999) {
            string = AppUtils.replaceStr(string, "'R'", "'R' and sectionID=" + n2);
        }
        string = ((StatDAO)((Object)arrayList)).adapter.getPageQuerySql(new StringBuilder(string), 1, n, n);
        ArrayList<HashMap> arrayList = ((EntityDAO)((Object)arrayList)).execSelectSql(string, null);
        return arrayList;
    }

    public Object[] getTopTopicsInfo(int n, int n2, int n3, boolean bl) throws SQLException {
        Object[] objectArray = new Object[7];
        int n4 = 0;
        Connection connection = null;
        try {
            Object object = this.adapter.VisitStat_GetTopics;
            if (n > 0 && n < 999) {
                object = String.valueOf(object) + " where sectionID=" + n;
            }
            connection = this.dbManager.getConnection();
            n4 = this.execSelectCountSql((String)object, null, connection);
            if (!bl) {
                Object object2 = Calendar.getInstance();
                ((Calendar)object2).add(5, -30);
                object = new SimpleDateFormat("yyyy-MM-dd");
                object2 = ((DateFormat)object).format(((Calendar)object2).getTime());
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(Date.valueOf((String)object2));
                object = this.adapter.VisitStat_30DaysTopVisitsTopics;
                if (n > 0 && n < 999) {
                    object = AppUtils.replaceStr((String)object, "'R'", "'R' and sectionID=" + n);
                }
                object = this.adapter.getPageQuerySql(new StringBuilder((String)object), 1, n3, n3);
                objectArray[1] = this.execSelectSql((String)object, arrayList, connection);
                object = this.adapter.VisitStat_30DaysTopRepliesTopics;
                if (n > 0 && n < 999) {
                    object = AppUtils.replaceStr((String)object, "'R'", "'R' and sectionID=" + n);
                }
                object = this.adapter.getPageQuerySql(new StringBuilder((String)object), 1, n3, n3);
                objectArray[2] = this.execSelectSql((String)object, arrayList, connection);
                object = this.adapter.VisitStat_30DaysTopDiggsTopics;
                if (n > 0 && n < 999) {
                    object = AppUtils.replaceStr((String)object, "'R'", "'R' and sectionID=" + n);
                }
                object = this.adapter.getPageQuerySql(new StringBuilder((String)object), 1, n3, n3);
                objectArray[3] = this.execSelectSql((String)object, arrayList, connection);
            }
            object = this.adapter.VisitStat_TopVisitsTopics;
            if (n > 0 && n < 999) {
                object = AppUtils.replaceStr((String)object, "'R'", "'R' and sectionID=" + n);
            }
            object = this.adapter.getPageQuerySql(new StringBuilder((String)object), n2, n3, n3);
            objectArray[4] = this.execSelectSql((String)object, null, connection);
            object = this.adapter.VisitStat_TopRepliesTopics;
            if (n > 0 && n < 999) {
                object = AppUtils.replaceStr((String)object, "'R'", "'R' and sectionID=" + n);
            }
            object = this.adapter.getPageQuerySql(new StringBuilder((String)object), n2, n3, n3);
            objectArray[5] = this.execSelectSql((String)object, null, connection);
            object = this.adapter.VisitStat_TopDiggsTopics;
            if (n > 0 && n < 999) {
                object = AppUtils.replaceStr((String)object, "'R'", "'R' and sectionID=" + n);
            }
            object = this.adapter.getPageQuerySql(new StringBuilder((String)object), n2, n3, n3);
            objectArray[6] = this.execSelectSql((String)object, null, connection);
        }
        catch (Throwable throwable) {
            this.dbManager.closeConnection(connection);
            throw throwable;
        }
        this.dbManager.closeConnection(connection);
        if (n4 > 0) {
            int n5 = (n4 - 1) / n3 + 1;
            if (n5 <= 1) {
                return objectArray;
            }
            objectArray[0] = PageUtils.getPageHTMLStr(n4, n2, n3, 0);
        }
        return objectArray;
    }

    public Object[] getTopUsersInfo() throws SQLException {
        Object[] objectArray = new Object[2];
        Connection connection = null;
        try {
            connection = this.dbManager.getConnection();
            String string = this.adapter.getPageQuerySql(new StringBuilder(this.adapter.VisitStat_TopCreditsUsers), 1, 15, 15);
            objectArray[0] = this.execSelectSql(string, null, connection);
            string = this.adapter.getPageQuerySql(new StringBuilder(this.adapter.VisitStat_TopPostsUsers), 1, 15, 15);
            objectArray[1] = this.execSelectSql(string, null, connection);
        }
        finally {
            this.dbManager.closeConnection(connection);
        }
        return objectArray;
    }

    public ArrayList<HashMap> getAdminUsersInfo() throws SQLException {
        String[] stringArray = CacheManager.getInstance().getModerators();
        stringArray = stringArray.split(",");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" (");
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].length() != 0) {
                if (stringBuilder.length() > 2) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("'").append(stringArray[n]).append("'");
            }
            ++n;
        }
        if (stringBuilder.length() == 2) {
            stringBuilder.append("'").append(AppContext.getInstance().getAdminUser()).append("'");
        }
        stringBuilder.append(")");
        String string = String.valueOf(this.adapter.VisitStat_AdminUsers) + stringBuilder.toString();
        return this.execSelectSql(string, null);
    }
}

