/*
 * Decompiled with CFR 0.152.
 */
package com.hongshee.ejforum.data;

import com.hongshee.common.util.DBManager;
import com.hongshee.ejforum.common.AppContext;
import com.hongshee.ejforum.data.SqlAdapter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityDAO {
    protected DBManager dbManager = DBManager.getInstance();
    protected SqlAdapter adapter = AppContext.getInstance().getSqlAdapter();
    protected String adapterName = this.adapter.getClass().getName();

    public void execUpdateSql(String string, ArrayList<Object> arrayList) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dbManager.getConnection();
            this.execUpdateSql(string, arrayList, connection);
        }
        finally {
            this.dbManager.closeConnection(connection);
        }
    }

    protected int execUpdateSql(String string, ArrayList<Object> arrayList, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            if (arrayList != null) {
                int n = 0;
                while (n < arrayList.size()) {
                    preparedStatement.setObject(n + 1, arrayList.get(n));
                    ++n;
                }
            }
            int n = preparedStatement.executeUpdate();
            return n;
        }
        finally {
            this.dbManager.closePStatement(preparedStatement);
        }
    }

    public ArrayList<HashMap> execSelectSql(String object, ArrayList<Object> arrayList) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dbManager.getConnection();
            object = this.execSelectSql((String)object, arrayList, connection);
            return object;
        }
        finally {
            this.dbManager.closeConnection(connection);
        }
    }

    protected ArrayList<HashMap> execSelectSql(String string, ArrayList<Object> arrayList, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            if (arrayList != null) {
                int n = 0;
                while (n < arrayList.size()) {
                    preparedStatement.setObject(n + 1, arrayList.get(n));
                    ++n;
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<HashMap> arrayList2 = new ArrayList<HashMap>();
            if (resultSet.next()) {
                this.fetchRsToList(resultSet, arrayList2);
            }
            this.dbManager.closeResultSet(resultSet);
            this.dbManager.closePStatement(preparedStatement);
            return arrayList2;
        }
        catch (Throwable throwable) {
            this.dbManager.closeResultSet(resultSet);
            this.dbManager.closePStatement(preparedStatement);
            throw throwable;
        }
    }

    protected int execSelectCountSql(String string, ArrayList<Object> arrayList, Connection connection) throws SQLException {
        int n = 0;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            if (arrayList != null) {
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    preparedStatement.setObject(n2 + 1, arrayList.get(n2));
                    ++n2;
                }
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                n = resultSet.getInt(1);
            }
            int n3 = n;
            this.dbManager.closeResultSet(resultSet);
            this.dbManager.closePStatement(preparedStatement);
            return n3;
        }
        catch (Throwable throwable) {
            this.dbManager.closeResultSet(resultSet);
            this.dbManager.closePStatement(preparedStatement);
            throw throwable;
        }
    }

    protected void fetchRsToList(ResultSet resultSet, ArrayList<HashMap> arrayList) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        String string = null;
        HashMap<String, String> hashMap = null;
        do {
            hashMap = new HashMap<String, String>();
            int n = 0;
            while (n < resultSetMetaData.getColumnCount()) {
                string = resultSetMetaData.getColumnName(n + 1);
                hashMap.put(string.toUpperCase(), resultSet.getString(n + 1));
                ++n;
            }
            arrayList.add(hashMap);
        } while (resultSet.next());
    }
}

