/*
 * Decompiled with CFR 0.152.
 */
package com.hongshee.ejforum.data;

import com.hongshee.ejforum.common.ForumSetting;
import com.hongshee.ejforum.data.EntityDAO;
import com.hongshee.ejforum.data.UserDAO;
import com.hongshee.ejforum.util.AppUtils;
import com.hongshee.ejforum.util.PageUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;

public class BookmarkDAO
extends EntityDAO {
    private static BookmarkDAO a = null;

    private BookmarkDAO() {
    }

    public static synchronized BookmarkDAO getInstance() {
        if (a == null) {
            a = new BookmarkDAO();
        }
        return a;
    }

    public String addBookmark(HttpServletRequest object, UserDAO.UserInfo userInfo) throws SQLException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            String string = PageUtils.getParam(object, "subject");
            string = AppUtils.replaceStr(string, "<", "&lt;");
            string = AppUtils.replaceStr(string, ">", "&gt;");
            connection = this.dbManager.getConnection();
            preparedStatement = connection.prepareStatement(this.adapter.Bookmark_Insert);
            preparedStatement.setString(1, userInfo.userID);
            preparedStatement.setString(2, PageUtils.getParam(object, "url"));
            preparedStatement.setString(3, string);
            preparedStatement.setString(4, PageUtils.getParam(object, "board"));
            preparedStatement.executeUpdate();
            object = PageUtils.OK;
            this.dbManager.closePStatement(preparedStatement);
            this.dbManager.closeConnection(connection);
            return object;
        }
        catch (Throwable throwable) {
            this.dbManager.closePStatement(preparedStatement);
            this.dbManager.closeConnection(connection);
            throw throwable;
        }
    }

    public Object[] getBookmarks(String string, int n, int n2) throws SQLException {
        Object[] objectArray = new Object[2];
        Object object = this.adapter.Bookmark_GetList;
        Object object2 = this.adapter.Bookmark_GetCount;
        int n3 = 0;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbManager.getConnection();
            preparedStatement = connection.prepareStatement((String)object2);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n3 = resultSet.getInt(1);
            }
            if (n3 > 0) {
                this.dbManager.closeResultSet(resultSet);
                this.dbManager.closePStatement(preparedStatement);
                object = this.adapter.getPageQuerySql(new StringBuilder((String)object), n, n2, n3);
                preparedStatement = connection.prepareStatement((String)object);
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                object = new ArrayList();
                object2 = null;
                while (resultSet.next()) {
                    object2 = new BookmarkVO();
                    new BookmarkVO().userID = string;
                    ((BookmarkVO)object2).markID = resultSet.getString("markID");
                    ((BookmarkVO)object2).url = resultSet.getString("url");
                    ((BookmarkVO)object2).title = resultSet.getString("title");
                    ((BookmarkVO)object2).boardName = resultSet.getString("boardName");
                    ((BookmarkVO)object2).createTime = AppUtils.formatSQLTimeStr(resultSet.getTimestamp("createTime"));
                    ((ArrayList)object).add(object2);
                }
                objectArray[1] = object;
            }
        }
        catch (Throwable throwable) {
            this.dbManager.closeResultSet(resultSet);
            this.dbManager.closePStatement(preparedStatement);
            this.dbManager.closeConnection(connection);
            throw throwable;
        }
        this.dbManager.closeResultSet(resultSet);
        this.dbManager.closePStatement(preparedStatement);
        this.dbManager.closeConnection(connection);
        if (n3 > 0) {
            int n4 = (n3 - 1) / n2 + 1;
            if (n4 <= 1) {
                return objectArray;
            }
            objectArray[0] = PageUtils.getPageHTMLStr(n3, n, n2, 0);
        }
        return objectArray;
    }

    public void deleteBookmarks(HttpServletRequest stringArray) throws SQLException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            stringArray = stringArray.getParameterValues("markID");
            connection = this.dbManager.getConnection();
            preparedStatement = connection.prepareStatement(this.adapter.Bookmark_Delete);
            int n = 0;
            while (n < stringArray.length) {
                preparedStatement.setString(1, stringArray[n]);
                preparedStatement.addBatch();
                ++n;
            }
            preparedStatement.executeBatch();
        }
        catch (Throwable throwable) {
            this.dbManager.closePStatement(preparedStatement);
            this.dbManager.closeConnection(connection);
            throw throwable;
        }
        this.dbManager.closePStatement(preparedStatement);
        this.dbManager.closeConnection(connection);
    }

    public void cleanOverflowMarks() throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block8: {
            connection = null;
            preparedStatement = null;
            resultSet = null;
            try {
                int n = ForumSetting.getInstance().getInt(0, "maxFavorites");
                connection = this.dbManager.getConnection();
                preparedStatement = connection.prepareStatement(this.adapter.Bookmark_StatUserCount);
                resultSet = preparedStatement.executeQuery();
                ArrayList<String> arrayList = null;
                while (resultSet.next()) {
                    if (resultSet.getInt("ct") <= n) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                    }
                    arrayList.add(resultSet.getString("userID"));
                }
                if (arrayList == null) break block8;
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    Connection connection2 = connection;
                    int n3 = n;
                    String string = (String)arrayList.get(n2);
                    BookmarkDAO bookmarkDAO = this;
                    PreparedStatement preparedStatement2 = null;
                    PreparedStatement preparedStatement3 = null;
                    ResultSet resultSet2 = null;
                    try {
                        int n4 = n3 /= 2;
                        String string2 = bookmarkDAO.adapter.getPageQuerySql(new StringBuilder(bookmarkDAO.adapter.Bookmark_getOverflow), n4, 1, n3);
                        preparedStatement2 = connection2.prepareStatement(string2);
                        preparedStatement2.setString(1, string);
                        resultSet2 = preparedStatement2.executeQuery();
                        if (resultSet2.next() && (string2 = resultSet2.getString(1)) != null && string2.length() > 0) {
                            preparedStatement3 = connection2.prepareStatement(bookmarkDAO.adapter.Bookmark_cleanOverflow);
                            preparedStatement3.setString(1, string);
                            preparedStatement3.setString(2, string2);
                            preparedStatement3.executeUpdate();
                        }
                    }
                    catch (Throwable throwable) {
                        bookmarkDAO.dbManager.closeResultSet(resultSet2);
                        bookmarkDAO.dbManager.closePStatement(preparedStatement2);
                        bookmarkDAO.dbManager.closePStatement(preparedStatement3);
                        throw throwable;
                    }
                    bookmarkDAO.dbManager.closeResultSet(resultSet2);
                    bookmarkDAO.dbManager.closePStatement(preparedStatement2);
                    bookmarkDAO.dbManager.closePStatement(preparedStatement3);
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                this.dbManager.closeResultSet(resultSet);
                this.dbManager.closePStatement(preparedStatement);
                this.dbManager.closeConnection(connection);
                throw throwable;
            }
        }
        this.dbManager.closeResultSet(resultSet);
        this.dbManager.closePStatement(preparedStatement);
        this.dbManager.closeConnection(connection);
    }

    public static class BookmarkVO {
        public String markID = null;
        public String userID = null;
        public String url = null;
        public String title = null;
        public String boardName = null;
        public String createTime = null;
    }
}

