/*
 * Decompiled with CFR 0.152.
 */
package com.hongshee.ejforum.data;

import com.hongshee.ejforum.common.AppContext;
import com.hongshee.ejforum.common.AppException;
import com.hongshee.ejforum.common.ForumSetting;
import com.hongshee.ejforum.data.ActionLogDAO;
import com.hongshee.ejforum.data.EntityDAO;
import com.hongshee.ejforum.data.GroupDAO;
import com.hongshee.ejforum.data.UserDAO;
import com.hongshee.ejforum.util.AppUtils;
import com.hongshee.ejforum.util.MyFileUpload;
import com.hongshee.ejforum.util.PageUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachDAO
extends EntityDAO {
    private static AttachDAO a = null;

    private AttachDAO() {
    }

    public static synchronized AttachDAO getInstance() {
        if (a == null) {
            a = new AttachDAO();
        }
        return a;
    }

    public void addAttaches(ArrayList<MyFileUpload.UploadVO> arrayList, String string, int n, int n2, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            MyFileUpload.UploadVO uploadVO = null;
            preparedStatement = connection.prepareStatement(this.adapter.Attach_Insert);
            int n3 = 0;
            while (n3 < arrayList.size()) {
                uploadVO = arrayList.get(n3);
                preparedStatement.setInt(1, n);
                preparedStatement.setInt(2, n2);
                preparedStatement.setString(3, string);
                preparedStatement.setString(4, uploadVO.localname);
                preparedStatement.setString(5, uploadVO.localID);
                preparedStatement.setString(6, uploadVO.filename);
                preparedStatement.setLong(7, uploadVO.filesize);
                preparedStatement.setInt(8, uploadVO.credits);
                preparedStatement.setString(9, uploadVO.title);
                preparedStatement.setString(10, String.valueOf(uploadVO.state));
                preparedStatement.addBatch();
                ++n3;
            }
            preparedStatement.executeBatch();
        }
        catch (Throwable throwable) {
            this.dbManager.closePStatement(preparedStatement);
            throw throwable;
        }
        this.dbManager.closePStatement(preparedStatement);
    }

    public void updateAttaches(ArrayList<MyFileUpload.UploadVO> arrayList, String string, int n, int n2, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            MyFileUpload.UploadVO uploadVO = null;
            ArrayList<MyFileUpload.UploadVO> arrayList2 = null;
            ArrayList<MyFileUpload.UploadVO> arrayList3 = null;
            if (arrayList != null) {
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    uploadVO = arrayList.get(n3);
                    if (uploadVO.attachID != null && uploadVO.attachID.length() > 0) {
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList<MyFileUpload.UploadVO>();
                        }
                        arrayList3.add(uploadVO);
                    } else {
                        if (arrayList2 == null) {
                            arrayList2 = new ArrayList<MyFileUpload.UploadVO>();
                        }
                        arrayList2.add(uploadVO);
                    }
                    ++n3;
                }
            }
            ArrayList<Object> arrayList4 = new ArrayList<Object>();
            arrayList4.add(n);
            arrayList4.add(n2);
            this.execUpdateSql(this.adapter.Attach_RemoveByPost, arrayList4, connection);
            if (arrayList2 != null && arrayList2.size() > 0) {
                this.addAttaches(arrayList2, string, n, n2, connection);
            }
            if (arrayList3 != null && arrayList3.size() > 0) {
                preparedStatement = connection.prepareStatement(this.adapter.Attach_Update);
                int n4 = 0;
                while (n4 < arrayList3.size()) {
                    uploadVO = (MyFileUpload.UploadVO)arrayList3.get(n4);
                    preparedStatement.setInt(1, uploadVO.credits);
                    preparedStatement.setString(2, uploadVO.title);
                    preparedStatement.setString(3, String.valueOf(uploadVO.state));
                    preparedStatement.setString(4, uploadVO.attachID);
                    preparedStatement.addBatch();
                    ++n4;
                }
                preparedStatement.executeBatch();
            }
        }
        finally {
            this.dbManager.closePStatement(preparedStatement);
        }
    }

    public ArrayList<AttachVO> getAttaches(int n, Connection object) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = object.prepareStatement(this.adapter.Attach_GetList);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            object = null;
            if (resultSet.next()) {
                object = new ArrayList();
                AttachVO attachVO = null;
                do {
                    attachVO = new AttachVO();
                    new AttachVO().topicID = n;
                    attachVO.replyID = resultSet.getInt("replyID");
                    attachVO.attachID = resultSet.getInt("attachID");
                    attachVO.localID = resultSet.getString("localID");
                    attachVO.filename = resultSet.getString("filename");
                    attachVO.filesize = resultSet.getInt("filesize");
                    attachVO.credits = resultSet.getInt("credits");
                    attachVO.title = resultSet.getString("title");
                    attachVO.downloads = resultSet.getInt("downloads");
                    attachVO.createTime = AppUtils.formatSQLTimeStr(resultSet.getTimestamp("createTime"));
                    ((ArrayList)object).add(attachVO);
                } while (resultSet.next());
            }
            Connection connection = object;
            this.dbManager.closeResultSet(resultSet);
            this.dbManager.closePStatement(preparedStatement);
            return connection;
        }
        catch (Throwable throwable) {
            this.dbManager.closeResultSet(resultSet);
            this.dbManager.closePStatement(preparedStatement);
            throw throwable;
        }
    }

    public ArrayList<AttachVO> getAttaches(int n, int n2, Connection object) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = object.prepareStatement(this.adapter.Attach_GetPostList);
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            resultSet = preparedStatement.executeQuery();
            object = null;
            if (resultSet.next()) {
                object = new ArrayList();
                AttachVO attachVO = null;
                do {
                    attachVO = new AttachVO();
                    new AttachVO().topicID = n;
                    attachVO.replyID = n2;
                    attachVO.attachID = resultSet.getInt("attachID");
                    attachVO.localID = resultSet.getString("localID");
                    attachVO.localname = resultSet.getString("localname");
                    attachVO.filename = resultSet.getString("filename");
                    attachVO.filesize = resultSet.getInt("filesize");
                    attachVO.credits = resultSet.getInt("credits");
                    attachVO.title = resultSet.getString("title");
                    attachVO.downloads = resultSet.getInt("downloads");
                    attachVO.state = resultSet.getString("state").charAt(0);
                    attachVO.createTime = AppUtils.formatSQLTimeStr(resultSet.getTimestamp("createTime"));
                    ((ArrayList)object).add(attachVO);
                } while (resultSet.next());
            }
            Connection connection = object;
            this.dbManager.closeResultSet(resultSet);
            this.dbManager.closePStatement(preparedStatement);
            return connection;
        }
        catch (Throwable throwable) {
            this.dbManager.closeResultSet(resultSet);
            this.dbManager.closePStatement(preparedStatement);
            throw throwable;
        }
    }

    public String[] downloadAttach(int n, HttpServletRequest stringArray) throws Exception {
        Connection connection = this.dbManager.getConnection();
        try {
            AttachVO attachVO = this.getAttach(n, connection);
            if (attachVO == null) {
                throw new AppException("\u6b64\u9644\u4ef6\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002");
            }
            HttpSession httpSession = stringArray.getSession();
            String string = (String)httpSession.getAttribute("attachIDs");
            if (string == null || !string.contains("," + n + ",")) {
                stringArray = PageUtils.getSessionUser((HttpServletRequest)stringArray);
                ArrayList<Object> arrayList = PageUtils.getGroupVO((UserDAO.UserInfo)stringArray);
                if (((GroupDAO.GroupVO)((Object)arrayList)).rights.indexOf(74) < 0) {
                    throw new AppException("\u60a8\u6ca1\u6709\u4e0b\u8f7d\u9644\u4ef6\u7684\u6743\u9650\u3002");
                }
                if (stringArray == null || !stringArray.userID.equalsIgnoreCase(attachVO.userID)) {
                    if (attachVO.credits <= 0) {
                        attachVO.credits = Math.abs(ForumSetting.getInstance().getInt(6, "download"));
                    }
                    if (attachVO.credits > 0) {
                        if (stringArray == null || stringArray.credits < attachVO.credits) {
                            throw new AppException("\u60a8\u7684\u79ef\u5206\u503c\u4e0d\u591f\uff0c\u4e0d\u80fd\u4e0b\u8f7d\u6b64\u9644\u4ef6\u3002");
                        }
                        arrayList = new ArrayList<Object>();
                        arrayList.add(attachVO.credits);
                        arrayList.add(attachVO.userID);
                        this.execUpdateSql(this.adapter.User_IncCredits, arrayList, connection);
                        arrayList.clear();
                        arrayList.add(attachVO.credits);
                        arrayList.add(stringArray.userID);
                        this.execUpdateSql(this.adapter.User_DecCredits, arrayList, connection);
                        stringArray.credits -= attachVO.credits;
                        ActionLogDAO.getInstance().addCreditsLog(stringArray.userID, attachVO.userID, attachVO.credits, "\u4e0b\u8f7d\u9644\u4ef6", connection);
                    }
                    arrayList = new ArrayList<Integer>();
                    arrayList.add(n);
                    this.execUpdateSql(this.adapter.Attach_IncDownloads, arrayList, connection);
                    if (string == null) {
                        httpSession.setAttribute("attachIDs", (Object)("," + n + ","));
                    } else {
                        httpSession.setAttribute("attachIDs", (Object)(String.valueOf(string) + n + ","));
                    }
                }
            }
            String[] stringArray2 = new String[2];
            stringArray = stringArray2;
            stringArray2[0] = attachVO.filename;
            stringArray[1] = attachVO.localname;
            String[] stringArray3 = stringArray;
            return stringArray3;
        }
        finally {
            this.dbManager.closeConnection(connection);
        }
    }

    public AttachVO getAttach(int n, Connection object) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = object.prepareStatement(this.adapter.Attach_Select);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            object = null;
            if (resultSet.next()) {
                object = new AttachVO();
                new AttachVO().attachID = n;
                ((AttachVO)object).userID = resultSet.getString("userID");
                ((AttachVO)object).filename = resultSet.getString("filename");
                ((AttachVO)object).localname = resultSet.getString("localname");
                ((AttachVO)object).credits = resultSet.getInt("credits");
                ((AttachVO)object).downloads = resultSet.getInt("downloads");
            }
            Connection connection = object;
            this.dbManager.closeResultSet(resultSet);
            this.dbManager.closePStatement(preparedStatement);
            return connection;
        }
        catch (Throwable throwable) {
            this.dbManager.closeResultSet(resultSet);
            this.dbManager.closePStatement(preparedStatement);
            throw throwable;
        }
    }

    public void cleanRecycledAttaches() throws SQLException {
        Object object = null;
        object = null;
        String string = String.valueOf(AppContext.getInstance().getRealPath()) + "upload/";
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        ResultSet resultSet = null;
        Connection connection = this.dbManager.getConnection();
        try {
            preparedStatement2 = connection.prepareStatement(this.adapter.Attach_delete);
            preparedStatement = connection.prepareStatement(this.adapter.Attach_GetRecycledList);
            preparedStatement.setObject(1, Date.valueOf(AppUtils.getCurrentDateStr()));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getString(2);
                try {
                    object = new File(String.valueOf(string) + (String)object);
                    if (!((File)object).exists() || !((File)object).delete()) continue;
                    preparedStatement2.setString(1, resultSet.getString(1));
                    preparedStatement2.addBatch();
                }
                catch (Exception exception) {}
            }
            preparedStatement2.executeBatch();
            this.cleanInvalidAvatars(connection);
            this.cleanInvalidAttaches(connection);
        }
        catch (Throwable throwable) {
            this.dbManager.closeResultSet(resultSet);
            this.dbManager.closePStatement(preparedStatement);
            this.dbManager.closePStatement(preparedStatement2);
            this.dbManager.closeConnection(connection);
            throw throwable;
        }
        this.dbManager.closeResultSet(resultSet);
        this.dbManager.closePStatement(preparedStatement);
        this.dbManager.closePStatement(preparedStatement2);
        this.dbManager.closeConnection(connection);
    }

    public void cleanInvalidAvatars(Connection object) throws SQLException {
        Object object2 = String.valueOf(AppContext.getInstance().getRealPath()) + "upload/avatar/";
        HashSet<String> hashSet = new HashSet<String>();
        File[] fileArray = null;
        File[] fileArray2 = null;
        try {
            fileArray = object.prepareStatement(((AttachDAO)object3).adapter.Attach_GetAvatarList);
            fileArray2 = fileArray.executeQuery();
            while (fileArray2.next()) {
                hashSet.add(fileArray2.getString(1));
            }
        }
        catch (Throwable throwable) {
            ((AttachDAO)object3).dbManager.closeResultSet((ResultSet)fileArray2);
            ((AttachDAO)object3).dbManager.closePStatement((PreparedStatement)fileArray);
            throw throwable;
        }
        ((AttachDAO)object3).dbManager.closeResultSet((ResultSet)fileArray2);
        ((AttachDAO)object3).dbManager.closePStatement((PreparedStatement)fileArray);
        object = null;
        Object object3 = null;
        object2 = new File((String)object2);
        fileArray = ((File)object2).listFiles();
        fileArray2 = null;
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                object3 = fileArray[n].getName();
                if (fileArray[n].isDirectory() && !((String)object3).startsWith("sample") && (fileArray2 = fileArray[n].listFiles()) != null) {
                    int n2 = 0;
                    while (n2 < fileArray2.length) {
                        object2 = fileArray2[n2];
                        if (!((File)object2).getName().equals("index.jsp")) {
                            object = String.valueOf(object3) + "/" + ((File)object2).getName();
                            try {
                                if (!hashSet.contains(object)) {
                                    ((File)object2).delete();
                                }
                            }
                            catch (Exception exception) {}
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    public void cleanInvalidAttaches(Connection object) throws SQLException {
        String string = String.valueOf(AppContext.getInstance().getRealPath()) + "upload/";
        HashSet<String> hashSet = new HashSet<String>();
        Object object2 = Calendar.getInstance();
        String string2 = String.valueOf(((Calendar)object2).get(1));
        int n = ((Calendar)object2).get(2) + 1;
        if (n <= 9) {
            string2 = String.valueOf(string2) + "0";
        }
        string2 = String.valueOf(string2) + String.valueOf(n);
        ((Calendar)object2).add(2, -1);
        String string3 = String.valueOf(((Calendar)object2).get(1));
        n = ((Calendar)object2).get(2) + 1;
        if (n <= 9) {
            string3 = String.valueOf(string3) + "0";
        }
        string3 = String.valueOf(string3) + String.valueOf(n);
        object2 = String.valueOf(String.valueOf(((Calendar)object2).get(1))) + "-" + string3.substring(4) + "-01";
        File[] fileArray = null;
        File[] fileArray2 = null;
        try {
            fileArray = object.prepareStatement(((AttachDAO)object3).adapter.Attach_Get2MonthList);
            fileArray.setObject(1, Date.valueOf((String)object2));
            fileArray2 = fileArray.executeQuery();
            while (fileArray2.next()) {
                hashSet.add(fileArray2.getString(1));
            }
        }
        catch (Throwable throwable) {
            ((AttachDAO)object3).dbManager.closeResultSet((ResultSet)fileArray2);
            ((AttachDAO)object3).dbManager.closePStatement((PreparedStatement)fileArray);
            throw throwable;
        }
        ((AttachDAO)object3).dbManager.closeResultSet((ResultSet)fileArray2);
        ((AttachDAO)object3).dbManager.closePStatement((PreparedStatement)fileArray);
        object = null;
        Object object3 = null;
        object2 = new File(string);
        fileArray = ((File)object2).listFiles();
        fileArray2 = null;
        if (fileArray != null) {
            File file = new File(String.valueOf(string) + "index.jsp");
            int n2 = 0;
            while (n2 < fileArray.length) {
                object3 = fileArray[n2].getName();
                if (fileArray[n2].isDirectory()) {
                    if (((String)object3).equals(string2) || ((String)object3).equals(string3)) {
                        fileArray2 = fileArray[n2].listFiles();
                        if (fileArray2 != null) {
                            int n3 = 0;
                            while (n3 < fileArray2.length) {
                                object2 = fileArray2[n3];
                                if (!((File)object2).getName().equals("index.jsp")) {
                                    object = String.valueOf(object3) + "/" + ((File)object2).getName();
                                    try {
                                        if (!hashSet.contains(object)) {
                                            ((File)object2).delete();
                                        }
                                    }
                                    catch (Exception exception) {}
                                }
                                ++n3;
                            }
                        }
                    } else if (!((String)object3).equals("avatar") && !((String)object3).equals("temp") && file.exists()) {
                        object = String.valueOf(string) + (String)object3 + "/index.jsp";
                        try {
                            object2 = new File((String)object);
                            if (!((File)object2).exists()) {
                                AppUtils.copyTo(file, (String)object);
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                ++n2;
            }
        }
    }

    private static String a(HttpServletRequest object, ArrayList<Object> arrayList) {
        StringBuilder stringBuilder = new StringBuilder(" where a.topicID = b.topicID");
        stringBuilder.append(" and a.state <> 'R' and b.state <> 'R'");
        Object object2 = PageUtils.getParam((HttpServletRequest)object, "boardID");
        if (object2 != null && ((String)object2).length() > 0 && !((String)object2).equals("all")) {
            stringBuilder.append(" and b.boardID=?");
            arrayList.add(object2);
        }
        if ((object2 = PageUtils.getParam((HttpServletRequest)object, "maxFilesize")) != null && ((String)object2).length() > 0) {
            try {
                Integer.parseInt((String)object2);
                stringBuilder.append(" and a.filesize<=?");
                arrayList.add(object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((object2 = PageUtils.getParam((HttpServletRequest)object, "minFilesize")) != null && ((String)object2).length() > 0) {
            try {
                Integer.parseInt((String)object2);
                stringBuilder.append(" and a.filesize>=?");
                arrayList.add(object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((object2 = PageUtils.getParam((HttpServletRequest)object, "maxDownloads")) != null && ((String)object2).length() > 0) {
            try {
                Integer.parseInt((String)object2);
                stringBuilder.append(" and a.downloads<=?");
                arrayList.add(object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((object2 = PageUtils.getParam((HttpServletRequest)object, "minDownloads")) != null && ((String)object2).length() > 0) {
            try {
                Integer.parseInt((String)object2);
                stringBuilder.append(" and a.downloads>=?");
                arrayList.add(object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((object2 = PageUtils.getParam((HttpServletRequest)object, "maxCredits")) != null && ((String)object2).length() > 0) {
            try {
                Integer.parseInt((String)object2);
                stringBuilder.append(" and a.credits<=?");
                arrayList.add(object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((object2 = PageUtils.getParam((HttpServletRequest)object, "minCredits")) != null && ((String)object2).length() > 0) {
            try {
                Integer.parseInt((String)object2);
                stringBuilder.append(" and a.credits>=?");
                arrayList.add(object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((object2 = PageUtils.getParam((HttpServletRequest)object, "maxCreateTime")) != null && ((String)object2).length() > 0) {
            try {
                object2 = Date.valueOf((String)object2);
                stringBuilder.append(" and a.createTime<=?");
                arrayList.add(object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((object2 = PageUtils.getParam((HttpServletRequest)object, "minCreateTime")) != null && ((String)object2).length() > 0) {
            try {
                object2 = Date.valueOf((String)object2);
                stringBuilder.append(" and a.createTime>=?");
                arrayList.add(object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((object2 = PageUtils.getParam((HttpServletRequest)object, "filename")) != null && ((String)object2).length() > 0) {
            if (((String)object2).indexOf(42) >= 0) {
                stringBuilder.append(" and a.filename like ?");
                arrayList.add(((String)object2).replace('*', '%'));
            } else {
                stringBuilder.append(" and a.filename=?");
                arrayList.add(object2);
            }
        }
        if ((object2 = PageUtils.getParam((HttpServletRequest)object, "userID")) != null && ((String)object2).length() > 0) {
            if (((String)object2).indexOf(42) >= 0) {
                stringBuilder.append(" and a.userID like ?");
                arrayList.add(((String)object2).replace('*', '%'));
            } else {
                stringBuilder.append(" and a.userID=?");
                arrayList.add(object2);
            }
        }
        if ((object = PageUtils.getParam((HttpServletRequest)object, "title")) != null && ((String)object).length() > 0) {
            stringBuilder.append(" and a.title like ?");
            arrayList.add("%" + (String)object + "%");
        }
        return stringBuilder.toString();
    }

    public Object[] searchAttach(HttpServletRequest object, int n) throws SQLException {
        Object[] objectArray = new Object[2];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        object = AttachDAO.a(object, arrayList);
        String string = "select COUNT(*) from ejf_attach a, ejf_topic b" + (String)object;
        object = String.valueOf(this.adapter.Attach_Query) + (String)object;
        int n2 = 0;
        Connection connection = null;
        try {
            connection = this.dbManager.getConnection();
            n2 = this.execSelectCountSql(string, arrayList, connection);
            if (n2 > 0) {
                object = this.adapter.getPageQuerySql(new StringBuilder((String)object).append(" order by a.createTime DESC"), n, 15, n2);
                object = this.execSelectSql((String)object, arrayList, connection);
                objectArray[1] = object;
            }
        }
        finally {
            this.dbManager.closeConnection(connection);
        }
        if (n2 > 0) {
            objectArray[0] = PageUtils.getPageHTMLStr(n2, n, 15, 0);
        }
        return objectArray;
    }

    public static class AttachVO {
        public int attachID = 0;
        public int topicID = 0;
        public int replyID = 0;
        public String userID = null;
        public String localname = null;
        public String filename = null;
        public int filesize = 0;
        public int credits = 0;
        public String localID = null;
        public String title = null;
        public int downloads = 0;
        public char state = (char)78;
        public String createTime = null;
    }
}

