/*
 * Decompiled with CFR 0.152.
 */
package com.hongshee.ejforum.data;

import com.hongshee.common.util.MyLogger;
import com.hongshee.ejforum.common.CacheManager;
import com.hongshee.ejforum.common.ForumSetting;
import com.hongshee.ejforum.data.BoardDAO;
import com.hongshee.ejforum.data.EntityDAO;
import com.hongshee.ejforum.data.GroupDAO;
import com.hongshee.ejforum.data.UserDAO;
import com.hongshee.ejforum.util.AppUtils;
import com.hongshee.ejforum.util.PageUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class ActionLogDAO
extends EntityDAO {
    private static Logger a = MyLogger.getLogger(ActionLogDAO.class.getName());
    private static ActionLogDAO b = null;

    private ActionLogDAO() {
    }

    public static synchronized ActionLogDAO getInstance() {
        if (b == null) {
            b = new ActionLogDAO();
        }
        return b;
    }

    public void addErrorLog(HttpServletRequest httpServletRequest, String string, String string2) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                Object object = null;
                object = PageUtils.getSessionUser(httpServletRequest);
                object = object != null ? ((UserDAO.UserInfo)object).userID : "";
                connection = this.dbManager.getConnection();
                preparedStatement = connection.prepareStatement(this.adapter.ErrorLog_Insert);
                preparedStatement.setString(1, (String)object);
                preparedStatement.setString(2, PageUtils.getRemoteAddr(httpServletRequest));
                if (string != null && string.length() > 10) {
                    preparedStatement.setString(3, string.substring(0, 10));
                } else {
                    preparedStatement.setString(3, string);
                }
                if (string2 != null && string2.length() > 100) {
                    preparedStatement.setString(4, String.valueOf(string2.substring(0, 95)) + "...");
                } else {
                    preparedStatement.setString(4, string2);
                }
                preparedStatement.executeUpdate();
            }
            catch (Exception exception) {
                a.warning("ActionLogDAO.addErrorLog - " + exception.toString());
            }
        }
        catch (Throwable throwable) {
            this.dbManager.closePStatement(preparedStatement);
            this.dbManager.closeConnection(connection);
            throw throwable;
        }
        this.dbManager.closePStatement(preparedStatement);
        this.dbManager.closeConnection(connection);
    }

    public void addAdminLog(HttpServletRequest httpServletRequest, String string, String string2, Connection connection) {
        PreparedStatement preparedStatement = null;
        try {
            try {
                UserDAO.UserInfo userInfo = PageUtils.getSessionUser(httpServletRequest);
                Object object = null;
                object = CacheManager.getInstance();
                object = ((CacheManager)object).getGroup(userInfo.groupID);
                object = object != null ? ((GroupDAO.GroupVO)object).groupName : "";
                preparedStatement = connection.prepareStatement(this.adapter.AdminLog_Insert);
                preparedStatement.setString(1, userInfo.userID);
                preparedStatement.setString(2, (String)object);
                preparedStatement.setString(3, PageUtils.getRemoteAddr(httpServletRequest));
                preparedStatement.setString(4, string);
                if (string2 != null && string2.length() > 40) {
                    preparedStatement.setString(5, String.valueOf(string2.substring(0, 35)) + "...");
                } else {
                    preparedStatement.setString(5, string2);
                }
                preparedStatement.executeUpdate();
            }
            catch (Exception exception) {
                a.warning("ActionLogDAO.addAdminLog - " + exception.toString());
            }
        }
        finally {
            this.dbManager.closePStatement(preparedStatement);
        }
    }

    public void addModerateLog(HttpServletRequest httpServletRequest, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String string, String string2, String string3, Connection connection) {
        PreparedStatement preparedStatement = null;
        try {
            try {
                UserDAO.UserInfo userInfo = PageUtils.getSessionUser(httpServletRequest);
                Object object = null;
                object = CacheManager.getInstance();
                object = ((CacheManager)object).getGroup(userInfo.groupID);
                object = object != null ? ((GroupDAO.GroupVO)object).groupName : "";
                preparedStatement = connection.prepareStatement(this.adapter.ModerateLog_Insert);
                int n = 0;
                while (n < stringArray3.length) {
                    preparedStatement.setString(1, userInfo.userID);
                    preparedStatement.setString(2, (String)object);
                    preparedStatement.setString(3, PageUtils.getRemoteAddr(httpServletRequest));
                    preparedStatement.setString(4, stringArray[n]);
                    preparedStatement.setString(5, stringArray2[n]);
                    preparedStatement.setString(6, stringArray3[n]);
                    if (stringArray4[n] != null && stringArray4[n].length() > 100) {
                        preparedStatement.setString(7, String.valueOf(stringArray4[n].substring(0, 95)) + "...");
                    } else {
                        preparedStatement.setString(7, stringArray4[n]);
                    }
                    preparedStatement.setString(8, string);
                    preparedStatement.setString(9, string2);
                    if (string3 != null && string3.length() > 40) {
                        preparedStatement.setString(10, String.valueOf(string3.substring(0, 35)) + "...");
                    } else {
                        preparedStatement.setString(10, string3);
                    }
                    preparedStatement.addBatch();
                    ++n;
                }
                preparedStatement.executeBatch();
            }
            catch (Exception exception) {
                a.warning("ActionLogDAO.addModerateLog - " + exception.toString());
            }
        }
        finally {
            this.dbManager.closePStatement(preparedStatement);
        }
    }

    public void addCreditsLog(String string, String string2, int n, String string3, Connection connection) {
        PreparedStatement preparedStatement = null;
        try {
            try {
                preparedStatement = connection.prepareStatement(this.adapter.CreditsLog_Insert);
                preparedStatement.setString(1, string2);
                preparedStatement.setString(2, string);
                preparedStatement.setInt(3, n);
                preparedStatement.setString(4, string3);
                preparedStatement.executeUpdate();
            }
            catch (Exception exception) {
                a.warning("ActionLogDAO.addCreditsLog - " + exception.toString());
            }
        }
        catch (Throwable throwable) {
            this.dbManager.closePStatement(preparedStatement);
            throw throwable;
        }
        this.dbManager.closePStatement(preparedStatement);
    }

    public void addCensorLog(String string, int n, String string2, String string3, String string4, String string5, String string6, Connection connection) {
        PreparedStatement preparedStatement = null;
        try {
            try {
                preparedStatement = connection.prepareStatement(this.adapter.CensorLog_Insert);
                preparedStatement.setString(1, string);
                preparedStatement.setInt(2, n);
                preparedStatement.setString(3, string2);
                preparedStatement.setString(4, string3);
                preparedStatement.setString(5, string4);
                preparedStatement.setString(6, string5);
                if (string6 != null && string6.length() > 40) {
                    preparedStatement.setString(7, String.valueOf(string6.substring(0, 35)) + "...");
                } else {
                    preparedStatement.setString(7, string6);
                }
                preparedStatement.executeUpdate();
            }
            catch (Exception exception) {
                a.warning("ActionLogDAO.addCensorLog - " + exception.toString());
            }
        }
        catch (Throwable throwable) {
            this.dbManager.closePStatement(preparedStatement);
            throw throwable;
        }
        this.dbManager.closePStatement(preparedStatement);
    }

    public String addReportLog(HttpServletRequest object, UserDAO.UserInfo object2) throws Exception {
        String string = PageUtils.getParam(object, "reason");
        String string2 = PageUtils.getParam(object, "topicID");
        String string3 = PageUtils.getParam(object, "replyID");
        if (string3.length() == 0) {
            string3 = "0";
        }
        PreparedStatement preparedStatement = null;
        Connection connection = this.dbManager.getConnection();
        try {
            Serializable serializable = null;
            if (!string3.equals("0")) {
                serializable = new ArrayList<String>();
                ((ArrayList)serializable).add(string3);
                serializable = this.execSelectSql(this.adapter.Reply_GetLogInfo, (ArrayList<Object>)serializable, connection);
            } else {
                serializable = new StringBuilder(this.adapter.Topic_GetLogInfo);
                ((StringBuilder)serializable).append(" (");
                ((StringBuilder)serializable).append("'").append(string2).append("'");
                ((StringBuilder)serializable).append(")");
                serializable = this.execSelectSql(((StringBuilder)serializable).toString(), null, connection);
            }
            if (serializable != null && ((ArrayList)serializable).size() > 0) {
                String string4 = (String)((HashMap)(serializable = (HashMap)((ArrayList)serializable).get(0))).get("TITLE");
                if (string4 != null && string4.length() > 100) {
                    string4 = String.valueOf(string4.substring(0, 95)) + "...";
                }
                String string5 = (String)((HashMap)serializable).get("USERID");
                serializable = (String)((HashMap)serializable).get("BOARDID");
                String[] stringArray = CacheManager.getInstance();
                stringArray = stringArray.getBoard(Integer.parseInt((String)((Object)serializable)));
                String string6 = stringArray.boardName;
                object2 = object2 == null ? "" : ((UserDAO.UserInfo)object2).userID;
                preparedStatement = connection.prepareStatement(this.adapter.ReportLog_Insert);
                preparedStatement.setString(1, (String)object2);
                preparedStatement.setString(2, string5);
                preparedStatement.setString(3, (String)((Object)serializable));
                preparedStatement.setString(4, string6);
                preparedStatement.setString(5, string2);
                preparedStatement.setString(6, string4);
                preparedStatement.setString(7, string3);
                if (string != null && string.length() > 40) {
                    preparedStatement.setString(8, String.valueOf(string.substring(0, 35)) + "...");
                } else {
                    preparedStatement.setString(8, string);
                }
                preparedStatement.executeUpdate();
                serializable = ForumSetting.getInstance().getString(5, "mailEvents");
                if (((String)((Object)serializable)).indexOf("report") >= 0 && (serializable = UserDAO.getInstance().getReportHandlers((BoardDAO.BoardVO)stringArray, connection)) != null && ((ArrayList)serializable).size() > 0) {
                    stringArray = new String[((ArrayList)serializable).size()];
                    int n = 0;
                    while (n < stringArray.length) {
                        stringArray[n] = ((ArrayList)serializable).get((int)n).value;
                        ++n;
                    }
                    String string7 = ForumSetting.getInstance().getForumName();
                    serializable = new StringBuilder();
                    ((StringBuilder)serializable).append("\u7528\u6237\u540d\uff1a").append((String)(((String)object2).length() == 0 ? "\u6e38\u5ba2" : object2)).append("<br>\n");
                    ((StringBuilder)serializable).append("\u88ab\u4e3e\u62a5\u7528\u6237\uff1a").append(string5).append("<br>\n");
                    ((StringBuilder)serializable).append("\u8bba\u575b\u7248\u5757\uff1a").append(string6).append("<br>\n");
                    ((StringBuilder)serializable).append("\u4e3b\u9898\uff1a").append("<A href=\"").append(PageUtils.getRootPath(object.getRequestURL().toString())).append(object.getContextPath()).append("/topic-").append(string2);
                    if (string3.equals("0")) {
                        ((StringBuilder)serializable).append(".html\">").append(string4);
                    } else {
                        ((StringBuilder)serializable).append(".html?rid=").append(string3).append("#rid").append(string3).append("\">").append(string4).append(" (RID:").append(string3).append(")");
                    }
                    ((StringBuilder)serializable).append("</A><br>\n");
                    ((StringBuilder)serializable).append("\u4e3e\u62a5\u539f\u56e0\uff1a").append(string).append("<br><br>\n");
                    ((StringBuilder)serializable).append("\u66f4\u591a\u4fe1\u606f\u8bf7\u5728\u540e\u53f0\u7ba1\u7406\u4e2d\u67e5\u9605\u7528\u6237\u4e3e\u62a5\u8bb0\u5f55\u3002");
                    ((StringBuilder)serializable).append(PageUtils.getSysMailFooter(object));
                    object = String.valueOf(string7) + "\u7528\u6237\u4e3e\u62a5\u4fe1\u606f";
                    AppUtils.sendMail(stringArray, (String)object, ((StringBuilder)serializable).toString());
                }
            }
            object = PageUtils.OK;
            return object;
        }
        finally {
            this.dbManager.closePStatement(preparedStatement);
            this.dbManager.closeConnection(connection);
        }
    }

    public void cleanExpiredLogs() throws Exception {
        int n = ForumSetting.getInstance().getInt(5, "logKeepMonths");
        if (n <= 0) {
            return;
        }
        Connection connection = this.dbManager.getConnection();
        try {
            Cloneable cloneable = Calendar.getInstance();
            cloneable.add(2, n * -1);
            Object object = new SimpleDateFormat("yyyy-MM-dd");
            object = ((DateFormat)object).format(cloneable.getTime());
            cloneable = new ArrayList<Date>();
            ((ArrayList)cloneable).add(Date.valueOf((String)object));
            this.execUpdateSql(this.adapter.AdminLog_Delete, (ArrayList<Object>)cloneable, connection);
            this.execUpdateSql(this.adapter.ModerateLog_Delete, (ArrayList<Object>)cloneable, connection);
            this.execUpdateSql(this.adapter.ErrorLog_Delete, (ArrayList<Object>)cloneable, connection);
            this.execUpdateSql(this.adapter.CensorLog_Delete, (ArrayList<Object>)cloneable, connection);
            this.execUpdateSql(this.adapter.ReportLog_Delete, (ArrayList<Object>)cloneable, connection);
            this.execUpdateSql(this.adapter.CreditsLog_Delete, (ArrayList<Object>)cloneable, connection);
        }
        finally {
            this.dbManager.closeConnection(connection);
        }
    }

    public Object[] getLogList(String string, String string2, String string3, String object) throws SQLException {
        Object[] objectArray = new Object[2];
        Object object2 = null;
        String string4 = null;
        if (string.equals("admin")) {
            object2 = "select COUNT(*) from ejf_admin_log";
            string4 = "select * from ejf_admin_log";
        } else if (string.equals("credits")) {
            object2 = "select COUNT(*) from ejf_credits_log";
            string4 = "select * from ejf_credits_log";
        } else if (string.equals("report")) {
            object2 = "select COUNT(*) from ejf_report_log";
            string4 = "select * from ejf_report_log";
        } else if (string.equals("censor")) {
            object2 = "select COUNT(*) from ejf_censor_log";
            string4 = "select * from ejf_censor_log";
        } else if (string.equals("moderator")) {
            object2 = "select COUNT(*) from ejf_moderator_log";
            string4 = "select * from ejf_moderator_log";
        } else if (string.equals("error")) {
            object2 = "select COUNT(*) from ejf_error_log";
            string4 = "select * from ejf_error_log";
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string5 = "";
        if (string2 != null && string2.length() > 0) {
            if (string2.indexOf(42) >= 0) {
                string5 = string.equals("report") || string.equals("censor") ? " where reason like ?" : " where action like ?";
                arrayList.add(string2.replace('*', '%'));
            } else {
                string5 = string.equals("report") || string.equals("censor") ? " where reason=?" : " where action=?";
                arrayList.add(string2);
            }
        }
        object2 = String.valueOf(object2) + string5;
        string4 = String.valueOf(string4) + string5;
        int n = 1;
        try {
            n = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n < 1) {
            n = 1;
        }
        int n2 = 20;
        try {
            n2 = Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 < 1) {
            n2 = 1;
        }
        int n3 = 0;
        object = null;
        try {
            object = this.dbManager.getConnection();
            n3 = this.execSelectCountSql((String)object2, arrayList, (Connection)object);
            if (n3 > 0) {
                string4 = this.adapter.getPageQuerySql(new StringBuilder(string4).append(" order by createTime DESC"), n, n2, n3);
                objectArray[1] = object2 = this.execSelectSql(string4, arrayList, (Connection)object);
            }
        }
        finally {
            this.dbManager.closeConnection((Connection)object);
        }
        if (n3 > 0) {
            objectArray[0] = PageUtils.getPageHTMLStr(n3, n, n2, 0);
        }
        return objectArray;
    }

    public Object[] getCreditsLogs(String object, String string, int n, int n2) throws SQLException {
        Object[] objectArray = new Object[2];
        String string2 = "select * from ejf_credits_log";
        String string3 = "select COUNT(*) from ejf_credits_log";
        if (string != null && string.equals("dec")) {
            string2 = String.valueOf(string2) + " where fromUser=?";
            string3 = String.valueOf(string3) + " where fromUser=?";
        } else {
            string2 = String.valueOf(string2) + " where userID=?";
            string3 = String.valueOf(string3) + " where userID=?";
        }
        int n3 = 0;
        Connection connection = null;
        try {
            connection = this.dbManager.getConnection();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object);
            n3 = this.execSelectCountSql(string3, arrayList, connection);
            if (n3 > 0) {
                string2 = this.adapter.getPageQuerySql(new StringBuilder(string2).append(" order by createTime DESC"), n, n2, n3);
                objectArray[1] = object = this.execSelectSql(string2, arrayList, connection);
            }
        }
        finally {
            this.dbManager.closeConnection(connection);
        }
        if (n3 > 0) {
            objectArray[0] = PageUtils.getPageHTMLStr(n3, n, n2, 0);
        }
        return objectArray;
    }
}

