/*
 * Decompiled with CFR 0.152.
 */
package com.hongshee.ejforum.common;

import com.hongshee.common.util.MyLogger;
import com.hongshee.ejforum.common.CacheManager;
import com.hongshee.ejforum.data.ActionLogDAO;
import com.hongshee.ejforum.data.AttachDAO;
import com.hongshee.ejforum.data.BackupDAO;
import com.hongshee.ejforum.data.BoardDAO;
import com.hongshee.ejforum.data.BookmarkDAO;
import com.hongshee.ejforum.data.ShortMsgDAO;
import com.hongshee.ejforum.data.StatDAO;
import com.hongshee.ejforum.data.TagDAO;
import com.hongshee.ejforum.data.TopicDAO;
import com.hongshee.ejforum.data.TopicISO;
import com.hongshee.ejforum.data.TrashBoxDAO;
import com.hongshee.ejforum.data.UserDAO;
import com.hongshee.ejforum.data.VoteDAO;
import com.hongshee.ejforum.util.AppUtils;
import java.util.Calendar;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MyTimerTask
implements Runnable {
    private static Logger a = null;
    public boolean isScheduled = false;
    private ScheduledExecutorService b = null;
    private long c = 0L;
    private long d = 0L;

    protected MyTimerTask() {
    }

    public MyTimerTask(ScheduledExecutorService scheduledExecutorService) {
        this.b = scheduledExecutorService;
    }

    public void run() {
        if (a == null) {
            a = MyLogger.getLogger(MyTimerTask.class.getName());
        }
        try {
            TopicDAO.getInstance().addTopicVisits();
            StatDAO.getInstance().addFeedVisits();
            VoteDAO.getInstance().cleanPollIP();
            TopicDAO.getInstance().cleanDiggIP();
            UserDAO.getInstance().cleanDeposit();
            CacheManager cacheManager = CacheManager.getInstance();
            cacheManager.loadSpecTopics("recent");
            cacheManager.loadSpecTopics("hot");
            cacheManager.loadSpecTopics("rank");
            cacheManager.loadSpecTopics("digest");
            cacheManager.loadSpecTopics("cat");
            Calendar calendar = Calendar.getInstance();
            long l = System.currentTimeMillis();
            int n = calendar.get(11);
            if (n >= 0 && n < 3 && l - this.c > 28800000L) {
                this.c = l;
                cacheManager.clearUserPosts();
                cacheManager.loadHotTags(true);
                cacheManager.resetBoardTodayPosts();
                MyTimerTask.a("checkExpireDate");
                MyTimerTask.a("closeOverflowTopics");
                MyTimerTask.a("cleanOverflowMsgs");
                MyTimerTask.a("cleanOverflowFavors");
                MyTimerTask.a("cleanOverflowTags");
                MyTimerTask.a("statBoardInfo");
                MyTimerTask.a("statVisits");
                MyTimerTask.a("indexTopics");
                MyTimerTask.a("execDailyBackup");
                return;
            }
            if (n >= 3 && n < 6 && l - this.d > 28800000L) {
                this.d = l;
                int n2 = calendar.get(7);
                if (n2 == 7) {
                    MyTimerTask.a("cleanExpiredTrashes");
                    MyTimerTask.a("cleanExpiredLogs");
                    MyTimerTask.a("cleanRecycledAttaches");
                    MyTimerTask.a("cleanExpiredUsers");
                    MyTimerTask.a("execWeeklyBackup");
                    return;
                }
                if (n2 == 2) {
                    MyTimerTask.a("fetchNewVersion");
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof ThreadDeath) {
                this.isScheduled = false;
                a.log(Level.SEVERE, "MyTimerTask.run():ThreadDeath", throwable2);
                AppUtils.synSendMail2Admin("EasyJForum error info", throwable2.toString());
                this.b.shutdown();
                return;
            }
            a.log(Level.SEVERE, "MyTimerTask.run()", throwable2);
            AppUtils.synSendMail2Admin("EasyJForum error info", throwable2.toString());
        }
    }

    private static void a(String string) {
        try {
            if (string.equals("checkExpireDate")) {
                TopicDAO.getInstance().checkExpireDate();
            } else if (string.equals("closeOverflowTopics")) {
                TopicDAO.getInstance().closeOverflowTopics();
            } else if (string.equals("cleanOverflowMsgs")) {
                ShortMsgDAO.getInstance().cleanOverflowMsgs();
            } else if (string.equals("cleanOverflowFavors")) {
                BookmarkDAO.getInstance().cleanOverflowMarks();
            } else if (string.equals("cleanOverflowTags")) {
                TagDAO.getInstance().cleanOverflowTags();
            } else if (string.equals("statVisits")) {
                StatDAO.getInstance().statVisits();
            } else if (string.equals("indexTopics")) {
                TopicISO.getInstance().buildTopicsIndex();
            } else if (string.equals("cleanExpiredTrashes")) {
                TrashBoxDAO.getInstance().cleanExpiredTrashes();
            } else if (string.equals("cleanExpiredLogs")) {
                ActionLogDAO.getInstance().cleanExpiredLogs();
            } else if (string.equals("statBoardInfo")) {
                BoardDAO.getInstance().statBoardInfo();
            } else if (string.equals("cleanRecycledAttaches")) {
                AttachDAO.getInstance().cleanRecycledAttaches();
            } else if (string.equals("cleanExpiredUsers")) {
                UserDAO.getInstance().cleanExpiredUsers();
            } else if (string.equals("fetchNewVersion")) {
                AppUtils.getAppVersion();
            } else if (string.equals("execDailyBackup")) {
                BackupDAO.getInstance().execBackupTasks("D");
            } else if (string.equals("execWeeklyBackup")) {
                BackupDAO.getInstance().execBackupTasks("W");
            }
            a.log(Level.INFO, "MyTimerTask - end of call:" + string);
            return;
        }
        catch (Exception exception) {
            a.log(Level.SEVERE, "MyTimerTask - call:" + string, exception);
            AppUtils.sendMail2Admin("EasyJForum timer task error: call " + string, exception.toString());
            return;
        }
    }
}

