/*
 * Decompiled with CFR 0.152.
 */
package com.hongshee.ejforum.common;

import com.hongshee.common.util.MyLogger;
import com.hongshee.ejforum.common.ForumSetting;
import com.hongshee.ejforum.data.BoardDAO;
import com.hongshee.ejforum.data.GroupDAO;
import com.hongshee.ejforum.data.SectionDAO;
import com.hongshee.ejforum.data.StatDAO;
import com.hongshee.ejforum.data.TagDAO;
import com.hongshee.ejforum.data.TopicDAO;
import com.hongshee.ejforum.util.AppUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheManager {
    private static Logger a = MyLogger.getLogger(CacheManager.class.getName());
    private static CacheManager b = null;
    private volatile a c = new a(this);
    private volatile ArrayList<GroupDAO.GroupVO> d = null;
    private volatile String e = null;
    private volatile String f = null;
    private volatile String g = null;
    private volatile String h = null;
    private volatile String i = null;
    private volatile String j = null;
    private volatile String[] k = new String[]{"", "_", "", "_", ""};
    private volatile boolean l = true;
    private volatile String m = null;
    private volatile int n = 10;
    private volatile int o = 10;
    private volatile int p = 10;
    private volatile int q = 10;
    private volatile int r = 10;
    private volatile int s = 10;
    private volatile int t = 10;
    private volatile int u = 10;
    private volatile int v = 10;
    private volatile int w = 10;
    private Hashtable<String, Integer> x = new Hashtable();

    private CacheManager() {
    }

    public static synchronized CacheManager getInstance() {
        if (b == null) {
            b = new CacheManager();
        }
        return b;
    }

    public ArrayList<GroupDAO.GroupVO> getGroups() {
        if (this.d == null) {
            this.loadGroups();
        }
        return this.d;
    }

    public GroupDAO.GroupVO getGroup(char c) {
        GroupDAO.GroupVO groupVO = null;
        if (this.d == null) {
            this.loadGroups();
        }
        GroupDAO.GroupVO groupVO2 = null;
        int n = 0;
        while (n < this.d.size()) {
            groupVO2 = this.d.get(n);
            if (groupVO2.groupID == c) {
                groupVO = groupVO2;
                break;
            }
            ++n;
        }
        return groupVO;
    }

    public GroupDAO.GroupVO getGroup(int n) {
        GroupDAO.GroupVO groupVO = null;
        if (this.d == null) {
            this.loadGroups();
        }
        GroupDAO.GroupVO groupVO2 = null;
        int n2 = 0;
        while (n2 < this.d.size()) {
            groupVO2 = this.d.get(n2);
            if (groupVO2.groupType != 'S' && n >= groupVO2.minCredits && n < groupVO2.maxCredits) {
                groupVO = groupVO2;
                break;
            }
            ++n2;
        }
        return groupVO;
    }

    public String getModerators() {
        if (this.e == null) {
            this.loadModerators();
        }
        return this.e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRecentTopics(SectionDAO.SectionVO sectionVO, int n) {
        if (sectionVO != null) {
            if (sectionVO.recent_topics == null || n != this.s) {
                CacheManager cacheManager = this;
                synchronized (cacheManager) {
                    if (sectionVO.recent_topics == null || n != this.s) {
                        this.s = n;
                        this.loadSpecTopics("recent", sectionVO);
                    }
                }
            }
            if (sectionVO.recent_topics == null) {
                return "";
            }
            return sectionVO.recent_topics;
        }
        if (this.f == null || n != this.n) {
            CacheManager cacheManager = this;
            synchronized (cacheManager) {
                if (this.f == null || n != this.n) {
                    this.n = n;
                    this.loadSpecTopics("recent", null);
                }
            }
        }
        if (this.f == null) {
            return "";
        }
        return this.f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHotTopics(SectionDAO.SectionVO sectionVO, int n) {
        if (sectionVO != null) {
            if (sectionVO.hot_topics == null || n != this.t) {
                CacheManager cacheManager = this;
                synchronized (cacheManager) {
                    if (sectionVO.hot_topics == null || n != this.t) {
                        this.t = n;
                        this.loadSpecTopics("hot", sectionVO);
                    }
                }
            }
            if (sectionVO.hot_topics == null) {
                return "";
            }
            return sectionVO.hot_topics;
        }
        if (this.g == null || n != this.o) {
            CacheManager cacheManager = this;
            synchronized (cacheManager) {
                if (this.g == null || n != this.o) {
                    this.o = n;
                    this.loadSpecTopics("hot", null);
                }
            }
        }
        if (this.g == null) {
            return "";
        }
        return this.g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRankTopics(SectionDAO.SectionVO sectionVO, int n) {
        if (sectionVO != null) {
            if (sectionVO.rank_topics == null || n != this.u) {
                CacheManager cacheManager = this;
                synchronized (cacheManager) {
                    if (sectionVO.rank_topics == null || n != this.u) {
                        this.u = n;
                        this.loadSpecTopics("rank", sectionVO);
                    }
                }
            }
            if (sectionVO.rank_topics == null) {
                return "";
            }
            return sectionVO.rank_topics;
        }
        if (this.h == null || n != this.p) {
            CacheManager cacheManager = this;
            synchronized (cacheManager) {
                if (this.h == null || n != this.p) {
                    this.p = n;
                    this.loadSpecTopics("rank", null);
                }
            }
        }
        if (this.h == null) {
            return "";
        }
        return this.h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDigestTopics(SectionDAO.SectionVO sectionVO, int n) {
        if (sectionVO != null) {
            if (sectionVO.digest_topics == null || n != this.v) {
                CacheManager cacheManager = this;
                synchronized (cacheManager) {
                    if (sectionVO.digest_topics == null || n != this.v) {
                        this.v = n;
                        this.loadSpecTopics("digest", sectionVO);
                    }
                }
            }
            if (sectionVO.digest_topics == null) {
                return "";
            }
            return sectionVO.digest_topics;
        }
        if (this.i == null || n != this.q) {
            CacheManager cacheManager = this;
            synchronized (cacheManager) {
                if (this.i == null || n != this.q) {
                    this.q = n;
                    this.loadSpecTopics("digest", null);
                }
            }
        }
        if (this.i == null) {
            return "";
        }
        return this.i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHotCats(SectionDAO.SectionVO sectionVO, int n) {
        if (sectionVO != null) {
            if (sectionVO.hot_cats == null || n != this.w) {
                CacheManager cacheManager = this;
                synchronized (cacheManager) {
                    if (sectionVO.hot_cats == null || n != this.w) {
                        this.w = n;
                        this.loadSpecTopics("cat", sectionVO);
                    }
                }
            }
            if (sectionVO.hot_cats == null) {
                return "";
            }
            return sectionVO.hot_cats;
        }
        if (this.j == null || n != this.r) {
            CacheManager cacheManager = this;
            synchronized (cacheManager) {
                if (this.j == null || n != this.r) {
                    this.r = n;
                    this.loadSpecTopics("cat", null);
                }
            }
        }
        if (this.j == null) {
            return "";
        }
        return this.j;
    }

    public void setHotCatSeps(String[] stringArray) {
        if (stringArray != null && stringArray.length >= 5) {
            this.k = stringArray;
        }
    }

    public boolean isNewHotCats() {
        boolean bl = this.l;
        if (bl) {
            this.l = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHotTags() {
        if (this.m == null) {
            CacheManager cacheManager = this;
            synchronized (cacheManager) {
                if (this.m == null) {
                    this.loadHotTags(true);
                }
            }
        }
        if (this.m == null) {
            return "";
        }
        return this.m;
    }

    public void loadModerators() {
        StringBuilder stringBuilder = new StringBuilder(",");
        if (this.c.a == null) {
            this.loadSections();
        }
        SectionDAO.SectionVO sectionVO = null;
        Object object = null;
        object = null;
        int n = 0;
        while (n < this.c.a.size()) {
            int n2;
            sectionVO = (SectionDAO.SectionVO)this.c.a.get(n);
            if (sectionVO.moderator != null) {
                object = sectionVO.moderator.split(",");
                n2 = 0;
                while (n2 < ((String[])object).length) {
                    if (stringBuilder.indexOf("," + object[n2] + ",") < 0) {
                        stringBuilder.append(object[n2]).append(',');
                    }
                    ++n2;
                }
            }
            n2 = 0;
            while (n2 < sectionVO.boardList.size()) {
                object = sectionVO.boardList.get(n2);
                if (object.moderator != null) {
                    object = object.moderator.split(",");
                    int n3 = 0;
                    while (n3 < ((String[])object).length) {
                        if (stringBuilder.indexOf("," + object[n3] + ",") < 0) {
                            stringBuilder.append(object[n3]).append(',');
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
        this.e = stringBuilder.toString();
    }

    public ArrayList<SectionDAO.SectionVO> getSections() {
        if (this.c.a == null) {
            this.loadSections();
        }
        return this.c.a;
    }

    public SectionDAO.SectionVO getSection(int n) {
        SectionDAO.SectionVO sectionVO = null;
        if (this.c.a == null) {
            this.loadSections();
        }
        SectionDAO.SectionVO sectionVO2 = null;
        int n2 = 0;
        while (n2 < this.c.a.size()) {
            sectionVO2 = (SectionDAO.SectionVO)this.c.a.get(n2);
            if (sectionVO2.sectionID == n) {
                sectionVO = sectionVO2;
                break;
            }
            ++n2;
        }
        return sectionVO;
    }

    public void deleteSection(int n) {
        if (this.c.a == null) {
            this.loadSections();
        }
        SectionDAO.SectionVO sectionVO = null;
        int n2 = 0;
        while (n2 < this.c.a.size()) {
            sectionVO = (SectionDAO.SectionVO)this.c.a.get(n2);
            if (sectionVO.sectionID == n) {
                this.c.a.remove(n2);
                if (sectionVO.boardList == null) break;
                n = 0;
                while (n < sectionVO.boardList.size()) {
                    this.c.b.remove(sectionVO.boardList.get((int)n).boardID);
                    ++n;
                }
                return;
            }
            ++n2;
        }
    }

    public BoardDAO.BoardVO getBoard(int n) {
        if (this.c.b == null) {
            this.loadSections();
        }
        return (BoardDAO.BoardVO)this.c.b.get(n);
    }

    public void resetBoardTodayPosts() {
        if (this.c.a == null) {
            return;
        }
        SectionDAO.SectionVO sectionVO = null;
        BoardDAO.BoardVO boardVO = null;
        int n = 0;
        while (n < this.c.a.size()) {
            sectionVO = (SectionDAO.SectionVO)this.c.a.get(n);
            if (sectionVO != null && sectionVO.boardList != null) {
                int n2 = 0;
                while (n2 < sectionVO.boardList.size()) {
                    boardVO = sectionVO.boardList.get(n2);
                    sectionVO.boardList.get(n2).todayPosts = 0;
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void resetBoardListTopics() {
        if (this.c.a == null) {
            return;
        }
        SectionDAO.SectionVO sectionVO = null;
        BoardDAO.BoardVO boardVO = null;
        int n = 0;
        while (n < this.c.a.size()) {
            sectionVO = (SectionDAO.SectionVO)this.c.a.get(n);
            if (sectionVO != null && sectionVO.boardList != null) {
                int n2 = 0;
                while (n2 < sectionVO.boardList.size()) {
                    boardVO = sectionVO.boardList.get(n2);
                    sectionVO.boardList.get(n2).listTopics = 0;
                    boardVO.unCat.listTopics = 0;
                    if (boardVO.catList != null) {
                        int n3 = 0;
                        while (n3 < boardVO.catList.size()) {
                            boardVO.catList.get((int)n3).listTopics = 0;
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void resetBoardTopicList() {
        if (this.c.a == null) {
            return;
        }
        SectionDAO.SectionVO sectionVO = null;
        BoardDAO.BoardVO boardVO = null;
        int n = 0;
        while (n < this.c.a.size()) {
            sectionVO = (SectionDAO.SectionVO)this.c.a.get(n);
            if (sectionVO != null && sectionVO.boardList != null) {
                int n2 = 0;
                while (n2 < sectionVO.boardList.size()) {
                    boardVO = sectionVO.boardList.get(n2);
                    sectionVO.boardList.get(n2).topicList = null;
                    boardVO.unCat.topicList = null;
                    if (boardVO.catList != null) {
                        int n3 = 0;
                        while (n3 < boardVO.catList.size()) {
                            boardVO.catList.get((int)n3).topicList = null;
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void deleteBoard(int n, int n2) {
        BoardDAO.BoardVO boardVO = null;
        SectionDAO.SectionVO sectionVO = this.getSection(n);
        int n3 = 0;
        while (n3 < sectionVO.boardList.size()) {
            boardVO = sectionVO.boardList.get(n3);
            if (boardVO.boardID == n2) {
                sectionVO.boardList.remove(n3);
                this.c.b.remove(n2);
                return;
            }
            ++n3;
        }
    }

    public boolean loadSpecTopics(String string) {
        Object object = ForumSetting.getInstance().getShowHotlinks();
        int n = 78;
        if (!string.equals("recent")) {
            n = string.toUpperCase().charAt(0);
        }
        if (((String)object).indexOf(n) >= 0) {
            this.loadSpecTopics(string, null);
            if (string.equals("cat")) {
                this.l = true;
            }
        } else if (string.equals("recent")) {
            this.f = null;
        } else if (string.equals("hot")) {
            this.g = null;
        } else if (string.equals("rank")) {
            this.h = null;
        } else if (string.equals("digest")) {
            this.i = null;
        } else if (string.equals("cat")) {
            this.j = null;
        }
        object = this.getSections();
        SectionDAO.SectionVO sectionVO = null;
        int n2 = 0;
        while (n2 < ((ArrayList)object).size()) {
            sectionVO = (SectionDAO.SectionVO)((ArrayList)object).get(n2);
            n = 78;
            if (!string.equals("recent")) {
                n = string.toUpperCase().charAt(0);
            }
            if (sectionVO.showHotlinks != null && sectionVO.showHotlinks.indexOf(n) >= 0) {
                this.loadSpecTopics(string, sectionVO);
                if (string.equals("cat")) {
                    this.l = true;
                }
            } else if (string.equals("recent")) {
                sectionVO.recent_topics = null;
            } else if (string.equals("hot")) {
                sectionVO.hot_topics = null;
            } else if (string.equals("rank")) {
                sectionVO.rank_topics = null;
            } else if (string.equals("digest")) {
                sectionVO.digest_topics = null;
            } else if (string.equals("cat")) {
                sectionVO.hot_cats = null;
            }
            ++n2;
        }
        a.log(Level.INFO, "Succeeded to load " + string + " links to cache!");
        return true;
    }

    public boolean loadSpecTopics(String string, SectionDAO.SectionVO sectionVO) {
        try {
            if (string.equals("cat")) {
                ArrayList<HashMap> arrayList = null;
                arrayList = sectionVO == null ? StatDAO.getInstance().getHotCatsInfo(this.r, 0) : StatDAO.getInstance().getHotCatsInfo(this.w, sectionVO.sectionID);
                if (arrayList != null && arrayList.size() > 0) {
                    Object object = null;
                    object = null;
                    int n = 0;
                    int n2 = 0;
                    BoardDAO.BoardVO boardVO = null;
                    SectionDAO.SectionVO sectionVO2 = null;
                    StringBuilder stringBuilder = new StringBuilder("<UL class='items'>");
                    int n3 = 0;
                    while (n3 < arrayList.size()) {
                        object = arrayList.get(n3);
                        n = Integer.parseInt((String)((HashMap)object).get("BOARDID"));
                        n2 = Integer.parseInt((String)((HashMap)object).get("CATID"));
                        boardVO = this.getBoard(n);
                        if (boardVO != null) {
                            sectionVO2 = this.getSection(boardVO.sectionID);
                            object = boardVO.getCatVO(n2);
                            if (object != null) {
                                stringBuilder.append("<LI class=\"item\">\n");
                                stringBuilder.append("<A href=\"./forum-");
                                stringBuilder.append(n).append(".html?cid=").append(n2).append("\" target=_blank>");
                                if (sectionVO == null) {
                                    stringBuilder.append(this.k[0]).append(sectionVO2.sectionName).append(this.k[1]);
                                }
                                stringBuilder.append(boardVO.plainName).append(this.k[2]).append(this.k[3]).append(((BoardDAO.CatVO)object).catName).append(this.k[4]).append("</A></LI>\n");
                            }
                        }
                        ++n3;
                    }
                    stringBuilder.append("</UL>");
                    if (sectionVO == null) {
                        this.j = stringBuilder.toString();
                    } else {
                        sectionVO.hot_cats = stringBuilder.toString();
                    }
                }
            } else {
                int n = 10;
                if (string.equals("recent")) {
                    n = sectionVO == null ? this.n : this.s;
                } else if (string.equals("hot")) {
                    n = sectionVO == null ? this.o : this.t;
                } else if (string.equals("rank")) {
                    n = sectionVO == null ? this.p : this.u;
                } else if (string.equals("digest")) {
                    n = this.q;
                }
                Object object = null;
                object = sectionVO != null ? TopicDAO.getInstance().getSpecTopics(sectionVO.sectionID, string, null, 1, n, true) : TopicDAO.getInstance().getSpecTopics(0, string, null, 1, n, true);
                if (object != null && object[1] != null) {
                    object = (ArrayList)object[1];
                    TopicDAO.TopicInfo topicInfo = null;
                    StringBuilder stringBuilder = new StringBuilder("<UL class='items'>");
                    int n4 = 0;
                    while (n4 < ((ArrayList)object).size()) {
                        topicInfo = (TopicDAO.TopicInfo)((ArrayList)object).get(n4);
                        stringBuilder.append("<LI class=\"item\">\n");
                        stringBuilder.append("<A href=\"./topic-");
                        stringBuilder.append(topicInfo.topicID).append(".html").append("\" target=_blank>").append(topicInfo.title).append("</A></LI>\n");
                        ++n4;
                    }
                    stringBuilder.append("</UL>");
                    if (sectionVO != null) {
                        if (string.equals("recent")) {
                            sectionVO.recent_topics = stringBuilder.toString();
                        } else if (string.equals("hot")) {
                            sectionVO.hot_topics = stringBuilder.toString();
                        } else if (string.equals("rank")) {
                            sectionVO.rank_topics = stringBuilder.toString();
                        } else if (string.equals("digest")) {
                            sectionVO.digest_topics = stringBuilder.toString();
                        }
                    } else if (string.equals("recent")) {
                        this.f = stringBuilder.toString();
                    } else if (string.equals("hot")) {
                        this.g = stringBuilder.toString();
                    } else if (string.equals("rank")) {
                        this.h = stringBuilder.toString();
                    } else if (string.equals("digest")) {
                        this.i = stringBuilder.toString();
                    }
                }
            }
            return true;
        }
        catch (Exception exception) {
            a.log(Level.SEVERE, exception.getMessage(), exception);
            AppUtils.sendMsg2Admin("Failed to load " + string + " topics to cache!");
            return false;
        }
    }

    public boolean loadHotTags(boolean bl) {
        try {
            ArrayList<TagDAO.TagInfo> arrayList = TagDAO.getInstance().getHotTags(bl);
            TagDAO.TagInfo tagInfo = null;
            if (arrayList != null && arrayList.size() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                int n = 0;
                while (n < arrayList.size()) {
                    tagInfo = arrayList.get(n);
                    stringBuilder.append("<A href=\"./search_result.jsp?searchfield=content&keys=");
                    stringBuilder.append(tagInfo.tagname).append("\" target=_blank>").append(tagInfo.tagname).append("&nbsp;<EM>(").append(tagInfo.recordCount).append(")</EM></A>&nbsp;&nbsp;\n");
                    ++n;
                }
                this.m = stringBuilder.toString();
            }
            if (bl) {
                a.log(Level.INFO, "Succeeded to load hot tags to cache!");
            }
            return true;
        }
        catch (Exception exception) {
            a.log(Level.SEVERE, exception.getMessage(), exception);
            AppUtils.sendMsg2Admin("Failed to load hot tags to cache!");
            return false;
        }
    }

    public boolean loadSections() {
        try {
            ArrayList<SectionDAO.SectionVO> arrayList = SectionDAO.getInstance().getAllSections();
            if (arrayList != null && arrayList.size() > 0) {
                HashMap<Integer, BoardDAO.BoardVO> hashMap = new HashMap<Integer, BoardDAO.BoardVO>();
                BoardDAO.BoardVO boardVO = null;
                SectionDAO.SectionVO sectionVO = null;
                int n = 0;
                while (n < arrayList.size()) {
                    sectionVO = arrayList.get(n);
                    int n2 = 0;
                    while (n2 < sectionVO.boardList.size()) {
                        boardVO = sectionVO.boardList.get(n2);
                        hashMap.put(boardVO.boardID, boardVO);
                        ++n2;
                    }
                    ++n;
                }
                a a2 = new a(this);
                a2.b = hashMap;
                a2.a = arrayList;
                this.c = a2;
                this.loadModerators();
            }
            a.log(Level.INFO, "Succeeded to load sections to cache!");
            return true;
        }
        catch (Exception exception) {
            a.log(Level.SEVERE, exception.getMessage(), exception);
            AppUtils.sendMsg2Admin("Failed to load sections to cache!");
            return false;
        }
    }

    public boolean loadGroups() {
        try {
            ArrayList<GroupDAO.GroupVO> arrayList = GroupDAO.getInstance().getAllGroups();
            if (arrayList != null && arrayList.size() > 0) {
                this.d = arrayList;
            }
            a.log(Level.INFO, "Succeeded to load groups to cache!");
            return true;
        }
        catch (Exception exception) {
            a.log(Level.SEVERE, exception.getMessage(), exception);
            AppUtils.sendMsg2Admin("Failed to load groups to cache!");
            return false;
        }
    }

    public void increaseUserPosts(String string) {
        Integer n = this.x.get(string);
        if (n == null) {
            this.x.put(string, 1);
            return;
        }
        this.x.put(string, n + 1);
    }

    public void clearUserPosts() {
        this.x.clear();
    }

    public int getUserPosts(String string) {
        Integer n = ((CacheManager)((Object)n)).x.get(string);
        if (n == null) {
            return 0;
        }
        return n;
    }

    private final class a {
        private volatile ArrayList<SectionDAO.SectionVO> a = null;
        private volatile HashMap<Integer, BoardDAO.BoardVO> b = null;

        a(CacheManager cacheManager) {
        }
    }
}

