/*
 * Decompiled with CFR 0.152.
 */
package com.hongshee.ejforum.common;

import com.hongshee.common.util.DBManager;
import com.hongshee.common.util.MyLogger;
import com.hongshee.common.util.ThreadManager;
import com.hongshee.common.util.XMLUtils;
import com.hongshee.ejforum.common.ForumSetting;
import com.hongshee.ejforum.common.MyTimerTask;
import com.hongshee.ejforum.data.SqlAdapter;
import com.hongshee.ejforum.data.StatDAO;
import com.hongshee.ejforum.data.TopicDAO;
import com.hongshee.ejforum.data.TopicISO;
import com.hongshee.ejforum.data.UserDAO;
import com.hongshee.ejforum.util.AppUtils;
import com.hongshee.ejforum.util.PageUtils;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppContext {
    private static Logger a = null;
    private static AppContext b = null;
    private String c = null;
    private String d = null;
    private Element e = null;
    private Element f = null;
    private SqlAdapter g = null;
    private Set<HttpSession> h = Collections.synchronizedSet(new HashSet());
    private volatile int i = 0;
    private int j = 0;
    private String k = "2008-08-08";
    private final ScheduledExecutorService l = Executors.newScheduledThreadPool(2);
    private final MyTimerTask m = new MyTimerTask(this.l);

    private AppContext() {
    }

    public static AppContext getInstance() {
        if (b == null) {
            b = new AppContext();
        }
        return b;
    }

    public void init(ServletContext object) throws RuntimeException {
        try {
            this.c = object.getRealPath("/");
            if (!this.c.endsWith(String.valueOf(File.separatorChar))) {
                this.c = String.valueOf(this.c) + File.separatorChar;
            }
            PageUtils.loadResources(String.valueOf(this.c) + "WEB-INF/resource.props");
            a = MyLogger.getLogger(AppContext.class.getName());
            object = this;
            this.e = XMLUtils.loadXMLFile(String.valueOf(((AppContext)object).c) + "WEB-INF/conf/config.xml");
            ((AppContext)object).f = XMLUtils.getSubElement(((AppContext)object).e, "misc");
            ((AppContext)object).d = XMLUtils.getSubElement(((AppContext)object).e, "system").getAttribute("adminUser");
            object = XMLUtils.getSubElement(this.e, "database");
            String string = object.getAttribute("url");
            int n = string.indexOf("jdbc:hsqldb:file:/");
            if (n >= 0) {
                string = "jdbc:hsqldb:file:" + this.c + string.substring(18);
                object.setAttribute("url", string);
            }
            string = object.getAttribute("sqlAdapter");
            this.g = (SqlAdapter)Class.forName("com.hongshee.ejforum.data." + string).newInstance();
            this.g.init();
            DBManager.getInstance().init((Element)object);
            ThreadManager.getInstance().init();
            object = ForumSetting.getInstance();
            ((ForumSetting)object).loadForumSetting();
            PageUtils.charset = ((ForumSetting)object).getString(0, "charset", "GBK");
            UserDAO.getInstance().initAdminUser(this.d, ((ForumSetting)object).getAdminMailAddr());
            TopicISO.getInstance().init();
            object = AppUtils.getStringFromFile(String.valueOf(this.c) + "WEB-INF/data/ejf.top");
            if (((String)object).length() > 0 && ((String[])(object = ((String)object).split(","))).length > 1) {
                this.j = Integer.parseInt((String)object[0]);
                this.k = object[1];
            }
            if (!this.m.isScheduled) {
                this.l.scheduleAtFixedRate(this.m, 7200L, 7200L, TimeUnit.SECONDS);
                this.m.isScheduled = true;
            }
            System.out.println("EasyJForum context initialized: " + this.c);
            a.log(Level.INFO, "EasyJForum context initialized: " + this.c);
            return;
        }
        catch (Exception exception) {
            a.log(Level.SEVERE, "EasyJForum AppContext : error in init().", exception);
            throw new RuntimeException(exception.getMessage());
        }
    }

    public Set<HttpSession> getSessions() {
        return this.h;
    }

    public int getSessionCount() {
        if (this.i > 0) {
            return this.i;
        }
        return 1;
    }

    public synchronized void incSessionCount() {
        ++this.i;
    }

    public synchronized void decSessionCount() {
        if (this.i > 0) {
            --this.i;
        }
    }

    public void setTopOnlines() {
        try {
            if (this.i > this.j) {
                String string = AppUtils.getCurrentTimeStr();
                this.j = this.i;
                this.k = string;
                string = String.valueOf(String.valueOf(this.i)) + "," + string;
                AppUtils.saveStringToFile(string, String.valueOf(this.c) + "WEB-INF/data/ejf.top");
                return;
            }
        }
        catch (Exception exception) {}
    }

    public int getTopOnlines() {
        return this.j;
    }

    public String getTopOnlineTime() {
        return this.k;
    }

    public Element getMiscConfig() {
        return this.f;
    }

    public String getAdminUser() {
        return this.d;
    }

    public String getRealPath() {
        return this.c;
    }

    public SqlAdapter getSqlAdapter() {
        return this.g;
    }

    public void destroy() {
        try {
            TopicDAO.getInstance().addTopicVisits();
            StatDAO.getInstance().addFeedVisits();
        }
        catch (Exception exception) {
            a.log(Level.WARNING, exception.toString());
        }
        DBManager.getInstance().closeConnectionPool();
        TopicISO.getInstance().destroy();
        ThreadManager.getInstance().shutdown();
        this.l.shutdown();
        a.log(Level.INFO, "EasyJForum AppContext : destroyed.");
    }
}

