/*
 * Decompiled with CFR 0.152.
 */
package com.hongshee.common.util;

import com.hongshee.common.util.MyLogger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tomcat.dbcp.dbcp.BasicDataSource;
import org.w3c.dom.Element;

public class DBManager {
    private static Logger a = null;
    private static DBManager b = null;
    private Element c = null;
    private BasicDataSource d = null;

    protected DBManager() {
    }

    public static DBManager getInstance() {
        if (b == null) {
            b = new DBManager();
        }
        return b;
    }

    public void init(Element stringArray) {
        this.c = stringArray;
        if (this.d == null) {
            this.d = new BasicDataSource();
            this.d.setDriverClassName(this.c.getAttribute("driverClassName"));
            this.d.setUsername(this.c.getAttribute("username"));
            this.d.setPassword(this.c.getAttribute("password"));
            this.d.setUrl(this.c.getAttribute("url"));
            stringArray = this.c.getAttribute("connectionProps");
            if (stringArray != null && stringArray.length() > 0 && (stringArray = stringArray.split("&")).length > 0) {
                String[] stringArray2 = null;
                int n = 0;
                while (n < stringArray.length) {
                    stringArray2 = stringArray[n].split("=");
                    if (stringArray2.length == 2) {
                        this.d.addConnectionProperty(stringArray2[0], stringArray2[1]);
                    }
                    ++n;
                }
            }
            this.d.setPoolPreparedStatements(true);
            this.d.setMaxOpenPreparedStatements(100);
            this.d.setMaxActive(Integer.parseInt(this.c.getAttribute("maxActive")));
            this.d.setMaxIdle(Integer.parseInt(this.c.getAttribute("maxIdle")));
            this.d.setMinIdle(Integer.parseInt(this.c.getAttribute("minIdle")));
            this.d.setMaxWait((long)Integer.parseInt(this.c.getAttribute("maxWait")));
            this.d.setMinEvictableIdleTimeMillis(3600000L);
            this.d.setTimeBetweenEvictionRunsMillis(0x6DDD00L);
            a = MyLogger.getLogger(DBManager.class.getName());
            a.log(Level.FINE, "ConnectionPool is initialized - " + this.c.getAttribute("url"));
        }
    }

    public int getConnectionsIdle() {
        if (this.d == null) {
            return 0;
        }
        return this.d.getNumIdle();
    }

    public int getConnectionsUsed() {
        if (this.d == null) {
            return 0;
        }
        return this.d.getNumActive();
    }

    public int getConnectionsMaxActive() {
        if (this.d == null) {
            return 0;
        }
        return this.d.getMaxActive();
    }

    public int getConnectionsMinIdle() {
        if (this.d == null) {
            return 0;
        }
        return this.d.getMinIdle();
    }

    public int getConnectionsMaxIdle() {
        if (this.d == null) {
            return 0;
        }
        return this.d.getMaxIdle();
    }

    public long getConnectionsMaxWait() {
        if (this.d == null) {
            return 0L;
        }
        return this.d.getMaxWait();
    }

    public Connection getConnection() throws SQLException {
        try {
            return ((DBManager)((Object)sQLException2)).d.getConnection();
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            throw sQLException;
        }
        catch (Exception exception) {
            a.log(Level.SEVERE, "DBManager : error in getConnection().", exception);
            throw new SQLException(exception.getMessage());
        }
    }

    public void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                return;
            }
            catch (SQLException sQLException) {
                a.log(Level.WARNING, "DBManager : error in closeResultSet().", sQLException);
            }
        }
    }

    public void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                return;
            }
            catch (SQLException sQLException) {
                a.log(Level.WARNING, "DBManager : error in closeStatement().", sQLException);
            }
        }
    }

    public void closePStatement(PreparedStatement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
                return;
            }
            catch (SQLException sQLException) {
                a.log(Level.WARNING, "DBManager : error in closePStatement().", sQLException);
            }
        }
    }

    public void closeCStatement(CallableStatement callableStatement) {
        if (callableStatement != null) {
            try {
                callableStatement.close();
                return;
            }
            catch (SQLException sQLException) {
                a.log(Level.WARNING, "DBManager : error in closeCStatement().", sQLException);
            }
        }
    }

    public void closeConnection(Connection connection) {
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
                return;
            }
        }
        catch (Exception exception) {
            a.log(Level.WARNING, "DBManager : error in closeConnection().", exception);
        }
    }

    public void closeConnectionPool() {
        try {
            if (this.d != null) {
                this.d.close();
                this.d = null;
                return;
            }
        }
        catch (Exception exception) {
            a.log(Level.WARNING, "DBManager : error in closeConnectionPool().", exception);
        }
    }
}

